/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec;

import com.smile.telephony.AudioCodec;

public class ULaw
extends AudioCodec {
    int BIAS = 132;

    public ULaw() {
        super(AudioCodec.ULAW);
    }

    @Override
    public int encode(byte[] input, byte[] output) {
        return this.encode(input, output, 0, output.length);
    }

    public int encode(byte[] input, byte[] output, int outoff, int outlen) {
        int i = 0;
        for (int j = 0; j < outlen; ++j) {
            int mask;
            int pcm_val;
            if ((pcm_val = (input[i++] & 0xFF) + (input[i++] << 8)) < 0) {
                pcm_val = -pcm_val;
                mask = 127;
            } else {
                mask = 255;
            }
            if (pcm_val >= 31616) {
                output[outoff + j] = (byte)(0x7F ^ mask);
                continue;
            }
            int seg = 0;
            if (pcm_val + 131 >= 2048) {
                seg = 4;
            }
            while (pcm_val + 131 >= 256 << seg) {
                ++seg;
            }
            int uval = seg << 4 | pcm_val + 131 >> seg + 3 & 0xF;
            output[outoff + j] = (byte)(uval ^ mask);
        }
        return outlen;
    }

    @Override
    public int decode(byte[] input, byte[] output) {
        return this.decode(input, 0, input.length, output);
    }

    public int decode(byte[] input, int inoff, int inlen, byte[] output) {
        int j = 0;
        for (int i = 0; i < inlen; ++i) {
            int val = ~input[inoff + i];
            int t = ((val & 0xF) << 3) + this.BIAS;
            val = (val & 0x80) != 0 ? this.BIAS - t : (t <<= (val & 0x70) >> 4) - this.BIAS;
            output[j++] = (byte)(val & 0xFF);
            output[j++] = (byte)(val >> 8 & 0xFF);
        }
        return j;
    }
}

