/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.rtp;

import com.smile.telephony.rtp.RTCPLocalSource;
import com.smile.telephony.rtp.RTCPRemoteSource;
import com.smile.telephony.rtp.RTPPacket;
import com.smile.telephony.video.VideoSocket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.Vector;
import smile.util.ResourceStore;
import smile.util.Utils;

public class RTCP
implements Runnable {
    public static final int VERSION = 2;
    public static final int SENDER_REPORT = 200;
    public static final int RECEIVER_REPORT = 201;
    public static final int SOURCE_DESCRIPTION = 202;
    public static final int GOODBYE = 203;
    public static final int APPLICATION_DEFINED = 204;
    public static final int RTP_FEEDBACK = 205;
    public static final int PAYLOAD_FEEDBACK = 206;
    public static final int MAXBUFSIZE = 8192;
    public static final long NTP1900TO1970 = 2208988800L;
    public static final int NTPFRCMPL = 4294967;
    public static final String SSRC = "ssrc";
    public static final String SEND_PAYLOAD_TYPE = "codec";
    public static final String SEND_PAYLOAD_SIZE = "psize";
    public static final String RECV_PAYLOAD_TYPE = "codec";
    public static final String RECV_PAYLOAD_SIZE = "psize";
    public static final String SEND_ADDRESS = "To";
    public static final String RECEIVE_ADDRESS = "From";
    public static final String PACKETS_SENT = "packets";
    public static final String OCTETS_SENT = "octets";
    public static final String REMOTE_LOST = "lost";
    public static final String REMOTE_JITTER = "jit";
    public static final String REMOTE_MAXJITTER = "mjit";
    public static final String REMOTE_FRACTION = "frac";
    public static final String REMOTE_MAXFRACTION = "mfrac";
    public static final String PACKETS_RECEIVED = "packets";
    public static final String OCTETS_RECEIVED = "octets";
    public static final String LOCAL_LOST = "lost";
    public static final String LOCAL_JITTER = "jit";
    public static final String LOCAL_MAXJITTER = "mjit";
    public static final String LOCAL_FRACTION = "frac";
    public static final String LOCAL_MAXFRACTION = "mfrac";
    public static final String DELAY_AVERAGE = "delay";
    public static final String DELAY_MAX = "mdelay";
    public static final String FIRST_SEQ_NUMBER = "fseq";
    public static final String LAST_SEQ_NUMBER = "lseq";
    private TimerTask timerTask;
    private DatagramSocket socket;
    private InetAddress remoteAddress;
    private int remotePort;
    private Hashtable localSources = new Hashtable();
    private Hashtable remoteSources = new Hashtable();
    private int reportInterval = 2500;
    private boolean running;
    private VideoSocket video;

    public RTCP(VideoSocket video, DatagramSocket socket) throws Exception {
        this(socket);
        this.video = video;
    }

    public RTCP(DatagramSocket socket) throws Exception {
        this.socket = socket;
    }

    public void setRemoteAddress(InetAddress address, int port) {
        this.remoteAddress = address;
        this.remotePort = port;
    }

    public void setReportInterval(int millis) {
        this.reportInterval = millis;
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public void open() {
        this.running = true;
        Thread thread = new Thread((Runnable)this, "rtcp-" + this.socket.getLocalPort());
        thread.start();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Enumeration en = RTCP.this.localSources.elements();
                while (en.hasMoreElements()) {
                    RTCPLocalSource source = (RTCPLocalSource)en.nextElement();
                    source.sendReport();
                }
            }
        };
        Utils.getTimer().schedule(this.timerTask, 1500L, (long)this.reportInterval);
    }

    public void close() {
        this.running = false;
        this.timerTask.cancel();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.socket.close();
    }

    public Hashtable getLocalSources() {
        return this.localSources;
    }

    public Hashtable getRemoteSources() {
        return this.remoteSources;
    }

    public Vector getSessionInfo() {
        Object source;
        Vector<Hashtable> info = new Vector<Hashtable>();
        Enumeration en = this.localSources.elements();
        while (en.hasMoreElements()) {
            source = (RTCPLocalSource)en.nextElement();
            info.addElement(((RTCPLocalSource)source).getInfo());
        }
        en = this.remoteSources.elements();
        while (en.hasMoreElements()) {
            source = (RTCPRemoteSource)en.nextElement();
            info.addElement(((RTCPRemoteSource)source).getInfo());
        }
        return info;
    }

    public int getPacketsLost() {
        int totalPacketsLost = 0;
        Enumeration en = this.remoteSources.elements();
        while (en.hasMoreElements()) {
            RTCPRemoteSource source = (RTCPRemoteSource)en.nextElement();
            totalPacketsLost += source.getPacketsLost();
        }
        return totalPacketsLost;
    }

    public int getJitter() {
        if (this.remoteSources.isEmpty()) {
            return 0;
        }
        int jitter = 0;
        Enumeration en = this.remoteSources.elements();
        while (en.hasMoreElements()) {
            RTCPRemoteSource source = (RTCPRemoteSource)en.nextElement();
            jitter += source.getJitter();
        }
        return jitter / this.remoteSources.size();
    }

    public int getJitterMax() {
        int jitter = 0;
        Enumeration en = this.remoteSources.elements();
        while (en.hasMoreElements()) {
            RTCPRemoteSource source = (RTCPRemoteSource)en.nextElement();
            int j = source.getJitterMax();
            if (j <= jitter) continue;
            jitter = j;
        }
        return jitter;
    }

    public int getPacketsSentLost() {
        int lostOnFarEnd = 0;
        Enumeration en = this.localSources.elements();
        while (en.hasMoreElements()) {
            RTCPLocalSource source = (RTCPLocalSource)en.nextElement();
            lostOnFarEnd += source.getPacketsSentLost();
        }
        return lostOnFarEnd;
    }

    public int getJitterFarEnd() {
        if (this.localSources.isEmpty()) {
            return 0;
        }
        int jitter = 0;
        Enumeration en = this.localSources.elements();
        while (en.hasMoreElements()) {
            RTCPLocalSource source = (RTCPLocalSource)en.nextElement();
            jitter += source.getJitterFarEnd();
        }
        return jitter / this.localSources.size();
    }

    public int getDelay() {
        if (this.localSources.isEmpty()) {
            return 0;
        }
        int delay = 0;
        Enumeration en = this.localSources.elements();
        while (en.hasMoreElements()) {
            RTCPLocalSource source = (RTCPLocalSource)en.nextElement();
            delay += source.getDelay();
        }
        return delay / this.localSources.size();
    }

    public int getDelay(String rtpAddress, int rtpPort) {
        int ssrc = this.findSSRC(rtpAddress, rtpPort);
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        return source != null ? source.getDelay() : 0;
    }

    public int getDelayMax() {
        int delay = 0;
        Enumeration en = this.localSources.elements();
        while (en.hasMoreElements()) {
            RTCPLocalSource source = (RTCPLocalSource)en.nextElement();
            int j = source.getDelayMax();
            if (j <= delay) continue;
            delay = j;
        }
        return delay;
    }

    public String getReceiveCodec() {
        int codec = -1;
        int packets = -1;
        Enumeration en = this.remoteSources.elements();
        while (en.hasMoreElements()) {
            RTCPRemoteSource source = (RTCPRemoteSource)en.nextElement();
            int p = source.getPacketsReceived();
            if (p <= packets) continue;
            packets = p;
            codec = source.getPayloadType();
        }
        return this.getCodecName(codec);
    }

    public String getSendCodec() {
        int codec = -1;
        int packets = -1;
        Enumeration en = this.localSources.elements();
        while (en.hasMoreElements()) {
            RTCPLocalSource source = (RTCPLocalSource)en.nextElement();
            int p = source.getPacketsSent();
            if (p <= packets) continue;
            packets = p;
            codec = source.getPayloadType();
        }
        return this.getCodecName(codec);
    }

    private String getCodecName(int ptype) {
        switch (ptype) {
            case 0: {
                return "G.711U";
            }
            case 8: {
                return "G.711A";
            }
            case 4: {
                return "G.723";
            }
            case 18: {
                return "G.729";
            }
            case 110: {
                return "opus";
            }
        }
        return "";
    }

    public void onPacketsSkipped(int ssrc, int n) {
        RTCPRemoteSource source = (RTCPRemoteSource)this.remoteSources.get(new Integer(ssrc));
        if (source != null) {
            source.onPacketsSkipped(n);
        }
    }

    public void onReceiveData(RTPPacket frame, InetAddress rtpAddress, int rtpPort, int fts) {
        int ssrc = frame.getSyncSource();
        if (ssrc == 0) {
            return;
        }
        RTCPRemoteSource source = (RTCPRemoteSource)this.remoteSources.get(new Integer(ssrc));
        if (source == null) {
            if (this.remoteSources.size() > 15) {
                return;
            }
            if (frame.getSize() == 16) {
                int ssrc_ = this.findSSRC(rtpAddress.getHostAddress(), rtpPort);
                RTCPLocalSource src = (RTCPLocalSource)this.localSources.get(new Integer(ssrc_));
                if (src != null) {
                    if (this.video != null) {
                        src.sendFIR(ssrc);
                    } else {
                        src.sendReport();
                    }
                }
                return;
            }
            source = new RTCPRemoteSource(ssrc, rtpAddress.getHostAddress(), rtpPort);
            this.remoteSources.put(new Integer(ssrc), source);
        }
        source.onReceiveData(frame, fts);
    }

    public void onSendData(RTPPacket frame, String rtpAddress, int rtpPort) {
        int ssrc = frame.getSyncSource();
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source == null) {
            source = new RTCPLocalSource(this, ssrc, rtpAddress, rtpPort);
            this.localSources.put(new Integer(ssrc), source);
        } else {
            source.setAddressInfo(rtpAddress, rtpPort);
        }
        source.onSendData(frame, rtpAddress);
    }

    public void sendTMMBR(int ssrc, int mssrc, double rate) {
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendTMMBR(mssrc, rate);
        }
    }

    public void sendTMMBN(int ssrc, double rate) {
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendTMMBN(ssrc, rate);
        }
    }

    public void sendTSTR(int ssrc, int mssrc, int seq, int index) {
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendTSTR(mssrc, seq, index);
        }
    }

    public void sendTSTN(int ssrc, int seq, int index) {
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendTSTN(ssrc, seq, index);
        }
    }

    public void sendFIR(int ssrc, int mssrc) {
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendFIR(mssrc);
        }
    }

    public void sendNack(int ssrc, int mssrc, int pid, int mask) {
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendNack(mssrc, pid, mask);
        }
    }

    public void sendNack(String rtpAddress, int rtpPort, int mssrc, int pid, int mask) {
        int ssrc = this.findSSRC(rtpAddress, rtpPort);
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendNack(mssrc, pid, mask);
        }
    }

    public void sendPLI(int ssrc, int mssrc) {
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendPLI(mssrc);
        }
    }

    public void sendPLI(String rtpAddress, int rtpPort, int mssrc) {
        int ssrc = this.findSSRC(rtpAddress, rtpPort);
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendPLI(mssrc);
        } else {
            this.sendPLI(mssrc);
        }
    }

    public void sendFIR(String rtpAddress, int rtpPort, int mssrc) {
        int ssrc = this.findSSRC(rtpAddress, rtpPort);
        RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc));
        if (source != null) {
            source.sendFIR(mssrc);
        }
    }

    public synchronized void send(byte[] data, int len) {
        try {
            DatagramPacket packet = new DatagramPacket(data, len, this.remoteAddress, this.remotePort);
            this.socket.send(packet);
        }
        catch (Exception e) {
            ResourceStore.error("RTCP send", e);
        }
    }

    public int findSSRC(String rtpAddress, int rtpPort) {
        Enumeration en = this.localSources.keys();
        while (en.hasMoreElements()) {
            Integer key = (Integer)en.nextElement();
            RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(key);
            if (!rtpAddress.equals(source.getAddress()) || rtpPort != source.getPort()) continue;
            return key;
        }
        return 0;
    }

    public void sendPLI(int mssrc) {
        int ssrc = 0;
        byte[] report = new byte[]{-127, -50, 0, 2, (byte)(ssrc >> 24), (byte)(ssrc >> 16), (byte)(ssrc >> 8), (byte)ssrc, (byte)(mssrc >> 24), (byte)(mssrc >> 16), (byte)(mssrc >> 8), (byte)mssrc};
        this.send(report, report.length);
    }

    @Override
    public void run() {
        byte[] buffer = new byte[8192];
        block3: while (this.running) {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, 8192);
                this.socket.receive(packet);
                if (packet.getAddress().equals(this.remoteAddress)) {
                    this.remotePort = packet.getPort();
                }
                byte[] b = packet.getData();
                int len = packet.getLength();
                int off = 0;
                while (len >= off + 8) {
                    int psize = b[off + 2] << 8 & 0xFF00 | b[off + 3] & 0xFF;
                    if (psize < 0 || (psize + 1) * 4 > len - off) {
                        ResourceStore.toLog(this + " Invalid RTCP packet from " + this.remoteAddress + " size=" + psize + " len=" + len);
                        continue block3;
                    }
                    int rrc = b[off] & 0x1F;
                    int ptype = b[off + 1] & 0xFF;
                    int ssrc = b[off + 4] << 24 | b[off + 5] << 16 & 0xFF0000 | b[off + 6] << 8 & 0xFF00 | b[off + 7] & 0xFF;
                    if (ptype == 200 || ptype == 201) {
                        long ntpfrc = System.currentTimeMillis();
                        long ntpsec = ntpfrc / 1000L;
                        ntpfrc = (ntpfrc - ntpsec * 1000L) * 4294967L;
                        long NTP = ((ntpsec += 2208988800L) & 0xFFFFL) << 16 | ntpfrc >> 16 & 0xFFFFL;
                        int n = 8;
                        if (ptype == 200) {
                            long ntps = ((long)b[off + 8] & 0xFFL) << 24 | (long)(b[off + 9] << 16 & 0xFF0000) | (long)(b[off + 10] << 8 & 0xFF00) | (long)(b[off + 11] & 0xFF);
                            long ntpf = ((long)b[off + 12] & 0xFFL) << 24 | (long)(b[off + 13] << 16 & 0xFF0000) | (long)(b[off + 14] << 8 & 0xFF00) | (long)(b[off + 15] & 0xFF);
                            long rtp = ((long)b[off + 16] & 0xFFL) << 24 | (long)(b[off + 17] << 16 & 0xFF0000) | (long)(b[off + 18] << 8 & 0xFF00) | (long)(b[off + 19] & 0xFF);
                            long spc = ((long)b[off + 20] & 0xFFL) << 24 | (long)(b[off + 21] << 16 & 0xFF0000) | (long)(b[off + 22] << 8 & 0xFF00) | (long)(b[off + 23] & 0xFF);
                            long soc = ((long)b[off + 24] & 0xFFL) << 24 | (long)(b[off + 25] << 16 & 0xFF0000) | (long)(b[off + 26] << 8 & 0xFF00) | (long)(b[off + 27] & 0xFF);
                            long timestamp = (ntps & 0xFFFFL) << 16 | ntpf >> 16 & 0xFFFFL;
                            RTCPRemoteSource source = (RTCPRemoteSource)this.remoteSources.get(new Integer(ssrc));
                            if (source != null) {
                                source.setReportTime(timestamp, NTP);
                            }
                            if (rrc == 0) {
                                off += (psize + 1) * 4;
                                continue;
                            }
                            n = 28;
                        }
                        n += off;
                        for (int i = 0; i < rrc; ++i) {
                            int lost;
                            int ssrc_1 = b[n++] << 24 | b[n++] << 16 & 0xFF0000 | b[n++] << 8 & 0xFF00 | b[n++] & 0xFF;
                            int fraction = b[n++] & 0xFF;
                            if ((lost = b[n++] << 16 & 0xFF0000 | b[n++] << 8 & 0xFF00 | b[n++] & 0xFF) > 0x7FFFFF) {
                                lost = 0;
                            }
                            long seqnum = ((long)b[n++] & 0xFFL) << 24 | (long)(b[n++] << 16 & 0xFF0000) | (long)(b[n++] << 8 & 0xFF00) | (long)(b[n++] & 0xFF);
                            long jitter = ((long)b[n++] & 0xFFL) << 24 | (long)(b[n++] << 16 & 0xFF0000) | (long)(b[n++] << 8 & 0xFF00) | (long)(b[n++] & 0xFF);
                            long lastsr = ((long)b[n++] & 0xFFL) << 24 | (long)(b[n++] << 16 & 0xFF0000) | (long)(b[n++] << 8 & 0xFF00) | (long)(b[n++] & 0xFF);
                            long dlsr = ((long)b[n++] & 0xFFL) << 24 | (long)(b[n++] << 16 & 0xFF0000) | (long)(b[n++] << 8 & 0xFF00) | (long)(b[n++] & 0xFF);
                            long roundTripDelay = 0L;
                            if (lastsr > 0L) {
                                roundTripDelay = NTP - lastsr - dlsr;
                            }
                            RTCPLocalSource source = (RTCPLocalSource)this.localSources.get(new Integer(ssrc_1));
                            if (fraction > 100) {
                                fraction = 100;
                            }
                            if (source == null) continue;
                            source.updateInfo(ssrc, fraction, lost, seqnum, jitter, roundTripDelay, this.video);
                        }
                    } else if (ptype != 202 && ptype != 203 && ptype != 204) {
                        if (ptype == 205) {
                            if (rrc == 1) {
                                int rsrc = b[off + 8] << 24 | b[off + 9] << 16 & 0xFF0000 | b[off + 10] << 8 & 0xFF00 | b[off + 11] & 0xFF;
                                int pid = b[off + 12] << 8 & 0xFF00 | b[off + 13] & 0xFF;
                                int mask = b[off + 14] << 8 & 0xFF00 | b[off + 15] & 0xFF;
                                if (this.video != null) {
                                    this.video.nack(ssrc, rsrc, pid, mask);
                                }
                            } else if (rrc == 3 || rrc == 4) {
                                int rsrc = b[off + 12] << 24 | b[off + 13] << 16 & 0xFF0000 | b[off + 14] << 8 & 0xFF00 | b[off + 15] & 0xFF;
                                int exp = b[off + 16] >> 2 & 0x3F;
                                int man = (b[off + 16] & 3) << 15 | b[off + 17] << 7 & 0x7F80 | b[off + 18] >> 1 & 0x7F;
                                double rate = (double)man * Math.pow(2.0, exp);
                                if (this.video != null) {
                                    if (rrc == 3) {
                                        this.video.rateChangeRequest(ssrc, rsrc, rate);
                                    } else {
                                        this.video.rateChangeNotification(ssrc, rate);
                                    }
                                }
                            }
                        } else if (ptype == 206) {
                            if (rrc == 1) {
                                int rsrc = b[off + 8] << 24 | b[off + 9] << 16 & 0xFF0000 | b[off + 10] << 8 & 0xFF00 | b[off + 11] & 0xFF;
                                if (this.video != null) {
                                    this.video.pictureLostIndication(ssrc, rsrc);
                                }
                            } else if (rrc == 4) {
                                int rsrc = b[off + 12] << 24 | b[off + 13] << 16 & 0xFF0000 | b[off + 14] << 8 & 0xFF00 | b[off + 15] & 0xFF;
                                if (this.video != null) {
                                    this.video.decoderRefreshRequest(ssrc, rsrc);
                                }
                            } else if (rrc == 5 || rrc == 6) {
                                int rsrc = b[off + 12] << 24 | b[off + 13] << 16 & 0xFF0000 | b[off + 14] << 8 & 0xFF00 | b[off + 15] & 0xFF;
                                int seq = b[off + 16] & 0xFF;
                                int index = b[off + 19] & 0x1F;
                                if (this.video != null) {
                                    if (rrc == 5) {
                                        this.video.temporalSpatialRequest(ssrc, rsrc, seq, index);
                                    } else {
                                        this.video.temporalSpatialNotification(ssrc, seq, index);
                                    }
                                }
                            }
                        }
                    }
                    off += (psize + 1) * 4;
                }
            }
            catch (IOException e) {
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

