/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.rtp;

import com.smile.telephony.rtp.RTCP;
import com.smile.telephony.rtp.RTCPRemoteSource;
import com.smile.telephony.rtp.RTPPacket;
import com.smile.telephony.video.VideoSocket;
import java.util.Enumeration;
import java.util.Hashtable;

public class RTCPLocalSource {
    private RTCP rtcp;
    private int ssrc;
    private String rtpAddress;
    private int rtpPort;
    private int payloadType = 0;
    private int payloadSize = 0;
    private long roundTripDelayAvg = 0L;
    private long roundTripDelayMax = 0L;
    private long jitterOnFarEnd = 0L;
    private int maxFractionOnFarEnd = 0;
    private int lostOnFarEnd = 0;
    private int packetsSent = 0;
    private int octetsSent = 0;
    private long timestamp = 0L;
    private long infoTime = System.currentTimeMillis();
    private int infoPacketsSent = 0;
    private int infoOctetsSent = 0;
    private int packetRate;
    private double mediaRate;
    private int sequenceNumber = 0;
    private int firstSequenceNumber = -1;

    public RTCPLocalSource(RTCP rtcp, int ssrc, String addr, int port) {
        this.rtcp = rtcp;
        this.ssrc = ssrc;
        this.rtpAddress = addr;
        this.rtpPort = port;
    }

    public String getAddress() {
        return this.rtpAddress;
    }

    public int getPort() {
        return this.rtpPort;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public int getPacketsSent() {
        return this.packetsSent;
    }

    public int getOctetsSent() {
        return this.octetsSent;
    }

    public int getPacketsSentLost() {
        return this.lostOnFarEnd;
    }

    public int getJitterFarEnd() {
        return (int)this.jitterOnFarEnd;
    }

    public int getDelay() {
        return (int)((this.roundTripDelayAvg * 1000L >> 16 & 0xFFFFL) + (this.roundTripDelayAvg & 0xFFFFL) / 4294967L);
    }

    public int getDelayMax() {
        return (int)((this.roundTripDelayMax * 1000L >> 16 & 0xFFFFL) + (this.roundTripDelayMax & 0xFFFFL) / 4294967L);
    }

    public void setAddressInfo(String addr, int port) {
        this.rtpAddress = addr;
        this.rtpPort = port;
    }

    public Hashtable getInfo() {
        int fractionFarEnd = this.packetsSent == 0 ? 0 : 100 * this.lostOnFarEnd / this.packetsSent;
        int fractionFarEndMax = this.maxFractionOnFarEnd * 100 / 256;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("ssrc", new Integer(this.ssrc));
        info.put("codec", new Integer(this.payloadType));
        info.put("psize", new Integer(this.payloadSize));
        info.put("packets", new Integer(this.packetsSent));
        info.put("octets", new Integer(this.octetsSent));
        info.put("lost", new Integer(this.lostOnFarEnd));
        info.put("jit", new Integer(this.getJitterFarEnd()));
        info.put("frac", new Integer(fractionFarEnd));
        info.put("mfrac", new Integer(fractionFarEndMax));
        info.put("delay", new Integer(this.getDelay()));
        info.put("mdelay", new Integer(this.getDelayMax()));
        info.put("To", this.rtpAddress + ":" + this.rtpPort);
        info.put("fseq", this.firstSequenceNumber);
        info.put("lseq", this.sequenceNumber);
        return info;
    }

    public void updateInfo(int rsrc, int fraction, int lost, long seqnum, long jitter, long roundTripDelay, VideoSocket video) {
        if (roundTripDelay > 0L) {
            if (roundTripDelay > this.roundTripDelayMax) {
                this.roundTripDelayMax = roundTripDelay;
            }
            this.roundTripDelayAvg = this.roundTripDelayAvg == 0L ? roundTripDelay : (this.roundTripDelayAvg += (roundTripDelay - this.roundTripDelayAvg) / 2L);
        }
        jitter = Math.abs(jitter);
        this.jitterOnFarEnd = this.jitterOnFarEnd == 0L ? jitter : (this.jitterOnFarEnd += (jitter - this.jitterOnFarEnd) / 16L);
        if (fraction > this.maxFractionOnFarEnd) {
            this.maxFractionOnFarEnd = fraction;
        }
        this.lostOnFarEnd = lost;
        long d = System.currentTimeMillis() - this.infoTime;
        if (d < 3000L) {
            return;
        }
        this.mediaRate = (double)((this.octetsSent - this.infoOctetsSent) * 8) * 1000.0 / (double)d;
        this.packetRate = (int)Math.ceil((double)(this.packetsSent - this.infoPacketsSent) * 1000.0 / (double)d);
        if (video != null) {
            video.onReceiverReport(this.ssrc, rsrc, this.mediaRate, fraction, (int)((roundTripDelay * 1000L >> 16 & 0xFFFFL) + (roundTripDelay & 0xFFFFL) / 4294967L));
        }
    }

    public void onSendData(RTPPacket frame, String addr) {
        this.rtpAddress = addr;
        this.timestamp = frame.getTimestamp();
        this.payloadType = frame.getPayloadType();
        int psize = frame.getPayloadSize();
        if (psize > this.payloadSize) {
            this.payloadSize = psize;
        }
        this.octetsSent += psize;
        ++this.packetsSent;
        this.sequenceNumber = frame.getSequenceNumber();
        if (this.firstSequenceNumber == -1) {
            this.firstSequenceNumber = this.sequenceNumber;
        }
    }

    public void sendReport() {
        long ntpfrc = System.currentTimeMillis();
        long ntpsec = ntpfrc / 1000L;
        ntpfrc = (ntpfrc - ntpsec * 1000L) * 4294967L;
        ntpsec += 2208988800L;
        byte[] report = new byte[512];
        report[0] = -128;
        report[1] = -56;
        report[2] = 0;
        report[3] = 6;
        report[4] = (byte)(this.ssrc >> 24);
        report[5] = (byte)(this.ssrc >> 16);
        report[6] = (byte)(this.ssrc >> 8);
        report[7] = (byte)this.ssrc;
        report[8] = (byte)(ntpsec >> 24);
        report[9] = (byte)(ntpsec >> 16);
        report[10] = (byte)(ntpsec >> 8);
        report[11] = (byte)ntpsec;
        report[12] = (byte)(ntpfrc >> 24);
        report[13] = (byte)(ntpfrc >> 16);
        report[14] = (byte)(ntpfrc >> 8);
        report[15] = (byte)ntpfrc;
        report[16] = (byte)(this.timestamp >> 24);
        report[17] = (byte)(this.timestamp >> 16);
        report[18] = (byte)(this.timestamp >> 8);
        report[19] = (byte)this.timestamp;
        report[20] = (byte)(this.packetsSent >> 24);
        report[21] = (byte)(this.packetsSent >> 16);
        report[22] = (byte)(this.packetsSent >> 8);
        report[23] = (byte)this.packetsSent;
        report[24] = (byte)(this.octetsSent >> 24);
        report[25] = (byte)(this.octetsSent >> 16);
        report[26] = (byte)(this.octetsSent >> 8);
        report[27] = (byte)this.octetsSent;
        int i = 28;
        Enumeration en = this.rtcp.getRemoteSources().elements();
        while (en.hasMoreElements()) {
            RTCPRemoteSource remoteSource = (RTCPRemoteSource)en.nextElement();
            byte[] rr = remoteSource.createReport(this.ssrc);
            for (int j = 8; j < 32; ++j) {
                report[i++] = rr[j];
            }
            report[0] = (byte)(report[0] + 1);
            report[3] = (byte)(report[3] + 6);
        }
        this.rtcp.send(report, i);
    }

    public void sendTMMBR(int rsrc, double rate) {
        this.sendTMMB(rsrc, rate, true);
    }

    public void sendTMMBN(int rsrc, double rate) {
        this.sendTMMB(rsrc, rate, false);
        this.infoTime = System.currentTimeMillis();
        this.infoOctetsSent = this.octetsSent;
        this.infoPacketsSent = this.packetsSent;
    }

    private void sendTMMB(int mssrc, double rate, boolean req) {
        byte[] report = new byte[20];
        report[0] = req ? -125 : -124;
        report[1] = -51;
        report[2] = 0;
        report[3] = 4;
        report[4] = (byte)(this.ssrc >> 24);
        report[5] = (byte)(this.ssrc >> 16);
        report[6] = (byte)(this.ssrc >> 8);
        report[7] = (byte)this.ssrc;
        report[8] = 0;
        report[9] = 0;
        report[10] = 0;
        report[11] = 0;
        report[12] = (byte)(mssrc >> 24);
        report[13] = (byte)(mssrc >> 16);
        report[14] = (byte)(mssrc >> 8);
        report[15] = (byte)mssrc;
        int exp = 10;
        int man = (int)(rate / Math.pow(2.0, exp));
        report[16] = (byte)(exp << 2 | man >> 15 & 3);
        report[17] = (byte)(man >> 7 & 0xFF);
        report[18] = (byte)(man << 1 & 0xFE);
        report[19] = 40;
        this.rtcp.send(report, report.length);
    }

    public void sendTSTR(int rsrc, int seq, int index) {
        this.sendTST(rsrc, seq, index, true);
    }

    public void sendTSTN(int rsrc, int seq, int index) {
        this.sendTST(rsrc, seq, index, false);
    }

    private void sendTST(int mssrc, int seq, int index, boolean req) {
        byte[] report = new byte[]{req ? (byte)-123 : -122, -50, 0, 4, (byte)(this.ssrc >> 24), (byte)(this.ssrc >> 16), (byte)(this.ssrc >> 8), (byte)this.ssrc, 0, 0, 0, 0, (byte)(mssrc >> 24), (byte)(mssrc >> 16), (byte)(mssrc >> 8), (byte)mssrc, (byte)seq, 0, 0, (byte)index};
        this.rtcp.send(report, report.length);
    }

    public void sendNack(int mssrc, int pid, int mask) {
        byte[] report = new byte[]{-127, -51, 0, 3, (byte)(this.ssrc >> 24), (byte)(this.ssrc >> 16), (byte)(this.ssrc >> 8), (byte)this.ssrc, (byte)(mssrc >> 24), (byte)(mssrc >> 16), (byte)(mssrc >> 8), (byte)mssrc, (byte)(pid >> 8), (byte)pid, (byte)(mask >> 8), (byte)mask};
        this.rtcp.send(report, report.length);
    }

    public void sendPLI(int mssrc) {
        byte[] report = new byte[]{-127, -50, 0, 2, (byte)(this.ssrc >> 24), (byte)(this.ssrc >> 16), (byte)(this.ssrc >> 8), (byte)this.ssrc, (byte)(mssrc >> 24), (byte)(mssrc >> 16), (byte)(mssrc >> 8), (byte)mssrc};
        this.rtcp.send(report, report.length);
    }

    public void sendFIR(int mssrc) {
        byte[] report = new byte[]{-124, -50, 0, 4, (byte)(this.ssrc >> 24), (byte)(this.ssrc >> 16), (byte)(this.ssrc >> 8), (byte)this.ssrc, 0, 0, 0, 0, (byte)(mssrc >> 24), (byte)(mssrc >> 16), (byte)(mssrc >> 8), (byte)mssrc, 0, 0, 0, 0};
        this.rtcp.send(report, report.length);
    }

    public String toString() {
        return this.rtpAddress + ":" + this.rtpPort;
    }
}

