/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.rtp;

import com.smile.telephony.rtp.RTP;
import com.smile.telephony.rtp.RTPPacket;
import java.util.Hashtable;

public class RTCPRemoteSource {
    private int ssrc;
    private String rtpAddress;
    private int rtpPort;
    private int payloadType = 0;
    private int payloadSize = 0;
    private int packetsReceived = 0;
    private int octetsReceived = 0;
    private long lsr = 0L;
    private long dlsr = 0L;
    private long lsrrcv = 0L;
    private int sequenceNumber = 0;
    private int firstSequenceNumber = 0;
    private int expectedSequenceNumber = 0;
    private int seqNumCycle = 0;
    private int jitterLevel = 0;
    private int maxJitterLevel = 0;
    private long lastPacketTime = 0L;
    private long lastPacketTimestamp = 0L;
    private int outOfOrder = 0;
    private int packetsLost = 0;
    private int packetsSkipped = 0;
    private int receivedReported = 0;
    private int lostReported = 0;
    private int outOfOrderReported = 0;
    private int maxFractionOnNearEnd = 0;
    private int maxDelay = 0;
    private boolean rfc2833;

    public Hashtable getInfo() {
        int fractionNearEnd;
        int totalLost = this.packetsLost - this.outOfOrder;
        if (totalLost < 0) {
            totalLost = 0;
        }
        if ((fractionNearEnd = this.packetsReceived + totalLost) != 0) {
            fractionNearEnd = 100 * totalLost / fractionNearEnd;
        }
        int fractionNearEndMax = this.maxFractionOnNearEnd * 100 / 256;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("ssrc", new Integer(this.ssrc));
        info.put("codec", new Integer(this.payloadType));
        info.put("psize", new Integer(this.payloadSize));
        info.put("packets", new Integer(this.packetsReceived));
        info.put("octets", new Integer(this.octetsReceived));
        info.put("lost", new Integer(totalLost));
        info.put("jit", new Integer(this.getJitter()));
        info.put("mjit", new Integer(this.getJitterMax()));
        info.put("frac", new Integer(fractionNearEnd));
        info.put("mfrac", new Integer(fractionNearEndMax));
        info.put("From", this.rtpAddress + ":" + this.rtpPort);
        info.put("fseq", this.firstSequenceNumber);
        info.put("lseq", this.sequenceNumber);
        info.put("mdelay", this.maxDelay);
        return info;
    }

    public RTCPRemoteSource(int ssrc, String addr, int port) {
        this.ssrc = ssrc;
        this.rtpAddress = addr;
        this.rtpPort = port;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public int getPacketsReceived() {
        return this.packetsReceived;
    }

    public int getOctetsReceived() {
        return this.octetsReceived;
    }

    public int getPacketsLost() {
        return this.packetsLost;
    }

    public int getJitter() {
        return this.jitterLevel >> 4;
    }

    public int getJitterMax() {
        return this.maxJitterLevel >> 4;
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public void setReportTime(long lsr, long lsrrcv) {
        this.lsr = lsr;
        this.lsrrcv = lsrrcv;
    }

    public void setAddressInfo(String addr, int port) {
        this.rtpAddress = addr;
        this.rtpPort = port;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getFirstSequenceNumber() {
        return this.firstSequenceNumber;
    }

    public void onPacketsSkipped(int n) {
        this.packetsSkipped += n;
    }

    public void onReceiveData(RTPPacket frame, int fts) {
        int dropped;
        this.sequenceNumber = frame.getSequenceNumber();
        this.payloadType = frame.getPayloadType();
        int psize = frame.getPayloadSize();
        if (psize > this.payloadSize) {
            this.payloadSize = psize;
        }
        this.octetsReceived += psize;
        ++this.packetsReceived;
        if (this.packetsReceived == 1) {
            this.firstSequenceNumber = this.sequenceNumber;
            this.expectedSequenceNumber = this.sequenceNumber + 1 & 0xFFFF;
            this.lastPacketTime = System.currentTimeMillis();
            this.lastPacketTimestamp = frame.getTimestamp();
            return;
        }
        boolean expectedPacket = this.sequenceNumber == this.expectedSequenceNumber;
        boolean markered = frame.getMarker();
        if (this.expectedSequenceNumber == 0) {
            if (expectedPacket) {
                ++this.seqNumCycle;
                ++this.expectedSequenceNumber;
            } else if (markered) {
                this.expectedSequenceNumber = this.sequenceNumber + 1 & 0xFFFF;
            } else if (this.sequenceNumber > 32768) {
                ++this.outOfOrder;
            } else {
                this.packetsLost += this.sequenceNumber;
                this.expectedSequenceNumber = this.sequenceNumber + 1 & 0xFFFF;
                ++this.seqNumCycle;
            }
        } else if (expectedPacket) {
            ++this.expectedSequenceNumber;
        } else if (markered) {
            this.expectedSequenceNumber = this.sequenceNumber + 1 & 0xFFFF;
        } else if (this.sequenceNumber < this.expectedSequenceNumber) {
            if (this.expectedSequenceNumber - this.sequenceNumber > 32768) {
                dropped = 65536 - (this.expectedSequenceNumber - this.sequenceNumber);
                this.packetsLost += dropped;
                this.expectedSequenceNumber = this.sequenceNumber + 1 & 0xFFFF;
                ++this.seqNumCycle;
            } else {
                ++this.outOfOrder;
            }
        } else {
            dropped = this.sequenceNumber - this.expectedSequenceNumber;
            this.packetsLost += dropped;
            this.expectedSequenceNumber = this.sequenceNumber + 1 & 0xFFFF;
        }
        long now = System.currentTimeMillis();
        long timestamp = frame.getTimestamp();
        long tsdiff = timestamp - this.lastPacketTimestamp;
        if (expectedPacket && !markered && this.packetsReceived > 3 && tsdiff >= 0L) {
            if (tsdiff == 0L) {
                if (frame.getPayloadType() == RTP.RFC2833) {
                    this.rfc2833 = true;
                }
            } else if (this.rfc2833) {
                this.rfc2833 = false;
            } else {
                int delay = (int)(now - this.lastPacketTime - tsdiff / (long)fts);
                if (delay > this.maxDelay) {
                    this.maxDelay = delay;
                }
                this.jitterLevel += Math.abs(delay) - (this.jitterLevel + 8 >> 4);
                if (this.jitterLevel > this.maxJitterLevel) {
                    this.maxJitterLevel = this.jitterLevel;
                }
            }
        }
        this.lastPacketTime = now;
        this.lastPacketTimestamp = timestamp;
    }

    public byte[] createReport(int syncSource) {
        int fraction = 0;
        int totalLost = this.packetsLost + this.packetsSkipped;
        if (this.packetsReceived > this.receivedReported) {
            fraction = (totalLost - this.lostReported - (this.outOfOrder - this.outOfOrderReported)) * 256 / (this.packetsReceived - this.receivedReported + (totalLost - this.lostReported));
            if (fraction < 0) {
                fraction = 0;
            }
            if (fraction > this.maxFractionOnNearEnd) {
                this.maxFractionOnNearEnd = fraction;
            }
        }
        this.receivedReported = this.packetsReceived;
        this.lostReported = totalLost;
        this.outOfOrderReported = this.outOfOrder;
        long lost = this.packetsLost - this.outOfOrder;
        long ntpfrc = System.currentTimeMillis();
        long ntpsec = ntpfrc / 1000L;
        ntpfrc = (ntpfrc - ntpsec * 1000L) * 4294967L;
        long ntpstamp = ((ntpsec += 2208988800L) & 0xFFFFL) << 16 | ntpfrc >> 16 & 0xFFFFL;
        if (this.lsr != 0L) {
            this.dlsr = ntpstamp - this.lsrrcv;
        }
        long jitter = this.jitterLevel >> 4;
        byte[] report = new byte[]{65, -55, 0, 7, (byte)(syncSource >> 24), (byte)(syncSource >> 16), (byte)(syncSource >> 8), (byte)syncSource, (byte)(this.ssrc >> 24), (byte)(this.ssrc >> 16), (byte)(this.ssrc >> 8), (byte)this.ssrc, (byte)fraction, (byte)(lost >> 16), (byte)(lost >> 8), (byte)lost, (byte)(this.seqNumCycle >> 8), (byte)this.seqNumCycle, (byte)(this.sequenceNumber >> 8), (byte)this.sequenceNumber, (byte)(jitter >> 24), (byte)(jitter >> 16), (byte)(jitter >> 8), (byte)jitter, (byte)(this.lsr >> 24), (byte)(this.lsr >> 16), (byte)(this.lsr >> 8), (byte)this.lsr, (byte)(this.dlsr >> 24), (byte)(this.dlsr >> 16), (byte)(this.dlsr >> 8), (byte)this.dlsr};
        return report;
    }

    public String toString() {
        return this.rtpAddress + ":" + this.rtpPort;
    }
}

