/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.rtp;

import com.smile.net.StunClient;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.RTPMediaSocket;
import com.smile.telephony.codec.DTMFDecoder;
import com.smile.telephony.codec.Opus;
import com.smile.telephony.rtp.RTCP;
import com.smile.telephony.rtp.RTPPacket;
import com.smile.telephony.rtp.RTPTransmitter;
import com.smile.telephony.rtp.SRTP;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Vector;
import smile.util.ResourceStore;

public class RTP
implements Runnable {
    public static int VERSION = 0;
    public static int MAXBUFSIZE = 32768;
    public static int RFC2833 = 101;
    public static final char[] RFC2833CHARSET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '#', 'A', 'B', 'C', 'D', '!'};
    private RTPMediaSocket media;
    private RTPTransmitter transmitter;
    private DatagramSocket socket;
    private RTCP rtcp;
    private SRTP srtpT;
    private SRTP srtpR;
    private InetAddress remoteAddress;
    private int remotePort;
    private String localAddress;
    private int localPort;
    private int exposedlocalPort;
    private boolean first;
    private boolean running;
    private boolean dmz;
    private boolean sym;
    private boolean nat;
    private int totalPacketsSent = 0;
    private int totalOctetsSent = 0;
    private int totalPacketsReceived = 0;
    private int totalOctetsReceived = 0;
    private int payloadType = -1;
    private int fts;
    private boolean ecm;
    private boolean inwork;
    private DTMFDecoder dtmfDecoder;

    public RTP(RTPMediaSocket media, int port, InetAddress address, int tos) throws Exception {
        this.media = media;
        this.socket = new DatagramSocket(port, address);
        if (tos != 0) {
            try {
                this.socket.setTrafficClass(tos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rtcp = new RTCP(new DatagramSocket(this.socket.getLocalPort() + 1, address));
        this.rtcp.open();
        if (!address.isAnyLocalAddress() && !address.isLoopbackAddress()) {
            this.localAddress = address.getHostAddress();
        }
        this.exposedlocalPort = this.localPort = port;
        this.running = true;
        ResourceStore.toLog("Create RTP socket " + address + ":" + port + " rcvbuf=" + this.socket.getReceiveBufferSize() + " sndbuf=" + this.socket.getSendBufferSize());
    }

    public void setStunAddress(InetAddress stunAddress, int stunPort) {
        if (stunAddress == null) {
            return;
        }
        StunClient stun = new StunClient(this.socket);
        stun.sendRequest(stunAddress, stunPort);
        String addr = stun.getReturnAddress();
        if (addr != null) {
            this.localAddress = addr;
            this.exposedlocalPort = stun.getReturnPort();
            this.nat = true;
        }
    }

    public boolean isNatAddress() {
        return this.nat;
    }

    public void close() {
        this.running = false;
        if (this.transmitter != null) {
            this.transmitter.close();
        }
        Thread cleaner = new Thread(){

            @Override
            public void run() {
                RTP.this.rtcp.close();
                RTP.this.socket.close();
            }
        };
        cleaner.start();
    }

    public void setCryptoParameters(String tsm, String rcv) throws Exception {
        if (tsm != null) {
            this.srtpT = new SRTP(tsm);
        }
        if (rcv != null) {
            this.srtpR = new SRTP(rcv);
        }
    }

    public void setCryptoKey(byte[] key) {
        this.srtpT = new SRTP(key);
        this.srtpR = new SRTP(key);
    }

    public Vector getSessionInfo() {
        return this.rtcp.getSessionInfo();
    }

    public String getReceiveCodec() {
        return this.rtcp.getReceiveCodec();
    }

    public String getSendCodec() {
        return this.rtcp.getReceiveCodec();
    }

    public int getPacketsSent() {
        return this.totalPacketsSent;
    }

    public int getOctetsSent() {
        return this.totalOctetsSent;
    }

    public int getPacketsReceived() {
        return this.totalPacketsReceived;
    }

    public int getOctetsReceived() {
        return this.totalOctetsReceived;
    }

    public int getPacketsLost() {
        return this.rtcp.getPacketsLost();
    }

    public int getJitter() {
        return this.rtcp.getJitter();
    }

    public int getJitterMax() {
        return this.rtcp.getJitterMax();
    }

    public int getPacketsSentLost() {
        return this.rtcp.getPacketsSentLost();
    }

    public int getJitterFarEnd() {
        return this.rtcp.getJitterFarEnd();
    }

    public int getDelay() {
        return this.rtcp.getDelay();
    }

    public int getDelayMax() {
        return this.rtcp.getDelayMax();
    }

    public InetAddress getSocketLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getSocketLocalPort() {
        return this.socket.getLocalPort();
    }

    public int getRTCPLocalPort() {
        return this.rtcp.getLocalPort();
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalPort() {
        return this.exposedlocalPort;
    }

    public void setRemoteAddress(InetAddress address, int port) {
        this.dmz = true;
        if (this.nat && this.remoteAddress != null && !this.remoteAddress.isSiteLocalAddress() && address.isSiteLocalAddress()) {
            this.localAddress = null;
            this.exposedlocalPort = this.localPort;
            this.nat = false;
        }
        this.remoteAddress = address;
        this.remotePort = port;
        this.rtcp.setRemoteAddress(address, port + 1);
        this.first = true;
        this.media.toLog("setRemoteAddress " + this.remoteAddress + ":" + this.remotePort + " dmz=" + this.dmz);
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void startReceiver(AudioCodec codec, boolean symnat, boolean dtmfInband) {
        this.sym = symnat;
        this.startReceive(codec, dtmfInband);
    }

    public void stopReceiver() {
        this.stopReceive();
    }

    public void startTransmitter(AudioCodec codec, int fpp, HashMap prms) {
        if (this.transmitter == null) {
            this.transmitter = new RTPTransmitter(this);
        }
        this.transmitter.start(codec, fpp, prms);
    }

    public void stopTransmitter() {
        if (this.transmitter != null) {
            this.transmitter.stop();
        }
    }

    public boolean isTransmit() {
        return this.transmitter != null && this.transmitter.isTransmit();
    }

    public int getTransmitCodecType() {
        if (this.transmitter == null) {
            return -1;
        }
        return this.transmitter.getPayloadType();
    }

    public int getReceiveCodecType() {
        return this.payloadType;
    }

    public int readBuffer(byte[] buffer, int offset, int length) {
        return this.media.readBuffer(buffer, offset, length);
    }

    public void sendDigits(String str, int volume, int dtmf_on, int dtmf_off) {
        if (this.transmitter == null) {
            this.transmitter = new RTPTransmitter(this);
        }
        for (int i = 0; i < str.length(); ++i) {
            char digit = str.charAt(i);
            if (digit == ',') {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (digit == '&') {
                digit = '!';
            }
            this.transmitter.sendDigit(digit, dtmf_on, volume, dtmf_off);
        }
    }

    public void sendDataPacket(byte[] buffer, int len) throws IOException {
        if (!this.running || this.remoteAddress == null) {
            return;
        }
        try {
            this.socket.send(new DatagramPacket(buffer, len, this.remoteAddress, this.remotePort));
            ++this.totalPacketsSent;
            this.totalOctetsSent += len + 20;
        }
        catch (Exception e) {
            ResourceStore.error("sendDataPacket", e);
        }
    }

    public void sendRTPPacket(byte[] buffer, int len) throws Exception {
        block4: {
            if (!this.running || this.remoteAddress == null) {
                return;
            }
            RTPPacket packet = new RTPPacket(buffer, len);
            this.rtcp.onSendData(packet, this.remoteAddress.getHostAddress(), this.remotePort);
            try {
                if (this.srtpT != null) {
                    this.srtpT.encrypt(packet);
                }
                this.socket.send(new DatagramPacket(packet.getBuffer(), packet.getSize(), this.remoteAddress, this.remotePort));
                ++this.totalPacketsSent;
                this.totalOctetsSent += packet.getSize() + 20;
            }
            catch (Exception e) {
                ResourceStore.error("sendRTPPacket", e);
                if (this.totalPacketsSent != 0 || this.media.getServerAddress() == null) break block4;
                this.remoteAddress = this.media.getServerAddress();
                this.rtcp.setRemoteAddress(this.remoteAddress, this.remotePort + 1);
                ResourceStore.toLog("setRemoteAddress " + this.remoteAddress);
            }
        }
    }

    protected void sendDumb(int seqn) {
        try {
            int payloadSize = this.payloadType == 0 || this.payloadType == 8 ? 92 : 32;
            RTPPacket frame = new RTPPacket(payloadSize);
            frame.setVersion(VERSION);
            frame.setPayloadType(this.payloadType);
            frame.setTimestamp(System.currentTimeMillis());
            frame.setSequenceNumber(seqn);
            if (this.srtpT != null) {
                this.srtpT.encrypt(frame);
            }
            DatagramPacket p = new DatagramPacket(frame.getBuffer(), frame.getSize(), this.remoteAddress, this.remotePort);
            this.socket.send(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startReceive(AudioCodec codec, boolean dtmfInband) {
        int pt = codec.getPayloadType();
        this.media.toLog("start Receiver payloadType=" + this.payloadType + " inwork=" + this.inwork + " dtmfInband=" + dtmfInband);
        if (dtmfInband && pt != this.payloadType && pt != 256) {
            if (this.payloadType != -1) {
                this.payloadType = -1;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.dtmfDecoder != null) {
                try {
                    this.dtmfDecoder.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.dtmfDecoder = new DTMFDecoder(codec, this.media);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.payloadType = pt;
        this.fts = codec.getKhz() / 1000;
        this.ecm = codec instanceof Opus;
        if (!this.inwork) {
            this.inwork = true;
            Thread thread = new Thread((Runnable)this, "RTPReceiver-" + this.localPort);
            thread.start();
        }
    }

    public void stopReceive() {
        this.media.toLog("stop Receiver ");
        this.payloadType = -1;
        this.first = true;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    @Override
    public void run() {
        int dc = 1;
        boolean dtmfEnded = false;
        int socketTimeout = this.media.getSocketTimeout();
        long dmztimeout = 0L;
        if (this.dmz) {
            this.sendDumb(dc++);
            try {
                this.socket.setSoTimeout(3000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            dmztimeout = System.currentTimeMillis() + 15000L;
        } else if (socketTimeout > 0) {
            try {
                this.socket.setSoTimeout(socketTimeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        this.media.toLog("Run Receiver-" + this.hashCode() + " codec=" + this.payloadType + " dmztimeout=" + dmztimeout + " socketTimeout=" + socketTimeout + " localAddr=" + this.localAddress + ":" + this.getLocalPort() + " srtp=" + this.srtpR + " running=" + this.running + " p=" + Thread.currentThread().getPriority());
        int seqnum = 0;
        long timestamp = 0L;
        while (this.running) {
            byte[] buffer = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                this.socket.receive(packet);
                if (this.payloadType == 256) {
                    this.media.onReceiveData(packet.getData(), packet.getLength());
                } else {
                    boolean mp;
                    RTPPacket frame = new RTPPacket(packet.getData(), packet.getLength());
                    int lost = 0;
                    if (this.ecm) {
                        if (!this.first) {
                            lost = frame.getSequenceNumber() - seqnum - 1 & 0xFFFF;
                        }
                        if (lost > 0 && ((lost = (int)((frame.getTimestamp() - timestamp) * (long)lost / (long)(lost + 1))) < 0 || lost > 30)) {
                            lost = 0;
                        }
                    }
                    seqnum = frame.getSequenceNumber();
                    timestamp = frame.getTimestamp();
                    if (this.srtpR != null) {
                        try {
                            this.srtpR.decrypt(frame);
                        }
                        catch (Exception e) {
                            this.media.toLog("decryption error");
                            continue;
                        }
                    }
                    if (frame.getSize() < 13) {
                        this.media.onReceiveData(packet.getData(), packet.getLength());
                        continue;
                    }
                    frame.setVersion(VERSION);
                    int ptype = frame.getPayloadType();
                    boolean bl = mp = ptype == this.payloadType || ptype == 19 && this.payloadType == 18 || ptype > 90 && this.payloadType > 90 && frame.getPayloadSize() != 4;
                    if (ptype == RFC2833 && frame.getPayloadSize() == 4) {
                        if ((frame.getByte(1) & 0x80) == 0) {
                            dtmfEnded = false;
                        } else if (!dtmfEnded) {
                            int data = frame.getByte(0) & 0xFF;
                            int duration = frame.getByte(2) << 8 & 0xFF00 | frame.getByte(3) & 0xFF;
                            if (duration >= 80 && data < RFC2833CHARSET.length) {
                                this.media.digitReceived(RFC2833CHARSET[data]);
                                dtmfEnded = true;
                            }
                        }
                    } else if (mp && this.dtmfDecoder != null) {
                        try {
                            this.dtmfDecoder.check(frame.getBuffer(), frame.getPayloadOffset(), frame.getPayloadSize());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.payloadType != -1) {
                        this.media.onReceiveData(frame.getBuffer(), frame.getSize(), ptype, frame.getPayloadOffset(), mp, lost);
                    }
                    this.rtcp.onReceiveData(frame, packet.getAddress(), packet.getPort(), this.fts);
                }
                ++this.totalPacketsReceived;
                this.totalOctetsReceived += packet.getLength() + 20;
                if (!this.first) continue;
                InetAddress receivedAddress = packet.getAddress();
                int receivedPort = packet.getPort();
                this.media.toLog("receivedAddress=" + receivedAddress + ":" + receivedPort + " remoteAddress=" + this.remoteAddress + ":" + this.remotePort + " sym=" + this.sym);
                if (this.remoteAddress == null || this.sym && (receivedPort != this.remotePort || !receivedAddress.equals(this.remoteAddress))) {
                    this.remoteAddress = receivedAddress;
                    this.remotePort = receivedPort;
                    this.rtcp.setRemoteAddress(receivedAddress, receivedPort + 1);
                }
                this.first = false;
                if (dmztimeout <= 0L) continue;
                dmztimeout = 0L;
                this.socket.setSoTimeout(socketTimeout);
            }
            catch (SocketTimeoutException se) {
                this.media.toLog("Receiver " + this + " SocketTimeoutException socketTimeout=" + socketTimeout + " dmztimeout=" + dmztimeout + " state=" + this.media.getState());
                if (this.totalPacketsSent == 0) {
                    this.sendDumb(dc++);
                }
                if (dmztimeout > 0L) {
                    if (this.media.getState() == 9) {
                        this.media.onReadTimeout();
                        continue;
                    }
                    if (System.currentTimeMillis() < dmztimeout) continue;
                    dmztimeout = 0L;
                    if (this.nat) {
                        this.localAddress = null;
                        this.exposedlocalPort = this.localPort;
                        this.nat = false;
                        this.media.redefineMedia();
                    }
                    try {
                        this.socket.setSoTimeout(socketTimeout);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (socketTimeout <= 0 || this.payloadType == -1) continue;
                this.media.forceDisconnect();
                break;
            }
            catch (SocketException e) {
                ResourceStore.error("RTP", e);
                break;
            }
            catch (Throwable e) {
                ResourceStore.error("RTP", e);
                if (this.payloadType != -1) continue;
                break;
            }
        }
        if (this.dtmfDecoder != null) {
            try {
                this.dtmfDecoder.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.inwork = false;
        this.media.toLog("End Receiver-" + this.hashCode());
    }
}

