/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.rtp;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.rtp.RTP;
import com.smile.telephony.rtp.RTPPacket;
import java.util.HashMap;
import smile.util.ResourceStore;
import smile.util.Utils;

public class RTPTransmitter
implements Runnable {
    private RTP rtp;
    private RTPPacket dtmfFrame;
    private int payloadType;
    private int ssrc;
    private int seqNumber;
    private int timestamp;
    private int payloadSize;
    private int millisInc;
    private int tstampInc;
    private int dtmfDuration;
    private boolean running;
    private boolean transmit = false;
    private boolean inwork = false;
    private long lastTick = 0L;

    public RTPTransmitter(RTP rtp) {
        this.rtp = rtp;
        this.dtmfFrame = new RTPPacket(16);
        this.seqNumber = Utils.intRandom(Short.MAX_VALUE);
        this.payloadType = -1;
        this.running = true;
    }

    public void start(AudioCodec codec, int fpp, HashMap prms) {
        ResourceStore.toLog(" START TRANSMITTER inwork=" + this.inwork + " prms=" + prms + " codec=" + codec);
        if (prms != null) {
            int maxfpp;
            String maxptime;
            int minfpp;
            String minptime = (String)prms.get("minptime");
            if (minptime != null && fpp < (minfpp = Integer.parseInt(minptime) / codec.getFrameTime())) {
                fpp = minfpp;
            }
            if ((maxptime = (String)prms.get("maxptime")) != null && fpp > (maxfpp = Integer.parseInt(maxptime) / codec.getFrameTime())) {
                fpp = maxfpp;
            }
        }
        int oldPayloadType = this.payloadType;
        this.payloadType = codec.getPayloadType();
        this.payloadSize = codec.getFrameSize() * fpp;
        this.millisInc = codec.getFrameTime() * fpp;
        this.tstampInc = this.millisInc * codec.getKhz() / 1000;
        if (oldPayloadType != this.payloadType) {
            this.ssrc = Utils.intRandom();
            this.timestamp = Utils.intRandom(65535);
        } else {
            int delta = (int)(System.currentTimeMillis() - this.lastTick);
            int skipped = delta / this.millisInc;
            this.timestamp += skipped * this.millisInc * 8;
        }
        this.dtmfFrame.setVersion(RTP.VERSION);
        this.transmit = true;
        if (!this.inwork) {
            this.inwork = true;
            Thread thread = new Thread(this);
            thread.setPriority(10);
            thread.start();
        }
    }

    public void close() {
        this.running = false;
    }

    public void stop() {
        this.transmit = false;
        ResourceStore.toLog("STOP Transmitter-" + this.hashCode());
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public boolean isTransmit() {
        return this.transmit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResourceStore.toLog("Run Transmitter-" + this.hashCode() + " seqNumber=" + this.seqNumber + " timestamp=" + this.timestamp + " payloadType=" + this.payloadType + " payloadSize=" + this.payloadSize + " millisInc=" + this.millisInc);
        long dtmfStartTimestamp = 0L;
        boolean mark = true;
        int scount = 0;
        int dc = 100;
        this.lastTick = System.currentTimeMillis();
        while (this.running) {
            try {
                this.lastTick += (long)this.millisInc;
                long sleepTime = this.lastTick - System.currentTimeMillis();
                if (sleepTime > 0L) {
                    RTPTransmitter rTPTransmitter = this;
                    synchronized (rTPTransmitter) {
                        this.wait(sleepTime);
                    }
                }
                this.timestamp += this.tstampInc;
                if (!this.transmit) continue;
                RTPPacket voiceFrame = new RTPPacket(512);
                voiceFrame.setVersion(RTP.VERSION);
                voiceFrame.setSyncSource(this.ssrc);
                voiceFrame.setPayloadType(this.payloadType);
                int len = this.rtp.readBuffer(voiceFrame.getBuffer(), 12, this.payloadSize);
                if (this.dtmfDuration > 0) {
                    if (dtmfStartTimestamp == 0L) {
                        dtmfStartTimestamp = this.timestamp;
                        this.dtmfFrame.setTimestamp(this.timestamp);
                    } else {
                        long duration = (long)this.timestamp - dtmfStartTimestamp;
                        if (duration >= (long)this.dtmfDuration) {
                            this.dtmfDuration = 0;
                            dtmfStartTimestamp = 0L;
                            this.dtmfFrame.setByte(1, (byte)(this.dtmfFrame.getByte(1) | 0x80));
                        }
                        this.dtmfFrame.setByte(2, (byte)(duration >> 8));
                        this.dtmfFrame.setByte(3, (byte)duration);
                    }
                    this.dtmfFrame.setMarker(mark);
                    this.dtmfFrame.setTimestamp(this.timestamp);
                    this.dtmfFrame.setSequenceNumber(this.seqNumber & 0xFFFF);
                    this.rtp.sendRTPPacket(this.dtmfFrame.getBuffer(), 16);
                } else {
                    if (len == -1) continue;
                    if (len == 0) {
                        if (++scount >= 100) {
                            scount = 0;
                            this.rtp.sendDumb(dc++);
                        }
                        if (mark) continue;
                        RTPTransmitter rTPTransmitter = this;
                        synchronized (rTPTransmitter) {
                            this.wait(this.millisInc);
                        }
                        len = this.rtp.readBuffer(voiceFrame.getBuffer(), 12, this.payloadSize);
                        if (len == 0) {
                            mark = true;
                            continue;
                        }
                    }
                    scount = 0;
                    voiceFrame.setMarker(mark);
                    voiceFrame.setTimestamp(this.timestamp);
                    voiceFrame.setSequenceNumber(this.seqNumber & 0xFFFF);
                    this.rtp.sendRTPPacket(voiceFrame.getBuffer(), 12 + len);
                }
                ++this.seqNumber;
                mark = false;
            }
            catch (Exception e) {
                ResourceStore.error("RTPTransmitter", e);
                break;
            }
        }
        this.inwork = false;
        this.transmit = false;
        ResourceStore.toLog("End Transmitter-" + this.hashCode() + " seqNumber=" + this.seqNumber + " timestamp=" + this.timestamp + " lastTick=" + this.lastTick + " running=" + this.running);
    }

    public void sendDigit(char c, int duration, int volume, int pause) {
        int i;
        for (i = 0; i < RTP.RFC2833CHARSET.length && c != RTP.RFC2833CHARSET[i]; ++i) {
        }
        if (i == RTP.RFC2833CHARSET.length) {
            return;
        }
        this.dtmfFrame.setSyncSource(this.ssrc);
        this.dtmfFrame.setPayloadType(RTP.RFC2833);
        this.dtmfFrame.setByte(0, (byte)i);
        this.dtmfFrame.setByte(1, (byte)volume);
        this.dtmfFrame.setByte(2, (byte)0);
        this.dtmfFrame.setByte(3, (byte)0);
        this.dtmfDuration = duration * 8;
        int p = pause;
        if (!this.transmit) {
            this.sendDTMF();
        } else {
            p += duration;
        }
        try {
            Thread.sleep(p);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDTMF() {
        long dtmfStartTimestamp = 0L;
        boolean mark = true;
        this.timestamp = this.lastTick != 0L ? (int)(System.currentTimeMillis() - this.lastTick) * 8 : Utils.intRandom(65535);
        this.lastTick = System.currentTimeMillis();
        try {
            while (this.dtmfDuration > 0) {
                if (dtmfStartTimestamp == 0L) {
                    dtmfStartTimestamp = this.timestamp;
                    this.dtmfFrame.setTimestamp(this.timestamp);
                } else {
                    long duration = (long)this.timestamp - dtmfStartTimestamp;
                    if (duration >= (long)this.dtmfDuration) {
                        this.dtmfDuration = 0;
                        dtmfStartTimestamp = 0L;
                        this.dtmfFrame.setByte(1, (byte)(this.dtmfFrame.getByte(1) | 0x80));
                    }
                    this.dtmfFrame.setByte(2, (byte)(duration >> 8));
                    this.dtmfFrame.setByte(3, (byte)duration);
                }
                this.dtmfFrame.setMarker(mark);
                this.dtmfFrame.setTimestamp(this.timestamp);
                this.dtmfFrame.setSequenceNumber(this.seqNumber & 0xFFFF);
                this.rtp.sendRTPPacket(this.dtmfFrame.getBuffer(), 16);
                this.lastTick += 30L;
                RTPTransmitter duration = this;
                synchronized (duration) {
                    this.wait(30L);
                }
                this.timestamp += 240;
                ++this.seqNumber;
                mark = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void toLog(String str) {
        System.out.println(str);
    }
}

