/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.rtp;

import com.smile.telephony.rtp.RTPPacket;
import com.smile.telephony.rtp.SRTP;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SRTPContext {
    private static final long REPLAY_WINDOW_SIZE = 64L;
    private long ssrc;
    private byte[] mki;
    private int roc;
    private int seqNum;
    private long keyDerivationRate;
    private long replayWindow;
    private byte[] masterKey;
    private byte[] masterSalt;
    private byte[] encKey;
    private byte[] authKey;
    private byte[] saltKey;
    private final SRTP srtp;
    private Mac mac;
    private Cipher cipher = null;
    private Cipher cipherF8 = null;
    private byte[] ivStore = new byte[16];
    private String initSpec = "AES";
    boolean enc = false;

    public SRTPContext(SRTP srtp, long ssrc) throws Exception {
        this.srtp = srtp;
        this.ssrc = ssrc;
        this.mki = null;
        this.roc = 0;
        this.keyDerivationRate = srtp.getDeriveRate();
        this.masterKey = new byte[srtp.getEncKeyLength()];
        System.arraycopy(srtp.getMasterKey(), 0, this.masterKey, 0, srtp.getEncKeyLength());
        this.masterSalt = new byte[srtp.getSaltKeyLength()];
        System.arraycopy(srtp.getMasterSalt(), 0, this.masterSalt, 0, srtp.getSaltKeyLength());
        this.encKey = new byte[srtp.getEncKeyLength()];
        this.saltKey = new byte[srtp.getSaltKeyLength()];
        String jvendor = System.getProperty("java.vendor");
        if (jvendor.indexOf("Android") != -1 || jvendor.indexOf("RoboVM") != -1) {
            this.initSpec = "AES/ECB/NoPADDING";
        }
        this.cipher = Cipher.getInstance(this.initSpec);
        if (srtp.getEncType() == 2) {
            this.cipherF8 = Cipher.getInstance("AES");
        }
        if (srtp.getAuthType() == 1) {
            this.mac = Mac.getInstance("HmacSHA1");
            this.authKey = new byte[srtp.getAuthKeyLength()];
        }
    }

    public int getAuthTagLength() {
        return this.srtp.getAuthTagLength();
    }

    public int getMKILength() {
        return this.mki != null ? this.mki.length : 0;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public int getROC() {
        return this.roc;
    }

    public void setROC(int rocIn) {
        this.roc = rocIn;
    }

    public void init(int seqNo) throws Exception {
        this.seqNum = seqNo;
        long label = 0L;
        this.computeIv(label, this.seqNum);
        SecretKeySpec skeySpec = new SecretKeySpec(this.masterKey, this.initSpec);
        this.cipher.init(1, skeySpec);
        this.doCipher(this.cipher, this.ivStore, this.encKey, 0, this.encKey.length);
        if (this.authKey != null) {
            label = 1L;
            this.computeIv(label, this.seqNum);
            this.doCipher(this.cipher, this.ivStore, this.authKey, 0, this.authKey.length);
            if (this.srtp.getAuthType() == 1) {
                SecretKeySpec key = new SecretKeySpec(this.authKey, this.initSpec);
                this.mac.init(key);
            }
        }
        label = 2L;
        this.computeIv(label, this.seqNum);
        this.doCipher(this.cipher, this.ivStore, this.saltKey, 0, this.saltKey.length);
        SecretKeySpec keySpec = new SecretKeySpec(this.encKey, this.initSpec);
        this.cipher.init(1, keySpec);
    }

    public void encrypt(RTPPacket pkt) throws Exception {
        if (this.srtp.getEncType() == 1) {
            this.processPacketAESCM(pkt);
        } else if (this.srtp.getEncType() == 2) {
            this.processPacketAESF8(pkt, 1);
        }
        int seqNo = pkt.getSequenceNumber();
        int diff = seqNo - this.seqNum;
        if (diff > 0 && diff < 32768) {
            this.seqNum = seqNo & 0xFFFF;
        } else if (diff < Short.MIN_VALUE) {
            ++this.roc;
            this.seqNum = seqNo & 0xFFFF;
        }
        if (this.srtp.getAuthType() == 1) {
            byte[] tag = this.doMac(pkt.getBuffer(), pkt.getSize(), this.roc);
            pkt.append(tag, this.srtp.getAuthTagLength());
        }
    }

    public void decrypt(RTPPacket pkt, boolean checkReplay) throws Exception {
        int seqNo = pkt.getSequenceNumber();
        int guessedROC = this.seqNum < 32768 ? (seqNo - this.seqNum > 32768 ? this.roc - 1 : this.roc) : (this.seqNum - 32768 > seqNo ? this.roc + 1 : this.roc);
        long guessedIndex = (long)guessedROC << 16 | (long)seqNo;
        long localIndex = (long)this.roc << 16 | (long)this.seqNum;
        long delta = guessedIndex - localIndex;
        if (checkReplay && delta <= 0L) {
            if (-delta > 64L) {
                throw new SecurityException("Packet too old");
            }
            if ((this.replayWindow >> (int)(-delta) & 1L) != 0L) {
                throw new SecurityException("Packet already received");
            }
        }
        if (this.srtp.getAuthType() == 1) {
            int length = this.srtp.getAuthTagLength();
            int newsize = pkt.getSize() - length;
            byte[] b = pkt.getBuffer();
            byte[] tag = this.doMac(b, newsize, guessedROC);
            for (int i = 0; i < length; ++i) {
                if ((b[newsize + i] & 0xFF) == (tag[i] & 0xFF)) continue;
                throw new SecurityException("Packet authentication error");
            }
            pkt.setSize(newsize);
            int mkilen = this.srtp.getMKILength();
            if (mkilen > 0) {
                pkt.setSize(newsize - mkilen);
            }
        }
        if (this.srtp.getEncType() == 1) {
            this.processPacketAESCM(pkt);
        } else if (this.srtp.getEncType() == 2) {
            this.processPacketAESF8(pkt, 2);
        }
        delta = guessedIndex - ((long)this.roc << 16 | (long)this.seqNum);
        if (delta > 0L) {
            this.replayWindow <<= (int)delta;
            this.replayWindow |= 1L;
        } else {
            this.replayWindow |= (long)(1 << (int)delta);
        }
        if (seqNo > this.seqNum) {
            this.seqNum = seqNo & 0xFFFF;
        }
        if (guessedROC > this.roc) {
            this.roc = guessedROC;
            this.seqNum = seqNo & 0xFFFF;
        }
    }

    public void processPacketAESCM(RTPPacket pkt) throws Exception {
        int i;
        long ssrc = pkt.getSyncSource();
        int seqNo = pkt.getSequenceNumber();
        long index = (long)this.roc << 16 | (long)seqNo;
        this.ivStore[0] = this.saltKey[0];
        this.ivStore[1] = this.saltKey[1];
        this.ivStore[2] = this.saltKey[2];
        this.ivStore[3] = this.saltKey[3];
        for (i = 4; i < 8; ++i) {
            this.ivStore[i] = (byte)(0xFFL & ssrc >> (7 - i) * 8 ^ (long)this.saltKey[i]);
        }
        for (i = 8; i < 14; ++i) {
            this.ivStore[i] = (byte)(0xFF & (byte)(index >> (13 - i) * 8) ^ this.saltKey[i]);
        }
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
        int len = pkt.getPayloadSize();
        int off = pkt.getPayloadOffset();
        byte[] data = pkt.getBuffer();
        byte[] b = new byte[len];
        this.doCipher(this.cipher, this.ivStore, b, 0, len);
        for (int j = 0; j < len; ++j) {
            int n = j + off;
            data[n] = (byte)(data[n] ^ b[j]);
        }
    }

    public void processPacketAESF8(RTPPacket pkt, int mode) throws Exception {
        int i;
        System.arraycopy(pkt.getBuffer(), 0, this.ivStore, 0, 12);
        this.ivStore[0] = 0;
        this.ivStore[12] = (byte)(this.roc >> 24);
        this.ivStore[13] = (byte)(this.roc >> 16);
        this.ivStore[14] = (byte)(this.roc >> 8);
        this.ivStore[15] = (byte)this.roc;
        byte[] ivAccent = new byte[16];
        byte[] saltMask = new byte[this.encKey.length];
        byte[] maskedKey = new byte[this.encKey.length];
        System.arraycopy(this.saltKey, 0, saltMask, 0, this.saltKey.length);
        for (i = this.saltKey.length; i < saltMask.length; ++i) {
            saltMask[i] = 85;
        }
        for (i = 0; i < this.encKey.length; ++i) {
            maskedKey[i] = (byte)(this.encKey[i] ^ saltMask[i]);
        }
        SecretKeySpec keySpec = new SecretKeySpec(maskedKey, "AES");
        this.cipherF8.init(mode, keySpec);
        this.cipherF8.doFinal(this.ivStore, 0, this.ivStore.length, ivAccent, 0);
        saltMask = null;
        maskedKey = null;
        long J = 0L;
        byte[] S = new byte[16];
        Arrays.fill(S, (byte)0);
        int inLen = pkt.getPayloadSize();
        int off = pkt.getPayloadOffset();
        byte[] data = pkt.getBuffer();
        while (inLen > 0) {
            for (int i2 = 0; i2 < 16; ++i2) {
                int n = i2;
                S[n] = (byte)(S[n] ^ ivAccent[i2]);
            }
            S[12] = (byte)((long)S[12] ^ J >> 24);
            S[13] = (byte)((long)S[13] ^ J >> 16);
            S[14] = (byte)((long)S[14] ^ J >> 8);
            S[15] = (byte)((long)S[15] ^ J >> 0);
            ++J;
            this.cipher.doFinal(S, 0, S.length, S, 0);
            int n = Math.min(inLen, 16);
            for (int i3 = 0; i3 < n; ++i3) {
                data[off + i3] = (byte)(data[off + i3] ^ S[i3]);
            }
            inLen -= 16;
            off += 16;
        }
    }

    private byte[] doMac(byte[] pbuf, int psize, int r) throws Exception {
        this.mac.update(pbuf, 0, psize);
        byte[] rb = new byte[]{(byte)(r >> 24), (byte)(r >> 16), (byte)(r >> 8), (byte)r};
        this.mac.update(rb, 0, 4);
        byte[] b = new byte[this.mac.getMacLength()];
        this.mac.doFinal(b, 0);
        return b;
    }

    private void computeIv(long label, long index) {
        int i;
        long key_id = this.keyDerivationRate == 0L ? label << 48 : label << 48 | index / this.keyDerivationRate;
        for (i = 0; i < 7; ++i) {
            this.ivStore[i] = this.masterSalt[i];
        }
        for (i = 7; i < 14; ++i) {
            this.ivStore[i] = (byte)((byte)(0xFFL & key_id >> 8 * (13 - i)) ^ this.masterSalt[i]);
        }
        this.ivStore[15] = 0;
        this.ivStore[14] = 0;
    }

    private void doCipher(Cipher aesCipher, byte[] in, byte[] out, int off, int length) throws Exception {
        int i;
        int bsize = 16;
        byte[] b = new byte[bsize];
        System.arraycopy(in, 0, b, off, 14);
        int c = length / bsize;
        for (i = 0; i < c; ++i) {
            b[14] = (byte)((i & 0xFF00) >> 8);
            b[15] = (byte)(i & 0xFF);
            aesCipher.update(b, 0, bsize, out, i * bsize);
        }
        int p = length % bsize;
        if (p > 0) {
            b[14] = (byte)((i & 0xFF00) >> 8);
            b[15] = (byte)(i & 0xFF);
            byte[] b1 = new byte[bsize];
            aesCipher.update(b, 0, bsize, b1, 0);
            System.arraycopy(b1, 0, out, i * bsize, p);
        }
    }
}

