/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip;

import com.smile.telephony.DeviceListener;
import com.smile.telephony.Resource;
import com.smile.telephony.ResourceProvider;
import com.smile.telephony.sip.SipEndpoint;
import com.smile.telephony.sip.SipPort;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.stack.ServerTransaction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class SipDevice
implements ResourceProvider {
    private static Vector endpoints = new Vector();
    protected Resource[] resources;
    private int channels = 1;

    @Override
    public void startBoard(String board, byte[] data) {
        this.channels = data.length;
    }

    public static boolean openChannel(String chname) {
        return true;
    }

    @Override
    public Resource[] getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        Vector<SipPort> ports = new Vector<SipPort>();
        String[] transport = this.getTransport();
        for (int i = 0; i < transport.length; ++i) {
            SipEndpoint sip = this.createEndpoint(transport[i]);
            for (int j = 0; j < this.channels; ++j) {
                ports.add(sip.createPort(sip.getDefaultPortName() + j));
            }
            endpoints.add(sip);
        }
        this.resources = new Resource[ports.size()];
        ports.copyInto(this.resources);
        return this.resources;
    }

    protected String[] getTransport() {
        String[] transport = new String[]{"UDP"};
        return transport;
    }

    protected SipEndpoint createEndpoint(String transport) {
        return new SipEndpoint(transport);
    }

    @Override
    public String getDeviceName() {
        return "SIP Device";
    }

    public static String sendMessage(String dest, String orig, String text) throws Exception {
        byte[] content = text.getBytes("UTF-8");
        return SipDevice.sendMessage(null, dest, orig, content, content.length, "text", "plain");
    }

    public static String sendMessage(String callId, String dest, String orig, Object content, int contentLength, String type, String sybtype) throws Exception {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            String messageId = sip.sendMessage(callId, dest, orig, content, contentLength, type, sybtype);
            if (messageId == null) continue;
            return messageId;
        }
        return null;
    }

    public static void sendMessageResponse(String callId, int statusCode) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            if (!sip.processMessageResponse(callId, statusCode)) continue;
            return;
        }
    }

    public static String deliverMessage(Request request, ServerTransaction transaction) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            String messageId = sip.deliverMessage(request, transaction);
            if (messageId == null) continue;
            return messageId;
        }
        return null;
    }

    public static void setDeviceListener(DeviceListener listener) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            sip.setDeviceListener(listener);
        }
    }

    public static void setCapabilities(int[] caps) throws Exception {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            sip.setCapabilities(caps);
            Map epProperties = sip.getProperties();
            epProperties.put("h323.capabilities", caps);
        }
    }

    public static void setJitterBuffer(int minvalue, int maxvalue) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            sip.setMinJitter(minvalue);
            sip.setMaxJitter(maxvalue);
        }
    }

    public static String doRegistration(Map props, boolean sync) throws Exception {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            String res = sip.doRegistration(props, sync);
            if (res == null) continue;
            return res;
        }
        throw new Exception("Transport unavailable");
    }

    public static void cancelRegistration(Map props) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            sip.cancelRegistration(props);
        }
    }

    public static void cancelRegistration(boolean unreg) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            sip.cancelRegistration(unreg);
        }
    }

    public static String getRegisteredUsername() {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            String res = sip.getRegisteredUsername();
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static String getRemoteSecret() {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            String res = sip.getRemoteSecret();
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static long getLastRegistrationTime() {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            long res = sip.getLastRegistrationTime();
            if (res <= 0L) continue;
            return res;
        }
        return 0L;
    }

    public static void setStun(String regkey, String stunserver) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            if (!regkey.equals(sip.getRegistrationId())) continue;
            sip.setStun(stunserver);
            break;
        }
    }

    public static void setProperty(String key, Object value) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            sip.setProperty(key, value);
        }
    }

    public static void setRegistrationPassword(String pass) {
        Enumeration en = endpoints.elements();
        while (en.hasMoreElements()) {
            SipEndpoint sip = (SipEndpoint)en.nextElement();
            if (!sip.setRegistrationPassword(pass)) continue;
            return;
        }
    }
}

