/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip;

import com.smile.telephony.MediaEndpoint;
import com.smile.telephony.sip.Registration;
import com.smile.telephony.sip.SdpInfo;
import com.smile.telephony.sip.SipCall;
import com.smile.telephony.sip.SipDevice;
import com.smile.telephony.sip.SipPort;
import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.AddressFactory;
import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.AcceptHeader;
import com.smile.telephony.sip.header.AllowHeader;
import com.smile.telephony.sip.header.AuthorizationHeader;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.CallIdHeader;
import com.smile.telephony.sip.header.ContactHeader;
import com.smile.telephony.sip.header.ContentLengthHeader;
import com.smile.telephony.sip.header.ContentTypeHeader;
import com.smile.telephony.sip.header.EventHeader;
import com.smile.telephony.sip.header.FromHeader;
import com.smile.telephony.sip.header.HeaderFactory;
import com.smile.telephony.sip.header.MaxForwardsHeader;
import com.smile.telephony.sip.header.ProxyAuthenticateHeader;
import com.smile.telephony.sip.header.ReferToHeader;
import com.smile.telephony.sip.header.ReplyToHeader;
import com.smile.telephony.sip.header.RouteHeader;
import com.smile.telephony.sip.header.ServerHeader;
import com.smile.telephony.sip.header.SubscriptionStateHeader;
import com.smile.telephony.sip.header.ToHeader;
import com.smile.telephony.sip.header.UserAgentHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.header.WWWAuthenticateHeader;
import com.smile.telephony.sip.header.WarningHeader;
import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.ClientTransaction;
import com.smile.telephony.sip.stack.Dialog;
import com.smile.telephony.sip.stack.RequestEvent;
import com.smile.telephony.sip.stack.ResponseEvent;
import com.smile.telephony.sip.stack.ServerTransaction;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.Transaction;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import smile.util.MimeMessage;
import smile.util.ResourceStore;
import smile.util.Utils;

public class SipEndpoint
extends MediaEndpoint {
    public static final String CHANNEL_NAME = "splink";
    public static final int DEFAULT_PORT = 5060;
    public static final int[] DEFAULT_PARAMETERS = new int[]{1, 60, 5000, 15000, 5000, 0, 0, 0};
    public static final int[] DEFAULT_CAPABILITIES = new int[]{28162, 1282, 2306, 3074, 257, 25088};
    public static final String ALLOWED = "INVITE, ACK, OPTIONS, CANCEL, BYE, UPDATE, REFER, NOTIFY, INFO, SUBSCRIBE, MESSAGE";
    static HeaderFactory sipHeaderFactory = new HeaderFactory();
    static AddressFactory sipAddressFactory = new AddressFactory();
    private String ipaddress;
    private String transport;
    private int listPort;
    private String outboundProxy;
    private String outboundServer;
    private HashMap invites = new HashMap();
    private HashMap activeCalls = new HashMap();
    private SipStack sipStack;
    private int traceLevel = 0;
    private int expires = 3000;
    private int bandwidth = 10000;
    private int sotimeout = 0;
    private boolean isclient;
    private String regAddress;
    private String regLogin;
    private String regPassw;
    private long lastPacketTime;
    private HashMap registrations = new HashMap();
    private HashMap registeredUas = new HashMap();
    private HashMap registeredHosts = new HashMap();
    private HashMap messages = new HashMap();
    static final char[] DCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int getDefaultPort(String transport) {
        if ("TLS".equalsIgnoreCase(transport)) {
            return 5061;
        }
        if ("TCP".equalsIgnoreCase(transport)) {
            return 5061;
        }
        if ("WSS".equalsIgnoreCase(transport)) {
            return 443;
        }
        if ("WS".equalsIgnoreCase(transport)) {
            return 80;
        }
        return 5060;
    }

    public static int convertCodecNumber(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 9: {
                return 0;
            }
            case 12: {
                return 18;
            }
        }
        return n;
    }

    public String createBranchId() {
        return "z9hG4bK" + Long.toHexString(Utils.longRandom());
    }

    public String createCallId() {
        return Long.toHexString(System.nanoTime()) + Long.toHexString(Utils.longRandom());
    }

    public String createTag() {
        return Integer.toHexString(Utils.intRandom());
    }

    public int createSeqNumber() {
        return Utils.intRandom() & 0xFFFF;
    }

    public SipEndpoint(String transp) {
        this.transport = transp;
        this.ipaddress = "0.0.0.0";
        this.listPort = 59600 + new Random(System.currentTimeMillis()).nextInt(100);
        try {
            this.sipStack = new SipStack(this, this.ipaddress, this.listPort, transp);
            this.listPort = this.sipStack.getPort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.setAddress(this.ipaddress);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.sipStack.dispose();
    }

    @Override
    public int getProtocolId() {
        return 1;
    }

    @Override
    public String getDefaultPortName() {
        return this.transport.toLowerCase();
    }

    @Override
    public int[] getDefaultParameters() {
        return DEFAULT_PARAMETERS;
    }

    @Override
    public int[] getDefaultCapabilities() {
        return DEFAULT_CAPABILITIES;
    }

    @Override
    public int getListenerPort() {
        return this.listPort;
    }

    public String getListeningAddress() {
        return this.ipaddress;
    }

    public void onRemoteAnswer() {
        this.listener.incomingCallRemoteAnswer();
    }

    public SipPort createPort(String key) {
        SipPort port = new SipPort(key);
        this.addPort(port);
        return port;
    }

    public String getTransport() {
        return this.transport;
    }

    public int getTCPSocketTimeout() {
        return this.sotimeout;
    }

    public int getPortBandwidth() {
        return this.bandwidth / this.channels;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public String getOutboundProxy() {
        return this.outboundProxy;
    }

    public boolean isClient() {
        return this.isclient;
    }

    @Override
    public void setProperties(Map props) throws Exception {
        super.setProperties(props);
        try {
            this.bandwidth = (Integer)this.properties.get("h323.bandwidth");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.outboundProxy = (String)this.properties.get("sip.outbound_proxy");
        if (this.outboundProxy != null && this.outboundProxy.length() == 0) {
            this.outboundProxy = null;
        }
        try {
            this.expires = (Integer)this.properties.get("sip.call_expires");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.traceLevel = (Integer)this.properties.get("sip.trace");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String transp = (String)this.properties.get("sip.protocol");
        transp = transp != null ? transp.toUpperCase() : this.transport;
        this.setSecure("TLS".equals(transp) || "WSS".equals(transp));
        try {
            this.sotimeout = (Integer)this.properties.get("sip.tcp.socket_timeout") * 1000;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isclient = true;
        int port = this.listPort;
        try {
            port = (Integer)this.properties.get("h323.port");
        }
        catch (Exception e) {
            this.properties.put("h323.port", port);
        }
        String address = (String)this.properties.get("h323.address");
        if (address == null || address.length() == 0) {
            address = "0.0.0.0";
        }
        if (this.sipStack == null) {
            this.sipStack = new SipStack(this, address, port, transp);
            super.setAddress(address);
            this.ipaddress = address;
            this.transport = transp;
            this.listPort = this.sipStack.getPort();
        }
        String reg = (String)this.properties.get("h323.gatekeeper");
        if (this.regAddress != null && !this.regAddress.equals(reg)) {
            this.cancelRegistration(true);
        }
        if (reg != null && !reg.equals("")) {
            String passw;
            String login;
            if (Boolean.TRUE.equals(this.properties.get("sip.reconnect"))) {
                this.sipStack.closeChannels();
            }
            if ((login = (String)this.properties.get("h323.gk_login")) == null) {
                login = "";
            }
            if ((passw = (String)this.properties.get("h323.gk_password")) == null) {
                passw = "";
            }
            boolean autoretry = !this.properties.containsKey("sip.noretry");
            Integer ttl = (Integer)this.properties.get("sip.reg_expires");
            if (ttl == null) {
                ttl = this.isclient ? 600 : 60;
            }
            this.register(reg, login, login, passw, ttl, null, null, null, null, true, false, autoretry);
            this.regAddress = reg;
            this.regLogin = login;
            this.regPassw = passw;
            try {
                this.setServerAddress(reg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getRegistrationId() {
        if (this.regAddress == null || this.regAddress.length() == 0) {
            return "";
        }
        return this.regLogin + "@" + this.regAddress;
    }

    @Override
    public String getRegistrationAddress() {
        return this.regAddress;
    }

    public String getRegisteredUsername() {
        if (this.regAddress == null || this.regAddress.length() == 0) {
            return null;
        }
        Registration reg = (Registration)this.registeredUas.get(this.regLogin + "@" + this.regAddress);
        if (reg == null) {
            return null;
        }
        return reg.getRegisteredUser();
    }

    public String getRemoteSecret() {
        if (this.regAddress == null || this.regAddress.length() == 0) {
            return null;
        }
        Registration reg = (Registration)this.registeredUas.get(this.regLogin + "@" + this.regAddress);
        if (reg == null) {
            return null;
        }
        return reg.getRemoteSecret();
    }

    public boolean setRegistrationPassword(String pass) {
        Registration reg = (Registration)this.registeredUas.get(this.regLogin + "@" + this.regAddress);
        if (reg == null) {
            return false;
        }
        reg.setUserPassword(pass);
        return true;
    }

    public void cancelRegistration() {
        this.cancelRegistration(true);
    }

    @Override
    public void cancelRegistration(boolean unreg) {
        this.cancelRegistration(this.regLogin, this.regAddress, unreg);
        this.regAddress = null;
        this.regLogin = null;
        this.regPassw = null;
    }

    public String doRegistration(Map props, boolean sync) throws Exception {
        String transp = (String)props.get("sip.protocol");
        if (!this.transport.equals(transp)) {
            return null;
        }
        if (this.transport.equalsIgnoreCase("WSS")) {
            this.setProperties(props);
            return this.regLogin + "@" + this.regAddress;
        }
        return this.register(props, sync);
    }

    public void cancelRegistration(Map props) {
        String user = (String)props.get("h323.gk_login");
        String address = (String)props.get("h323.gatekeeper");
        this.cancelRegistration(user, address, true);
    }

    @Override
    public void updateRegistration() {
    }

    public long getLastRegistrationTime() {
        return this.getLastRegistrationTime(this.regLogin, this.regAddress);
    }

    public void setStun(String stunserver) {
        try {
            this.discoverStun(stunserver);
        }
        catch (Exception e) {
            ResourceStore.error("setStun: " + e);
        }
    }

    public String getAuthorizationHeader() {
        Registration reg = (Registration)this.registeredUas.get(this.regLogin + "@" + this.regAddress);
        return reg != null ? reg.getAuthorizationHeader().toString() : null;
    }

    @Override
    public String getFeatureServerAlias() {
        return "";
    }

    public SipCall getIncomingCall(SipPort port) {
        SipCall call = this.getIncomingCall();
        if (call != null) {
            if (!this.sendTrying(call)) {
                return null;
            }
            if (call.getLocalHost() == null) {
                try {
                    call.setLocalHost(this.getLocalInetAddress(call.getReceivedAddress(), true).getHostAddress());
                }
                catch (UnknownHostException e) {
                    ResourceStore.error("IncomingCall", e);
                    return null;
                }
            }
            this.activeCalls.put(call.getCallId(), port);
            call.setSeqNumber(this.createSeqNumber());
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SipCall getIncomingCall() {
        HashMap hashMap = this.invites;
        synchronized (hashMap) {
            if (this.invites.isEmpty()) {
                return null;
            }
            String key = (String)this.invites.keySet().iterator().next();
            return (SipCall)this.invites.remove(key);
        }
    }

    public SipCall getCall(String callId) {
        SipPort sipPort = (SipPort)this.activeCalls.get(callId);
        return sipPort != null ? sipPort.getCall() : null;
    }

    public SipCall createOutgoingCall(String calledNumber, String callingNumber, String callingUser, String calledUser, String proxy, String router, boolean regmod) throws Exception {
        SipURI contactUri;
        SipURI fromUri;
        String key;
        String callingLogin = null;
        String callingParty = callingNumber;
        int n = callingNumber.lastIndexOf(64);
        if (n != -1) {
            callingParty = callingNumber.substring(0, n);
            callingLogin = callingNumber.substring(n + 1);
        }
        if ("".equals(callingParty)) {
            callingParty = null;
        }
        String calledParty = null;
        String calledAddress = calledNumber;
        n = calledNumber.lastIndexOf(64);
        if (n != -1) {
            calledParty = calledNumber.substring(0, n).trim();
            calledAddress = calledNumber.substring(n + 1);
        } else {
            n = calledNumber.lastIndexOf(42);
            if (n != -1) {
                calledAddress = calledNumber.substring(0, n);
            }
        }
        String remoteAddress = calledAddress;
        String contactAddress = router;
        String fromAddress = router;
        String proxyAddress = proxy;
        SipURI uri = null;
        SipURI toUri = null;
        Registration registration = null;
        if (callingLogin != null && (registration = (Registration)this.registeredUas.get(key = callingLogin + "@" + calledAddress)) != null) {
            uri = sipAddressFactory.createSipURI(calledParty, remoteAddress);
            if (!"UDP".equals(this.transport)) {
                uri.setTransportParam(this.transport);
            }
        }
        if (uri == null) {
            if (calledParty != null) {
                uri = sipAddressFactory.createSipURI(calledParty, remoteAddress);
            } else if (this.gateway.length() > 0) {
                remoteAddress = this.gateway;
                uri = sipAddressFactory.createSipURI(calledNumber, remoteAddress);
            } else if (this.regAddress != null && this.regAddress.length() > 0) {
                registration = (Registration)this.registeredUas.get(this.regLogin + "@" + this.regAddress);
                if (registration == null || registration.getStatus() != 2) {
                    throw new IllegalStateException("Lost registration: " + this.regAddress);
                }
                remoteAddress = registration.getServerAddress();
                uri = sipAddressFactory.createSipURI(calledNumber, remoteAddress);
            } else {
                remoteAddress = calledNumber;
                uri = sipAddressFactory.createSipURI("", remoteAddress);
            }
            if (!"UDP".equals(this.transport)) {
                uri.setTransportParam(this.transport);
            }
        }
        if (fromAddress == null) {
            fromAddress = this.getLocalAddress(this.outboundServer != null ? this.outboundServer : remoteAddress, false);
        }
        if (contactAddress == null) {
            contactAddress = this.outboundRouter == null ? fromAddress : this.getLocalAddress(remoteAddress, true);
        }
        if (registration != null) {
            if (regmod) {
                fromUri = sipAddressFactory.createSipURI(callingParty, registration.getFromURI().getHost());
                if (this.listPort != 5060) {
                    fromUri.setPort(this.listPort);
                }
            } else {
                fromUri = registration.getFromURI();
                if (!fromUri.getUser().equals(callingParty)) {
                    callingUser = callingParty;
                }
            }
            contactUri = registration.getContactURI();
        } else {
            fromUri = sipAddressFactory.createSipURI(callingParty, fromAddress);
            if (this.listPort != 5060) {
                fromUri.setPort(this.listPort);
            }
            contactUri = sipAddressFactory.createSipURI(callingParty, contactAddress);
            if (this.listPort != 5060) {
                contactUri.setPort(this.listPort);
            }
            if (!"UDP".equals(this.transport)) {
                contactUri.setTransportParam(this.transport);
            }
        }
        if (toUri == null) {
            if (calledUser != null) {
                n = calledUser.indexOf(64);
                if (n != -1) {
                    calledParty = calledUser.substring(0, n);
                    toUri = sipAddressFactory.createSipURI(calledParty, calledUser.substring(n + 1));
                } else {
                    toUri = uri;
                }
            } else {
                toUri = uri;
            }
        }
        if (calledParty == null) {
            calledParty = calledNumber;
        }
        if (callingUser == null) {
            callingUser = callingParty;
        }
        Address addressTo = sipAddressFactory.createAddress(calledParty, toUri);
        ToHeader toHeader = sipHeaderFactory.createToHeader(addressTo, null);
        Address addressFrom = sipAddressFactory.createAddress(callingUser, fromUri);
        FromHeader fromHeader = sipHeaderFactory.createFromHeader(addressFrom, this.createTag());
        ArrayList<ViaHeader> viaHeader = new ArrayList<ViaHeader>();
        viaHeader.add(sipHeaderFactory.createViaHeader(contactAddress, this.listPort, this.transport, this.createBranchId()));
        CallIdHeader callIdHeader = new CallIdHeader(this.createCallId());
        CSeqHeader cseq = sipHeaderFactory.createCSeqHeader(this.createSeqNumber(), "INVITE");
        MaxForwardsHeader maxForward = sipHeaderFactory.createMaxForwardsHeader(70);
        Request request = new Request(uri, "INVITE", callIdHeader, cseq, fromHeader, toHeader, viaHeader, maxForward);
        Address cAddress = sipAddressFactory.createAddress(contactUri);
        ContactHeader contactHeader = sipHeaderFactory.createContactHeader(cAddress);
        request.addHeader(contactHeader);
        AllowHeader allowHeader = sipHeaderFactory.createAllowHeader(ALLOWED);
        request.addHeader(allowHeader);
        UserAgentHeader uaHeader = sipHeaderFactory.createUserAgentHeader(this.productName);
        request.addHeader(uaHeader);
        SipCall call = new SipCall(request, null, 2, this.outboundServer);
        if (proxyAddress != null && proxyAddress.length() > 0) {
            request.addHeader(this.createRouteHeader(proxyAddress));
            call.setRouterAddress(proxyAddress);
        }
        this.addOutboundRouteHeaders(request);
        if (registration != null) {
            call.setUsername(registration.getUserLogin());
            call.setPassword(registration.getUserPassword());
        }
        return call;
    }

    public void sendInvite(SipPort sipPort, SipCall call, int timeout) throws Exception {
        Request request = call.getRequest();
        ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
        request.setContentType(contentType);
        byte[] content = call.getLocalSDPInfo().encode();
        request.setContent(content);
        ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
        transaction.sendRequest();
        call.setTransaction(transaction);
        this.activeCalls.put(((CallIdHeader)request.getHeader("Call-ID")).getCallId(), sipPort);
    }

    public boolean sendTrying(SipCall call) {
        try {
            Response response = call.getRequest().createResponse(100);
            ServerTransaction transaction = (ServerTransaction)call.getTransaction();
            transaction.sendResponse(response);
            call.setLocalTag(this.createTag());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void sendResponse(int statusCode, SipCall call) {
        if (call == null) {
            return;
        }
        Request request = call.getRequest();
        try {
            WarningHeader warning = null;
            if (statusCode == 0) {
                statusCode = 403;
                warning = sipHeaderFactory.createWarningHeader(this.productName, 399, "Call Rejected");
            }
            Response response = request.createResponse(statusCode);
            SipURI contactUri = sipAddressFactory.createSipURI(call.getLocalParty(), call.getLocalHost());
            if (this.listPort != 5060) {
                contactUri.setPort(this.listPort);
            }
            if (!"UDP".equals(this.transport)) {
                contactUri.setTransportParam(this.transport);
            }
            Address address = sipAddressFactory.createAddress(contactUri);
            ContactHeader contactHeader = sipHeaderFactory.createContactHeader(address);
            response.addHeader(contactHeader);
            if (warning != null) {
                response.addHeader(warning);
            }
            ServerHeader uaHeader = sipHeaderFactory.createServerHeader(this.productName);
            response.addHeader(uaHeader);
            ServerTransaction transaction = (ServerTransaction)call.getTransaction();
            transaction.sendResponse(response);
        }
        catch (Exception e) {
            ResourceStore.error("sendResponse: " + statusCode, e);
        }
        this.activeCalls.remove(call.getCallId());
    }

    public boolean sendResponse(int statusCode, SipCall call, String router) {
        if (call == null || !(call.getTransaction() instanceof ServerTransaction)) {
            return false;
        }
        Request request = call.getRequest();
        try {
            Response response;
            SdpInfo sdp = call.getLocalSDPInfo();
            if (sdp == null) {
                response = request.createResponse(statusCode);
            } else {
                ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
                response = request.createResponse(statusCode, contentType, sdp.encode());
            }
            SipURI contactUri = sipAddressFactory.createSipURI(call.getLocalParty(), call.getLocalHost());
            if (this.listPort != 5060) {
                contactUri.setPort(this.listPort);
            }
            if (!"UDP".equals(this.transport)) {
                contactUri.setTransportParam(this.transport);
            }
            Address address = sipAddressFactory.createAddress(contactUri);
            response.addHeader(sipHeaderFactory.createContactHeader(address));
            response.addHeader(sipHeaderFactory.createAllowHeader(ALLOWED));
            response.addHeader(sipHeaderFactory.createServerHeader(this.productName));
            response.addHeader(sipHeaderFactory.createAllowEventsHeader("talk"));
            ServerTransaction transaction = (ServerTransaction)call.getTransaction();
            transaction.sendResponse(response);
            return true;
        }
        catch (Exception e) {
            ResourceStore.error("sendResponse: " + statusCode, e);
            return false;
        }
    }

    public void sendResponse(int statusCode, SipCall call, Request request, ServerTransaction transaction, byte[] content) throws Exception {
        Response response;
        if (content == null) {
            response = request.createResponse(statusCode);
        } else {
            ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
            response = request.createResponse(statusCode, contentType, content);
        }
        if (statusCode == 200) {
            SipURI contactUri = sipAddressFactory.createSipURI(call.getLocalParty(), call.getLocalHost());
            if (this.listPort != 5060) {
                contactUri.setPort(this.listPort);
            }
            if (!"UDP".equals(this.transport)) {
                contactUri.setTransportParam(this.transport);
            }
            Address address = sipAddressFactory.createAddress(contactUri);
            ContactHeader contactHeader = sipHeaderFactory.createContactHeader(address);
            response.addHeader(contactHeader);
            response.addHeader(sipHeaderFactory.createServerHeader(this.productName));
            response.addHeader(sipHeaderFactory.createAllowEventsHeader("talk"));
        }
        transaction.sendResponse(response);
    }

    public Response createResponse(int statusCode, Request request) throws ParseException {
        Response response = request.createResponse(statusCode);
        response.addHeader(sipHeaderFactory.createServerHeader(this.productName));
        return response;
    }

    public Response createResponse(int statusCode, Request request, ContentTypeHeader contentType, byte[] content) throws ParseException {
        Response response = request.createResponse(statusCode, contentType, content);
        response.addHeader(sipHeaderFactory.createServerHeader(this.productName));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(RequestEvent requestEvent) {
        this.lastPacketTime = System.currentTimeMillis();
        Request request = requestEvent.getRequest();
        ServerTransaction transaction = requestEvent.getServerTransaction();
        String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        String requestName = request.getMethod();
        SipPort sipPort = (SipPort)this.activeCalls.get(callId);
        if (sipPort != null) {
            try {
                Response response = sipPort.processRequest(request, transaction);
                if (response != null) {
                    transaction.sendResponse(response);
                }
            }
            catch (Exception response) {
                // empty catch block
            }
            if (requestName.equals("BYE") || requestName.equals("CANCEL")) {
                this.activeCalls.remove(callId);
            }
        } else {
            if (transaction == null) {
                this.toLog(request, true);
                return;
            }
            if (requestName.equals("INVITE")) {
                try {
                    SipCall call = new SipCall(request, transaction, 1, null);
                    HashMap hashMap = this.registeredUas;
                    synchronized (hashMap) {
                        Registration reg;
                        Iterator iterator = this.registeredUas.values().iterator();
                        while (iterator.hasNext() && !call.isLocalUser((reg = (Registration)iterator.next()).getRegisteredUser())) {
                        }
                    }
                    this.invites.put(callId, call);
                    Thread.sleep(50L);
                    this.listener.incomingCallPresent();
                }
                catch (Exception e) {
                    this.toLog(request, true);
                    try {
                        Response response = request.createResponse(400);
                        WarningHeader warning = sipHeaderFactory.createWarningHeader(this.productName, 399, "Bad message (" + e.getMessage() + ")");
                        response.addHeader(warning);
                        transaction.sendResponse(response);
                        this.toLog(response, false);
                    }
                    catch (Exception response) {}
                }
            } else if (requestName.equals("CANCEL")) {
                SipCall call = (SipCall)this.invites.remove(callId);
                if (call != null) {
                    Response response;
                    try {
                        response = request.createResponse(200);
                        transaction.sendResponse(response);
                    }
                    catch (Exception e) {
                        ResourceStore.error("Cancel request: " + e.toString());
                    }
                    try {
                        response = call.getRequest().createResponse(487);
                        ((ServerTransaction)call.getTransaction()).sendResponse(response);
                    }
                    catch (Exception e) {
                        ResourceStore.error("IncomingExpired", e);
                    }
                    call.clear();
                } else {
                    this.toLog(request, true);
                    try {
                        Response response = request.createResponse(481);
                        transaction.sendResponse(response);
                        this.toLog(response, false);
                    }
                    catch (Exception response) {}
                }
            } else if (requestName.equals("OPTIONS")) {
                if (this.traceLevel >= 2) {
                    this.toLog(request, true);
                }
                Response response = null;
                try {
                    SipURI fromUri = (SipURI)((FromHeader)request.getHeader("From")).getAddress().getURI();
                    String user = fromUri.getUser();
                    String host = fromUri.getHost();
                    if (this.registeredUas.containsKey(user + "@" + host)) {
                        String remoteHost = request.getReceivedAddress();
                        String localAddress = this.getLocalInetAddress(remoteHost, true).getHostAddress();
                        SipURI toUri = (SipURI)((ToHeader)request.getHeader("To")).getAddress().getURI();
                        SipURI contactUri = sipAddressFactory.createSipURI(toUri.getUser(), localAddress);
                        if (this.listPort != 5060) {
                            contactUri.setPort(this.listPort);
                        }
                        Address contactAddress = sipAddressFactory.createAddress(contactUri);
                        ContactHeader contactHeader = sipHeaderFactory.createContactHeader(contactAddress);
                        AcceptHeader accept = (AcceptHeader)request.getHeader("Accept");
                        if (accept != null && accept.getContentType().equals("application") && accept.getContentSubType().equals("sdp")) {
                            SdpInfo sdpInfo = new SdpInfo("-", "-", "c=IN IP4 " + localAddress);
                            sdpInfo.setHost(localAddress);
                            sdpInfo.setPort(this.listPort);
                            sdpInfo.setBandwidth(this.bandwidth);
                            Vector<String> captable = new Vector<String>();
                            for (int i = 0; i < this.capabilities.length; ++i) {
                                int c = SipEndpoint.convertCodecNumber(this.capabilities[i] >> 8 & 0xFF);
                                if (c == -1) continue;
                                captable.addElement(String.valueOf(c));
                            }
                            sdpInfo.setCapabilities(captable);
                            byte[] content = sdpInfo.encode();
                            ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
                            response = request.createResponse(200, contentType, content);
                            response.addHeader(contactHeader);
                        } else {
                            response = request.createResponse(200);
                            response.addHeader(contactHeader);
                        }
                    }
                }
                catch (Exception fromUri) {
                    // empty catch block
                }
                try {
                    if (response == null) {
                        response = request.createResponse(403);
                        WarningHeader warning = sipHeaderFactory.createWarningHeader(this.productName, 399, "Not authorized request");
                        response.addHeader(warning);
                    }
                    transaction.sendResponse(response);
                    if (this.traceLevel >= 2) {
                        this.toLog(response, false);
                    }
                }
                catch (Exception e) {
                    ResourceStore.error("[SIP]", e);
                }
            } else if (requestName.equals("MESSAGE")) {
                this.toLog(request, true);
                int responseCode = 0;
                if (this.listener != null) {
                    ToHeader to = (ToHeader)request.getHeader("To");
                    FromHeader from = (FromHeader)request.getHeader("From");
                    ReplyToHeader replyTo = (ReplyToHeader)request.getHeader("Reply-To");
                    ContentTypeHeader cType = (ContentTypeHeader)request.getHeader("Content-Type");
                    MimeMessage message = new MimeMessage(callId);
                    String orig = ((SipURI)from.getAddress().getURI()).getUser();
                    message.setSender(orig);
                    message.setDomain(((SipURI)from.getAddress().getURI()).getHost());
                    Vector<String> recipients = new Vector<String>();
                    recipients.add(((SipURI)to.getAddress().getURI()).getUser());
                    message.setRecepients(recipients);
                    message.setContentType(cType.getContentType(), cType.getContentSubType());
                    Iterator it = cType.getParameterNames();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        message.setParameter(key, cType.getParameter(key));
                    }
                    message.setContentLength(request.getContentLength());
                    message.setContent(request.getContent());
                    if (replyTo != null) {
                        message.setReplyTo(orig + "@" + ((SipURI)replyTo.getAddress().getURI()).getUser());
                    }
                    if ((responseCode = this.listener.processMessage(message)) == 100) {
                        this.messages.put(callId, new RequestEvent(this, transaction, request));
                    }
                }
                if (responseCode == 0) {
                    boolean allowed = this.registeredHosts.containsKey(request.getReceivedAddress());
                    if (allowed) {
                        try {
                            Response response = request.createResponse(100);
                            this.toLog(response, false);
                            transaction.sendResponse(response);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        String messageId = SipDevice.deliverMessage(request, transaction);
                        if (messageId != null) {
                            this.messages.put(messageId, new RequestEvent(this, transaction, request));
                            return;
                        }
                        responseCode = 404;
                    } else {
                        responseCode = 403;
                    }
                }
                try {
                    Response response = request.createResponse(responseCode);
                    if (responseCode == 403) {
                        WarningHeader warning = sipHeaderFactory.createWarningHeader(this.productName, 399, "Not authorized request");
                        response.addHeader(warning);
                    }
                    this.toLog(response, false);
                    transaction.sendResponse(response);
                }
                catch (Exception e) {
                    ResourceStore.error(request.toString(), e);
                }
            } else {
                if (this.traceLevel >= 2) {
                    this.toLog(request, true);
                }
                try {
                    Response response = request.createResponse(481);
                    WarningHeader warning = sipHeaderFactory.createWarningHeader(this.productName, 399, "!");
                    response.addHeader(warning);
                    transaction.sendResponse(response);
                    if (this.traceLevel >= 2) {
                        this.toLog(response, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        this.lastPacketTime = System.currentTimeMillis();
        Response response = responseEvent.getResponse();
        CallIdHeader callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
        String callId = callIdHeader.getCallId();
        CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
        String method = cseq.getMethod();
        if (method.equals("REGISTER")) {
            Registration reg = (Registration)this.registrations.get(callId);
            if (reg != null) {
                reg.processResponse(response);
                this.toLog(response, true);
            }
            return;
        }
        if (method.equals("MESSAGE")) {
            this.toLog(response, true);
            if (this.listener == null || !this.listener.processResponse(callId, response.getStatusCode())) {
                // empty if block
            }
            return;
        }
        if (method.equals("CANCEL")) {
            this.activeCalls.remove(callId);
            this.toLog(response, true);
            return;
        }
        SipPort sipPort = (SipPort)this.activeCalls.get(callId);
        if (sipPort == null) {
            this.toLog(response, true);
            return;
        }
        SipCall call = sipPort.getCall(callId);
        if (call == null) {
            this.activeCalls.remove(callId);
            this.toLog(response, true);
            return;
        }
        ToHeader toHeader = (ToHeader)response.getHeader("To");
        ContactHeader contactHeader = (ContactHeader)response.getHeader("Contact");
        int statusCode = response.getStatusCode();
        if (method.equals("INVITE")) {
            if (statusCode == 401) {
                String username = call.getUsername();
                String password = call.getPassword();
                if (username == null || username.length() == 0) {
                    username = call.getProxyLogin();
                    password = call.getProxyPassword();
                }
                if (this.sendAuthorizedInvite(call, (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate"), username, password, sipPort.getState() == 4)) {
                    return;
                }
            } else if (statusCode == 407) {
                if (this.sendAuthorizedInvite(call, (ProxyAuthenticateHeader)response.getHeader("Proxy-Authenticate"), call.getProxyLogin(), call.getProxyPassword(), sipPort.getState() == 4)) {
                    return;
                }
            } else if (statusCode < 200 || statusCode >= 400 || contactHeader != null) {
                // empty if block
            }
            if (statusCode >= 180) {
                try {
                    call.setRemoteTag(toHeader.getTag());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                call.setRemoteInfo(response);
            }
            sipPort.processResponse(response, statusCode, statusCode >= 200 && statusCode < 300);
            if (statusCode >= 300 && sipPort.getState() != 4) {
                this.activeCalls.remove(callId);
            }
        } else if (method.equals("UPDATE") || method.equals("REFER")) {
            sipPort.processResponse(response, statusCode, false);
        } else {
            sipPort.processResponse(response);
        }
    }

    private boolean sendAuthorizedInvite(SipCall call, WWWAuthenticateHeader wwwauth, String user, String pass, boolean reinvite) {
        if (user == null || user.length() == 0) {
            user = "anonymous";
        }
        if (pass == null) {
            pass = "";
        }
        int seqNumber = call.getSeqNumber() + 1;
        try {
            if (reinvite) {
                byte[] content = call.getLocalSDPInfo().encode();
                Request request = this.createRequest("INVITE", seqNumber, call);
                ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
                request.setContentType(contentType);
                request.setContent(content);
                this.addAuthorizationHeader(request, wwwauth, user, pass);
                ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
                transaction.sendRequest();
            } else {
                Request request = call.getRequest();
                request.setCSeqNumber(seqNumber);
                ViaHeader viaHeader = request.getTopmostVia();
                viaHeader.setBranch(this.createBranchId());
                AuthorizationHeader auth = this.addAuthorizationHeader(request, wwwauth, user, pass);
                ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
                transaction.sendRequest();
                call.setTransaction(transaction);
                call.setLocalViaHeader(viaHeader);
                call.setAuthorizationHeader(auth);
            }
            call.setSeqNumber(seqNumber);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sendReInvite(SipCall call) {
        int seqNumber = call.getSeqNumber() + 1;
        try {
            byte[] content = call.getLocalSDPInfo().encode();
            Request request = this.createRequest("INVITE", seqNumber, call);
            ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
            request.setContentType(contentType);
            request.setContent(content);
            ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
            transaction.sendRequest();
            call.setSeqNumber(seqNumber);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sendUpdate(SipCall call) {
        int seqNumber = call.getSeqNumber() + 1;
        try {
            byte[] content = call.getLocalSDPInfo().encode();
            Request request = this.createRequest("UPDATE", seqNumber, call);
            ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
            request.setContentType(contentType);
            request.setContent(content);
            ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
            transaction.sendRequest();
            call.setSeqNumber(seqNumber);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void sendBye(SipCall call) {
        try {
            Request request = this.createRequest("BYE", call.getSeqNumber() + 1, call);
            ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
            transaction.sendRequest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.activeCalls.remove(call.getCallId());
    }

    public void sendNotify(SipCall call, String event, String content, String type, String subtype) throws Exception {
        SipURI uri = sipAddressFactory.createSipURI(call.getRemoteParty(), call.getRemoteHost());
        SipURI toUri = sipAddressFactory.createSipURI(call.getRemoteParty(), call.getRemoteHost());
        ToHeader to = sipHeaderFactory.createToHeader(sipAddressFactory.createAddress(toUri), call.getRemoteParty());
        SipURI fromUri = sipAddressFactory.createSipURI(call.getLocalParty(), call.getLocalHost());
        FromHeader from = sipHeaderFactory.createFromHeader(sipAddressFactory.createAddress(fromUri), call.getLocalParty());
        ArrayList<ViaHeader> via = new ArrayList<ViaHeader>();
        String remoteAddress = uri.getHost();
        via.add(sipHeaderFactory.createViaHeader(this.getLocalInetAddress(remoteAddress, true).getHostAddress(), this.listPort, this.transport, this.createBranchId()));
        MaxForwardsHeader maxForward = sipHeaderFactory.createMaxForwardsHeader(70);
        CallIdHeader callIdHeader = new CallIdHeader(this.createCallId());
        CSeqHeader cseq = sipHeaderFactory.createCSeqHeader(this.createSeqNumber(), "NOTIFY");
        Request request = new Request(uri, "NOTIFY", callIdHeader, cseq, from, to, via, maxForward);
        SipURI contactUri = sipAddressFactory.createSipURI(call.getLocalParty(), call.getLocalHost());
        ContactHeader contactHeader = sipHeaderFactory.createContactHeader(sipAddressFactory.createAddress(contactUri));
        request.addHeader(contactHeader);
        EventHeader eh = sipHeaderFactory.createEventHeader(event);
        request.addHeader(eh);
        ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader(type, subtype);
        request.setContentType(contentType);
        request.setContent(content.getBytes());
        ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
        transaction.sendRequest();
    }

    public void sendNotify(SipCall call, String event, String state, String content, String type, String subtype) throws Exception {
        int seqNumber = call.getSeqNumber() + 1;
        Request request = this.createRequest("NOTIFY", seqNumber, call);
        SubscriptionStateHeader ssh = sipHeaderFactory.createSubscriptionStateHeader(state);
        request.addHeader(ssh);
        EventHeader eh = sipHeaderFactory.createEventHeader(event);
        request.addHeader(eh);
        if (content != null) {
            ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader(type, subtype);
            request.setContentType(contentType);
            request.setContent(content.getBytes());
        }
        ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
        transaction.sendRequest();
        call.setSeqNumber(seqNumber);
    }

    public void sendInfo(SipCall call, String type, String subtype, String info) {
        try {
            int seqNumber = call.getSeqNumber() + 1;
            Request request = this.createRequest("INFO", seqNumber, call);
            ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader(type, subtype);
            request.setContentType(contentType);
            request.setContent(info.getBytes());
            ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
            transaction.sendRequest();
            call.setSeqNumber(seqNumber);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sendRefer(SipCall call, SipCall refcall) throws Exception {
        int seqNumber = call.getSeqNumber() + 1;
        Request request = this.createRequest("REFER", seqNumber, call);
        SipURI refUri = sipAddressFactory.createSipURI(call.getLocalParty(), call.getLocalHost());
        refUri.setHeader("Replaces", this.toReferString(refcall.getReferReplaces()));
        Address refaddr = sipAddressFactory.createAddress(null, refUri);
        ReferToHeader referTo = sipHeaderFactory.createReferToHeader(refaddr);
        request.addHeader(referTo);
        ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
        transaction.sendRequest();
        call.setSeqNumber(seqNumber);
    }

    public SipPort getReferredPort(SipURI uri) {
        String replaces = uri.getHeader("Replaces");
        if (replaces == null) {
            return null;
        }
        String key = this.fromReferString(replaces);
        int n = key.indexOf(59);
        if (n != -1) {
            key = key.substring(0, n);
        }
        return (SipPort)this.activeCalls.get(key);
    }

    private String toReferString(String str) {
        Object newstr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            newstr = Character.isLetterOrDigit(c) ? (String)newstr + c : (String)newstr + "%" + Integer.toHexString(c);
        }
        return newstr;
    }

    private String fromReferString(String str) {
        Object newstr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '%') {
                c = (char)Integer.parseInt(str.substring(i + 1, i + 3), 16);
                i += 2;
            }
            newstr = (String)newstr + c;
        }
        return newstr;
    }

    public void forceDisconnect(String callId) {
        SipPort port = (SipPort)this.activeCalls.get(callId);
        if (port != null) {
            port.forceDisconnect();
        }
    }

    protected Request createRequest(String requestName, int seqNumber, SipCall call) throws Exception {
        AuthorizationHeader auth;
        String router;
        URI uri = call.getRemoteURI();
        if (!"UDP".equals(this.transport) && uri instanceof SipURI) {
            ((SipURI)uri).setTransportParam(this.transport);
        }
        CallIdHeader callIdHeader = sipHeaderFactory.createCallIdHeader(call.getCallId());
        CSeqHeader cseq = sipHeaderFactory.createCSeqHeader(seqNumber, requestName);
        ToHeader toHeader = call.getToHeader();
        FromHeader fromHeader = call.getFromHeader();
        if (call.getDirection() == 1) {
            Address toAddress = toHeader.getAddress();
            toHeader = sipHeaderFactory.createToHeader(fromHeader.getAddress(), call.getRemoteTag());
            fromHeader = sipHeaderFactory.createFromHeader(toAddress, call.getLocalTag());
        }
        MaxForwardsHeader maxForward = sipHeaderFactory.createMaxForwardsHeader(70);
        ViaHeader viaHeader = call.getLocalViaHeader();
        if (viaHeader == null || call.hasRemoteContactAddress()) {
            viaHeader = sipHeaderFactory.createViaHeader(call.getLocalHost(), this.listPort, this.transport, this.createBranchId());
            call.setLocalViaHeader(viaHeader);
        } else {
            viaHeader = (ViaHeader)viaHeader.clone();
        }
        ArrayList<ViaHeader> via = new ArrayList<ViaHeader>();
        via.add(viaHeader);
        Request request = new Request(uri, requestName, callIdHeader, cseq, fromHeader, toHeader, via, maxForward);
        SipURI contactUri = sipAddressFactory.createSipURI(call.getLocalParty(), call.getLocalHost());
        if (this.listPort != 5060) {
            contactUri.setPort(this.listPort);
        }
        if (!"UDP".equals(this.transport)) {
            contactUri.setTransportParam(this.transport);
        }
        Address address = sipAddressFactory.createAddress(contactUri);
        ContactHeader contactHeader = sipHeaderFactory.createContactHeader(address);
        request.addHeader(contactHeader);
        UserAgentHeader uaHeader = sipHeaderFactory.createUserAgentHeader(this.productName);
        request.addHeader(uaHeader);
        Dialog dialog = call.getTransaction().getDialog();
        Iterator routeSet = dialog.getRouteSet();
        int i = 0;
        RouteHeader replaced = null;
        while (routeSet.hasNext()) {
            RouteHeader route = (RouteHeader)routeSet.next();
            Address routeAddress = route.getAddress();
            SipURI routeUri = (SipURI)routeAddress.getURI();
            if (i == 0 && !routeUri.hasLrParam()) {
                request.setRequestURI(routeUri);
                routeAddress.setURI(uri);
                replaced = route;
            } else {
                request.addHeader(route);
            }
            ++i;
        }
        if (replaced != null) {
            request.addHeader(replaced);
        }
        if (i == 0 && (router = call.getRouterAddress()) != null) {
            request.addHeader(this.createRouteHeader(router));
        }
        if (call.getDirection() == 2 && (auth = call.getAuthorizationHeader()) != null) {
            request.addHeader(auth);
        }
        return request;
    }

    public void sendCancel(SipCall call) {
        try {
            Request request = this.createRequest("CANCEL", call.getSeqNumber(), call);
            ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
            if (transaction != null) {
                transaction.sendRequest();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendAck(SipCall call, byte[] content, int seqNumber) {
        try {
            Request request = this.createRequest("ACK", seqNumber, call);
            if (content != null) {
                ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
                request.setContentType(contentType);
                request.setContent(content);
            }
            Dialog dialog = call.getTransaction().getDialog();
            dialog.sendAck(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request createRequest(SipCall call, String requestInfo) throws Exception {
        Request request = (Request)Message.parseMessage(requestInfo);
        call.setLocalHost(this.getLocalInetAddress(call.getReceivedAddress(), true).getHostAddress());
        ViaHeader viaHeader = sipHeaderFactory.createViaHeader(call.getLocalHost(), this.listPort, this.transport, this.createBranchId());
        call.setLocalViaHeader(viaHeader);
        request.removeHeader("Contact");
        SipURI contactUri = sipAddressFactory.createSipURI(call.getLocalParty(), call.getLocalHost());
        if (this.listPort != 5060) {
            contactUri.setPort(this.listPort);
        }
        if (!"UDP".equals(this.transport)) {
            contactUri.setTransportParam(this.transport);
        }
        Address address = sipAddressFactory.createAddress(contactUri);
        ContactHeader contactHeader = sipHeaderFactory.createContactHeader(address);
        request.addHeader(contactHeader);
        call.setRequest(request);
        return request;
    }

    public void sendRequest(SipCall call, byte[] content) throws Exception {
        Request request = call.getRequest();
        ContentTypeHeader contentType = sipHeaderFactory.createContentTypeHeader("application", "sdp");
        request.setContentType(contentType);
        request.setContent(content);
        ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
        transaction.sendRequest();
        call.setTransaction(transaction);
    }

    public void processTimeout(Transaction transaction) {
        Request req = transaction.getRequest();
        CallIdHeader callIdHeader = (CallIdHeader)req.getHeader("Call-ID");
        String callId = callIdHeader.getCallId();
        if (req.getMethod().equals("REGISTER")) {
            Registration reg = (Registration)this.registrations.get(callId);
            if (reg != null) {
                reg.processTimeout();
            }
        } else if (req.getMethod().equals("MESSAGE")) {
            if (this.listener != null && !this.listener.processTimeout(callId)) {
                // empty if block
            }
        } else if (req.getMethod().equals("CANCEL")) {
            this.activeCalls.remove(callId);
        } else {
            SipPort sipPort = (SipPort)this.activeCalls.get(callId);
            if (sipPort != null) {
                sipPort.processTimeout(callId);
            }
        }
    }

    public void toLog(Request req, boolean in) {
    }

    public void toLog(Response resp, boolean in) {
    }

    public SipURI getContactUri(String alias) {
        return null;
    }

    public String getCalledParty(SipCall call) {
        if (call == null) {
            return "";
        }
        String user = call.getCalledParty();
        if (user == null) {
            return "";
        }
        String cname = call.getCalledName();
        if (user.equals(cname) || cname == null || cname.length() == 0) {
            return user;
        }
        String key = call.getRegKey();
        return key != null && this.registeredUas.containsKey(key) ? cname : user;
    }

    public String register(Map parameters, boolean sync) throws Exception {
        Integer expires;
        int[] prms = (int[])parameters.get("H323_PARAMETERS");
        if (prms == null) {
            prms = DEFAULT_PARAMETERS;
            parameters.put("H323_PARAMETERS", prms);
            parameters.put("H323_CAPABILITIES", DEFAULT_CAPABILITIES);
        }
        if ((expires = (Integer)parameters.get("sip.reg_expires")) == null) {
            expires = 60;
        }
        String address = (String)parameters.get("h323.gatekeeper");
        String user = (String)parameters.get("sip.user");
        String login = (String)parameters.get("h323.gk_login");
        String passw = (String)parameters.get("h323.gk_password");
        if (passw == null) {
            passw = "";
        }
        String proxy = (String)parameters.get("sip.outbound_proxy");
        String plogin = login;
        String ppass = passw;
        String router = (String)parameters.get("RTP_PROXY_ADDRESS");
        return this.register(address, user, login, passw, expires, proxy, plogin, ppass, router, sync, false, true);
    }

    public String register(String address, String user, String login, String pass, int ttl, String proxy, String user1, String pass1, String router, boolean sync, boolean master, boolean autoretry) throws Exception {
        String key = login + "@" + address;
        Registration reg = (Registration)this.registeredUas.get(key);
        ResourceStore.syslog("Register user=" + user + " pass=" + pass + " key=" + key + " reg=" + reg + " ttl=" + ttl + " sync=" + sync + " lastRegTime=" + this.getLastRegistrationTime());
        if (reg != null && reg.isRunning()) {
            String state;
            if (ttl > 0 && login.equals(reg.getAuthName()) && pass.equals(reg.getUserPassword()) && "OK".equals(state = reg.getErorMessage()) && System.currentTimeMillis() - this.getLastRegistrationTime() < 3000L) {
                return key;
            }
            reg.cancelRegistration(false);
        }
        if (ttl == 0) {
            return key;
        }
        reg = new Registration(this, address, user, login, pass, ttl, proxy, user1, pass1, router, this.productName);
        this.registrations.put(reg.getCallId(), reg);
        if (!sync || reg.getRegistrationResult() == 200) {
            if (sync) {
                // empty if block
            }
            reg.setAutoRetrieve(autoretry);
            reg.start();
            return key;
        }
        this.registrations.remove(reg.getCallId());
        if (this.registrations.isEmpty()) {
            try {
                this.closeConnection(reg.getRequest());
            }
            catch (Exception e) {
                ResourceStore.error("closeConnection", e);
            }
        }
        throw new Exception(reg.getErorMessage());
    }

    private void cancelRegistration(String username, String address, boolean unreg) {
        String key = username + "@" + address;
        Registration reg = (Registration)this.registeredUas.get(key);
        if (reg != null) {
            reg.cancelRegistration(unreg);
        }
    }

    public void addRegistration(String key, Registration reg) {
        Registration registration = this.registeredUas.put(key, reg);
        if (registration != null) {
            registration.cancel();
        }
    }

    public boolean removeRegistration(Registration reg) {
        this.registrations.remove(reg.getCallId());
        this.registeredHosts.remove(reg.getRegisteredAddress());
        if (!this.registeredUas.containsValue(reg)) {
            return false;
        }
        this.registeredUas.remove(reg.getKey());
        return true;
    }

    public void addRegistrationAddress(String addr, Registration reg) {
        this.registeredHosts.put(addr, reg);
    }

    public CallIdHeader getNewRegistrationId(Registration reg) {
        this.registrations.remove(reg.getCallId());
        CallIdHeader callIdHeader = new CallIdHeader(this.createCallId());
        this.registrations.put(callIdHeader.getCallId(), this);
        return callIdHeader;
    }

    public void onRegistrationFound(String key) {
        if (this.listener != null) {
            this.listener.onRegistrationFound(key);
        }
    }

    public void onRegistrationLost(String key) {
        if (this.listener != null) {
            this.listener.onRegistrationLost(key);
        }
    }

    public void onConnectionLost(String addr) {
        int n = addr.indexOf(58);
        if (n != -1) {
            addr = addr.substring(0, n);
        }
        ResourceStore.toLog("onConnectionLost addr=" + addr + " registeredHosts=" + this.registeredHosts);
        Registration registration = (Registration)this.registeredHosts.get(addr);
        if (registration != null) {
            registration.cancelRegistration(false);
        }
    }

    public long getLastRegistrationTime(String username, String address) {
        String key = username + "@" + address;
        Registration reg = (Registration)this.registeredUas.get(key);
        return reg != null ? reg.getLastRegistrationTime() : 0L;
    }

    public AuthorizationHeader addAuthorizationHeader(Request request, WWWAuthenticateHeader wwwauth, String user, String pass) throws Exception {
        String scheme = wwwauth.getScheme();
        AuthorizationHeader auth = wwwauth instanceof ProxyAuthenticateHeader ? sipHeaderFactory.createProxyAuthorizationHeader(scheme) : sipHeaderFactory.createAuthorizationHeader(scheme);
        auth.setUsername(user);
        if (scheme.equals("Basic")) {
            auth.setPassword(pass);
        } else {
            String realm = wwwauth.getRealm();
            String qop = wwwauth.getQop();
            String opaque = wwwauth.getOpaque();
            String alg = wwwauth.getAlgorithm();
            String nonce = wwwauth.getNonce();
            String uristr = request.getRequestURI().toString();
            auth.setURI(uristr);
            auth.setRealm(realm);
            auth.setNonce(nonce);
            if (opaque != null) {
                auth.setOpaque(opaque);
            }
            if (alg != null) {
                auth.setAlgorithm(alg);
            }
            String cnonce = this.createCallId();
            if (qop != null && qop.length() > 0) {
                if (qop.toLowerCase().indexOf(44) != -1) {
                    qop = "auth";
                }
                auth.setQop(qop);
                auth.setCNonce(cnonce);
                auth.setNonceCount(1);
            }
            if ("MD5-sess".equalsIgnoreCase(alg)) {
                auth.setCNonce(cnonce);
            }
            String r = SipEndpoint.getDigest(user, pass, realm, request.getMethod(), uristr, nonce, cnonce, qop, alg, new byte[0]);
            auth.setResponse(r);
        }
        request.addHeader(auth);
        return auth;
    }

    public void sendRequest(Request request) throws Exception {
        ClientTransaction transaction = this.sipStack.getNewClientTransaction(request, true);
        transaction.sendRequest();
    }

    public void closeConnection(Request request) throws Exception {
        this.sipStack.closeMessageChannel(request);
    }

    public String sendMessage(SipURI uri, SipURI toUri, SipURI fromUri, String proxyAddress, Object content, int contentLength, String type, String subtype) throws Exception {
        return this.sendMessage(null, uri, toUri, fromUri, proxyAddress, content, contentLength, type, subtype);
    }

    private String sendMessage(String callId, SipURI uri, SipURI toUri, SipURI fromUri, String proxyAddress, Object content, int contentLength, String type, String subtype) throws Exception {
        return this.sendMessage(callId, uri, toUri, fromUri, proxyAddress, content, contentLength, type, subtype, null);
    }

    private String sendMessage(String callId, SipURI uri, SipURI toUri, SipURI fromUri, String proxyAddress, Object content, int contentLength, String type, String subtype, SipURI replyTo) throws Exception {
        ToHeader to = sipHeaderFactory.createToHeader(sipAddressFactory.createAddress(toUri), null);
        FromHeader from = sipHeaderFactory.createFromHeader(sipAddressFactory.createAddress(fromUri), this.createTag());
        if (callId == null) {
            callId = this.createCallId();
        }
        CallIdHeader callIdHeader = sipHeaderFactory.createCallIdHeader(callId);
        CSeqHeader cseq = sipHeaderFactory.createCSeqHeader(1, "MESSAGE");
        MaxForwardsHeader maxForward = sipHeaderFactory.createMaxForwardsHeader(70);
        ArrayList<ViaHeader> via = new ArrayList<ViaHeader>();
        String remoteAddress = this.outboundServer != null ? this.outboundServer : uri.getHost();
        via.add(sipHeaderFactory.createViaHeader(this.getLocalInetAddress(remoteAddress, true).getHostAddress(), this.listPort, this.transport, this.createBranchId()));
        Request request = new Request(uri, "MESSAGE", callIdHeader, cseq, from, to, via, maxForward);
        if (proxyAddress != null && proxyAddress.length() > 0) {
            request.addHeader(this.createRouteHeader(proxyAddress));
        }
        this.addOutboundRouteHeaders(request);
        if (replyTo != null) {
            ReplyToHeader replyToHeader = sipHeaderFactory.createReplyToHeader(sipAddressFactory.createAddress(replyTo));
            request.addHeader(replyToHeader);
        }
        UserAgentHeader uaHeader = sipHeaderFactory.createUserAgentHeader(this.productName);
        request.addHeader(uaHeader);
        ContentTypeHeader contentTypeHeader = sipHeaderFactory.createContentTypeHeader(type, subtype);
        request.setContentType(contentTypeHeader);
        request.setContent(content);
        ContentLengthHeader contentLengthHeader = sipHeaderFactory.createContentLengthHeader(contentLength);
        request.setContentLength(contentLengthHeader);
        this.toLog(request, false);
        ClientTransaction transaction = this.sipStack.getNewClientTransaction(request);
        transaction.sendRequest();
        return callIdHeader.getCallId();
    }

    public String sendMessage(String callId, String dest, String orig, Object content, int contentLength, String type, String subtype) throws Exception {
        String regid;
        int n = dest.indexOf(64);
        String addr = dest;
        if (n != -1) {
            addr = dest.substring(n + 1);
            dest = dest.substring(0, n);
        }
        if ((regid = this.getRegistrationId()).length() > 0) {
            Registration reg = (Registration)this.registeredUas.get(regid);
            if (reg != null) {
                SipURI uri = sipAddressFactory.createSipURI(dest, reg.getURI().getHost());
                uri.setPort(reg.getURI().getPort());
                uri.setTransportParam(this.transport);
                SipURI toUri = uri;
                SipURI fromUri = sipAddressFactory.createSipURI(orig, uri.getHost());
                return this.sendMessage(callId, uri, toUri, fromUri, null, content, contentLength, type, subtype);
            }
        } else if (n != -1) {
            SipURI uri = sipAddressFactory.createSipURI(dest, addr);
            if (!"UDP".equals(this.transport)) {
                uri.setTransportParam(this.transport);
            }
            SipURI toUri = sipAddressFactory.createSipURI(dest, addr);
            try {
                SipURI fromUri = sipAddressFactory.createSipURI(orig, this.getLocalAddress(addr, true));
                return this.sendMessage(callId, uri, toUri, fromUri, null, content, contentLength, type, subtype);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String deliverMessage(Request request, ServerTransaction transaction) {
        FromHeader from = (FromHeader)request.getHeader("From");
        SipURI fromUri = (SipURI)from.getAddress().getURI();
        ToHeader to = (ToHeader)request.getHeader("To");
        SipURI toUri = (SipURI)to.getAddress().getURI();
        ContentTypeHeader ctype = (ContentTypeHeader)request.getHeader("Content-Type");
        ViaHeader via = (ViaHeader)request.getHeader("Via");
        Object received = request.getReceivedAddress();
        int port = via.getPort();
        if (port != -1) {
            received = (String)received + ":" + port;
        }
        try {
            Registration reg;
            String regid = this.getRegistrationId();
            if (regid.length() > 0 && (reg = (Registration)this.registeredUas.get(regid)) != null && !((String)received).equals(reg.getServerAddress())) {
                SipURI sipUri = sipAddressFactory.createSipURI(toUri.getUser(), reg.getServerAddress());
                if (!"UDP".equals(this.transport)) {
                    sipUri.setTransportParam(this.transport);
                }
                return this.sendMessage(null, sipUri, toUri, fromUri, null, request.getContent(), request.getContentLength(), ctype.getContentType(), ctype.getContentSubType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean processMessageResponse(String callId, int statusCode) {
        RequestEvent req = statusCode == 100 ? (RequestEvent)this.messages.get(callId) : (RequestEvent)this.messages.remove(callId);
        if (req == null) {
            return false;
        }
        try {
            Response res = this.createResponse(statusCode, req.getRequest());
            req.getServerTransaction().sendResponse(res);
            this.toLog(res, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean processMessageTimeout(String callId) {
        RequestEvent req = (RequestEvent)this.messages.remove(callId);
        if (req == null) {
            return false;
        }
        try {
            Response res = this.createResponse(408, req.getRequest());
            req.getServerTransaction().sendResponse(res);
            this.toLog(res, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void addOutboundRouteHeaders(Request request) throws ParseException {
        if (this.outboundProxy != null && !"WSS".equals(this.transport) && !"WS".equals(this.transport)) {
            request.addHeader(this.createRouteHeader(this.outboundProxy));
        }
    }

    private RouteHeader createRouteHeader(String host) throws ParseException {
        String uri = "sip:" + host + ";transport=" + this.transport;
        Address routeAddress = sipAddressFactory.createAddress(uri);
        return sipHeaderFactory.createRouteHeader(routeAddress);
    }

    public static String getDigest(String user, String pass, String realm, String method, String uri, String nonce, String cnonce, String qop, String alg, byte[] body) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        String a1 = user + ":" + realm + ":" + pass;
        String a2 = method + ":" + uri;
        if ("auth-int".equalsIgnoreCase(qop)) {
            a2 = a2 + ":" + SipEndpoint.encode(body, md);
        }
        String r1 = SipEndpoint.encode(a1, md);
        String r2 = SipEndpoint.encode(a2, md);
        if ("MD5-sess".equalsIgnoreCase(alg)) {
            String a3 = r1 + ":" + nonce + ":" + cnonce;
            r1 = SipEndpoint.encode(a3, md);
        }
        String r3 = qop != null && qop.length() > 0 ? r1 + ":" + nonce + ":00000001:" + cnonce + ":" + qop + ":" + r2 : r1 + ":" + nonce + ":" + r2;
        return SipEndpoint.encode(r3, md);
    }

    private static String encode(String str, MessageDigest md) {
        return SipEndpoint.encode(str.getBytes(), md);
    }

    private static String encode(byte[] data, MessageDigest md) {
        md.update(data);
        byte[] b = md.digest();
        StringBuffer stringbuffer = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            stringbuffer.append(DCHAR[b[i] >>> 4 & 0xF]);
            stringbuffer.append(DCHAR[b[i] & 0xF]);
        }
        return stringbuffer.toString();
    }
}

