/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip;

import com.smile.sound.WavAudioFormat;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.CallInfo;
import com.smile.telephony.MediaEndpoint;
import com.smile.telephony.Mixer;
import com.smile.telephony.RTPMediaSocket;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.SoftPort;
import com.smile.telephony.codec.ConvertedInputStream;
import com.smile.telephony.sip.SdpInfo;
import com.smile.telephony.sip.SipCall;
import com.smile.telephony.sip.SipDevice;
import com.smile.telephony.sip.SipEndpoint;
import com.smile.telephony.sip.SipUtils;
import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.header.AllowEventsHeader;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.CallIdHeader;
import com.smile.telephony.sip.header.ContactHeader;
import com.smile.telephony.sip.header.ContentTypeHeader;
import com.smile.telephony.sip.header.EventHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.PAssertedIdentityHeader;
import com.smile.telephony.sip.header.ReferToHeader;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.ServerTransaction;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import smile.util.ResourceStore;
import smile.util.Utils;

public class SipPort
extends RTPMediaSocket
implements SoftPort,
Runnable {
    public static boolean isPhone = true;
    protected SipEndpoint sip;
    private String openKey;
    private boolean disconnected;
    private boolean cancelled;
    private boolean released;
    private boolean referred;
    private boolean onhold;
    private boolean onholdByInfo;
    private boolean inband = false;
    private int state;
    private int status;
    private int resourceType = 2055;
    private long callTimestamp;
    protected SipCall call;
    private int selectedCapability;
    private int responseCode;
    private String responsePhrase = "";
    private String infoResponse;
    private String notification;
    private int responseCause;
    private boolean mediaAccepted;
    private boolean reinviteRequired;
    private boolean updateAllowed = true;
    private boolean urealibleChangeReinvite = false;
    private boolean earlyReinviteAllowed = false;
    private boolean updatingCodec = false;
    private String errorMessage;
    private String displayName;
    private String originNumber = "";
    private boolean updateSent = false;
    private boolean updateCollision = false;
    private boolean ansAckReceived = false;
    private boolean faxSession = false;
    private boolean holdsdp = false;
    private boolean hisinfo = false;
    private boolean ssig = isPhone;
    private boolean autoTalk = false;
    private boolean talkEvent = false;
    private boolean holdEvent = false;
    private boolean divinfo = false;
    private boolean reginfo = false;
    private String proxy;
    private String proxyLogin;
    private String proxyPassword;
    private String router;
    private int T0 = 500;
    private Hashtable codes;
    private Hashtable causes;
    private Hashtable altCalls;
    private boolean mroute;
    private String targetInfo;
    AudioCodec newcodec;
    Request request;
    ServerTransaction transaction;
    String oldAddress;
    int oldCapability;

    public SipPort(String openKey) {
        this.openKey = openKey;
        this.blockingRead = false;
    }

    @Override
    public boolean open() {
        this.status = SipDevice.openChannel(this.openKey) ? 1 : 0;
        return this.status == 1;
    }

    @Override
    public void setEndpoint(MediaEndpoint ep) {
        super.setEndpoint(ep);
        this.sip = (SipEndpoint)ep;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void close() {
        this.status = 0;
    }

    @Override
    public int getType() {
        return this.resourceType;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getPortType() {
        return 7;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public RouteSocket getRouteSocket() {
        return this;
    }

    @Override
    public void hold() {
        if (this.call == null || this.call.getLocalSDPInfo() == null || this.disconnected) {
            return;
        }
        if (this.signallingOnly && this.reopenRTPAllowed) {
            SdpInfo sdpInfo = this.call.getLocalSDPInfo();
            String ipaddress = this.call.getLocalHost();
            int port = super.getLocalDataPort();
            String sdpaddress = sdpInfo.getHost();
            int sdpport = sdpInfo.getPort();
            if (sdpport != port || !sdpaddress.equals(ipaddress)) {
                sdpInfo.setHost(ipaddress);
                sdpInfo.setPort(port);
                if (this.sip.sendReInvite(this.call)) {
                    sdpInfo.setHost(sdpaddress);
                    sdpInfo.setPort(sdpport);
                    this.holdsdp = true;
                    this.signallingOnly = false;
                    this.changeReceiverReq = false;
                }
            }
        }
    }

    @Override
    public void resume() {
        if (this.holdsdp && !this.disconnected && !this.signallingOnly && this.sip.sendReInvite(this.call)) {
            this.holdsdp = false;
            this.signallingOnly = true;
        }
    }

    @Override
    public int getPlayBufferDepth() {
        return this.selectedCapability & 0xFF;
    }

    @Override
    public int getRecBufferDepth() {
        return this.selectedCapability & 0xFF;
    }

    @Override
    public boolean seize() {
        return false;
    }

    @Override
    public void release() {
        this.released = true;
        super.terminate(this.disconnected ? 8 : 256);
    }

    @Override
    public void setDisplayName(String str) {
        this.displayName = str;
    }

    @Override
    public void setOriginNumber(String str) {
        this.originNumber = str;
        this.autoTalk = this.originNumber.endsWith("***");
    }

    @Override
    public String getCalledNumber() {
        return this.call != null ? this.sip.getCalledParty(this.call) : "";
    }

    @Override
    public String getCallingNumber() {
        if (this.call == null) {
            return "";
        }
        String cpn = this.call.getCallingPartyNumber();
        if (cpn == null) {
            cpn = "";
        }
        return cpn;
    }

    @Override
    public String getConnectedNumber() {
        return this.call.getConnectedParty();
    }

    @Override
    public int getDisconnectCause() {
        Integer c;
        if (this.responseCause > 0) {
            return this.responseCause;
        }
        if (this.codes != null && (c = (Integer)this.codes.get(this.responseCode)) != null) {
            return c;
        }
        return SipUtils.convertToCauseCode(this.responseCode);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean isCallDisconnected() {
        return this.disconnected;
    }

    @Override
    public void forceDisconnect() {
        this.disconnected = true;
    }

    public SipCall getCall() {
        return this.call;
    }

    public SipCall getCall(String callId) {
        if (this.altCalls != null) {
            SipCall sipcall = (SipCall)this.altCalls.get(callId);
            if (sipcall != null) {
                return sipcall;
            }
            if (this.call == null || !callId.equals(this.call.getCallId())) {
                return null;
            }
        }
        return this.call;
    }

    @Override
    public AudioCodec[] getAudioCodecs(int mode) {
        int faxid;
        Vector<Integer> tmp = new Vector<Integer>();
        if (this.call == null || this.selectedCapability == 0) {
            return null;
        }
        tmp.addElement(this.selectedCapability >> 8 & 0xFF);
        if (this.call.getDirection() == 1 || this.remoteCapabilitiesInfo.size() > 1) {
            Enumeration en = this.remoteCapabilitiesInfo.keys();
            while (en.hasMoreElements()) {
                int id = (Integer)en.nextElement() >> 8 & 0xFF;
                if (tmp.contains(id)) continue;
                tmp.addElement(id);
            }
        }
        if (!tmp.contains(faxid = AudioCodec.T38UDP.getId()) && this.getCapability(faxid) != 0) {
            tmp.addElement(faxid);
        }
        this.toLog("getAudioCodecs: " + tmp);
        AudioCodec[] cs = new AudioCodec[tmp.size()];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = this.getAudioCodec((Integer)tmp.get(i));
        }
        return cs;
    }

    private AudioCodec getAudioCodec(int codecId) {
        AudioCodec codec = AudioCodec.getAudioCodec(codecId);
        SdpInfo sdp = this.call.getRemoteSDPInfo();
        if (sdp != null) {
            codec.setParameters(sdp.getCodecParameters(String.valueOf(codecId)));
        }
        return codec;
    }

    @Override
    public Hashtable getCallInfo() {
        Hashtable info = super.getCallInfo();
        info.put("cti.Timestamp", this.callTimestamp);
        if (this.call != null) {
            this.call.setCallInfo(info);
        }
        return info;
    }

    @Override
    public void setEndpointProperties(Hashtable info) {
        this.setLocalCapabilities((int[])info.get("H323_CAPABILITIES"));
        this.setLocalParameters((int[])info.get("H323_PARAMETERS"));
        switch (this.parameters[0]) {
            case 0: {
                this.dtmfInfo = 2;
                break;
            }
            case 1: {
                this.dtmfInfo = 1;
                break;
            }
            default: {
                this.dtmfInfo = 3;
            }
        }
        this.divinfo = (this.parameters[5] & 0x1000) == 0;
        boolean bl = this.reginfo = (this.parameters[5] & 0x10000) != 0;
        if ((this.parameters[5] & 0x80) != 0) {
            this.proxy = (String)info.get("SIP_PROXY");
            this.proxyLogin = (String)info.get("SIP_PROXY_LOGIN");
            this.proxyPassword = (String)info.get("SIP_PROXY_PASSWORD");
            if (this.proxy != null && this.proxy.length() > 0 && this.call != null) {
                this.call.setProxyLogin(this.proxyLogin);
                this.call.setProxyPassword(this.proxyPassword);
            }
        } else {
            this.proxy = null;
        }
        this.router = (String)info.get("RTP_PROXY_ADDRESS");
        if (this.router == null) {
            this.router = this.sip.getRouterAddress();
        }
        this.codes = (Hashtable)info.get("RX_CODE_TABLE");
        this.causes = (Hashtable)info.get("TX_CODE_TABLE");
        this.mroute = info.get("MASTER_ROUTE") != null;
    }

    @Override
    public int waitCall(int timeout) {
        this.state = 1;
        this.call = this.sip.getIncomingCall(this);
        if (this.call == null) {
            return 0;
        }
        this.state = 3;
        this.callTimestamp = System.currentTimeMillis();
        this.released = false;
        this.disconnected = false;
        this.cancelled = false;
        this.mediaAccepted = false;
        this.reinviteRequired = false;
        this.selectedCapability = 0;
        return 1;
    }

    @Override
    public boolean proceed() {
        try {
            this.setLocalCryptoCapabilities();
            byte[] sdp = this.call.getRequest().getContentBytes();
            if (sdp != null && this.setRemoteMediaParameters(sdp)) {
                return true;
            }
            this.state = 7;
            this.responseCode = 415;
            this.sip.sendResponse(this.responseCode, this.call);
            this.call.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean progress(int param) {
        boolean result;
        if (this.disconnected) {
            return false;
        }
        if (param == 8) {
            this.call.setLocalSDPInfo(this.getResponseContent(true));
        }
        if (result = this.sip.sendResponse(183, this.call, this.router)) {
            this.state = 12;
        }
        return result;
    }

    @Override
    public int acceptCall(int rings) {
        if (this.disconnected) {
            return 0;
        }
        if (rings > 0) {
            super.onAcceptCall();
        }
        if (!this.sip.sendResponse(180, this.call, this.router)) {
            return 0;
        }
        if (rings > 1) {
            int seconds = (rings - 1) * 6;
            for (int i = 0; i < seconds; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.disconnected) continue;
                return 0;
            }
        }
        this.state = 6;
        return 1;
    }

    @Override
    public synchronized boolean answerCall(int param) {
        if (this.disconnected) {
            return false;
        }
        super.onAcceptCall();
        this.call.setLocalSDPInfo(this.getResponseContent(false));
        this.ansAckReceived = false;
        if (!this.sip.sendResponse(200, this.call, this.router)) {
            return false;
        }
        this.state = 4;
        this.ssig |= this.call.isSmileClient();
        if (this.mediaAccepted) {
            return true;
        }
        try {
            this.wait(this.T1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.ansAckReceived;
    }

    @Override
    public String makeCall(String calledParty, int timeout, CallInfo info) {
        block34: {
            this.callTimestamp = System.currentTimeMillis();
            this.released = false;
            this.disconnected = false;
            this.mediaAccepted = false;
            this.reinviteRequired = false;
            this.selectedCapability = 0;
            this.errorMessage = null;
            super.onAcceptCall();
            this.setLocalCryptoCapabilities();
            Request request = null;
            try {
                SdpInfo sdp;
                String host;
                Vector diversions;
                Object originalCalledUser = null;
                Vector vector = diversions = this.divinfo ? info.getDiversionInfo() : new Vector();
                if (!diversions.isEmpty() && (host = (String)info.getAttribute("cti.CalledHost")) != null) {
                    originalCalledUser = (String)diversions.firstElement();
                    originalCalledUser = ((String)originalCalledUser).substring(0, ((String)originalCalledUser).indexOf(58)) + "@" + host;
                }
                this.call = this.sip.createOutgoingCall(calledParty, this.originNumber, this.displayName, (String)originalCalledUser, this.proxy, this.router, this.reginfo);
                request = this.call.getRequest();
                if (!diversions.isEmpty()) {
                    Vector diversion = info.getDiversionInfo();
                    String host2 = (String)info.getAttribute("cti.CalledHost");
                    this.hisinfo &= host2 != null;
                    for (int i = 0; i < diversion.size(); ++i) {
                        Object str = (String)diversion.elementAt(i);
                        try {
                            int n = ((String)str).indexOf(58);
                            String number = ((String)str).substring(0, n);
                            n = Integer.parseInt(((String)str).substring(n + 1));
                            str = host2 != null ? "<sip:" + number + "@" + host2 : "<tel:" + number;
                            switch (n) {
                                case 1: {
                                    str = (String)str + (this.hisinfo ? "?Reason=SIP;cause=486;text=\"User busy\">;index=1." + (i + 1) : ">;reason=user-busy;counter=" + (i + 1));
                                    break;
                                }
                                case 10: {
                                    str = (String)str + (this.hisinfo ? "?Reason=SIP;cause=302;text=\"Forwarding by called equipment\">;index=1." + (i + 1) : ">;reason=deflection;counter=" + (i + 1));
                                    break;
                                }
                                case 4: {
                                    str = (String)str + (this.hisinfo ? "?Reason=SIP;cause=302;text=\"Call deflection\">;index=1." + (i + 1) : ">;reason=follow-me;counter=" + (i + 1));
                                    break;
                                }
                                case 2: {
                                    str = (String)str + (this.hisinfo ? "?Reason=SIP;cause=480;text=\"No reply\">;index=1." + (i + 1) : ">;reason=no-answer;counter=" + (i + 1));
                                    break;
                                }
                                case 9: {
                                    str = (String)str + (this.hisinfo ? "?Reason=SIP;cause=302;text=\"Not available\">;index=1." + (i + 1) : ">;reason=unavailable;counter=" + (i + 1));
                                    break;
                                }
                                case 15: {
                                    str = (String)str + (this.hisinfo ? "?Reason=SIP;cause=302;text=\"Unconditional forwarding\">;index=1." + (i + 1) : ">;reason=unconditional;counter=" + (i + 1));
                                    break;
                                }
                                case 0: {
                                    str = (String)str + (this.hisinfo ? "?Reason=SIP;cause=404;text=\"Not available\">;index=1." + (i + 1) : ">;reason=unknown;counter=" + (i + 1));
                                }
                            }
                            Header header = SipEndpoint.sipHeaderFactory.createHeader(this.hisinfo ? "History-Info" : "Diversion", (String)str);
                            request.addHeader(header);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.proxy != null) {
                    if (this.proxyLogin == null) {
                        this.proxyLogin = "";
                    }
                    if (this.proxyPassword == null) {
                        this.proxyPassword = "";
                    }
                    this.call.setProxyLogin(this.proxyLogin);
                    this.call.setProxyPassword(this.proxyPassword);
                }
                if ((sdp = this.getRequestContent(true)) == null) {
                    return "NO DIAL TONE";
                }
                this.call.setLocalSDPInfo(sdp);
                this.altCalls = this.call.getAlternateCalls();
                if (this.altCalls != null) {
                    try {
                        this.sip.sendInvite(this, this.call, this.T0);
                    }
                    catch (Throwable t) {
                        this.errorMessage = t.getMessage();
                    }
                    Vector<SipCall> fails = new Vector<SipCall>();
                    Enumeration<Object> en = this.altCalls.elements();
                    while (en.hasMoreElements()) {
                        SipCall nextcall = (SipCall)en.nextElement();
                        try {
                            nextcall.setLocalSDPInfo(this.getRequestContent(true));
                            this.sip.sendInvite(this, nextcall, this.T0);
                        }
                        catch (Throwable t) {
                            nextcall.clear();
                            fails.add(nextcall);
                        }
                    }
                    en = fails.elements();
                    while (en.hasMoreElements()) {
                        SipCall failed = (SipCall)en.nextElement();
                        this.altCalls.remove(failed.getCallId());
                    }
                    if (this.errorMessage != null) {
                        this.call.clear();
                        if (this.altCalls.isEmpty()) {
                            return this.call.getLocalSDPInfo() == null ? "COMPATIBILITY" : "NO DIAL TONE";
                        }
                        this.call = (SipCall)this.altCalls.values().iterator().next();
                        if (this.altCalls.size() == 1) {
                            this.altCalls = null;
                        }
                    } else if (this.altCalls.isEmpty()) {
                        this.altCalls = null;
                    } else {
                        this.altCalls.put(this.call.getCallId(), this.call);
                    }
                    break block34;
                }
                this.sip.sendInvite(this, this.call, this.T0);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.errorMessage = e.getMessage();
                if (this.call == null && request != null) {
                    this.sip.toLog(request, false);
                }
                return "NO DIAL TONE";
            }
        }
        this.state = 5;
        return this.waitForResponse(this.T1);
    }

    @Override
    public String progressCall(int timeout) {
        return this.waitForResponse(timeout * 1000);
    }

    private synchronized String waitForResponse(long wtime) {
        if (this.state == 11) {
            if (this.T2 < 3000) {
                this.T2 = 3000;
            }
            wtime = Math.min(wtime, (long)this.T2);
        }
        long edge = System.currentTimeMillis() + wtime;
        boolean first = true;
        while (wtime > 0L && !this.released) {
            switch (this.responseCode) {
                case 0: {
                    break;
                }
                case 100: 
                case 101: {
                    this.state = 11;
                    break;
                }
                case 183: {
                    if (this.state == 9 && first) break;
                    this.state = 9;
                    return this.mediaAccepted ? "INBAND" : "PROGRESS";
                }
                case 180: 
                case 202: {
                    if (this.state == 8 && first) break;
                    this.state = 8;
                    return "ALERTED";
                }
                case 200: {
                    this.state = 4;
                    return "VOICE";
                }
                case 181: {
                    break;
                }
                case 182: {
                    break;
                }
                case 480: {
                    if (this.state == 5 || this.state == 11) {
                        this.responseCause = 31;
                    }
                    this.state = 7;
                    return "BUSY";
                }
                case 503: {
                    if (this.state == 8 || this.state == 9) {
                        this.responseCause = 18;
                    }
                    this.state = 7;
                    return "BUSY";
                }
                case 486: {
                    if (this.state == 8 || this.state == 9) {
                        this.responseCause = 21;
                    }
                    this.state = 7;
                    return "BUSY";
                }
                case 404: {
                    this.state = 7;
                    if (System.currentTimeMillis() - this.callTimestamp > 30000L) {
                        return "NO ANSWER";
                    }
                    return "BUSY";
                }
                default: {
                    this.state = 7;
                    return "BUSY";
                }
            }
            first = false;
            try {
                this.wait(wtime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            wtime = edge - System.currentTimeMillis();
        }
        if (this.state == 5) {
            return "NO DIAL TONE";
        }
        if (this.state == 11) {
            return "NO RINGBACK";
        }
        if (this.released) {
            return "STOPPED";
        }
        return "NO ANSWER";
    }

    @Override
    public synchronized void dropCall(int cause) {
        this.toLog("dropCall state=" + this.state);
        this.disconnected = true;
        switch (this.state) {
            case 4: {
                this.sip.sendBye(this.call);
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                if ((cause == 22 || cause == 23) && this.originNumber.length() > 0) {
                    int n = this.originNumber.indexOf(64);
                    if (n == -1) {
                        SipURI uri = this.sip.getContactUri(this.originNumber);
                        if (uri != null) {
                            this.call.setLocalParty(uri.getUser());
                            this.call.setLocalHost(uri.getHost());
                        } else {
                            this.call.setLocalParty(this.originNumber);
                        }
                    } else {
                        this.call.setLocalParty(this.originNumber.substring(0, n));
                        this.call.setLocalHost(this.originNumber.substring(n + 1));
                    }
                }
                Integer code = null;
                if (cause == 149) {
                    code = 0;
                } else if (this.cancelled) {
                    code = 487;
                } else {
                    cause &= 0x7F;
                    if (this.causes != null) {
                        code = (Integer)this.causes.get(cause);
                    }
                    if (code == null) {
                        code = SipUtils.convertToStatusCode(cause);
                    }
                    if (cause == 21 && this.state != 3 && code == 403) {
                        code = 603;
                    }
                }
                this.sip.sendResponse(code, this.call);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                if (this.altCalls == null) {
                    this.sip.sendCancel(this.call);
                    break;
                }
                Enumeration en = this.altCalls.elements();
                while (en.hasMoreElements()) {
                    SipCall altcall = (SipCall)en.nextElement();
                    this.sip.sendCancel(altcall);
                    if (altcall == this.call) continue;
                    altcall.clear();
                }
                this.altCalls.clear();
                break;
            }
        }
        this.clear();
        if (this.call != null) {
            String info = this.getSessionInfo();
            this.toLog(info);
            this.call.clear();
            this.call = null;
        }
        this.state = 1;
    }

    @Override
    protected void clear() {
        super.clear();
        this.clearDigitBuffer();
        this.altCalls = null;
        this.responseCode = 0;
        this.responseCause = 0;
        this.responsePhrase = "";
        this.originNumber = "";
        this.infoResponse = null;
        this.notification = null;
        this.mediaAccepted = false;
        this.faxSession = false;
        this.onhold = false;
        this.onholdByInfo = false;
        this.referred = false;
        this.holdsdp = false;
        this.autoTalk = false;
        this.talkEvent = false;
        this.holdEvent = false;
        this.ssig = isPhone;
        this.updateCollision = false;
        this.inband = false;
        this.targetInfo = null;
    }

    public byte[] getSdpContent() {
        return this.call.getLocalSDPInfo().encode();
    }

    public String getRemoteParty() {
        return this.call != null ? this.call.getRemoteParty() : "";
    }

    @Override
    public String getRemoteHostAddress() {
        return this.call != null ? this.call.getRemoteAddress() : "";
    }

    public synchronized boolean joinCall(SipPort port) {
        try {
            this.sip.sendRefer(this.call, port.getCall());
            this.responseCode = 0;
            this.wait(this.T1);
            if (this.responseCode == 202) {
                this.wait(this.T1);
                if (this.notification != null && this.notification.indexOf("OK") != -1) {
                    this.notification = null;
                    return true;
                }
            }
            this.toLog(this + " joinCall " + port + " responseCode=" + this.responseCode + " notification=" + this.notification);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public synchronized void notifyReceived(byte[] content) {
        if (content != null) {
            this.notification = new String(content);
        }
        this.notifyAll();
    }

    public void processRefer(ReferToHeader rth) {
        SipURI uri = (SipURI)rth.getAddress().getURI();
        SipPort port = this.sip.getReferredPort(uri);
        Object numbr = "";
        if (port != null) {
            numbr = port.getName();
            if (this.onhold) {
                numbr = "!" + (String)numbr;
            }
            numbr = (String)numbr + "!";
        } else {
            numbr = uri.getUser();
            if (numbr == null) {
                numbr = uri.getHost();
                int p = uri.getPort();
                if (p != -1) {
                    numbr = (String)numbr + ":" + p;
                }
            }
            numbr = "!" + (String)numbr + "!";
        }
        this.referred = true;
        this.setDigitBuffer((String)numbr);
        this.toLog(" processRefer uri=" + uri + " port=" + port + " numbr=" + (String)numbr);
    }

    public synchronized void doNotify() {
        this.notifyAll();
    }

    public Response processRequest(Request request, ServerTransaction transaction) throws Exception {
        if (this.call == null) {
            return null;
        }
        String requestName = request.getMethod();
        if (requestName.equals("INVITE") || requestName.equals("UPDATE")) {
            int rc = this.processUpdate(request, transaction);
            if (rc == 0) {
                return null;
            }
            Response response = this.sip.createResponse(rc, request);
            if (rc == 200) {
                Header seh;
                if (request.getContentBytes() != null) {
                    byte[] sdp = this.getSdpContent();
                    response.setContent(sdp);
                    response.setContentLength(sdp.length);
                    response.setContentType(SipEndpoint.sipHeaderFactory.createContentTypeHeader("application", "sdp"));
                    SipURI contactUri = SipEndpoint.sipAddressFactory.createSipURI(this.call.getLocalParty(), this.call.getLocalHost());
                    if (this.sip.getListenerPort() != -1) {
                        contactUri.setPort(this.sip.getListenerPort());
                    }
                    if (!"UDP".equals(this.sip.getTransport())) {
                        contactUri.setTransportParam(this.sip.getTransport());
                    }
                    Address address = SipEndpoint.sipAddressFactory.createAddress(contactUri);
                    ContactHeader contactHeader = SipEndpoint.sipHeaderFactory.createContactHeader(address);
                    response.addHeader(contactHeader);
                } else if (requestName.equals("UPDATE") && (seh = response.getHeader("Session-Expires")) != null) {
                    String str = seh.toString();
                    response.addHeader(SipEndpoint.sipHeaderFactory.createHeader("Require", "timer"));
                    response.addHeader(SipEndpoint.sipHeaderFactory.createHeader("Session-Expires", str));
                }
            }
            return response;
        }
        if (requestName.equals("OPTIONS")) {
            Response response;
            SdpInfo sdp = this.call.getLocalSDPInfo();
            if (sdp == null) {
                sdp = this.getResponseContent(true);
            }
            if (sdp != null) {
                SdpInfo sdpInfo = new SdpInfo("-", "-", "c=IN IP4 " + sdp.getOriginAddress());
                sdpInfo.setHost(sdp.getHost());
                sdpInfo.setPort(sdp.getPort());
                Vector<String> captable = new Vector<String>();
                for (int i = 0; i < this.capabilities.length; ++i) {
                    int c = SipEndpoint.convertCodecNumber(this.capabilities[i] >> 8 & 0xFF);
                    if (c == -1) continue;
                    captable.addElement(String.valueOf(c));
                }
                sdpInfo.setCapabilities(captable);
                ContentTypeHeader contentType = SipEndpoint.sipHeaderFactory.createContentTypeHeader("application", "sdp");
                response = this.sip.createResponse(200, request, contentType, sdpInfo.encode());
            } else {
                response = this.sip.createResponse(200, request);
            }
            return response;
        }
        if (requestName.equals("INFO")) {
            Response response = this.sip.createResponse(200, request);
            ContentTypeHeader header = (ContentTypeHeader)request.getHeader("Content-Type");
            if (header != null) {
                if (header.getContentSubType().equals("dtmf-relay")) {
                    this.processDtmfInfo(new String(request.getContentBytes()));
                } else if (header.getContentSubType().equals("media_control+xml")) {
                    String retval = this.processMediaControl(new String(request.getContentBytes()));
                    if (retval != null) {
                        byte[] content = retval.getBytes();
                        response.setContent(content);
                        response.setContentLength(content.length);
                        response.setContentType(SipEndpoint.sipHeaderFactory.createContentTypeHeader("application", "media_control+xml"));
                    }
                } else if (header.getContentSubType().equals("smile-redundancy-info")) {
                    this.targetInfo = new String(request.getContentBytes());
                }
            }
            return response;
        }
        if (requestName.equals("PRACK")) {
            return null;
        }
        if (requestName.equals("ACK")) {
            this.processAck(request.getContentBytes());
            return null;
        }
        if (requestName.equals("CANCEL")) {
            if (this.state != 4) {
                this.cancelled = true;
                this.disconnected = true;
            }
            return this.sip.createResponse(200, request);
        }
        if (requestName.equals("BYE")) {
            if (this.state != 4) {
                this.responseCode = 603;
                this.doNotify();
            }
            this.disconnected = true;
            this.state = 7;
            return this.sip.createResponse(200, request);
        }
        if (requestName.equals("NOTIFY")) {
            EventHeader eventHeader = (EventHeader)request.getHeader("Event");
            if (eventHeader != null && "talk".equals(eventHeader.getEventType()) && (this.state == 6 || this.state == 12)) {
                this.sip.onRemoteAnswer();
            }
            this.notifyReceived(request.getContentBytes());
            return this.sip.createResponse(200, request);
        }
        if (requestName.equals("REFER")) {
            ReferToHeader rth = (ReferToHeader)request.getHeader("Refer-To");
            if (rth == null) {
                return this.sip.createResponse(400, request);
            }
            this.processRefer(rth);
            return this.sip.createResponse(202, request);
        }
        return this.sip.createResponse(501, request);
    }

    public int processUpdate(Request request, ServerTransaction transaction) {
        if (this.disconnected) {
            return 481;
        }
        byte[] content = request.getContentBytes();
        if (!this.mediaAccepted && content != null) {
            if (this.updateSent) {
                this.updateCollision = true;
            }
            return 491;
        }
        PAssertedIdentityHeader pid = (PAssertedIdentityHeader)request.getHeader("P-Asserted-Identity");
        if (pid != null) {
            this.call.setRemoteURI(pid.getAddress().getURI());
            this.digitReceived('/');
            if (this.state != 4) {
                this.sip.getDeviceListener().lineIdentityChanged(this.call.getConnectedParty(), this.getName());
            }
        }
        if (content != null) {
            if (!this.setRemoteMediaParameters(content)) {
                return 415;
            }
            this.selectedCapability = this.preferredCapability;
            if (!this.isConnected(1) && !this.isConnected(2)) {
                this.call.setLocalSDPInfo(this.getResponseContent(true));
                return 200;
            }
            this.request = request;
            this.transaction = transaction;
            this.newcodec = this.getSelectedCodec();
            this.oldAddress = this.remoteOpen;
            this.oldCapability = this.selectedCapability;
            new Thread(this).start();
            return 0;
        }
        return 200;
    }

    @Override
    public void run() {
        this.updatingCodec = true;
        try {
            int rcode;
            boolean rxok = true;
            boolean txok = true;
            this.mediaAccepted = false;
            AudioCodec oldcodec = this.playCodec;
            if (this.isConnected(1)) {
                txok = this.connectSocket(1, this.newcodec);
            }
            if (txok && this.isConnected(2)) {
                oldcodec = this.recCodec;
                rxok = this.connectSocket(2, this.newcodec);
            }
            byte[] sdp = null;
            if (this.disconnected) {
                rcode = 481;
            } else if (!rxok || !txok) {
                rcode = 488;
                this.remoteOpen = this.oldAddress;
                this.selectedCapability = this.preferredCapability = this.oldCapability;
            } else {
                rcode = 200;
                this.call.setLocalSDPInfo(this.getResponseContent(true));
                sdp = this.getSdpContent();
            }
            this.sip.sendResponse(rcode, this.call, this.request, this.transaction, sdp);
            if (!txok) {
                this.mediaAccepted = this.connectSocket(1, oldcodec);
            } else if (!rxok) {
                this.mediaAccepted = this.connectSocket(2, oldcodec);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatingCodec = false;
    }

    public String processMediaControl(String str) {
        if (this.master instanceof SipPort) {
            ((SipPort)this.master).sendMediaControl(str);
        } else if (this.master instanceof Mixer) {
            return ((Mixer)this.master).processMediaControl(str);
        }
        return null;
    }

    public void processDtmfInfo(String str) {
        int n = str.indexOf("ignal=");
        if (n != -1) {
            if ((n = (str = str.substring(n + 6).trim()).indexOf(10)) != -1) {
                str = str.substring(0, n).trim();
            }
            if (str.equals("10")) {
                this.digitReceived('*');
            } else if (str.equals("11")) {
                this.digitReceived('#');
            } else if (str.length() > 0) {
                this.digitReceived(str.charAt(0));
            }
        }
    }

    public synchronized void processAck(byte[] content) {
        if (this.state == 4) {
            if (!this.mediaAccepted && content != null) {
                this.mediaAccepted = this.setRemoteMediaParameters(content);
                this.selectedCapability = this.preferredCapability;
            } else if (this.reinviteRequired) {
                this.mediaAccepted = false;
                this.sip.sendReInvite(this.call);
            }
            this.ansAckReceived = true;
            this.notifyAll();
        }
    }

    public synchronized void processTimeout(String callId) {
        if (this.altCalls != null) {
            SipCall altcall = (SipCall)this.altCalls.remove(callId);
            this.sip.sendCancel(altcall);
            if (!this.altCalls.isEmpty()) {
                return;
            }
        } else if (this.call != null) {
            // empty if block
        }
        this.notifyAll();
    }

    public void sendMediaControl(String cmd) {
        this.sip.sendInfo(this.call, "application", "media_control+xml", cmd);
    }

    public synchronized String sendMediaControl(String cmd, boolean waitForReply) {
        this.sendMediaControl(cmd);
        if (!waitForReply) {
            return null;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String retval = this.infoResponse;
        this.infoResponse = null;
        return retval;
    }

    public synchronized void processResponse(Response response) {
        String method = ((CSeqHeader)response.getHeader("CSeq")).getMethod();
        if (method.equals("INFO")) {
            byte[] res = response.getContentBytes();
            if (res != null) {
                this.infoResponse = new String(res);
            }
            this.notifyAll();
        }
    }

    public synchronized void processResponse(Response response, int code, boolean ack) {
        this.toLog(this.getName() + " processResponse code=" + code + " ack=" + ack + " updateSent=" + this.updateSent + " method=" + ((CSeqHeader)response.getHeader("CSeq")).getMethod() + " callid=" + ((CallIdHeader)response.getHeader("Call-ID")).getCallId());
        if (this.disconnected) {
            this.notifyAll();
            return;
        }
        if (this.altCalls != null) {
            if (code == 200) {
                this.call = (SipCall)this.altCalls.remove(((CallIdHeader)response.getHeader("Call-ID")).getCallId());
                Enumeration en = this.altCalls.elements();
                while (en.hasMoreElements()) {
                    SipCall altcall = (SipCall)en.nextElement();
                    this.sip.sendCancel(altcall);
                    altcall.clear();
                }
                this.altCalls.clear();
                this.altCalls = null;
            } else {
                if (code < 200) {
                    if (code != this.responseCode && this.responseCode != 180) {
                        this.responseCode = code;
                        this.notifyAll();
                    }
                    return;
                }
                if (code >= 300) {
                    this.altCalls.remove(((CallIdHeader)response.getHeader("Call-ID")).getCallId());
                    if (this.altCalls.isEmpty()) {
                        this.responseCode = code;
                        this.notifyAll();
                    }
                    return;
                }
            }
        }
        String method = response.getCSeq().getMethod();
        if (!this.updateSent && (method.equals("INVITE") || method.equals("REFER"))) {
            this.responseCode = code;
            if (code >= 300) {
                this.responsePhrase = response.getReasonPhrase();
            }
            if (ack && this.responseCode == 200) {
                this.state = 4;
                this.ssig |= this.call.isSmileClient();
            } else if (this.responseCode >= 300 && this.responseCode < 400) {
                ContactHeader contactHeader = (ContactHeader)response.getHeader("Contact");
                this.call.setRemoteURI(contactHeader.getAddress().getURI());
            }
        } else {
            if (code == 100 || code == 101) {
                return;
            }
            if (this.updateSent && code == 491) {
                this.mediaAccepted = false;
            }
        }
        byte[] sdp = null;
        byte[] content = response.getContentBytes();
        if (!(content == null || this.updateSent && code != 200)) {
            this.mediaAccepted = this.setRemoteMediaParameters(content);
            Vector vcaps = this.getAcceptedCapabilities();
            if (ack && (vcaps.size() > 1 || this.needAckSDP())) {
                int[] caps = new int[]{(Integer)vcaps.elementAt(0)};
                SdpInfo sdpInfo = this.buildSDPContent(caps, true, true);
                sdp = sdpInfo.encode();
                this.selectedCapability = caps[0];
                this.call.setLocalSDPInfo(sdpInfo);
            } else {
                this.selectedCapability = this.preferredCapability;
            }
        }
        if (ack) {
            this.sip.sendAck(this.call, sdp, response.getSequenceNumber());
        } else if (code == 180) {
            ListIterator lit = response.getHeaders("Allow-Events");
            while (lit.hasNext()) {
                AllowEventsHeader aeh = (AllowEventsHeader)lit.next();
                String evt = aeh.getEventType();
                if (!evt.equals("talk")) continue;
                this.talkEvent = true;
            }
            if (this.autoTalk) {
                this.sendCTIAnswer();
            }
        }
        this.notifyAll();
    }

    protected boolean needAckSDP() {
        return false;
    }

    private boolean setRemoteMediaParameters(byte[] content) {
        try {
            SdpInfo info = new SdpInfo(content);
            String remoteHost = info.getHost();
            int remotePort = info.getPort();
            this.clearAcceptedCapabilities();
            Enumeration en = info.getCapabilities().elements();
            while (en.hasMoreElements()) {
                String cap = (String)en.nextElement();
                if (cap.equals("t38")) {
                    if (!this.localCapabilitiesInfo.containsKey(25088)) continue;
                    this.setMediaParameters(AudioCodec.T38UDP.getId(), !info.getFaxTrasferredTCF(), 0);
                    if (info.getCapabilities().size() != 1) continue;
                    this.faxSession = true;
                    this.digitReceived('\u001e');
                    continue;
                }
                int codecid = this.convertCodecIndex(cap);
                if (codecid != 0) {
                    int psize = info.getPacketTime() / (codecid > 1 ? 10 : 30);
                    this.setMediaParameters(codecid, info.getSilenceSuppression(SipEndpoint.convertCodecNumber(codecid)), psize, this.selectedCapability);
                }
                this.faxSession = false;
            }
            if (this.preferredCapability == 0) {
                return false;
            }
            this.call.setRemoteSDPInfo(info);
            if (remoteHost == null) {
                if (!this.onhold) {
                    this.digitReceived('!');
                }
                this.onholdByInfo = true;
            } else {
                this.setMediaAddress(remoteHost, remotePort, info.getOriginAddress());
                if (this.onholdByInfo) {
                    if (this.onhold) {
                        this.digitReceived('!');
                    }
                    this.onholdByInfo = false;
                }
            }
            this.setRemoteCryptoCapabilities(info.getCrypto());
            return true;
        }
        catch (Exception e) {
            ResourceStore.error(this.getName(), e);
            return false;
        }
    }

    public SdpInfo getRemoteSDPInfo() {
        return this.call.getRemoteSDPInfo();
    }

    public SdpInfo getLocalSDPInfo() {
        return this.call.getLocalSDPInfo();
    }

    private SdpInfo getRequestContent(boolean nowait) {
        int[] caps = this.getOfferedCapabilities();
        if (caps == null || caps.length == 0) {
            return null;
        }
        return this.buildSDPContent(caps, nowait, true);
    }

    private SdpInfo getResponseContent(boolean nowait) {
        if (this.call.getRemoteSDPInfo() == null) {
            if (nowait) {
                return null;
            }
            return this.getRequestContent(false);
        }
        if (nowait && !this.isMediaAddressReady(false)) {
            return null;
        }
        Vector vcaps = this.getAcceptedCapabilities();
        if (vcaps.isEmpty()) {
            return null;
        }
        int[] caps = new int[]{(Integer)vcaps.elementAt(0)};
        SdpInfo sdp = this.buildSDPContent(caps, false, false);
        if (sdp != null) {
            this.selectedCapability = caps[0];
            this.mediaAccepted = true;
        }
        return sdp;
    }

    protected SdpInfo buildSDPContent(int[] caps, boolean nowait, boolean tsmit) {
        if (this.call == null) {
            return null;
        }
        String ipaddress = "127.0.0.1";
        int port = super.getLocalDataPort();
        SdpInfo sdpInfo = this.call.getLocalSDPInfo();
        if (sdpInfo != null) {
            sdpInfo = new SdpInfo(sdpInfo);
            if (tsmit) {
                sdpInfo.setOriginAddress(ipaddress);
            }
        } else {
            sdpInfo = new SdpInfo("SIP Call", this.call.getLocalParty(), "IN IP4 " + ipaddress);
        }
        sdpInfo.setHost(ipaddress);
        sdpInfo.setPort(port);
        Vector<String> captable = new Vector<String>();
        for (int i = 0; i < caps.length; ++i) {
            String codecid;
            boolean s;
            int c = caps[i] >> 8 & 0xFF;
            boolean bl = s = (caps[i] & 0x10000) != 0;
            if (c == AudioCodec.T38UDP.getId()) {
                if (i > 0) continue;
                captable.addElement("t38");
                sdpInfo.setFaxTrasferredTCF(!s);
                this.faxSession = true;
                break;
            }
            if (c == -1) continue;
            if (c == AudioCodec.OPUSNB.getId()) {
                Object prm;
                String payloadType = codecid = String.valueOf(c);
                SdpInfo remoteinfo = this.getRemoteSDPInfo();
                if (remoteinfo != null) {
                    payloadType = remoteinfo.getCapabilityPayloadType(codecid);
                }
                if ((prm = this.sip.getProperty("minptime")) != null) {
                    sdpInfo.setCodecParameter(codecid, "minptime", prm.toString());
                }
                if ((prm = this.sip.getProperty("maxptime")) != null) {
                    sdpInfo.setCodecParameter(codecid, "maxptime", prm.toString());
                }
                if ((prm = this.sip.getProperty("maxaveragebitrate")) != null) {
                    sdpInfo.setCodecParameter(codecid, "maxaveragebitrate", prm.toString());
                }
                sdpInfo.setCapabilityPayloadType(codecid, payloadType);
            } else {
                c = SipEndpoint.convertCodecNumber(c);
                codecid = String.valueOf(c);
                sdpInfo.setSilenceSuppression(c, s);
            }
            captable.addElement(codecid);
            if (i == 0) {
                sdpInfo.setPacketTime((caps[i] & 0xFF) * (c == 4 ? 30 : 10));
            }
            this.faxSession = false;
        }
        sdpInfo.setCapabilities(captable);
        sdpInfo.setBandwidth(this.sip.getPortBandwidth());
        sdpInfo.setPhone(this.call.getLocalParty());
        sdpInfo.setDtmfRelay(this.dtmfInfo != 3);
        sdpInfo.setCrypto(this.getLocalCryptoCapabilities());
        return sdpInfo;
    }

    @Override
    public boolean redefineMedia() {
        if (this.canReinvite()) {
            this.signallingOnly = false;
            this.call.setLocalSDPInfo(this.getRequestContent(true));
            return this.sip.sendReInvite(this.call);
        }
        if (this.updateAllowed) {
            this.signallingOnly = false;
            this.call.setLocalSDPInfo(this.getRequestContent(true));
            return this.sip.sendUpdate(this.call);
        }
        return false;
    }

    public void onTargetLost() {
        if (this.targetInfo != null) {
            try {
                if (this.signallingOnly && this.socket instanceof SipPort) {
                    this.signallingOnly = false;
                    ((SipPort)this.socket).redefineMedia();
                }
                this.sip.createRequest(this.call, this.targetInfo);
                Vector vcaps = this.call.getLocalSDPInfo().getCapabilities();
                int[] caps = new int[]{(Integer)vcaps.elementAt(0)};
                SdpInfo content = this.buildSDPContent(caps, true, false);
                this.sip.sendRequest(this.call, content.encode());
                this.call.setLocalSDPInfo(content);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.forceDisconnect();
        }
    }

    private int convertCodecIndex(String key) {
        if (key.equals("0")) {
            return 9;
        }
        if (key.equals("4")) {
            return 1;
        }
        if (key.equals("8")) {
            return 5;
        }
        if (key.equals("18")) {
            return 12;
        }
        return Integer.parseInt(key);
    }

    private boolean canReinvite() {
        return this.state == 4 || this.earlyReinviteAllowed;
    }

    private synchronized boolean adjustMediaParameters(AudioCodec codec, boolean changeReq) {
        if (this.selectedCapability == 0) {
            return false;
        }
        int[] caps = new int[]{this.getCapability(codec.getId())};
        if (caps[0] == 0) {
            if (!codec.equals(AudioCodec.T38UDP)) {
                return false;
            }
            caps[0] = codec.getId() << 8;
        }
        if (this.updatingCodec) {
            this.selectedCapability = caps[0];
            return true;
        }
        SdpInfo newSdp = this.buildSDPContent(caps, false, false);
        if (newSdp == null) {
            return false;
        }
        SdpInfo oldSdp = this.call.getLocalSDPInfo();
        if (oldSdp != null && codec.getId() == (this.selectedCapability >> 8 & 0xFF) && newSdp.getPort() == oldSdp.getPort() && newSdp.getHost().equals(oldSdp.getHost()) && (newSdp.getVideoMode() == -1 || newSdp.getVideoMode() == oldSdp.getVideoMode())) {
            return true;
        }
        this.toLog(" adjustMediaParameters=" + codec + " cc=" + this.selectedCapability + " selectedCapability=" + this.selectedCapability + " state=" + this.state + " newSdp=" + newSdp + " oldSdp=" + oldSdp);
        this.call.setLocalSDPInfo(newSdp);
        if (this.state == 6) {
            this.sip.sendResponse(180, this.call, this.router);
            this.reinviteRequired = this.urealibleChangeReinvite;
            this.selectedCapability = caps[0];
            return this.mediaAccepted;
        }
        if (this.state == 3 || this.state == 12) {
            this.sip.sendResponse(183, this.call, this.router);
            this.reinviteRequired = this.urealibleChangeReinvite;
            this.selectedCapability = caps[0];
            return this.mediaAccepted;
        }
        do {
            if (this.updateCollision) {
                int rtime = (Utils.intRandom(9) + 1) * 50;
                try {
                    this.wait(rtime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.mediaAccepted) break;
            }
            this.updateCollision = false;
            if (this.canReinvite()) {
                if (!this.sip.sendReInvite(this.call)) {
                    return false;
                }
                this.changeReceiverReq = false;
            } else if (this.updateAllowed) {
                if (!this.sip.sendUpdate(this.call)) {
                    return false;
                }
                this.changeReceiverReq = false;
            } else {
                return false;
            }
            this.mediaAccepted = false;
            this.updateSent = true;
            try {
                this.wait(this.T3);
            }
            catch (InterruptedException rtime) {
                // empty catch block
            }
            this.updateSent = false;
        } while (!this.mediaAccepted && this.updateCollision);
        boolean result = this.mediaAccepted;
        if (this.mediaAccepted) {
            this.selectedCapability = caps[0];
        } else if (this.selectedCapability > 0) {
            this.mediaAccepted = true;
            this.call.setLocalSDPInfo(oldSdp);
        }
        this.toLog(" adjustMediaParameters cc=" + codec + " result" + result + " mediaAccepted=" + this.mediaAccepted + " selectedCapability=" + this.selectedCapability);
        return result && !this.disconnected;
    }

    private AudioCodec getSelectedCodec() {
        return this.selectedCapability > 0 ? this.getAudioCodec(this.selectedCapability >> 8 & 0xFF) : null;
    }

    private synchronized boolean checkCodec(AudioCodec codec, boolean changeReq) {
        if (this.disconnected) {
            return false;
        }
        if (!this.mediaAccepted && !this.updatingCodec) {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.mediaAccepted) {
                return false;
            }
        }
        if (this.adjustMediaParameters(codec, changeReq)) {
            return true;
        }
        this.removeMediaParameters(codec.getId());
        return false;
    }

    @Override
    public boolean startPlayback(AudioCodec codec) {
        this.toLog("starting Playback with codec " + codec.getId() + " crr=" + this.changeReceiverReq + " ma=" + this.mediaAccepted + " cap=" + this.selectedCapability);
        if (!this.checkCodec(codec, false)) {
            return false;
        }
        if (this.isConnected(2) && !codec.equals(this.recCodec) && !this.connectSocket(2, codec)) {
            return false;
        }
        HashMap prms = this.call.getRemoteSDPInfo().getCodecParameters(String.valueOf(codec.getId()));
        String payloadType = this.call.getRemoteSDPInfo().getCapabilityPayloadType(String.valueOf(codec.getPayloadType()));
        codec.setPayloadType(Integer.parseInt(payloadType));
        if (this.getRemoteSDPInfo().getAudioMode() != 1 && this.getLocalSDPInfo().getAudioMode() != 2) {
            this.startTransmit(codec, this.selectedCapability & 0xFF, prms);
        } else {
            this.setPreferredCapability(codec.getId());
        }
        this.toLog("startPlayback OK. cap=" + this.preferredCapability + " prms=" + prms);
        this.released = false;
        return true;
    }

    @Override
    public boolean startRecord(AudioCodec codec) {
        this.toLog("starting Record with codec " + codec.getId() + " crr=" + this.changeReceiverReq + " ma=" + this.mediaAccepted + " cap=" + this.selectedCapability);
        if (!this.checkCodec(codec, this.changeReceiverReq)) {
            return false;
        }
        String payloadType = this.call.getRemoteSDPInfo().getCapabilityPayloadType(String.valueOf(codec.getPayloadType()));
        codec.setPayloadType(Integer.parseInt(payloadType));
        if (this.getRemoteSDPInfo().getAudioMode() != 2 && this.getLocalSDPInfo().getAudioMode() != 1) {
            this.startReceive(codec);
        } else {
            this.setPreferredCapability(codec.getId());
        }
        this.toLog("startRecord OK. cap=" + this.preferredCapability);
        this.released = false;
        return true;
    }

    @Override
    public void stopPlayback() {
        this.toLog("stopPlayback");
        this.stopTransmit();
    }

    @Override
    public void stopRecord() {
        this.toLog("stopRecord");
        this.stopReceive();
    }

    @Override
    public void setDigitMask(char[] mask) {
        super.setDigitMask(mask);
        this.released = false;
    }

    @Override
    public char retriveSignal(int timeout) {
        char digit = super.retriveSignal(timeout);
        if (this.state == 7) {
            return '\u001d';
        }
        if (this.released) {
            this.released = false;
            return '\u001c';
        }
        return digit;
    }

    @Override
    public void sendDigits(String str) {
        switch (str.charAt(0)) {
            case '!': 
            case '^': {
                this.sendSignalInfo(str.charAt(0));
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            case '$': 
            case '%': {
                if (this.referred) {
                    this.sendReferNotify(200);
                } else {
                    this.sendSignalInfo(str.charAt(0));
                }
                this.referred = false;
                return;
            }
            case 'h': {
                boolean bl = this.onhold = !this.onhold;
                if (this.referred) {
                    this.sendReferNotify(100);
                } else {
                    this.sendSignalInfo(str.charAt(0));
                }
                return;
            }
            case '~': {
                if (this.referred) {
                    this.sendReferNotify(503);
                } else {
                    this.sendSignalInfo(str.charAt(0));
                }
                this.referred = false;
                return;
            }
        }
        if (this.dtmfInfo == 1) {
            if (str.length() > 1 && str.charAt(str.length() - 1) == '!') {
                this.sip.sendInfo(this.call, "application", "smile-dtmf-info", str);
            } else {
                for (int i = 0; i < str.length(); ++i) {
                    char digit = str.charAt(i);
                    if (digit == ',') {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (digit == '&') {
                        digit = '!';
                    }
                    this.sip.sendInfo(this.call, "application", "dtmf-relay", "Signal=" + digit + "\r\nDuration=100");
                    if (i >= str.length() - 1) continue;
                    try {
                        Thread.sleep(150L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        } else {
            super.sendDigits(str);
        }
    }

    private void sendSignalInfo(char c) {
        if (this.ssig) {
            this.sip.sendInfo(this.call, "application", "dtmf-relay", "Signal=" + c);
        }
    }

    private void sendReferNotify(int code) {
        String content = "SIP/2.0 " + code;
        String state = "terminated;reason=noresource";
        switch (code) {
            case 100: {
                state = "active;expires=60";
                content = content + " Trying";
                break;
            }
            case 200: {
                content = content + " OK";
                break;
            }
            case 503: {
                content = content + " Service unavailable";
            }
        }
        try {
            this.sip.sendNotify(this.call, "refer", state, content, "message", "sipfrag;version=2.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendCTIAnswer() {
        if (this.call == null) {
            return;
        }
        if (this.talkEvent) {
            try {
                this.sip.sendNotify(this.call, "talk", "active", null, null, null);
            }
            catch (Exception exception) {}
        } else {
            String ua = this.call.getRemoteUserAgent();
            if (ua.indexOf("SPA") == -1) {
                return;
            }
            String event = "x-spa-cti";
            String content = "<spa-control>\r\n  <answer call=\"1\" />\r\n</spa-control>";
            String type = "application";
            String subtype = "x-spa-control";
            try {
                this.sip.sendNotify(this.call, event, content, type, subtype);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendApplicationData(String appName, String info) {
        this.sip.sendInfo(this.call, "application", appName, info);
    }

    public void onRoute() {
        if (this.mroute && this.socket instanceof SipPort) {
            try {
                SipCall scall = ((SipPort)this.socket).getCall();
                Request request = this.sip.createRequest("INVITE", scall.getSeqNumber() + 100, scall);
                this.sendApplicationData("smile-redundancy-info", request.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public WavAudioFormat[] getAvailableCodecs(int dir) {
        AudioCodec codec = this.getSelectedCodec();
        if (codec == null) {
            return null;
        }
        WavAudioFormat[] format = new WavAudioFormat[]{AudioCodec.getWavAudioFormat(codec)};
        return format[0] != null ? format : null;
    }

    @Override
    public int play(InputStream istream, char[] signal_mask, int maxtime, WavAudioFormat wcodec) {
        int result;
        if (this.disconnected) {
            return 8;
        }
        AudioCodec pcodec = AudioCodec.getAudioCodec(wcodec);
        AudioCodec scodec = this.getSelectedCodec();
        if (pcodec == null || scodec == null) {
            return this.faxSession ? 8192 : 16384;
        }
        if (pcodec.equals(scodec)) {
            result = super.play(istream, signal_mask, maxtime, scodec, this.selectedCapability & 0xFF);
        } else {
            if (this.faxSession) {
                return 8192;
            }
            AudioConverter acv = new AudioConverter();
            AudioCodec[] avlcodecs = new AudioCodec[]{scodec};
            ConvertedInputStream cin = acv.getInputStream(istream, pcodec, avlcodecs);
            if (cin == null) {
                return 16384;
            }
            result = super.play(cin, signal_mask, maxtime, scodec, this.selectedCapability & 0xFF);
            cin.release();
        }
        return this.disconnected ? 8 : result;
    }

    @Override
    public int record(OutputStream ostream, char[] signal_mask, int maxsilence, int maxtime, WavAudioFormat wcodec) {
        if (this.disconnected) {
            return 8;
        }
        AudioCodec codec = AudioCodec.getAudioCodec(wcodec);
        if (codec == null || !codec.equals(this.getSelectedCodec())) {
            return this.faxSession ? 8192 : 16384;
        }
        int result = super.record(ostream, signal_mask, maxsilence, maxtime, codec);
        return this.disconnected ? 8 : result;
    }

    public int getStatusCode() {
        return this.responseCode;
    }

    public String getReasonPhrase() {
        return this.responsePhrase;
    }

    @Override
    public int getSocketTimeout() {
        return super.getSocketTimeout();
    }
}

