/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip;

import com.smile.telephony.sip.address.SipURI;
import java.text.ParseException;

public class SipRoute {
    private SipURI remoteUri;
    private String proxyAddress;
    private String user;
    private String localHost;

    public SipRoute(String user, SipURI remoteUri, String proxyAddress, String localHost) {
        this.user = user;
        this.remoteUri = remoteUri;
        this.localHost = localHost;
        this.proxyAddress = proxyAddress;
        if (remoteUri.getHost().endsWith(".invalid")) {
            try {
                this.remoteUri = new SipURI(user + "@" + localHost);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.user + "@" + this.remoteUri + " (" + this.proxyAddress + ")";
    }

    public SipURI getRemoteUri() {
        return this.remoteUri;
    }

    public String getRemoteAddress() {
        Object addr = this.remoteUri.getHost();
        int port = this.remoteUri.getPort();
        if (port > 0) {
            addr = (String)addr + ":" + port;
        }
        return addr;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUserUri() {
        return this.localHost;
    }

    public String getLocalAddress() {
        return this.localHost;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }
}

