/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.address;

import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.address.TelURL;
import com.smile.telephony.sip.address.URI;
import java.text.ParseException;

public class AddressFactory {
    public static URI parseURI(String uri) throws ParseException {
        int i = uri.indexOf(58);
        if (i == -1) {
            throw new ParseException("Invalid URI format: " + uri, 0);
        }
        String scheme = uri.substring(0, i).toLowerCase();
        if (scheme.equals("sip") || scheme.equals("sips")) {
            SipURI sipUri = new SipURI(uri.substring(i + 1));
            sipUri.setScheme(scheme);
            return sipUri;
        }
        if (scheme.equals("tel")) {
            return new TelURL(uri.substring(i + 1));
        }
        return new URI(uri);
    }

    public Address createAddress(URI uri) {
        Address address = new Address();
        address.setURI(uri);
        return address;
    }

    public Address createAddress(String displayName, URI uri) {
        Address address = this.createAddress(uri);
        if (displayName != null) {
            address.setDisplayName(displayName);
        }
        return address;
    }

    public Address createAddress(String uri) throws ParseException {
        return this.createAddress(AddressFactory.parseURI(uri));
    }

    public URI createURI(String uri) throws ParseException {
        return AddressFactory.parseURI(uri);
    }

    public SipURI createSipURI(String uri) throws ParseException {
        return (SipURI)this.createURI(uri);
    }

    public SipURI createSipURI(String user, String address) throws ParseException {
        SipURI sipUri = new SipURI();
        sipUri.setUser(user);
        int i = address.indexOf(58);
        if (i != -1 && address.indexOf(58, i + 1) == -1) {
            try {
                sipUri.setPort(Integer.parseInt(address.substring(i + 1)));
            }
            catch (NumberFormatException e) {
                throw new ParseException(address, 0);
            }
            sipUri.setHost(address.substring(0, i));
        } else {
            sipUri.setHost(address);
        }
        return sipUri;
    }

    public TelURL createTelURL(String uri) throws ParseException {
        return new TelURL(uri);
    }
}

