/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.address;

import com.smile.telephony.sip.address.URI;
import java.text.ParseException;

public class SipURI
extends URI {
    protected String host;
    protected String user;
    protected String pass;
    protected int port = -1;

    public SipURI() {
        this.scheme = "sip";
    }

    public SipURI(String uri) throws ParseException {
        this.scheme = "sip";
        int i = uri.indexOf(64);
        if (i != -1) {
            this.user = uri.substring(0, i);
            uri = uri.substring(i + 1);
            i = this.user.indexOf(58);
            if (i != -1) {
                this.pass = this.user.substring(i + 1);
                this.user = this.user.substring(0, i);
            }
        }
        if ((i = uri.indexOf(63)) != -1) {
            this.parseHeaders(uri.substring(i + 1));
            uri = uri.substring(0, i);
        }
        if ((i = uri.indexOf(59)) != -1) {
            this.parseParameters(uri.substring(i + 1));
            uri = uri.substring(0, i);
        }
        if ((i = uri.lastIndexOf(58)) != -1) {
            this.setPort(Integer.parseInt(uri.substring(i + 1)));
            uri = uri.substring(0, i);
        }
        this.setHost(uri);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SipURI)) {
            return false;
        }
        SipURI uri = (SipURI)obj;
        if (!this.host.equals(uri.host) || this.port != uri.port) {
            return false;
        }
        if (this.user != null && !this.user.equals(uri.user)) {
            return false;
        }
        return this.pass == null || this.pass.equals(uri.pass);
    }

    public void setScheme(String scheme) {
        this.scheme = scheme.toLowerCase();
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public void clearPassword() {
        this.pass = null;
    }

    @Override
    public String encode() {
        String uri = this.scheme + ":";
        if (this.user != null) {
            uri = this.pass == null ? uri + this.user + "@" : uri + this.user + ":" + this.pass + "@";
        }
        uri = uri + this.host;
        if (this.port != -1) {
            uri = uri + ":" + this.port;
        }
        return uri + this.encodeParameters() + this.encodeHeaders();
    }

    public String getUserAtHost() {
        return this.user != null ? this.user + "@" + this.host : this.host;
    }

    public String getUserAtHostPort() {
        Object retval = this.getUserAtHost();
        if (this.port != -1) {
            retval = (String)retval + (58 + this.port);
        }
        return retval;
    }

    public boolean isSecure() {
        return this.scheme.equalsIgnoreCase("sips");
    }

    public void setSecure(boolean secure) {
        this.scheme = secure ? "sips" : "sip";
    }

    public String getUserPassword() {
        return this.pass;
    }

    public void setUserPassword(String password) {
        this.pass = password;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public void removePort() {
        this.port = -1;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void removeUser() {
        this.user = null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isUserTelephoneSubscriber() {
        return "phone".equals(this.getUserType());
    }

    public String getMethod() {
        return (String)this.getParameter("method");
    }

    public String getUserType() {
        return (String)this.getParameter("user");
    }

    public String getLrParam() {
        return this.hasParameter("lr") ? "true" : null;
    }

    public String getMAddrParam() {
        return (String)this.getParameter("maddr");
    }

    public String getMethodParam() {
        return (String)this.getParameter("method");
    }

    public int getTTLParam() {
        Object ttl = this.getParameter("ttl");
        if (ttl == null) {
            return -1;
        }
        return Integer.parseInt(ttl.toString());
    }

    public String getTransportParam() {
        return (String)this.getParameter("transport");
    }

    public String getUserParam() {
        return (String)this.getParameter("user");
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public boolean hasTransport() {
        return this.hasParameter("transport");
    }

    public boolean hasLrParam() {
        return this.hasParameter("lr");
    }

    public void removeTTL() {
        this.removeParameter("ttl");
    }

    public void removeMAddr() {
        this.removeParameter("maddr");
    }

    public void removeTransport() {
        this.removeParameter("transport");
    }

    public void removeUserType() {
        this.removeParameter("user");
    }

    public void removeMethod() {
        this.removeParameter("method");
    }

    public void setMAddr(String mAddr) {
        this.setParameter("maddr", mAddr);
    }

    public void setUserParam(String usertype) {
        this.setParameter("user", usertype);
    }

    public void setMethod(String method) {
        this.setParameter("method", method);
    }

    public void setLrParam() {
        this.setParameter("lr", null);
    }

    public void setMAddrParam(String maddr) {
        this.setParameter("maddr", maddr);
    }

    public void setMethodParam(String method) {
        this.setParameter("method", method);
    }

    public void setTTLParam(int ttl) {
        this.setParameter("ttl", ttl);
    }

    public void setTransportParam(String transport) {
        if (transport != null) {
            this.setParameter("transport", transport.toLowerCase());
        }
    }
}

