/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.AddressFactory;
import com.smile.telephony.sip.header.ParametersHeader;
import java.text.ParseException;

public abstract class AddressHeader
extends ParametersHeader {
    protected Address address;

    @Override
    public int parse(String value, int offset) throws ParseException {
        int i;
        this.address = new Address();
        int j = i = offset;
        while (i < value.length()) {
            switch (value.charAt(i)) {
                case '\t': 
                case ' ': {
                    ++j;
                    break;
                }
                case '\"': {
                    j = value.indexOf(34, i + 1);
                    if (j == -1) {
                        throw new ParseException(value, 0);
                    }
                    this.address.setDisplayName(value.substring(i + 1, j));
                    i = j++;
                    break;
                }
                case '<': {
                    if (i > j) {
                        this.address.setDisplayName(value.substring(j, i));
                    }
                    if ((j = value.indexOf(62, i + 1)) == -1) {
                        throw new ParseException(value, 0);
                    }
                    this.address.setURI(AddressFactory.parseURI(value.substring(i + 1, j)));
                    this.address.setAddressType(1);
                    ++j;
                    i = value.length();
                    break;
                }
                case '/': 
                case ':': {
                    i = j;
                    j = value.indexOf(59, i + 1);
                    if (j == -1) {
                        j = value.indexOf(44, i + 1);
                    }
                    if (j == -1) {
                        j = value.length();
                    }
                    this.address.setURI(AddressFactory.parseURI(value.substring(i, j)));
                    this.address.setAddressType(2);
                    ++j;
                    i = value.length();
                    break;
                }
                case '*': {
                    this.address.setAddressType(3);
                    return i + 1;
                }
            }
            ++i;
        }
        if (j < value.length()) {
            j = super.parse(value, j);
        }
        return j;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getHost() {
        return this.address.getHost();
    }

    public int getPort() {
        return this.address.getPort();
    }

    public String getUserAtHostPort() {
        return this.address.getUserAtHostPort();
    }

    public String getUserAtHost() {
        return this.address.getUserAtHost();
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }

    @Override
    protected String encodeBody() {
        return this.address.encode() + super.encodeBody();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && ((AddressHeader)obj).address.equals(this.address);
    }
}

