/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.header.AddressHeader;

public class ContactHeader
extends AddressHeader {
    public static final String NAME = "Contact";
    public static final String ACTION = "action";
    public static final String PROXY = "proxy";
    public static final String REDIRECT = "redirect";
    public static final String EXPIRES = "expires";
    public static final String Q = "q";

    public ContactHeader() {
        this.setHeaderName(NAME);
    }

    public boolean getWildCardFlag() {
        return this.address.isWildcard();
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public int getExpires() {
        return this.getIntParameter(EXPIRES);
    }

    public void setExpires(int deltaSeconds) {
        this.setParameter(EXPIRES, String.valueOf(deltaSeconds));
    }

    public float getQValue() {
        return this.getFloatParameter(Q);
    }

    public void setWildCardAddress() {
        this.address = new Address();
        this.address.setWildCardFlag();
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    public void setQValue(float qValue) {
        this.setParameter(Q, String.valueOf(qValue));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ContactHeader)) {
            return false;
        }
        ContactHeader ch = (ContactHeader)obj;
        return this.address.isWildcard() == ch.address.isWildcard() && super.equals(obj);
    }
}

