/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.ValueParametersHeader;
import java.text.ParseException;

public class ContentTypeHeader
extends ValueParametersHeader {
    public static final String NAME = "Content-Type";
    protected String contentType;
    protected String contentSubType;

    public ContentTypeHeader() {
        this.setHeaderName(NAME);
    }

    public ContentTypeHeader(String contentType, String contentSubtype) {
        this();
        this.setContentType(contentType, contentSubtype);
    }

    @Override
    protected void parseValue(String value) throws ParseException {
        int n = value.indexOf(47);
        if (n != -1) {
            this.contentType = value.substring(0, n);
            this.contentSubType = value.substring(n + 1);
        } else {
            this.contentType = value;
            this.contentSubType = "*";
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentSubType() {
        return this.contentSubType;
    }

    public String getCharset() {
        return this.getParameter("charset");
    }

    public void setContentType(String contentType, String contentSubType) {
        this.contentType = contentType;
        this.contentSubType = contentSubType;
    }

    @Override
    public String encodeBody() {
        return this.contentType + "/" + this.contentSubType + super.encodeBody();
    }
}

