/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.AuthorizationHeader;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.CallIdHeader;
import com.smile.telephony.sip.header.ContentDispositionHeader;
import com.smile.telephony.sip.header.ContentLengthHeader;
import com.smile.telephony.sip.header.ContentTypeHeader;
import com.smile.telephony.sip.header.DateHeader;
import com.smile.telephony.sip.header.EventHeader;
import com.smile.telephony.sip.header.ExpiresHeader;
import com.smile.telephony.sip.header.ExtensionHeader;
import com.smile.telephony.sip.header.FromHeader;
import com.smile.telephony.sip.header.MaxForwardsHeader;
import com.smile.telephony.sip.header.MimeVersionHeader;
import com.smile.telephony.sip.header.MinExpiresHeader;
import com.smile.telephony.sip.header.OrganizationHeader;
import com.smile.telephony.sip.header.PriorityHeader;
import com.smile.telephony.sip.header.ProxyAuthenticateHeader;
import com.smile.telephony.sip.header.ProxyAuthorizationHeader;
import com.smile.telephony.sip.header.RAckHeader;
import com.smile.telephony.sip.header.RSeqHeader;
import com.smile.telephony.sip.header.ReasonHeader;
import com.smile.telephony.sip.header.ReferToHeader;
import com.smile.telephony.sip.header.ReplyToHeader;
import com.smile.telephony.sip.header.RetryAfterHeader;
import com.smile.telephony.sip.header.ServerHeader;
import com.smile.telephony.sip.header.SubjectHeader;
import com.smile.telephony.sip.header.SubscriptionStateHeader;
import com.smile.telephony.sip.header.TimeStampHeader;
import com.smile.telephony.sip.header.ToHeader;
import com.smile.telephony.sip.header.UserAgentHeader;
import com.smile.telephony.sip.header.WWWAuthenticateHeader;
import java.text.ParseException;
import java.util.HashMap;

public abstract class Header
implements Cloneable {
    private static HashMap classTable = new HashMap();
    protected String headerName;
    protected boolean required;

    public static Header createHeader(String headerName, String headerValue) throws Exception {
        Class headerClass = (Class)classTable.get(headerName);
        if (headerClass != null) {
            Header header = (Header)headerClass.newInstance();
            header.parse(headerValue, 0);
            return header;
        }
        ExtensionHeader header = new ExtensionHeader(headerName);
        ((Header)header).parse(headerValue, 0);
        return header;
    }

    public static boolean isRequired(String h) {
        return h.equals("From") || h.equals("To") || h.equals("CSeq") || h.equals("Via") || h.equals("Call-ID");
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String hdrname) {
        this.headerName = hdrname;
    }

    public void setName(String hdrname) {
        this.headerName = hdrname;
    }

    public String getName() {
        return this.headerName;
    }

    public String getValue() {
        return this.encodeBody();
    }

    public boolean isHeaderList() {
        return false;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String encode() {
        return this.headerName + ": " + this.encodeBody() + "\r\n";
    }

    protected abstract String encodeBody();

    protected abstract int parse(String var1, int var2) throws ParseException;

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass()) && this.headerName.equals(((Header)obj).headerName);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String toString() {
        return this.encode();
    }

    static {
        classTable.put("Authorization", AuthorizationHeader.class);
        classTable.put("Call-ID", CallIdHeader.class);
        classTable.put("Content-Disposition", ContentDispositionHeader.class);
        classTable.put("Content-Length", ContentLengthHeader.class);
        classTable.put("Content-Type", ContentTypeHeader.class);
        classTable.put("CSeq", CSeqHeader.class);
        classTable.put("Date", DateHeader.class);
        classTable.put("Event", EventHeader.class);
        classTable.put("Expires", ExpiresHeader.class);
        classTable.put("From", FromHeader.class);
        classTable.put("Max-Forwards", MaxForwardsHeader.class);
        classTable.put("MIME-Version", MimeVersionHeader.class);
        classTable.put("Min-Expires", MinExpiresHeader.class);
        classTable.put("Organization", OrganizationHeader.class);
        classTable.put("Priority", PriorityHeader.class);
        classTable.put("Proxy-Authenticate", ProxyAuthenticateHeader.class);
        classTable.put("Proxy-Authorization", ProxyAuthorizationHeader.class);
        classTable.put("WWW-Authenticate", WWWAuthenticateHeader.class);
        classTable.put("RAck", RAckHeader.class);
        classTable.put("RSeq", RSeqHeader.class);
        classTable.put("Reason", ReasonHeader.class);
        classTable.put("Refer-To", ReferToHeader.class);
        classTable.put("Reply-To", ReplyToHeader.class);
        classTable.put("Retry-After", RetryAfterHeader.class);
        classTable.put("Server", ServerHeader.class);
        classTable.put("Subject", SubjectHeader.class);
        classTable.put("Subscription-State", SubscriptionStateHeader.class);
        classTable.put("Timestamp", TimeStampHeader.class);
        classTable.put("To", ToHeader.class);
        classTable.put("User-Agent", UserAgentHeader.class);
    }
}

