/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.AcceptEncodingHeader;
import com.smile.telephony.sip.header.AcceptHeader;
import com.smile.telephony.sip.header.AcceptLanguageHeader;
import com.smile.telephony.sip.header.AlertInfoHeader;
import com.smile.telephony.sip.header.AllowEventsHeader;
import com.smile.telephony.sip.header.AllowHeader;
import com.smile.telephony.sip.header.AuthenticationInfoHeader;
import com.smile.telephony.sip.header.CallInfoHeader;
import com.smile.telephony.sip.header.ContactHeader;
import com.smile.telephony.sip.header.ContentEncodingHeader;
import com.smile.telephony.sip.header.ContentLanguageHeader;
import com.smile.telephony.sip.header.ErrorInfoHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.InReplyToHeader;
import com.smile.telephony.sip.header.PAssertedIdentityHeader;
import com.smile.telephony.sip.header.ProxyRequireHeader;
import com.smile.telephony.sip.header.RecordRouteHeader;
import com.smile.telephony.sip.header.RequireHeader;
import com.smile.telephony.sip.header.RouteHeader;
import com.smile.telephony.sip.header.SupportedHeader;
import com.smile.telephony.sip.header.UnsupportedHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.header.WarningHeader;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class HeaderList
extends Header
implements List {
    private static HashMap classTable = new HashMap();
    protected LinkedList hlist;

    public static Header createHeader(String headerName, String headerValue) throws Exception {
        if (!classTable.containsKey(headerName)) {
            return Header.createHeader(headerName, headerValue);
        }
        HeaderList hlist = new HeaderList(headerName);
        hlist.parse(headerValue, 0);
        return hlist;
    }

    public static boolean isHeaderList(String headerName) {
        return classTable.containsKey(headerName);
    }

    public HeaderList(String name) {
        this(name, new LinkedList());
    }

    public HeaderList(String name, LinkedList hl) {
        this.setHeaderName(name);
        this.hlist = hl;
        this.required = name.equals("Via");
    }

    @Override
    public boolean add(Object objectToAdd) {
        return this.hlist.add(objectToAdd);
    }

    @Override
    public void addFirst(Object obj) {
        this.hlist.addFirst(obj);
    }

    public void add(Header sipheader, boolean top) {
        if (top) {
            this.addFirst(sipheader);
        } else {
            this.add(sipheader);
        }
    }

    public void concatenate(HeaderList other, boolean top) {
        if (!top) {
            this.hlist.addAll(other);
        } else {
            this.hlist.addAll(0, other);
        }
    }

    public void concatenate(HeaderList other) {
        this.concatenate(other, false);
    }

    @Override
    public int parse(String value, int offset) throws ParseException {
        Class headerClass = (Class)classTable.get(this.headerName);
        try {
            while (offset < value.length()) {
                char c = value.charAt(offset);
                if (c == ' ' || c == '\t') {
                    ++offset;
                    continue;
                }
                Header header = (Header)headerClass.newInstance();
                int i = header.parse(value, offset);
                if (i <= offset) {
                    return offset + 1;
                }
                offset = i;
                this.add(header);
            }
            return offset;
        }
        catch (Exception e) {
            throw new ParseException(value, offset);
        }
    }

    public LinkedList getHeadersAsEncodedStrings() {
        LinkedList<String> retval = new LinkedList<String>();
        ListIterator li = this.hlist.listIterator();
        while (li.hasNext()) {
            Header sipheader = (Header)li.next();
            retval.add(sipheader.encode());
        }
        return retval;
    }

    public Header first() {
        Iterator it = this.hlist.iterator();
        return it.hasNext() ? (Header)it.next() : null;
    }

    @Override
    public Header getFirst() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (Header)this.hlist.getFirst();
    }

    @Override
    public Header getLast() {
        if (this.hlist == null || this.hlist.isEmpty()) {
            return null;
        }
        return (Header)this.hlist.getLast();
    }

    public Header[] getHeaders() {
        Header[] retval = new Header[this.size()];
        ListIterator li = this.listIterator();
        int i = 0;
        while (li.hasNext()) {
            Header nextContact;
            retval[i] = nextContact = (Header)li.next();
            ++i;
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.hlist.isEmpty();
    }

    public ListIterator listIterator() {
        return this.hlist.listIterator(0);
    }

    public LinkedList getHeaderList() {
        return this.hlist;
    }

    public ListIterator listIterator(int position) {
        return this.hlist.listIterator(position);
    }

    @Override
    public void removeFirst() {
        if (this.hlist.size() != 0) {
            this.hlist.removeFirst();
        }
    }

    @Override
    public void removeLast() {
        if (this.hlist.size() != 0) {
            this.hlist.removeLast();
        }
    }

    public boolean remove(Header obj) {
        if (this.hlist.size() == 0) {
            return false;
        }
        return this.hlist.remove(obj);
    }

    @Override
    public Object[] toArray() {
        Header[] retval = new Header[this.hlist.size()];
        return this.hlist.toArray(retval);
    }

    @Override
    public int indexOf(Object gobj) {
        return this.hlist.indexOf(gobj);
    }

    public void add(int index, Header sipHeader) throws IndexOutOfBoundsException {
        this.hlist.add(index, sipHeader);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.hlist.equals(((HeaderList)obj).hlist);
    }

    @Override
    public Object clone() {
        HeaderList retval = new HeaderList(this.getHeaderName());
        retval.required = this.required;
        if (this.hlist != null) {
            retval.hlist = (LinkedList)this.hlist.clone();
            ListIterator it = retval.listIterator();
            while (it.hasNext()) {
                it.set(((Header)it.next()).clone());
            }
        }
        return retval;
    }

    @Override
    public int size() {
        return this.hlist.size();
    }

    @Override
    public boolean isHeaderList() {
        return true;
    }

    @Override
    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext()) {
            Header siphdr = (Header)iterator.next();
            encoding.append(siphdr.encodeBody());
            if (!iterator.hasNext()) break;
            encoding.append(",");
        }
        return encoding.toString();
    }

    public void add(int position, Object headerToAdd) {
        this.hlist.add(position, headerToAdd);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.hlist.add(collection);
    }

    public boolean addAll(int index, Collection collection) {
        return this.hlist.addAll(index, collection);
    }

    @Override
    public void clear() {
        this.hlist.clear();
    }

    @Override
    public boolean contains(Object header) {
        return this.hlist.contains(header);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.hlist.containsAll(collection);
    }

    public Object get(int index) {
        if (index >= this.hlist.size()) {
            return null;
        }
        return this.hlist.get(index);
    }

    @Override
    public Iterator iterator() {
        return this.hlist.listIterator();
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.hlist.lastIndexOf(obj);
    }

    @Override
    public boolean remove(Object obj) {
        return this.hlist.remove(obj);
    }

    public Object remove(int index) {
        return this.hlist.remove(index);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.hlist.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.hlist.retainAll(collection);
    }

    public Object set(int index, Object obj) {
        return this.hlist.set(index, obj);
    }

    public List subList(int index1, int index2) {
        return this.hlist.subList(index1, index2);
    }

    @Override
    public Object[] toArray(Object[] obj) {
        return this.hlist.toArray();
    }

    static {
        classTable.put("Accept", AcceptHeader.class);
        classTable.put("Accept-Encoding", AcceptEncodingHeader.class);
        classTable.put("Accept-Language", AcceptLanguageHeader.class);
        classTable.put("Alert-Info", AlertInfoHeader.class);
        classTable.put("Allow", AllowHeader.class);
        classTable.put("Allow-Events", AllowEventsHeader.class);
        classTable.put("Authentication-Info", AuthenticationInfoHeader.class);
        classTable.put("Call-Info", CallInfoHeader.class);
        classTable.put("Contact", ContactHeader.class);
        classTable.put("Content-Encoding", ContentEncodingHeader.class);
        classTable.put("Content-Language", ContentLanguageHeader.class);
        classTable.put("Error-Info", ErrorInfoHeader.class);
        classTable.put("In-Reply-To", InReplyToHeader.class);
        classTable.put("Proxy-Require", ProxyRequireHeader.class);
        classTable.put("Record-Route", RecordRouteHeader.class);
        classTable.put("Require", RequireHeader.class);
        classTable.put("Route", RouteHeader.class);
        classTable.put("Supported", SupportedHeader.class);
        classTable.put("Unsupported", UnsupportedHeader.class);
        classTable.put("Warning", WarningHeader.class);
        classTable.put("Via", ViaHeader.class);
        classTable.put("P-Asserted-Identity", PAssertedIdentityHeader.class);
    }
}

