/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.ValueHeader;
import java.text.ParseException;

public class MimeVersionHeader
extends ValueHeader {
    public static final String NAME = "MIME-Version";
    protected int majorVersion;
    protected int minorVersion;

    public MimeVersionHeader() {
        super.setHeaderName(NAME);
    }

    @Override
    protected void parseValue(String value) throws ParseException {
        int n = value.indexOf(46);
        if (n != -1) {
            this.majorVersion = Integer.parseInt(value.substring(0, n));
            this.minorVersion = Integer.parseInt(value.substring(n + 1));
        } else {
            this.majorVersion = Integer.parseInt(value);
            this.minorVersion = 0;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMajorVersion(int ver) {
        this.majorVersion = ver;
    }

    public void setMinorVersion(int ver) {
        this.minorVersion = ver;
    }

    @Override
    public String encodeBody() {
        return this.majorVersion + "." + this.minorVersion;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MimeVersionHeader)) {
            return false;
        }
        MimeVersionHeader mh = (MimeVersionHeader)obj;
        return this.majorVersion == mh.majorVersion && this.minorVersion == mh.minorVersion;
    }
}

