/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.ValueHeader;
import java.text.ParseException;

public class RAckHeader
extends ValueHeader {
    public static final String NAME = "RAck";
    protected int cSeqNumber;
    protected int rSeqNumber;
    protected String method;

    public RAckHeader() {
        this.setHeaderName(NAME);
    }

    @Override
    protected void parseValue(String str) throws ParseException {
        int n = str.indexOf(32);
        try {
            this.rSeqNumber = new Integer(str.substring(0, n));
            int m = str.indexOf(32, n + 1);
            this.cSeqNumber = new Integer(str.substring(n, m));
            this.method = str.substring(m + 1);
        }
        catch (Exception e) {
            throw new ParseException(str, 0);
        }
    }

    @Override
    protected String encodeBody() {
        return this.rSeqNumber + " " + this.cSeqNumber + " " + this.method;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RAckHeader)) {
            return false;
        }
        RAckHeader rh = (RAckHeader)obj;
        return this.cSeqNumber == rh.cSeqNumber && this.rSeqNumber == rh.rSeqNumber && this.method.equals(rh.method);
    }

    public int getCSeqNumber() {
        return this.cSeqNumber;
    }

    public String getMethod() {
        return this.method;
    }

    public int getRSeqNumber() {
        return this.rSeqNumber;
    }

    public void setCSeqNumber(int cSeqNumber) {
        this.cSeqNumber = cSeqNumber;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setRSeqNumber(int rSeqNumber) {
        this.rSeqNumber = rSeqNumber;
    }
}

