/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.ValueParametersHeader;
import java.text.ParseException;

public class RetryAfterHeader
extends ValueParametersHeader {
    public static final String NAME = "Retry-After";
    protected int retryAfter;
    protected String comment;

    public RetryAfterHeader() {
        this.setHeaderName(NAME);
    }

    @Override
    protected void parseValue(String str) throws ParseException {
        try {
            int n = str.indexOf(40);
            if (n != -1) {
                this.retryAfter = Integer.parseInt(str.substring(0, n));
                this.comment = str.substring(n, str.indexOf(41));
            } else {
                this.retryAfter = Integer.parseInt(str);
            }
        }
        catch (Exception e) {
            throw new ParseException(str, 0);
        }
    }

    @Override
    public String encodeBody() {
        Object s = String.valueOf(this.retryAfter);
        if (this.comment != null) {
            s = (String)s + " (" + this.comment + ")";
        }
        return (String)s + super.encodeBody();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.retryAfter == ((RetryAfterHeader)obj).retryAfter;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removeComment() {
        this.comment = null;
    }

    public void removeDuration() {
        super.removeParameter("duration");
    }

    public void setRetryAfter(int retryAfter) {
        this.retryAfter = new Integer(retryAfter);
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDuration(int duration) {
        super.setParameter("duration", String.valueOf(duration));
    }

    public int getDuration() {
        return super.getIntParameter("duration");
    }
}

