/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.Header;
import java.text.ParseException;

public class TimeStampHeader
extends Header {
    public static final String NAME = "Timestamp";
    protected float timeStamp;
    protected float delay;

    public TimeStampHeader() {
        this.setHeaderName(NAME);
        this.delay = -1.0f;
    }

    @Override
    protected int parse(String str, int offset) throws ParseException {
        int n = str.indexOf(32, offset);
        try {
            if (n != -1) {
                this.timeStamp = new Float(str.substring(offset, n)).floatValue();
                this.delay = new Float(str.substring(n + 1)).floatValue();
            } else {
                this.timeStamp = new Float(str.substring(offset)).floatValue();
                this.delay = -1.0f;
            }
        }
        catch (Exception e) {
            throw new ParseException(str, offset);
        }
        return str.length();
    }

    @Override
    public String encodeBody() {
        if (this.delay != -1.0f) {
            return new Float(this.timeStamp).toString() + " " + new Float(this.delay).toString();
        }
        return new Float(this.timeStamp).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TimeStampHeader)) {
            return false;
        }
        TimeStampHeader th = (TimeStampHeader)obj;
        return this.timeStamp == th.timeStamp && this.delay == th.delay;
    }

    public boolean hasDelay() {
        return this.delay != -1.0f;
    }

    public void removeDelay() {
        this.delay = -1.0f;
    }

    public void setTimeStamp(float timeStamp) {
        this.timeStamp = timeStamp;
    }

    public float getTimeStamp() {
        return this.timeStamp;
    }

    public float getDelay() {
        return this.delay;
    }

    public void setDelay(float delay) {
        this.delay = delay;
    }
}

