/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.ValueParametersHeader;
import java.text.ParseException;

public class ViaHeader
extends ValueParametersHeader {
    public static final String NAME = "Via";
    protected String protocolName;
    protected String protocolVersion;
    protected String transport;
    protected String host;
    protected int port = -1;

    public ViaHeader() {
        this.setHeaderName(NAME);
        this.protocolName = "SIP";
        this.protocolVersion = "2.0";
        this.transport = "UDP";
    }

    @Override
    protected void parseValue(String value) throws ParseException {
        int i = value.indexOf(32);
        if (i == -1) {
            throw new ParseException(value, 0);
        }
        String protocol = value.substring(0, i);
        int j = protocol.indexOf(47);
        if (j == -1) {
            throw new ParseException(value, 0);
        }
        this.protocolName = protocol.substring(0, j);
        if ((j = (protocol = protocol.substring(j + 1)).indexOf(47)) == -1) {
            throw new ParseException(value, 0);
        }
        this.protocolVersion = protocol.substring(0, j);
        this.transport = protocol.substring(j + 1);
        this.host = value.substring(i + 1);
        j = this.host.lastIndexOf(58);
        if (j != -1) {
            try {
                this.port = Integer.parseInt(this.host.substring(j + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.host = this.host.substring(0, j);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ViaHeader)) {
            return false;
        }
        ViaHeader v = (ViaHeader)obj;
        return this.host.equals(v.host) && this.port == v.port && this.transport.equals(v.transport) && this.protocolName.equals(v.protocolName) && this.protocolVersion.equals(v.protocolVersion) && super.equals(obj);
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getProtocol() {
        return this.protocolName;
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public void removePort() {
        this.port = -1;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setProtocol(String protocolName) {
        this.protocolName = protocolName;
    }

    @Override
    protected String encodeBody() {
        String retval = this.protocolName + "/" + this.protocolVersion + "/" + this.transport + " " + this.host;
        if (this.port != -1) {
            retval = retval + ":" + this.port;
        }
        return retval + super.encodeBody();
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getMaddr() {
        return this.getParameter("maddr");
    }

    public int getRport() {
        String value = this.getParameter("rport");
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean hasRport() {
        return this.hasParameter("rport");
    }

    public void setRport(int p) {
        this.setParameter("rport", String.valueOf(p));
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public int getTTL() {
        String value = this.getParameter("ttl");
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setTTL(int ttl) {
        this.setParameter("ttl", String.valueOf(ttl));
    }

    public String getMAddr() {
        return this.getParameter("maddr");
    }

    public void setMAddr(String mAddr) {
        this.setParameter("maddr", mAddr);
    }

    public String getReceived() {
        return this.getParameter("received");
    }

    public void setReceived(String received) {
        this.setParameter("received", received);
    }

    public String getBranch() {
        return this.getParameter("branch");
    }

    public void setBranch(String branch) {
        this.setParameter("branch", branch);
    }
}

