/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.ValueHeader;
import java.text.ParseException;

public class WarningHeader
extends ValueHeader {
    public static final String NAME = "Warning";
    public static final int INCOMPATIBLE_NETWORK_PROTOCOL = 300;
    public static final int INCOMPATIBLE_NETWORK_ADDRESS_FORMATS = 301;
    public static final int INCOMPATIBLE_TRANSPORT_PROTOCOL = 302;
    public static final int INCOMPATIBLE_BANDWIDTH_UNITS = 303;
    public static final int MEDIA_TYPE_NOT_AVAILABLE = 304;
    public static final int INCOMPATIBLE_MEDIA_FORMAT = 305;
    public static final int ATTRIBUTE_NOT_UNDERSTOOD = 306;
    public static final int SESSION_DESCRIPTION_PARAMETER_NOT_UNDERSTOOD = 307;
    public static final int MULTICAST_NOT_AVAILABLE = 330;
    public static final int UNICAST_NOT_AVAILABLE = 331;
    public static final int INSUFFICIENT_BANDWIDTH = 370;
    public static final int MISCELLANEOUS_WARNING = 399;
    protected int code;
    protected String agent;
    protected String text;

    public WarningHeader() {
        this.setHeaderName(NAME);
    }

    @Override
    protected void parseValue(String str) throws ParseException {
        int n = str.indexOf(32);
        try {
            this.code = Integer.parseInt(str.substring(0, n));
            int m = str.indexOf(32, n + 1);
            if (m != -1) {
                this.agent = str.substring(n + 1, m);
                this.text = str.substring(m + 1);
            } else {
                this.agent = str.substring(n + 1);
            }
        }
        catch (Exception e) {
            throw new ParseException(str, 0);
        }
    }

    @Override
    public String encodeBody() {
        String s = this.code + " " + this.agent;
        if (this.text != null) {
            s = s + " " + this.text;
        }
        return s;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WarningHeader)) {
            return false;
        }
        WarningHeader wh = (WarningHeader)obj;
        return this.code == wh.code && this.agent.equals(wh.agent) && this.text != null && this.text.equals(wh.text);
    }

    public int getCode() {
        return this.code;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getText() {
        return this.text;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setAgent(String host) {
        this.agent = host;
    }

    public void setText(String text) {
        this.text = "\"" + text + "\"";
    }
}

