/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.ContactHeader;
import com.smile.telephony.sip.header.ContentLengthHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.HeaderList;
import com.smile.telephony.sip.header.RecordRouteHeader;
import com.smile.telephony.sip.header.RouteHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.Transaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import smile.util.ResourceStore;

public class ClientTransaction
extends Transaction {
    private Request lastRequest;

    public ClientTransaction(SipStack stack, MessageChannel channel, Request request) {
        super(stack, channel, request);
        if (this.getMethod().equals("SUBSCRIBE")) {
            this.transactionKey = request.getSubsribeTransactionKey();
        }
    }

    @Override
    public void sendMessage(Message messageToSend) throws Exception {
        Request transactionRequest = (Request)messageToSend;
        ViaHeader topVia = (ViaHeader)transactionRequest.getViaHeaders().get(0);
        topVia.setBranch(this.getBranch());
        if ((2 == this.getState() || 0 == this.getState()) && transactionRequest.getMethod().equals("ACK")) {
            if (this.isReliable()) {
                this.setState(5);
            } else {
                this.setState(3);
            }
            super.sendMessage(transactionRequest);
            return;
        }
        try {
            this.lastRequest = transactionRequest;
            if (this.getState() == -1) {
                if (transactionRequest.getMethod().equals("INVITE")) {
                    this.setState(0);
                } else if (transactionRequest.getMethod().equals("ACK")) {
                    this.setState(5);
                } else {
                    this.setState(1);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                if (this.isInviteTransaction()) {
                    this.enableTimeoutTimer(64);
                } else {
                    this.enableTimeoutTimer(64);
                }
            }
            super.sendMessage(transactionRequest);
        }
        catch (IOException e) {
            this.setState(5);
            throw e;
        }
    }

    public void processResponse(Response transactionResponse, MessageChannel sourceChannel) {
        block47: {
            if (this.getState() == -1 || this.getState() == 5) {
                return;
            }
            int statusCode = transactionResponse.getStatusCode();
            if (this.getState() == 2 && statusCode == 100) {
                return;
            }
            if (this.getState() == 3 && statusCode < 200) {
                return;
            }
            this.lastResponse = transactionResponse;
            String method = transactionResponse.getCSeq().getMethod();
            if (this.dialog != null) {
                String tag = transactionResponse.getToTag();
                this.dialog.setRoutes(transactionResponse);
                if (statusCode != 100 && tag != null && !tag.equals(this.dialog.getRemoteTag())) {
                    if (this.sipStack.isDialogCreated(method) && this.dialog.getDialogId() == null && this.dialog.getState() != 3) {
                        this.dialog.setDialogId(transactionResponse.getDialogId(false));
                        this.sipStack.putDialog(this.dialog);
                    }
                    this.dialog.setRemoteTag(tag);
                }
                if (this.sipStack.isDialogCreated(method)) {
                    if (this.dialog.getState() == -1 && statusCode < 200) {
                        this.dialog.setState(0);
                    } else if (tag != null && 200 <= statusCode && statusCode < 300) {
                        this.dialog.setRemoteTag(tag);
                        this.dialog.setState(1);
                    } else if (statusCode >= 300 && statusCode <= 699 && (this.dialog.getState() == -1 || this.dialog.getMethod().equals(this.getMethod()) && this.dialog.getState() == 0)) {
                        this.dialog.setState(3);
                    }
                }
                if (this.getMethod().equals("BYE")) {
                    this.dialog.setState(3);
                }
            }
            try {
                if (this.isInviteTransaction()) {
                    if (0 == this.getState()) {
                        if (statusCode < 200) {
                            this.disableRetransmissionTimer();
                            this.disableTimeoutTimer();
                            this.processResponse(transactionResponse);
                            this.setState(2);
                            break block47;
                        }
                        if (200 <= statusCode && statusCode < 300) {
                            this.setState(5);
                            this.processResponse(transactionResponse);
                            this.disableRetransmissionTimer();
                            this.disableTimeoutTimer();
                            break block47;
                        }
                        if (300 > statusCode || statusCode > 699) break block47;
                        try {
                            this.sendAck();
                        }
                        catch (Exception tag) {
                            // empty catch block
                        }
                        this.processResponse(transactionResponse);
                        if (!this.isReliable()) {
                            this.setState(3);
                            this.enableTimeoutTimer(64);
                        } else {
                            this.setState(5);
                        }
                        break block47;
                    }
                    if (2 == this.getState()) {
                        if (statusCode < 200) {
                            this.processResponse(transactionResponse);
                            break block47;
                        }
                        if (200 <= statusCode && statusCode < 300) {
                            this.setState(5);
                            this.processResponse(transactionResponse);
                            break block47;
                        }
                        if (300 > statusCode || statusCode > 699) break block47;
                        try {
                            this.sendAck();
                        }
                        catch (Exception tag) {
                            // empty catch block
                        }
                        this.processResponse(transactionResponse);
                        if (!this.isReliable()) {
                            this.setState(3);
                            this.enableTimeoutTimer(64);
                        } else {
                            this.setState(5);
                        }
                        break block47;
                    }
                    if (3 == this.getState() && 300 <= statusCode && statusCode <= 699) {
                        try {
                            this.sendAck();
                        }
                        catch (Exception tag) {}
                    }
                    break block47;
                }
                if (1 == this.getState()) {
                    if (statusCode < 200) {
                        this.setState(2);
                        if (!this.isReliable()) {
                            this.enableRetransmissionTimer(8);
                        }
                        this.enableTimeoutTimer(64);
                        this.processResponse(transactionResponse);
                    } else if (200 <= statusCode && statusCode <= 699) {
                        this.processResponse(transactionResponse);
                        if (!this.isReliable()) {
                            this.setState(3);
                            this.enableTimeoutTimer(10);
                        } else {
                            this.setState(5);
                        }
                    }
                } else if (2 == this.getState()) {
                    if (statusCode < 200) {
                        this.processResponse(transactionResponse);
                    } else if (200 <= statusCode && statusCode <= 699) {
                        this.processResponse(transactionResponse);
                        this.disableRetransmissionTimer();
                        this.disableTimeoutTimer();
                        if (!this.isReliable()) {
                            this.setState(3);
                            this.enableTimeoutTimer(10);
                        } else {
                            this.setState(5);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ResourceStore.error(transactionResponse.toString(), ex);
                this.setState(5);
                this.processEvent(2);
            }
        }
    }

    private void processResponse(Response sipResponse) {
        this.sipStack.processResponse(this, sipResponse);
        if (3 == this.getState() && !this.getMethod().equals("INVITE")) {
            this.lastRequest = null;
            this.lastResponse = null;
        }
    }

    public void sendRequest() throws Exception {
        this.isMapped = true;
        this.sendMessage(this.getRequest());
    }

    public void sendAck() throws Exception {
        this.sendMessage(this.createAck());
    }

    public Request createCancel() throws Exception {
        Request newRequest = new Request();
        newRequest.setMethod("CANCEL");
        newRequest.setRequestURI((URI)this.request.getRequestURI().clone());
        Iterator headerIterator = this.request.getHeaders();
        while (headerIterator.hasNext()) {
            Header nextHeader = (Header)headerIterator.next();
            String hname = nextHeader.getName();
            if (hname.equals("Require") || hname.equals("Proxy-Require") || hname.equals("Content-Length") || hname.equals("Content-Type")) continue;
            if (hname.equals("Via")) {
                nextHeader = (Header)nextHeader.clone();
            }
            if (hname.equals("CSeq")) {
                nextHeader = (Header)nextHeader.clone();
                ((CSeqHeader)nextHeader).setMethod("CANCEL");
            }
            newRequest.addHeader(nextHeader);
        }
        return newRequest;
    }

    public Request createAck() throws Exception {
        RouteHeader route;
        Request newRequest = new Request();
        newRequest.setMethod("ACK");
        newRequest.setRequestURI((URI)this.request.getRequestURI().clone());
        Iterator headerIterator = this.request.getHeaders();
        while (headerIterator.hasNext()) {
            Header nextHeader = (Header)headerIterator.next();
            String hname = nextHeader.getName();
            if (hname.equals("Route") || hname.equals("Proxy-Authorization")) continue;
            if (hname.equals("Content-Length")) {
                nextHeader = (Header)nextHeader.clone();
                ((ContentLengthHeader)nextHeader).setContentLength(0);
            } else {
                if (hname.equals("Content-Type")) continue;
                if (hname.equals("CSeq")) {
                    CSeqHeader cseq = (CSeqHeader)nextHeader.clone();
                    cseq.setMethod("ACK");
                    nextHeader = cseq;
                } else if (hname.equals("To")) {
                    nextHeader = this.lastResponse.getTo() != null ? this.lastResponse.getTo() : (Header)nextHeader.clone();
                } else {
                    if (hname.equals("Contact")) continue;
                    nextHeader = hname.equals("Via") ? (Header)((HeaderList)nextHeader).getFirst().clone() : (Header)nextHeader.clone();
                }
            }
            newRequest.addHeader(nextHeader);
        }
        HeaderList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            if (this.lastResponse.getContactHeaders() != null) {
                ContactHeader contact = (ContactHeader)this.lastResponse.getContactHeaders().getFirst();
                URI uri = (URI)contact.getAddress().getURI().clone();
                newRequest.setRequestURI(uri);
            }
            return newRequest;
        }
        newRequest.removeHeader("Route");
        HeaderList routeList = new HeaderList("Route");
        ListIterator li = recordRouteList.listIterator(recordRouteList.size());
        while (li.hasPrevious()) {
            RecordRouteHeader rr = (RecordRouteHeader)li.previous();
            route = new RouteHeader();
            route.setAddress((Address)rr.getAddress().clone());
            route.setParameters((HashMap)rr.getParameters().clone());
            routeList.add(route);
        }
        ContactHeader contact = null;
        if (this.lastResponse.getContactHeaders() != null) {
            contact = (ContactHeader)this.lastResponse.getContactHeaders().getFirst();
        }
        if (!((SipURI)((RouteHeader)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            route = null;
            if (contact != null) {
                route = new RouteHeader();
                route.setAddress((Address)contact.getAddress().clone());
            }
            RouteHeader firstRoute = (RouteHeader)routeList.getFirst();
            routeList.removeFirst();
            URI uri = firstRoute.getAddress().getURI();
            newRequest.setRequestURI(uri);
            if (route != null) {
                routeList.add(route);
            }
            newRequest.addHeader(routeList);
        } else if (contact != null) {
            URI uri = (URI)contact.getAddress().getURI().clone();
            newRequest.setRequestURI(uri);
            newRequest.addHeader(routeList);
        }
        return newRequest;
    }

    @Override
    protected void fireRetransmissionTimer() {
        try {
            if (this.getState() == -1 || !this.isMapped) {
                return;
            }
            if ((0 == this.getState() || 1 == this.getState()) && this.lastRequest != null) {
                super.sendMessage(this.lastRequest);
            }
        }
        catch (Exception e) {
            this.setState(5);
            this.processEvent(2);
        }
    }

    @Override
    protected void fireTimeoutTimer() {
        if ((0 == this.getState() || 1 == this.getState() || 2 == this.getState()) && this.dialog != null && (this.sipStack.isDialogCreated(this.getMethod()) || this.getMethod().equalsIgnoreCase("BYE"))) {
            this.dialog.setState(3);
        }
        if (3 != this.getState()) {
            this.processEvent(1);
        } else {
            this.setState(5);
        }
    }
}

