/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.header.RetryAfterHeader;
import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.ClientTransaction;
import com.smile.telephony.sip.stack.Dialog;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.Transaction;
import java.io.IOException;

public class ServerTransaction
extends Transaction {
    protected boolean toListener;

    public ServerTransaction(SipStack stack, MessageChannel channel, Request request) {
        super(stack, channel, request);
        if (request.getMethod().equals("ACK")) {
            this.setState(5);
        }
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        ServerTransaction sst = (ServerTransaction)other;
        return this.getBranch().equalsIgnoreCase(sst.getBranch());
    }

    private int getRealState() {
        return super.getState();
    }

    @Override
    public int getState() {
        if (this.isInviteTransaction() && 1 == super.getState()) {
            return 2;
        }
        return super.getState();
    }

    public void map() {
        if (this.getRealState() == -1 || this.getRealState() == 1) {
            this.isMapped = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(Request sipRequest, Dialog dialog) {
        try {
            boolean passThis;
            String method;
            block63: {
                block64: {
                    block61: {
                        block62: {
                            Response sipResponse;
                            Transaction lastTransaction2;
                            block59: {
                                block60: {
                                    block58: {
                                        method = sipRequest.getMethod().toUpperCase();
                                        if (this.getRealState() == -1) {
                                            this.setState(1);
                                            if (this.isInviteTransaction() && this.isMapped) {
                                                this.sendMessage(sipRequest.createResponse(100, "Trying"));
                                            }
                                        } else {
                                            if (this.isInviteTransaction() && 3 == this.getRealState() && method.equals("ACK")) {
                                                this.setState(4);
                                                this.disableRetransmissionTimer();
                                                if (this.isReliable()) {
                                                    this.setState(5);
                                                    return;
                                                }
                                                if (this.lastResponse != null && this.lastResponse.getStatusCode() == 487) {
                                                    this.setState(5);
                                                    return;
                                                }
                                                this.enableTimeoutTimer(10);
                                                return;
                                            }
                                            if (method.equals(this.getMethod())) {
                                                if (2 == this.getRealState() || 3 == this.getRealState()) {
                                                    if (this.lastResponse == null) return;
                                                    try {
                                                        super.sendMessage(this.lastResponse);
                                                        return;
                                                    }
                                                    catch (Exception e) {
                                                        this.setState(5);
                                                    }
                                                    return;
                                                }
                                                if (!method.equals("ACK")) {
                                                    return;
                                                }
                                            } else if (3 == this.getRealState() || 5 == this.getRealState()) {
                                                if (method.equals("ACK")) {
                                                    if (dialog == null) return;
                                                    if (dialog.ackProcessed) return;
                                                    if (this.getRealState() == 3) {
                                                        return;
                                                    }
                                                    dialog.ackProcessed = true;
                                                } else {
                                                    if (!method.equals("CANCEL")) return;
                                                    try {
                                                        this.sendMessage(sipRequest.createResponse(200));
                                                        return;
                                                    }
                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                    return;
                                                }
                                            }
                                        }
                                        passThis = true;
                                        if (!method.equals("ACK")) break block58;
                                        if (dialog == null) return;
                                        if (dialog.isAckSeen() && dialog.getRemoteSequenceNumber() == sipRequest.getCSeq().getSequenceNumber()) {
                                            return;
                                        }
                                        lastTransaction2 = dialog.getInviteTransaction();
                                        if (lastTransaction2 == null) {
                                            return;
                                        }
                                        sipResponse = lastTransaction2.getLastResponse();
                                        if (sipResponse == null) return;
                                        if (sipResponse.getStatusCode() != 200) return;
                                        if (!sipResponse.getCSeq().getMethod().equals("INVITE")) return;
                                        if (sipResponse.getCSeq().getSequenceNumber() != sipRequest.getCSeq().getSequenceNumber()) {
                                            return;
                                        }
                                        this.setDialog(dialog);
                                        dialog.ackReceived(sipRequest);
                                        break block59;
                                    }
                                    if (!method.equals("BYE")) break block60;
                                    if (this.isMapped) {
                                        if (dialog != null) {
                                            if (!dialog.isRequestConsumable(sipRequest)) {
                                                this.setState(5);
                                                this.sipStack.removeTransaction(this);
                                                return;
                                            }
                                            dialog.addTransaction(this);
                                        }
                                        break block59;
                                    } else {
                                        if (dialog != null) {
                                            return;
                                        }
                                        passThis = false;
                                    }
                                    break block59;
                                }
                                if (method.equals("CANCEL")) {
                                    if (this.isInviteTransaction()) {
                                        if (this.getState() == 5) {
                                            try {
                                                this.sendMessage(sipRequest.createResponse(200));
                                                return;
                                            }
                                            catch (IOException lastTransaction2) {
                                                // empty catch block
                                            }
                                            return;
                                        }
                                    } else {
                                        passThis = false;
                                    }
                                }
                            }
                            if (dialog == null) break block61;
                            if (!method.equals("INVITE")) break block62;
                            lastTransaction2 = dialog.getInviteTransaction();
                            if (lastTransaction2 != null && lastTransaction2 instanceof ServerTransaction && lastTransaction2.isInviteTransaction() && sipRequest.getCSeq().getSequenceNumber() > dialog.getRemoteSequenceNumber() && lastTransaction2.getState() != 3 && lastTransaction2.getState() != 5 && lastTransaction2.getState() != 4) {
                                sipResponse = sipRequest.createResponse(500);
                                RetryAfterHeader retryAfter = new RetryAfterHeader();
                                try {
                                    retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                                    sipResponse.addHeader(retryAfter);
                                    this.sendMessage(sipResponse);
                                    return;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return;
                            }
                            lastTransaction2 = dialog.getLastTransaction();
                            if (lastTransaction2 != null && lastTransaction2.isInviteTransaction() && lastTransaction2 instanceof ClientTransaction && lastTransaction2.getState() != 3 && lastTransaction2.getState() != 5) {
                                if (dialog.getRemoteSequenceNumber() + 1 != sipRequest.getCSeq().getSequenceNumber()) return;
                                dialog.setRemoteSequenceNumber(sipRequest.getCSeq().getSequenceNumber());
                                sipResponse = sipRequest.createResponse(491);
                                try {
                                    this.sendMessage(sipResponse);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                dialog.requestConsumed();
                                return;
                            }
                            this.setDialog(dialog);
                            break block63;
                        }
                        if (!(method.equals("BYE") || method.equals("CANCEL") || method.equals("ACK"))) {
                            if (dialog.getRemoteSequenceNumber() >= sipRequest.getCSeq().getSequenceNumber()) {
                                if (dialog.getRemoteSequenceNumber() <= sipRequest.getCSeq().getSequenceNumber()) return;
                                Response sipResponse = sipRequest.createResponse(500);
                                try {
                                    this.sendMessage(sipResponse);
                                    return;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return;
                            }
                            if (dialog.isRequestConsumable(sipRequest)) {
                                dialog.addTransaction(this);
                                dialog.setRoutes(sipRequest);
                            }
                            break block63;
                        } else if (!this.isMapped) {
                            passThis = false;
                        }
                        break block63;
                    }
                    if (!method.equals("NOTIFY")) break block64;
                    ClientTransaction ct = this.sipStack.findSubscribeTransaction(sipRequest);
                    if (ct != null) {
                        this.setDialog(ct.getDialog());
                        if (ct.getDialog().getState() == -1) {
                            passThis = false;
                        }
                        break block63;
                    } else {
                        passThis = false;
                    }
                    break block63;
                }
                if (!method.equals("OPTIONS") && !this.isMapped) {
                    passThis = false;
                }
            }
            if (!passThis) {
                this.sipStack.addTransaction(this);
                if (this.sipStack.isDialogCreated(method)) {
                    if (dialog == null) {
                        dialog = this.sipStack.createDialog(this);
                    } else {
                        this.setDialog(dialog);
                        if (dialog.getRemoteTag() != null && dialog.getLocalTag() != null) {
                            this.sipStack.putDialog(dialog);
                        }
                    }
                    dialog.setStack(this.sipStack);
                    dialog.setRoutes(sipRequest);
                } else if (dialog != null) {
                    dialog.addTransaction(this);
                    dialog.setRoutes(sipRequest);
                }
            }
            this.sipStack.processRequest(this, sipRequest);
            if (!passThis) return;
            if (dialog == null) return;
            dialog.requestConsumed();
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void sendMessage(Message messageToSend) throws Exception {
        Response transactionResponse = (Response)messageToSend;
        int statusCode = transactionResponse.getStatusCode();
        String method = transactionResponse.getCSeq().getMethod();
        if (this.getRequest().getTopmostVia().getBranch() != null) {
            transactionResponse.getTopmostVia().setBranch(this.getBranch());
        } else {
            transactionResponse.getTopmostVia().removeParameter("branch");
        }
        if (!this.getRequest().getTopmostVia().hasPort()) {
            transactionResponse.getTopmostVia().removePort();
        }
        if (!method.equals(this.getMethod())) {
            this.sendTransactionResponse(transactionResponse);
            return;
        }
        if (this.dialog != null) {
            if (this.dialog.getRemoteTag() == null && transactionResponse.getTo().getTag() != null && this.sipStack.isDialogCreated(method)) {
                this.dialog.setRemoteTag(transactionResponse.getTo().getTag());
                this.sipStack.putDialog(this.dialog);
                if (statusCode < 200) {
                    this.dialog.setState(0);
                }
            }
            if (this.sipStack.isDialogCreated(method) && method.equals(this.getMethod())) {
                if (200 <= statusCode && statusCode < 300) {
                    if (!this.isInviteTransaction()) {
                        this.dialog.setState(1);
                    } else if (this.dialog.getState() == -1) {
                        this.dialog.setState(0);
                    }
                } else if (statusCode >= 300 && statusCode <= 699 && (this.dialog.getState() == -1 || this.dialog.getState() == 0)) {
                    this.dialog.setState(3);
                }
            } else if (method.equals("BYE") && 200 <= statusCode && statusCode < 300) {
                if (!this.isReliable()) {
                    this.dialog.setState(2);
                } else {
                    this.dialog.setState(3);
                }
            }
        }
        if (this.getRealState() == 1) {
            if (statusCode < 200) {
                this.setState(2);
            } else {
                if (this.isInviteTransaction() && statusCode < 300) {
                    this.setState(5);
                } else {
                    this.setState(3);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                this.enableTimeoutTimer(64);
            }
        } else if (this.getRealState() == 2) {
            if (this.isInviteTransaction()) {
                if (200 <= statusCode && statusCode < 300) {
                    if (!method.equals("CANCEL")) {
                        this.setState(5);
                        if (!this.isReliable()) {
                            if (this.dialog != null) {
                                this.dialog.setRetransmissionTicks();
                            } else {
                                this.enableRetransmissionTimer();
                            }
                        }
                        this.enableTimeoutTimer(64);
                    } else {
                        this.disableRetransmissionTimer();
                    }
                } else if (300 <= statusCode && statusCode <= 699) {
                    this.setState(3);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(3);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(5);
                }
            }
        } else if (this.getRealState() == 3) {
            return;
        }
        try {
            this.lastResponse = transactionResponse;
            this.sendTransactionResponse(transactionResponse);
        }
        catch (IOException e) {
            this.setState(5);
            throw e;
        }
    }

    private void sendTransactionResponse(Response response) throws Exception {
        this.getMessageChannel().sendMessage(response);
    }

    public void sendResponse(Response response) throws Exception {
        String fromTag;
        Response responseImpl = response;
        int statusCode = responseImpl.getStatusCode();
        String method = responseImpl.getCSeq().getMethod();
        if (this.dialog != null && this.dialog.getLocalTag() != null) {
            responseImpl.getTo().setTag(this.dialog.getLocalTag());
        }
        if ((fromTag = this.getRequest().getFrom().getTag()) != null) {
            responseImpl.getFrom().setTag(fromTag);
        }
        this.sendMessage(responseImpl);
        if (this.dialog != null) {
            if (method.equals("BYE") && statusCode == 200) {
                this.dialog.setState(3);
            } else if (method.equalsIgnoreCase("CANCEL")) {
                if (this.dialog.getState() == -1 || this.dialog.getState() == 0) {
                    this.dialog.setState(3);
                }
            } else if (this.dialog.getLocalTag() == null && responseImpl.getTo().getTag() != null) {
                if (statusCode != 100) {
                    this.dialog.setLocalTag(responseImpl.getTo().getTag());
                }
                if (this.sipStack.isDialogCreated(method)) {
                    if (statusCode / 100 == 1) {
                        this.dialog.setState(0);
                        if (statusCode != 100) {
                            this.sipStack.putDialog(this.dialog);
                        }
                    } else if (statusCode / 100 <= 2) {
                        this.sipStack.putDialog(this.dialog);
                    } else {
                        this.dialog.setState(3);
                    }
                    if (statusCode / 100 == 2) {
                        if (method.equals("INVITE")) {
                            if (this.dialog.getState() == -1) {
                                this.dialog.setState(0);
                            }
                            this.dialog.startTimer(this);
                        } else {
                            this.dialog.setState(1);
                        }
                    }
                }
            } else if (statusCode / 100 == 2 && this.sipStack.isDialogCreated(method)) {
                if (!method.equals("INVITE")) {
                    this.dialog.setState(1);
                } else {
                    if (this.dialog.getState() == -1) {
                        this.dialog.setState(0);
                    }
                    this.dialog.startTimer(this);
                }
                this.sipStack.putDialog(this.dialog);
            }
        }
    }

    @Override
    protected void fireRetransmissionTimer() {
        try {
            if (this.isInviteTransaction()) {
                super.sendMessage(this.lastResponse);
            }
        }
        catch (Exception e) {
            this.processEvent(2);
        }
    }

    @Override
    protected void fireTimeoutTimer() {
        if (this.sipStack.isDialogCreated(this.getMethod()) && (0 == this.getRealState() || 1 == this.getRealState())) {
            this.dialog.setState(3);
        } else if (this.getMethod().equals("BYE") && this.dialog != null) {
            this.dialog.setState(3);
        }
        if (3 == this.getRealState() && this.isInviteTransaction()) {
            this.processEvent(1);
            this.setState(5);
        } else if (4 == this.getRealState() && this.isInviteTransaction()) {
            this.setState(5);
        } else if (!(this.isInviteTransaction() || 3 != this.getRealState() && 4 != this.getRealState())) {
            this.setState(5);
        } else if (this.isInviteTransaction() && 5 == this.getRealState()) {
            this.processEvent(1);
            if (this.dialog != null) {
                this.dialog.setState(3);
            }
        }
    }
}

