/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.SipCall;
import com.smile.telephony.sip.SipEndpoint;
import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.EventHeader;
import com.smile.telephony.sip.header.HeaderList;
import com.smile.telephony.sip.header.RouteHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.ClientTransaction;
import com.smile.telephony.sip.stack.Dialog;
import com.smile.telephony.sip.stack.Hop;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.MessageProcessor;
import com.smile.telephony.sip.stack.RequestEvent;
import com.smile.telephony.sip.stack.ResponseEvent;
import com.smile.telephony.sip.stack.ServerTransaction;
import com.smile.telephony.sip.stack.TCPMessageProcessor;
import com.smile.telephony.sip.stack.TLSMessageProcessor;
import com.smile.telephony.sip.stack.Transaction;
import com.smile.telephony.sip.stack.TransactionTimer;
import com.smile.telephony.sip.stack.UDPMessageProcessor;
import com.smile.telephony.sip.stack.WSMessageProcessor;
import com.smile.telephony.sip.stack.WSSMessageProcessor;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import smile.util.ResourceStore;

public class SipStack {
    public static final int BASE_TIMER_INTERVAL = 500;
    public static final int CONNECTION_LINGER_TIME = 16;
    static Random random = new Random(System.currentTimeMillis());
    protected Timer timer;
    private int maxMessageSize = 10000000;
    private int backlog = 50;
    private boolean toExit;
    private String logname;
    private int port;
    private String proxy;
    private String transport;
    private String stackAddress;
    private InetAddress stackInetAddress;
    private SipEndpoint sipEndpoint;
    private MessageProcessor messageProcessor;
    private ConcurrentHashMap dialogTable;
    private ConcurrentHashMap clientTransactionTable;
    private ConcurrentHashMap serverTransactionTable;

    public static String generateBranchId() {
        return "z9hG4bK" + Long.toHexString(System.currentTimeMillis()) + Long.toHexString(random.nextLong());
    }

    public SipStack(SipEndpoint endpoint, String address, int port, String transport) throws Exception {
        this.sipEndpoint = endpoint;
        this.stackAddress = address.indexOf(58) != -1 && address.trim().charAt(0) != '[' ? "[" + address + "]" : address;
        this.stackInetAddress = InetAddress.getByName(this.stackAddress);
        String errMsg = "";
        int i = 10;
        for (int n = port; n < port + i; ++n) {
            try {
                this.messageProcessor = this.createMessageProcessor(n, transport);
                break;
            }
            catch (Exception e) {
                errMsg = e.getMessage();
                continue;
            }
        }
        if (this.messageProcessor == null) {
            throw new Exception("Could not create sip stack - " + errMsg);
        }
        this.logname = "sip-" + port + ".log";
        this.timer = new Timer();
        this.dialogTable = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
    }

    public String getTlsSertificate() {
        return this.sipEndpoint.getCertAlias();
    }

    public int getTcpSocketTimeout() {
        return this.sipEndpoint.getTCPSocketTimeout();
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public String getOutboundProxy() {
        return this.sipEndpoint.getOutboundProxy();
    }

    public boolean channelLog() {
        return true;
    }

    public void log(String message) {
        ResourceStore.toLog(this.logname, message);
    }

    public boolean isClient() {
        return this.sipEndpoint.isClient();
    }

    public void onConnectionLost(String addr) {
        this.sipEndpoint.onConnectionLost(addr);
    }

    public void dispose() {
        this.timer.cancel();
        this.toExit = true;
        this.messageProcessor.dispose();
    }

    public void closeChannels() {
        this.messageProcessor.dispose();
    }

    private MessageProcessor createMessageProcessor(int port, String transport) throws Exception {
        MessageProcessor messageProcessor;
        if (transport.equalsIgnoreCase("TCP")) {
            messageProcessor = new TCPMessageProcessor(this, port);
        } else if (transport.equalsIgnoreCase("TLS")) {
            messageProcessor = new TLSMessageProcessor(this, port);
        } else if (transport.equalsIgnoreCase("WS")) {
            WSMessageProcessor ws = new WSMessageProcessor(this, port);
            messageProcessor = ws;
        } else if (transport.equalsIgnoreCase("WSS")) {
            WSSMessageProcessor ws = new WSSMessageProcessor(this, port);
            messageProcessor = ws;
        } else {
            messageProcessor = new UDPMessageProcessor(this, port);
        }
        this.port = port;
        this.transport = transport;
        return messageProcessor;
    }

    public String getIPAddress() {
        return this.stackAddress;
    }

    public InetAddress getInetAddress() {
        return this.stackInetAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public ViaHeader createViaHeader() {
        ViaHeader via = new ViaHeader();
        via.setHost(this.stackAddress);
        via.setPort(this.port);
        via.setTransport(this.transport);
        via.setBranch(SipStack.generateBranchId());
        return via;
    }

    public RouteHeader createRouteHeader(Hop hop) {
        SipURI uri = new SipURI();
        uri.setScheme("sip");
        uri.setHost(hop.getHost());
        uri.setPort(hop.getPort());
        uri.setTransportParam(hop.getTransport());
        Address address = new Address();
        address.setURI(uri);
        RouteHeader route = new RouteHeader();
        route.setAddress(address);
        return route;
    }

    public boolean isAlive() {
        return !this.toExit;
    }

    public void finalize() {
        this.dispose();
    }

    public boolean isDialogCreated(String method) {
        return method.equals("INVITE") || method.equals("REFER") || method.equals("SUBSCRIBE");
    }

    public void putDialog(Dialog dialog) {
        if (this.dialogTable.putIfAbsent(dialog.getDialogId(), dialog) == null) {
            dialog.setStack(this);
        }
    }

    public Dialog createDialog(Transaction transaction) {
        Dialog dialog = new Dialog(transaction);
        return dialog;
    }

    public Iterator getDialogs() {
        return this.dialogTable.values().iterator();
    }

    public void removeDialog(Dialog dialog) {
        String id = dialog.getDialogId();
        if (id != null) {
            this.dialogTable.remove(id);
        }
    }

    public Dialog getDialog(String dialogId) {
        return (Dialog)this.dialogTable.get(dialogId);
    }

    public ClientTransaction findSubscribeTransaction(Request notifyMessage) {
        String thisToTag = notifyMessage.getTo().getTag();
        if (thisToTag == null) {
            return null;
        }
        EventHeader eventHdr = (EventHeader)notifyMessage.getHeader("Event");
        if (eventHdr == null) {
            return null;
        }
        String key = notifyMessage.getCallId() + ":" + thisToTag + ":" + eventHdr.toString();
        return (ClientTransaction)this.clientTransactionTable.get(key);
    }

    public Transaction findInviteTransaction(Message sipMessage, boolean isServer) {
        String key = "invite" + sipMessage.getCSeq().getSequenceNumber() + ";" + sipMessage.getTransactionId();
        if (isServer) {
            return (Transaction)this.serverTransactionTable.get(key);
        }
        return (Transaction)this.clientTransactionTable.get(key);
    }

    public Transaction findTransaction(Message sipMessage, boolean isServer) {
        String key = sipMessage.getTransactionKey();
        if (isServer) {
            return (Transaction)this.serverTransactionTable.get(key);
        }
        return (Transaction)this.clientTransactionTable.get(key);
    }

    public void processMessage(Message sipMessage, MessageChannel messageChannel) {
        if (sipMessage instanceof Request) {
            this.processRequest((Request)sipMessage, messageChannel);
        } else {
            this.processResponse((Response)sipMessage, messageChannel);
        }
    }

    public void processRequest(Request requestReceived, MessageChannel requestMessageChannel) {
        String method = requestReceived.getMethod();
        Dialog dialog = this.getDialog(requestReceived.getDialogId(true));
        ServerTransaction transaction = (ServerTransaction)this.findTransaction(requestReceived, true);
        if (transaction != null && (this.isDialogCreated(method) ? !transaction.toListener : dialog == null && method.equals("ACK"))) {
            return;
        }
        if (transaction == null && (method.equals("CANCEL") || method.equals("ACK"))) {
            transaction = (ServerTransaction)this.findInviteTransaction(requestReceived, true);
        }
        if (transaction == null) {
            transaction = this.createServerTransaction(requestMessageChannel, requestReceived);
            if (dialog != null && dialog.getState() != 3 && (method.equals("ACK") || requestReceived.getCSeq().getSequenceNumber() > dialog.getRemoteSequenceNumber())) {
                if (this.isDialogCreated(method)) {
                    transaction.map();
                    transaction.toListener = true;
                } else {
                    transaction.isMapped = true;
                }
                transaction.startTransactionTimer();
                this.serverTransactionTable.put(transaction.getTransactionKey(), transaction);
            }
        }
        transaction.processRequest(requestReceived, dialog);
    }

    public void processResponse(Response responseReceived, MessageChannel responseMessageChannel) {
        ClientTransaction transaction = (ClientTransaction)this.findTransaction(responseReceived, false);
        if (transaction != null) {
            transaction.processResponse(responseReceived, responseMessageChannel);
        } else {
            SipCall call;
            String dialogId = responseReceived.getDialogId(false);
            Dialog dialog = this.getDialog(dialogId);
            if (dialog != null) {
                if (dialog.getLastTransaction() instanceof ClientTransaction) {
                    transaction = (ClientTransaction)dialog.getLastTransaction();
                } else if (dialog.getFirstTransaction() instanceof ClientTransaction) {
                    transaction = (ClientTransaction)dialog.getFirstTransaction();
                }
                if (transaction != null) {
                    transaction.processResponse(responseReceived, responseMessageChannel);
                    return;
                }
            }
            if (responseReceived.getCSeq().getMethod().equals("INVITE") && (call = this.sipEndpoint.getCall(responseReceived.getCallId())) != null && call.getTransaction() instanceof ClientTransaction) {
                ((ClientTransaction)call.getTransaction()).processResponse(responseReceived, responseMessageChannel);
                return;
            }
            this.processResponse(transaction, responseReceived);
        }
    }

    public void processRequest(ServerTransaction transaction, Request request) {
        RequestEvent sipEvent = new RequestEvent(this, transaction, request);
        this.sipEndpoint.processRequest(sipEvent);
    }

    public void processResponse(ClientTransaction transaction, Response response) {
        ResponseEvent sipEvent = new ResponseEvent(this, transaction, response);
        try {
            this.sipEndpoint.processResponse(sipEvent);
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processTimeout(Transaction transaction) {
        this.sipEndpoint.processTimeout(transaction);
    }

    public MessageChannel getMessageChannel(Hop nextHop) throws Exception {
        return this.getMessageChannel(nextHop, true);
    }

    public MessageChannel getMessageChannel(Hop hop, boolean reopen) throws Exception {
        return this.messageProcessor.getMessageChannel(hop, reopen);
    }

    public ClientTransaction createClientTransaction(Hop hop, Request request, boolean reopen) throws Exception {
        MessageChannel mc = this.getMessageChannel(hop, reopen);
        if (mc == null) {
            return null;
        }
        return this.createClientTransaction(mc, request);
    }

    public ClientTransaction createClientTransaction(MessageChannel encapsulatedChannel, Request request) {
        return new ClientTransaction(this, encapsulatedChannel, request);
    }

    public ServerTransaction createServerTransaction(MessageChannel encapsulatedChannel, Request request) {
        return new ServerTransaction(this, encapsulatedChannel, request);
    }

    public void addTransaction(ClientTransaction transaction) {
        transaction.startTransactionTimer();
        this.clientTransactionTable.put(transaction.getTransactionKey(), transaction);
    }

    public void addTransaction(ServerTransaction transaction) {
        transaction.map();
        transaction.startTransactionTimer();
        this.serverTransactionTable.put(transaction.getTransactionKey(), transaction);
    }

    public void removeTransaction(Transaction sipTransaction) {
        String key = sipTransaction.getTransactionKey();
        if (sipTransaction instanceof ServerTransaction) {
            this.serverTransactionTable.remove(key);
        } else {
            this.clientTransactionTable.remove(key);
        }
    }

    public void startTransactionTimer(Transaction sipTransaction) {
        this.timer.schedule((TimerTask)new TransactionTimer(sipTransaction, this), 500L, 500L);
    }

    public ClientTransaction getNewClientTransaction(Request request) throws Exception {
        return this.getNewClientTransaction(request, true);
    }

    public ClientTransaction getNewClientTransaction(Request request, boolean reopen) throws Exception {
        ClientTransaction ct;
        if (request.getMethod().equalsIgnoreCase("CANCEL") && (ct = (ClientTransaction)this.findInviteTransaction(request, false)) != null) {
            Dialog dialog;
            ct.setState(5);
            if (ct.getState() == 0 && ct.isReliable() && reopen) {
                this.closeMessageChannel(request);
            }
            if ((dialog = ct.getDialog()) != null) {
                dialog.setState(3);
            }
            if (!ct.isReliable()) {
                ct.enableTimeoutTimer(64);
            }
            ClientTransaction transaction = this.createClientTransaction(ct.getMessageChannel(), request);
            transaction.setDialog(dialog);
            this.addTransaction(transaction);
            return transaction;
        }
        String dialogId = request.getDialogId(false);
        Dialog dialog = this.getDialog(dialogId);
        Hop hop = this.getNextHop(request);
        if (hop == null) {
            if (dialog != null && (hop = dialog.getNextHop()) != null) {
                if (request.getTopmostVia() == null) {
                    request.addHeader(this.createViaHeader());
                }
                ClientTransaction transaction = this.createClientTransaction(hop, request, reopen);
                transaction.setDialog(dialog);
                this.addTransaction(transaction);
                return transaction;
            }
        } else {
            ClientTransaction transaction;
            if (request.getTopmostVia() == null) {
                request.addHeader(this.createViaHeader());
            }
            if ((transaction = this.createClientTransaction(hop, request, reopen)) != null) {
                this.addTransaction(transaction);
                if (this.isDialogCreated(request.getMethod())) {
                    if (dialog != null) {
                        transaction.setDialog(dialog);
                    } else {
                        this.createDialog(transaction);
                    }
                } else {
                    transaction.setDialog(dialog);
                }
                return transaction;
            }
        }
        if (dialog != null) {
            dialog.setState(3);
        }
        throw new IllegalStateException("Could not resolve server name or route not available: " + hop);
    }

    public void closeMessageChannel(Request request) throws Exception {
        this.closeMessageChannel(this.getNextHop(request));
    }

    public void closeMessageChannel(Hop hop) throws Exception {
        MessageChannel mc;
        if (hop != null && (mc = this.getMessageChannel(hop, false)) != null) {
            mc.close();
        }
    }

    protected Hop getNextHop(Request request) {
        URI requestURI = request.getRequestURI();
        HeaderList routes = request.getRouteHeaders();
        if (routes != null) {
            RouteHeader route = (RouteHeader)routes.getFirst();
            SipURI uri = (SipURI)route.getAddress().getURI();
            String transport = uri.getTransportParam();
            if (transport == null) {
                transport = "UDP";
            }
            int port = uri.hasPort() ? uri.getPort() : SipEndpoint.getDefaultPort(transport);
            String host = uri.getHost();
            Hop hop = new Hop(host, port, transport);
            return hop;
        }
        if (requestURI instanceof SipURI && ((SipURI)requestURI).getMAddrParam() != null) {
            String maddr = ((SipURI)requestURI).getMAddrParam();
            String transport = ((SipURI)requestURI).getTransportParam();
            if (transport == null) {
                transport = "UDP";
            }
            int port = 5060;
            Hop hop = new Hop(maddr, port, transport);
            hop.setURIRouteFlag();
            return hop;
        }
        if (requestURI instanceof SipURI) {
            String transport = ((SipURI)requestURI).getTransportParam();
            if (transport == null) {
                transport = "UDP";
            }
            String host = ((SipURI)requestURI).getHost();
            int port = ((SipURI)requestURI).getPort();
            if (port == -1) {
                port = SipEndpoint.getDefaultPort(transport);
            }
            if (host.equals(this.stackAddress) && port == this.port) {
                return null;
            }
            Hop hop = new Hop(host, port, transport);
            return hop;
        }
        return null;
    }
}

