/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.stack.TCPMessageChannel;
import java.util.Vector;

public class TCPMessageSender
implements Runnable {
    private boolean running;
    private boolean hasWrite;
    private Vector messages = new Vector();
    private TCPMessageChannel channel;

    public TCPMessageSender(TCPMessageChannel channel) {
        this.channel = channel;
        this.running = true;
    }

    public synchronized void add(Message message) {
        this.messages.add(message);
        if (!this.hasWrite) {
            this.hasWrite = true;
            new Thread(this).start();
        }
    }

    public synchronized Message get() {
        if (this.messages.isEmpty()) {
            this.hasWrite = false;
            return null;
        }
        return (Message)this.messages.remove(0);
    }

    @Override
    public void run() {
        Message message;
        while (this.running && (message = this.get()) != null) {
            try {
                this.channel.send(message);
            }
            catch (Exception e) {}
        }
    }

    public void cancel() {
        this.running = false;
    }
}

