/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.header.WarningHeader;
import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;

public class UDPMessageChannel
implements MessageChannel,
Runnable {
    private UDPMessageProcessor messageProcessor;
    private SipStack stack;
    private InetAddress peerAddress;
    private int peerPort;
    private DatagramPacket packet;

    protected UDPMessageChannel(DatagramPacket packet, UDPMessageProcessor messageProcessor, SipStack stack) {
        this.messageProcessor = messageProcessor;
        this.stack = stack;
        this.packet = packet;
        this.peerAddress = packet.getAddress();
        this.peerPort = packet.getPort();
        new Thread(this).start();
    }

    protected UDPMessageChannel(InetAddress inetAddr, int port, UDPMessageProcessor messageProcessor, SipStack stack) {
        this.messageProcessor = messageProcessor;
        this.stack = stack;
        this.peerAddress = inetAddr;
        this.peerPort = port;
    }

    @Override
    public void close() {
    }

    @Override
    public void sendMessage(Message sipMessage) throws IOException {
        if (this.stack.channelLog()) {
            this.stack.log(Thread.currentThread().getId() + "\t" + this.peerAddress + ":" + this.peerPort + "\t<- " + sipMessage.getCSeq().getSequenceNumber() + " " + sipMessage.getCSeq().getMethod() + (String)(sipMessage instanceof Response ? " " + ((Response)sipMessage).getStatusCode() : ""));
        }
        if (sipMessage instanceof Response) {
            Response response = (Response)sipMessage;
            WarningHeader warning = (WarningHeader)response.getHeader("Warning");
            String warn = null;
            if (warning != null && warning.getCode() == 399) {
                warn = response.getCSeq().getMethod() + " " + warning.getText();
            }
            if (response.getStatusCode() != 401 && response.getStatusCode() != 100) {
                this.messageProcessor.onResponse(this.peerAddress, warn);
            }
        }
        byte[] msg = sipMessage.encodeAsBytes();
        DatagramPacket packet = new DatagramPacket(msg, msg.length, this.peerAddress, this.peerPort);
        this.messageProcessor.send(packet);
    }

    @Override
    public void run() {
        block14: {
            byte[] buf = this.packet.getData();
            int length = this.packet.getLength();
            boolean crlf = false;
            int j = 0;
            Message sipMessage = null;
            try {
                int contentLength;
                int i;
                Object line = "";
                for (i = 0; i < length; ++i) {
                    if (buf[i] == 10 && i > 0 && buf[i - 1] == 13) {
                        if (crlf) {
                            ++i;
                            break;
                        }
                        crlf = true;
                        continue;
                    }
                    if (!crlf) continue;
                    if (buf[i] == 32 || buf[i] == 9) {
                        line = (String)line + new String(buf, j, i - j - 2).trim() + " ";
                        crlf = false;
                    } else {
                        line = (String)line + new String(buf, j, i - j).trim();
                        if (sipMessage == null) {
                            if (((String)line).startsWith("SIP")) {
                                sipMessage = new Response((String)line);
                            } else {
                                sipMessage = new Request((String)line);
                                ((Request)sipMessage).setReceived(this.peerAddress.getHostAddress(), this.peerPort);
                            }
                        } else {
                            sipMessage.addHeader((String)line);
                        }
                        line = "";
                        if (buf[i] != 13) {
                            crlf = false;
                        }
                    }
                    j = i;
                }
                if ((contentLength = sipMessage.getContentLength()) > 0) {
                    byte[] content = new byte[contentLength];
                    System.arraycopy(buf, i, content, 0, contentLength);
                    sipMessage.setContentBytes(content);
                }
                if (this.stack.channelLog()) {
                    this.stack.log(Thread.currentThread().getId() + "\t" + this.peerAddress + ":" + this.peerPort + "\t-> " + sipMessage.getCSeq().getSequenceNumber() + " " + sipMessage.getCSeq().getMethod() + (String)(sipMessage instanceof Request ? "" : " " + ((Response)sipMessage).getStatusCode()));
                }
                this.stack.processMessage(sipMessage, this);
            }
            catch (Throwable ex) {
                this.messageProcessor.onResponse(this.peerAddress, "Invalid message");
                if (!this.stack.channelLog()) break block14;
                this.stack.log(Thread.currentThread().getId() + "\t" + this.peerAddress + "\tInvalid message - " + ex.getMessage());
            }
        }
    }
}

