/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.net.WebSocket;
import com.smile.telephony.sip.header.ContentLengthHeader;
import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.WSMessageProcessor;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import smile.util.ResourceStore;

public class WSMessageChannel
extends WebSocket
implements MessageChannel {
    private WSMessageProcessor messageProcessor;
    private SipStack sipStack;
    private InetAddress peerAddress;
    private int peerPort;

    protected WSMessageChannel(String url, String protocol, WSMessageProcessor messageProcessor, SipStack stack) throws Exception {
        super(url, protocol, null, null, stack.getOutboundProxy());
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.peerAddress = super.getInetAddress();
        this.peerPort = super.getPort();
    }

    public InetAddress getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public void sendMessage(Message sipMessage) throws IOException {
        int code;
        this.sendTextFrame(sipMessage.encodeAsBytes());
        if (this.sipStack.channelLog()) {
            ResourceStore.toLog(this.peerAddress + ":" + this.peerPort + "\t<-\t" + sipMessage.getCSeq().getSequenceNumber() + " " + sipMessage.getCSeq().getMethod() + " " + (Serializable)(sipMessage instanceof Response ? Integer.valueOf(((Response)sipMessage).getStatusCode()) : ""));
        }
        if (sipMessage instanceof Response && sipMessage.getCSeq().getMethod().equals("REGISTER") && ((code = ((Response)sipMessage).getStatusCode()) == 302 || sipMessage.hasHeader("Warning"))) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
        }
    }

    @Override
    protected void onTextFrame(byte[] buf) {
        block15: {
            boolean crlf = false;
            int j = 0;
            Message sipMessage = null;
            try {
                int contentLength;
                int i;
                Object line = "";
                for (i = 0; i < buf.length; ++i) {
                    if (buf[i] == 10 && i > 0 && buf[i - 1] == 13) {
                        if (crlf) {
                            ++i;
                            break;
                        }
                        crlf = true;
                        continue;
                    }
                    if (!crlf) continue;
                    if (buf[i] == 32 || buf[i] == 9) {
                        line = (String)line + new String(buf, j, i - j - 2).trim() + " ";
                        crlf = false;
                    } else {
                        line = (String)line + new String(buf, j, i - j).trim();
                        if (sipMessage == null) {
                            if (((String)line).startsWith("SIP")) {
                                sipMessage = new Response((String)line);
                            } else {
                                sipMessage = new Request((String)line);
                                ((Request)sipMessage).setReceived(this.peerAddress.getHostAddress(), this.peerPort);
                            }
                        } else {
                            sipMessage.addHeader((String)line);
                        }
                        line = "";
                        if (buf[i] != 13) {
                            crlf = false;
                        }
                    }
                    j = i;
                }
                if (sipMessage == null) {
                    return;
                }
                ContentLengthHeader clh = sipMessage.getContentLengthHeader();
                int n = contentLength = clh != null ? clh.getContentLength() : buf.length - i;
                if (contentLength > 0) {
                    byte[] content = new byte[contentLength];
                    System.arraycopy(buf, i, content, 0, contentLength);
                    sipMessage.setContentBytes(content);
                }
                if (this.sipStack.channelLog()) {
                    ResourceStore.toLog(this.peerAddress + ":" + this.peerPort + "\t-> " + sipMessage.getCSeq().getSequenceNumber() + " " + sipMessage.getCSeq().getMethod() + (String)(sipMessage instanceof Request ? "" : " " + ((Response)sipMessage).getStatusCode()));
                }
                this.sipStack.processMessage(sipMessage, this);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                System.out.println(new String(buf));
                if (!this.sipStack.channelLog()) break block15;
                ResourceStore.toLog(this.peerAddress + "\tInvalid message - " + ex.getMessage());
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.messageProcessor.removeMessageChannel(this.getLocalPort());
    }

    @Override
    public void onClose(int code, int cause) {
        super.onClose(code, cause);
        String key = this.messageProcessor.removeMessageChannel(this.getLocalPort());
        if (key != null) {
            this.sipStack.onConnectionLost(key);
        }
    }
}

