/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.stack.Hop;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.MessageProcessor;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.WSMessageChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import smile.util.ResourceStore;

public class WSMessageProcessor
implements MessageProcessor {
    public static final String PROTOCOL_SIP = "sip";
    public static final String PROTOCOL_SIP_SMILE = "sip.smile-soft.com";
    public static final String[] PROTOCOLS = new String[]{"sip", "sip.smile-soft.com"};
    protected SipStack sipStack;
    private Map channels = new HashMap();

    public WSMessageProcessor(SipStack sipStack, int port) throws Exception {
        this.sipStack = sipStack;
    }

    @Override
    public synchronized MessageChannel getMessageChannel(Hop hop, boolean reopen) throws Exception {
        WSMessageChannel channel = null;
        Iterator itr = this.channels.values().iterator();
        if (itr.hasNext()) {
            channel = (WSMessageChannel)itr.next();
        }
        if (channel == null && reopen) {
            String url = hop.getTransport() + "://" + hop.getHost() + ":" + hop.getPort();
            String protocol = this.sipStack.isClient() ? PROTOCOL_SIP_SMILE : PROTOCOL_SIP;
            channel = new WSMessageChannel(url, protocol, this, this.sipStack);
            this.channels.put(channel.getLocalPort(), channel);
            ResourceStore.toLog("open channel " + channel);
        }
        return channel;
    }

    protected synchronized String removeMessageChannel(int port) {
        WSMessageChannel channel = (WSMessageChannel)this.channels.remove(port);
        ResourceStore.error("remove channel " + channel + " on port " + port);
        return channel != null ? channel.getPeerAddress().getHostAddress() : null;
    }

    @Override
    public void dispose() {
        Iterator itr = this.channels.values().iterator();
        while (itr.hasNext()) {
            ((WSMessageChannel)itr.next()).close();
        }
        this.channels.clear();
    }
}

