/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.video;

import com.smile.telephony.codec.video.Codec;
import com.smile.telephony.video.Frame;
import java.io.IOException;
import java.util.Vector;
import smile.util.ResourceStore;

public class FrameBuffer
implements Runnable {
    private Vector<Frame> buffer = new Vector();
    private Vector<Frame> dbuffer = new Vector();
    private boolean disposed = false;
    private Codec decoder;
    private int maxqueuetime = 45000;
    private int jtime = 0;
    private long rel;
    private int decodedBytes;
    private int decodedFrames;
    private boolean decoderError;
    private boolean ignoreError;
    private boolean snapshotMode;
    private boolean pauseMode;
    private int frameWidth;
    private int frameHeight;
    private String pixelFormat;
    private int inputWidth;
    private int inputHeight;
    private String inputPixelFormat;
    private float inratio;
    private Thread decoderThread;

    public void setJitterBuffer(int msec) {
        this.jtime = msec * 90;
    }

    public int getJitterBuffer() {
        return this.jtime / 90;
    }

    public void setPauseMode(boolean on) {
        if (this.pauseMode && !on) {
            this.decoderError = true;
        }
        this.pauseMode = on;
        this.buffer.clear();
        this.dbuffer.clear();
    }

    public boolean isPauseMode() {
        return this.pauseMode;
    }

    public void setSnapshotMode(boolean on) {
        this.snapshotMode = on;
    }

    public void setIgnoreDecoderError(boolean on) {
        this.ignoreError = on;
    }

    public boolean put(Frame frame) throws IOException {
        if (this.disposed) {
            throw new IOException("Buffer disposed");
        }
        if (this.pauseMode) {
            return true;
        }
        if (this.decoder != null) {
            if (frame.isKey()) {
                this.decoderError = false;
            } else {
                if (this.decoderError) {
                    return false;
                }
                if (this.snapshotMode) {
                    return true;
                }
            }
            this.dbuffer.add(frame);
        } else {
            this.putFrame(frame);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFrame(Frame frame) {
        Vector<Frame> vector = this.buffer;
        synchronized (vector) {
            long diff;
            int i;
            for (i = this.buffer.size(); i > 0 && (diff = frame.timestamp - this.buffer.elementAt((int)(i - 1)).timestamp) < 0L && (diff += 0xFFFFFFFFL) >= 0xFFFFFFL; --i) {
            }
            this.buffer.insertElementAt(frame, i);
            --i;
            while (i >= 0) {
                diff = frame.timestamp - this.buffer.elementAt((int)i).timestamp;
                if (diff < 0L) {
                    diff += 0xFFFFFFFFL;
                }
                if (diff > (long)this.maxqueuetime) break;
                --i;
            }
            while (i >= 0) {
                this.buffer.removeElementAt(i);
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame get() throws IOException {
        if (this.disposed) {
            throw new IOException("Buffer disposed");
        }
        Vector<Frame> vector = this.buffer;
        synchronized (vector) {
            if (this.buffer.isEmpty()) {
                return null;
            }
            Frame frame = null;
            if (this.jtime <= 0) {
                frame = this.buffer.remove(0);
            } else {
                int i;
                long laststamp = this.buffer.lastElement().timestamp;
                long thisstamp = System.currentTimeMillis() * 90L & 0xFFFFFFFFL;
                long diff = thisstamp - laststamp;
                if (diff < 0L) {
                    diff += 0xFFFFFFFFL;
                }
                if (this.rel == 0L) {
                    this.rel = diff;
                } else {
                    long stamp = thisstamp - this.rel;
                    if (stamp < 0L) {
                        stamp += 0xFFFFFFFFL;
                    }
                    if (laststamp < stamp) {
                        laststamp = stamp;
                    } else {
                        this.rel = diff;
                    }
                }
                for (i = this.buffer.size() - 1; i >= 0; --i) {
                    diff = laststamp - this.buffer.elementAt((int)i).timestamp;
                    if (diff < 0L) {
                        diff += 0xFFFFFFFFL;
                    }
                    if (diff < (long)this.jtime) continue;
                    frame = this.buffer.elementAt(i);
                    break;
                }
                if (frame != null) {
                    while (i >= 0) {
                        this.buffer.removeElementAt(i);
                        --i;
                    }
                }
            }
            return frame;
        }
    }

    public void reset() {
        this.buffer.clear();
        this.rel = 0L;
    }

    public void dispose() {
        this.setDecoder(null);
        this.disposed = true;
    }

    public int getSize() {
        return this.buffer.size();
    }

    public void setInputFormat(int width, int height, String pixfmt) {
        this.inputWidth = width;
        this.inputHeight = height;
        this.inputPixelFormat = pixfmt;
    }

    public String getInputPixelFormat() {
        return this.inputPixelFormat;
    }

    public int getInputWidth() {
        return this.inputWidth;
    }

    public int getInputHeight() {
        return this.inputHeight;
    }

    public synchronized void setImageFormat(int width, int height, String pixfmt, boolean b) {
        if (width == 0 || height == 0) {
            return;
        }
        this.frameWidth = width;
        this.frameHeight = height;
        this.pixelFormat = pixfmt;
        float aspect_ration = this.getAspectRatio();
        if (aspect_ration == 0.0f || aspect_ration == this.inratio && !b) {
            return;
        }
        if (!Float.isNaN(aspect_ration)) {
            if ((float)width < (float)height * aspect_ration) {
                this.frameHeight = (int)((float)width / aspect_ration);
            } else {
                this.frameWidth = (int)((float)height * aspect_ration);
            }
        }
        this.inratio = aspect_ration;
        ResourceStore.toLog("setImageFormat aspect_ration=" + aspect_ration + " frameWidth=" + this.frameWidth + " frameHeight=" + this.frameHeight + " pixelFormat=" + this.pixelFormat);
        if (this.decoder != null) {
            this.decoder.setImageFmt(this.frameWidth, this.frameHeight, this.pixelFormat);
        }
    }

    public String getImagePixelFormat() {
        return this.pixelFormat;
    }

    public int getImageWidth() {
        return this.decoder != null ? this.decoder.getWidth() : this.frameWidth;
    }

    public int getImageHeight() {
        return this.decoder != null ? this.decoder.getHeight() : this.frameHeight;
    }

    public String getImageFormat() {
        return this.decoder != null ? this.decoder.getWidth() + "x" + this.decoder.getHeight() : this.frameWidth + "x" + this.frameHeight;
    }

    public float getAspectRatio() {
        return this.decoder != null ? this.decoder.getAspectRatio() : (float)this.frameWidth / (float)this.frameHeight;
    }

    public Codec getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Codec c) {
        if (c == null && this.decoder != null) {
            this.decoder.close_codec();
            this.inratio = 0.0f;
        }
        this.decoder = c;
        if (c != null) {
            this.decodedBytes = 0;
            this.decodedFrames = 0;
            this.dbuffer.clear();
            this.decoderThread = new Thread(this);
            this.decoderThread.start();
        } else if (this.decoderThread != null) {
            try {
                this.decoderThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getDecodedBytes() {
        return this.decodedBytes;
    }

    public int getDecodedFrames() {
        return this.decodedFrames;
    }

    public String getCodecName() {
        return this.decoder != null ? this.decoder.toString() : "null";
    }

    @Override
    public void run() {
        ResourceStore.toLog(this + " run decoder thread");
        long dtime = 0L;
        int fcount = 0;
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (!this.disposed && this.decoder != null) {
            try {
                Frame frame = null;
                for (int i = this.dbuffer.size() - 1; i >= 0; --i) {
                    frame = this.dbuffer.elementAt(i);
                    if (!frame.isKey()) continue;
                    while (--i != -1) {
                        this.dbuffer.removeElementAt(i);
                    }
                    break;
                }
                if (frame != null) {
                    this.dbuffer.removeElementAt(0);
                    long s = System.currentTimeMillis();
                    this.decodeFrame(frame);
                    dtime += System.currentTimeMillis() - s;
                    ++fcount;
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (Exception e) {
                ResourceStore.error("decodeFrame", e);
            }
        }
        ResourceStore.toLog(this + " decoder thread ended fcount=" + fcount + " avtime=" + (fcount != 0 ? dtime / (long)fcount : 0L));
    }

    private synchronized boolean decodeFrame(Frame frame) {
        byte[] data = frame.getData();
        if (data == null || data.length == 0) {
            return true;
        }
        this.decodedBytes += data.length;
        try {
            data = this.decoder.process(data, data.length);
            if (this.decoder.isNoReference()) {
                return true;
            }
            if (this.decoder.isError()) {
                if (!this.ignoreError) {
                    this.decoderError = true;
                }
                return false;
            }
            if (this.decoder.isCorruptedFrame()) {
                if (!this.ignoreError) {
                    this.decoderError = true;
                }
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (data == null) {
            if (!this.ignoreError) {
                this.decoderError = true;
            }
            return true;
        }
        if (data.length == 0) {
            return true;
        }
        ++this.decodedFrames;
        Frame outputFrame = new Frame(data, frame.getTimestamp());
        outputFrame.width = this.decoder.getOutWidth();
        outputFrame.height = this.decoder.getOutHeight();
        outputFrame.pixformat = this.decoder.getPixelFormat();
        outputFrame.bytesPerRow = outputFrame.pixformat.equals("RGBA") ? outputFrame.width * 4 : (outputFrame.pixformat.equals("RGB24") ? outputFrame.width * 3 : (int)((double)outputFrame.width * 1.5));
        this.putFrame(outputFrame);
        this.decoderError = false;
        return true;
    }
}

