/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.video;

import com.smile.telephony.codec.video.H264;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class VideoCapability
implements Serializable {
    static final long serialVersionUID = -508142207749788796L;
    public static final int PLAIN = 0;
    public static final int H263 = 1;
    public static final int H263P = 2;
    public static final int H264 = 4;
    public static final int H264L = 3;
    public static final int H264H = 5;
    public static final String H264_LOW_LEVEL_ID = "428014";
    public static final String H264_MID_LEVEL_ID = "42801e";
    public static final String H264_HIGH_LEVEL_ID = "4d0028";
    public static final String PROFILE_LEVEL_ID = "profile-level-id";
    public static final String MAX_RECV_LEVEL = "max-recv-level";
    public static final String PACKETIZATION_MODE = "packetization-mode";
    public static final String SPROP_PARAMETER_SETS = "sprop-parameter-sets";
    public static final String NACK = "nack";
    public static final String PLI = "nack pli";
    public static final String FIR = "ccm fir";
    public static final String TMMBR = "ccm tmmbr";
    public static final String SQCIF = "128x96";
    public static final String SQ4HD = "160x90";
    public static final String SQVGA = "160x120";
    public static final String QCIF = "176x144";
    public static final String QCIF_625 = "192x144";
    public static final String SQHD = "320x180";
    public static final String QVGA = "320x240";
    public static final String SIF_525 = "352x240";
    public static final String CIF = "352x288";
    public static final String CIF_625 = "384x288";
    public static final String HHR_525 = "352x480";
    public static final String HHR_625 = "352x576";
    public static final String QHD = "640x360";
    public static final String VGA = "640x480";
    public static final String SIF4_525 = "704x480";
    public static final String SD_525 = "720x480";
    public static final String CIF4 = "704x576";
    public static final String SD_625 = "720x576";
    public static final String SVGA = "800x600";
    public static final String XGA = "1024x768";
    public static final String HD720 = "1280x720";
    public static final String VGA4 = "1280x960";
    public static final String SXGA = "1280x1024";
    public static final String SIF16_525 = "1408x960";
    public static final String CIF16 = "1408x1152";
    public static final String SVGA4 = "1600x1200";
    public static final String HD1080 = "1920x1080";
    public static final String SQCIF_P = "96x128";
    public static final String SQ4HD_P = "90x160";
    public static final String SQVGA_P = "120x160";
    public static final String QCIF_P = "144x176";
    public static final String QCIF_625_P = "144x192";
    public static final String SQHD_P = "180x320";
    public static final String QVGA_P = "240x320";
    public static final String SIF_525_P = "240x352";
    public static final String CIF_P = "288x352";
    public static final String CIF_625_P = "288x384";
    public static final String HHR_525_P = "480x352";
    public static final String HHR_625_P = "572x352";
    public static final String QHD_P = "360x640";
    public static final String VGA_P = "480x640";
    public static final String SIF4_525_P = "480x704";
    public static final String SD_525_P = "480x720";
    public static final String CIF4_P = "576x704";
    public static final String SD_625_P = "576x720";
    public static final String SVGA_P = "600x800";
    public static final String XGA_P = "768x1024";
    public static final String HD720_P = "720x1280";
    public static final String VGA4_P = "960x1280";
    public static final String SXGA_P = "1024x1280";
    public static final String SIF16_525_P = "960x1408";
    public static final String CIF16_P = "1152x1408";
    public static final String SVGA4_P = "1200x1600";
    public static final String HD1080_P = "1080x1920";
    public static final String[] FORMATS = new String[]{"128x96", "160x90", "160x120", "176x144", "192x144", "320x180", "320x240", "352x240", "352x288", "384x288", "352x480", "352x576", "640x360", "640x480", "704x480", "720x480", "704x576", "720x576", "800x600", "1024x768", "1280x720", "1280x960", "1280x1024", "1408x960", "1408x1152", "1600x1200", "1920x1080"};
    public static final String[] FORMATS_P = new String[]{"96x128", "90x160", "120x160", "144x176", "144x192", "180x320", "240x320", "240x352", "288x352", "288x384", "352x480", "352x576", "360x640", "480x640", "480x704", "480x720", "576x704", "576x720", "600x800", "768x1024", "720x1280", "960x1280", "1024x1280", "960x1408", "1152x1408", "1200x1600", "1080x1920"};
    private String codec;
    private int rtptype;
    private int clockrate = 90000;
    private Hashtable parameters = new Hashtable();
    private HashSet caps = new HashSet();

    public static int getFormatIndex(String format) {
        int i;
        for (i = 0; i < FORMATS.length; ++i) {
            if (!FORMATS[i].equals(format)) continue;
            return i;
        }
        for (i = 0; i < FORMATS_P.length; ++i) {
            if (!FORMATS_P[i].equals(format)) continue;
            return i;
        }
        return -1;
    }

    public static int getFormatIndex(String format, boolean landscape) {
        String[] formats = landscape ? FORMATS : FORMATS_P;
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].equals(format)) continue;
            return i;
        }
        return -1;
    }

    public static int getMaxFormatIndex(Vector videoCapabilities) {
        int max = 0;
        Enumeration en = videoCapabilities.elements();
        while (en.hasMoreElements()) {
            VideoCapability vcap = (VideoCapability)en.nextElement();
            int n = vcap.getMaxFormatIndex();
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    public static int getMaxBitrate(Vector videoCapabilities) {
        int max = 0;
        Enumeration en = videoCapabilities.elements();
        while (en.hasMoreElements()) {
            VideoCapability vcap = (VideoCapability)en.nextElement();
            int n = vcap.getMaxBitrate();
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    public static int getSuggestedBitrate(String format) {
        return com.smile.telephony.codec.video.H264.getSuggestedBitrate(format);
    }

    public static VideoCapability getDefaultCapabilities(int codec) {
        VideoCapability cap = new VideoCapability();
        switch (codec) {
            case 0: {
                return new VideoCapability("Plain");
            }
            case 4: {
                cap.setRTPType(102);
                cap.setCodec("H264");
                cap.setParameter(PROFILE_LEVEL_ID, H264_MID_LEVEL_ID);
                break;
            }
            case 3: {
                cap.setRTPType(101);
                cap.setCodec("H264");
                cap.setParameter(PROFILE_LEVEL_ID, H264_LOW_LEVEL_ID);
                cap.setParameter(MAX_RECV_LEVEL, "000c");
                break;
            }
            case 5: {
                cap.setRTPType(103);
                cap.setCodec("H264");
                cap.setParameter(PROFILE_LEVEL_ID, H264_HIGH_LEVEL_ID);
                break;
            }
            case 2: {
                cap.setRTPType(99);
                cap.setCodec("H263-1998");
                break;
            }
            case 1: {
                cap.setRTPType(34);
                cap.setCodec("H263");
            }
        }
        cap.addCapability(NACK);
        cap.addCapability(PLI);
        cap.addCapability(FIR);
        cap.addCapability(TMMBR);
        return cap;
    }

    public static Vector getDefaultCapabilities() {
        Vector<VideoCapability> caps = new Vector<VideoCapability>();
        caps.add(VideoCapability.getDefaultCapabilities(3));
        caps.add(VideoCapability.getDefaultCapabilities(4));
        caps.add(VideoCapability.getDefaultCapabilities(2));
        caps.add(VideoCapability.getDefaultCapabilities(1));
        return caps;
    }

    public static Vector getFullCapabilities() {
        Vector<VideoCapability> caps = new Vector<VideoCapability>();
        caps.add(VideoCapability.getDefaultCapabilities(3));
        caps.add(VideoCapability.getDefaultCapabilities(4));
        caps.add(VideoCapability.getDefaultCapabilities(5));
        caps.add(VideoCapability.getDefaultCapabilities(2));
        caps.add(VideoCapability.getDefaultCapabilities(1));
        return caps;
    }

    public static Vector getLowCapabilities() {
        Vector<VideoCapability> caps = new Vector<VideoCapability>();
        caps.add(VideoCapability.getDefaultCapabilities(3));
        caps.add(VideoCapability.getDefaultCapabilities(2));
        caps.add(VideoCapability.getDefaultCapabilities(1));
        return caps;
    }

    public VideoCapability() {
    }

    public VideoCapability(String codec) {
        this.codec = codec;
    }

    public VideoCapability(int rtptype) {
        this.rtptype = rtptype;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VideoCapability)) {
            return false;
        }
        VideoCapability vc = (VideoCapability)obj;
        return this.codec.equals(vc.codec) && this.rtptype == vc.rtptype;
    }

    public boolean isCompatible(VideoCapability vc) {
        return this.getCodecType() == vc.getCodecType();
    }

    public void adjustCapabilities(VideoCapability vc) {
        Vector r = new Vector();
        for (Object obj : vc.caps) {
            if (this.caps.contains(obj)) continue;
            r.add(obj);
        }
        for (int i = 0; i < r.size(); ++i) {
            vc.caps.remove(r.elementAt(i));
        }
    }

    public VideoCapability createCapability(VideoCapability offer) {
        VideoCapability cap = new VideoCapability(offer.getRTPType());
        cap.setCodec(offer.getCodec());
        cap.setCapabilities(offer.getCapabilities());
        this.adjustCapabilities(cap);
        cap.setParameters(this.getParameters());
        return cap;
    }

    public VideoCapability select(Vector vcaps) {
        VideoCapability vcap = null;
        Enumeration enu = vcaps.elements();
        while (enu.hasMoreElements()) {
            VideoCapability vc = (VideoCapability)enu.nextElement();
            if ((vcap != null || !this.isCompatible(vc)) && (vcap == null || !vc.isPreferred(vcap) || vc.isPreferred(this))) continue;
            vcap = vc;
        }
        return vcap;
    }

    public boolean isPreferred(VideoCapability vc) {
        if (this.getCodecType() != 4) {
            return false;
        }
        String plid = (String)this.parameters.get(PROFILE_LEVEL_ID);
        if (plid == null) {
            return false;
        }
        String plid2 = (String)vc.parameters.get(PROFILE_LEVEL_ID);
        if (plid2 == null) {
            return true;
        }
        int c = plid.compareTo(plid2);
        if (c != 0) {
            return c > 0;
        }
        plid = (String)this.parameters.get(MAX_RECV_LEVEL);
        if (plid == null) {
            return false;
        }
        plid2 = (String)vc.parameters.get(MAX_RECV_LEVEL);
        if (plid2 == null) {
            return true;
        }
        return plid.compareTo(plid2) > 0;
    }

    public boolean isSupportedFormat(String format) {
        if (this.codec.equals("H264")) {
            String maxRecvLevel;
            int profile_idc = 66;
            int profile_iop = 128;
            int level_idc = 30;
            String profileLevelId = (String)this.parameters.get(PROFILE_LEVEL_ID);
            if (profileLevelId != null) {
                try {
                    int plid = Integer.parseInt(profileLevelId, 16);
                    profile_idc = plid >> 16 & 0xFF;
                    profile_iop = plid >> 8 & 0xFF;
                    level_idc = plid & 0xFF;
                }
                catch (NumberFormatException plid) {
                    // empty catch block
                }
            }
            if ((maxRecvLevel = (String)this.parameters.get(MAX_RECV_LEVEL)) != null) {
                try {
                    int plid = Integer.parseInt(maxRecvLevel, 16);
                    int iop = plid >> 8 & 0xFF;
                    level_idc = plid & 0xFF;
                    if ((iop & 0x10) != 0 && level_idc == 11) {
                        level_idc = 9;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return com.smile.telephony.codec.video.H264.getMaxFormatIndex(level_idc) >= VideoCapability.getFormatIndex(format);
        }
        return VideoCapability.getFormatIndex(format) <= 3;
    }

    public int getMaxFormatIndex() {
        int profile_idc = 66;
        int profile_iop = 128;
        int level_idc = 30;
        String profileLevelId = (String)this.parameters.get(PROFILE_LEVEL_ID);
        if (profileLevelId != null) {
            try {
                int plid = Integer.parseInt(profileLevelId, 16);
                profile_idc = plid >> 16 & 0xFF;
                profile_iop = plid >> 8 & 0xFF;
                level_idc = plid & 0xFF;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return com.smile.telephony.codec.video.H264.getMaxFormatIndex(level_idc);
    }

    public int getMaxBitrate() {
        switch (this.getCodecType()) {
            case 4: {
                return com.smile.telephony.codec.video.H264.getMaxBitrate(this);
            }
        }
        return 384000;
    }

    public int getMaxFormatIndex(double bitrate) {
        switch (this.getCodecType()) {
            case 4: {
                return com.smile.telephony.codec.video.H264.getMaxFormatIndex(bitrate);
            }
        }
        return -1;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String c) {
        this.codec = c.toUpperCase();
    }

    public int getCodecType() {
        if (this.codec.equals("H263-1998") || this.codec.equals("H263-2000")) {
            return 2;
        }
        if (this.codec.equals("H263")) {
            return 1;
        }
        if (this.codec.equals("H264")) {
            return 4;
        }
        if (this.codec.equals("Plain")) {
            return 0;
        }
        return -1;
    }

    public int getRTPType() {
        return this.rtptype;
    }

    public void setRTPType(int t) {
        this.rtptype = t;
    }

    public int getClockRate() {
        return this.clockrate;
    }

    public void setClockRate(int t) {
        this.clockrate = t;
    }

    public Hashtable getParameters() {
        return this.parameters;
    }

    public void setParameters(Hashtable table) {
        this.parameters = table;
    }

    public void setParameter(String key, Object value) {
        if (value == null) {
            this.parameters.remove(key);
        } else {
            this.parameters.put(key, value);
        }
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public HashSet getCapabilities() {
        return this.caps;
    }

    public void setCapabilities(HashSet c) {
        this.caps = c;
    }

    public void addCapability(String cap) {
        this.caps.add(cap);
    }

    public boolean hasCapability(String cap) {
        return this.caps.contains(cap);
    }

    public String toString() {
        return this.rtptype + " " + this.codec + "/" + this.clockrate + (String)(this.codec.equals("H264") ? " (" + this.getParameter(PROFILE_LEVEL_ID) + ")" : "");
    }
}

