/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.video;

import com.smile.telephony.rtp.RTP;
import com.smile.telephony.rtp.RTPPacket;
import com.smile.telephony.video.Frame;
import com.smile.telephony.video.FrameBuffer;
import com.smile.telephony.video.VideoCapability;
import com.smile.telephony.video.VideoSocket;
import java.io.IOException;
import java.util.Vector;
import smile.util.Utils;

public class VideoSocketTransmitter
implements Runnable {
    private VideoSocket videoSocket;
    private FrameBuffer input;
    private int payloadType;
    private int ssrc;
    private int seqNumber;
    private long timestamp;
    private boolean transmit;
    private boolean inwork;
    private int codecType;
    private boolean running;
    private Vector store = new Vector();

    public VideoSocketTransmitter(VideoSocket videoSocket) {
        this.videoSocket = videoSocket;
        this.seqNumber = Utils.intRandom(Short.MAX_VALUE);
        this.payloadType = -1;
        this.running = true;
    }

    public void start(VideoCapability cap, FrameBuffer in) {
        this.input = in;
        this.codecType = cap.getCodecType();
        int oldPayloadType = this.payloadType;
        this.payloadType = cap.getRTPType();
        if (oldPayloadType != this.payloadType) {
            this.ssrc = Utils.intRandom();
        }
        this.transmit = true;
        if (!this.inwork) {
            this.inwork = true;
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        this.transmit = false;
        this.input.dispose();
    }

    public int getSyncSource() {
        return this.ssrc;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public boolean isRunning() {
        return this.transmit;
    }

    public void clearStore() {
        this.store.clear();
    }

    public void close() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.videoSocket.toLog("Run VideoTransmitter-" + this.hashCode() + " input=" + this.input + " seqNumber=" + this.seqNumber + " timestamp=" + this.timestamp + " codecType=" + this.codecType + " payloadType=" + this.payloadType);
        this.videoSocket.sendDumb(this.payloadType);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (this.running) {
            try {
                Frame frame = null;
                if (!this.transmit || (frame = this.input.get()) == null) {
                    Thread.sleep(10L);
                    continue;
                }
                this.timestamp = frame.getTimestamp();
                byte[] data = frame.getData();
                Vector packets = new Vector();
                switch (this.codecType) {
                    case 4: {
                        packets = this.parseH264Frame(data);
                        break;
                    }
                    case 2: {
                        packets = this.parseH263Frame(data);
                        break;
                    }
                    case 1: {
                        packets = this.parseH263FrameRFC2190(data);
                    }
                }
                int fs = this.seqNumber;
                long st = System.currentTimeMillis();
                int plen = 0;
                for (int i = 0; i < packets.size(); ++i) {
                    RTPPacket packet = (RTPPacket)packets.elementAt(i);
                    packet.setSyncSource(this.ssrc);
                    packet.setPayloadType(this.payloadType);
                    packet.setTimestamp(this.timestamp);
                    packet.setSequenceNumber(this.seqNumber & 0xFFFF);
                    packet.setMarker(i == packets.size() - 1);
                    this.videoSocket.sendRTPPacket(packet);
                    ++this.seqNumber;
                    this.store.add(packet);
                    plen += packet.getPayloadSize();
                }
                Vector vector = this.store;
                synchronized (vector) {
                    for (int i = this.store.size() - packets.size() - 1; i >= 0; --i) {
                        RTPPacket packet = (RTPPacket)this.store.elementAt(i);
                        long diff = this.timestamp - packet.getTimestamp();
                        if (diff < 0L) {
                            diff += 0xFFFFFFFFL;
                        }
                        if (diff <= this.videoSocket.getMaxBuffer()) continue;
                        while (i >= 0) {
                            this.store.removeElementAt(i);
                            --i;
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!this.running) break;
                e.printStackTrace();
                break;
            }
        }
        this.inwork = false;
        this.transmit = false;
        this.videoSocket.toLog("End VideoTransmitter-" + this.hashCode() + " seqNumber=" + this.seqNumber + " timestamp=" + this.timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nackReceived(int rsrc, int pid, int mask) {
        if (rsrc != this.ssrc) {
            return;
        }
        Vector vector = this.store;
        synchronized (vector) {
            for (int i = 0; i < this.store.size(); ++i) {
                RTPPacket packet = (RTPPacket)this.store.elementAt(i);
                if (packet.getSequenceNumber() != pid) continue;
                try {
                    this.videoSocket.sendRTPPacket(packet, null);
                    if (mask == 0) break;
                    int k = Math.min(this.store.size() - i, 16);
                    ++i;
                    for (int j = 0; j < k; ++j) {
                        if ((mask & 1 << j) == 0) continue;
                        packet = (RTPPacket)this.store.elementAt(i + j);
                        this.videoSocket.sendRTPPacket(packet, null);
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    private Vector parseH264Frame(byte[] b) throws IOException {
        int n;
        int length = b.length;
        for (n = 0; n < length - 3; ++n) {
            if (b[n] != 0 || b[n + 1] != 0 || b[n + 2] != 1) continue;
            n += 3;
            break;
        }
        int mtu = this.videoSocket.getMTU();
        Vector<RTPPacket> packets = new Vector<RTPPacket>();
        while (n < length) {
            int nalLength;
            int beginIndex = n;
            int z = 0;
            while (n < length) {
                if (b[n] == 0) {
                    ++z;
                } else {
                    if (z >= 2 && b[n] == 1) break;
                    z = 0;
                }
                ++n;
            }
            if ((nalLength = n - z - beginIndex) <= mtu) {
                RTPPacket packet = new RTPPacket(nalLength + 12);
                packet.setVersion(RTP.VERSION);
                System.arraycopy(b, beginIndex, packet.getBuffer(), 12, nalLength);
                packets.add(packet);
            } else {
                byte octet = b[beginIndex];
                int forbidden_zero_bit = octet & 0x80;
                int nri = octet & 0x60;
                int nal_unit_type = octet & 0x1F;
                byte fuIndicator = (byte)(0xFF & (forbidden_zero_bit | nri | 0x1C));
                byte fuHeader = (byte)(0xFF & (0x80 | nal_unit_type));
                int maxFUPayloadLength = mtu - 2;
                ++beginIndex;
                --nalLength;
                while (nalLength > 0) {
                    int fuPayloadLength;
                    if (nalLength > maxFUPayloadLength) {
                        fuPayloadLength = maxFUPayloadLength;
                    } else {
                        fuPayloadLength = nalLength;
                        fuHeader = (byte)(fuHeader | 0x40);
                    }
                    RTPPacket packet = new RTPPacket(fuPayloadLength + 14);
                    packet.setVersion(RTP.VERSION);
                    byte[] fua = packet.getBuffer();
                    fua[12] = fuIndicator;
                    fua[13] = fuHeader;
                    System.arraycopy(b, beginIndex, fua, 14, fuPayloadLength);
                    packets.add(packet);
                    beginIndex += fuPayloadLength;
                    nalLength -= fuPayloadLength;
                    fuHeader = (byte)(fuHeader & 0xFFFFFF7F);
                }
            }
            ++n;
        }
        return packets;
    }

    private Vector parseH263Frame(byte[] b) throws IOException {
        int length = b.length;
        int n = 0;
        int tr = (b[2] & 3) << 6 | (b[3] & 0xFFFFFFFC) >> 2 & 0x3F;
        boolean isSSI = (b[4] & 0xFFFFFF80) != 0;
        boolean isDC = (b[4] & 0x40) != 0;
        boolean isFPFR = (b[4] & 0x20) != 0;
        int srcFmt = (b[5] & 0x70) >> 4;
        boolean isCPCF = (b[5] & 8) != 0;
        boolean isUMV = (b[5] & 4) != 0;
        boolean isSAC = (b[5] & 2) != 0;
        boolean isAP = (b[5] & 1) != 0;
        boolean isAIC = (b[6] & 0xFFFFFF80) != 0;
        boolean isDF = (b[6] & 0x40) != 0;
        boolean isSS = (b[6] & 0x20) != 0;
        boolean isRPS = (b[6] & 0x10) != 0;
        boolean isISD = (b[6] & 8) != 0;
        boolean isAIV = (b[6] & 4) != 0;
        boolean isMQ = (b[6] & 2) != 0;
        boolean isPFrame = (b[7] & 0x1C) != 0;
        boolean isRRR = (b[7] & 2) != 0;
        boolean isRRU = (b[7] & 1) != 0;
        boolean isRT = (b[8] & 0xFFFFFF80) != 0;
        boolean isCPM = (b[8] & 8) != 0;
        int offset = 0;
        if (isCPCF) {
            offset += 10;
        }
        if (isUMV) {
            offset += 2;
        }
        if (isSS) {
            offset += 2;
        }
        int qscale = 0;
        boolean isPEI = false;
        switch (offset) {
            case 0: {
                qscale = ((b[8] & 7) << 2 | (b[9] & 0xFFFFFFC0) >> 6) & 0xFF;
                isPEI = (b[9] & 0x20) != 0;
                break;
            }
            case 2: {
                qscale = ((b[8] & 1) << 4 | (b[9] & 0xFFFFFFF0) >> 4) & 0xFF;
                isPEI = (b[9] & 8) != 0;
                break;
            }
            case 4: {
                qscale = (b[9] & 0x7C) >> 2 & 0xFF;
                isPEI = (b[9] & 2) != 0;
                break;
            }
            case 10: {
                qscale = ((b[9] & 1) << 4 | (b[10] & 0xFFFFFFF0) >>> 4 & 0xF) & 0xFF;
                isPEI = (b[10] & 8) != 0;
                break;
            }
            case 12: {
                qscale = (b[10] & 0x7C) >> 2 & 0xFF;
                isPEI = (b[10] & 2) != 0;
                break;
            }
            case 14: {
                qscale = b[10] & 0x1F & 0xFF;
                isPEI = (b[11] & 0xFFFFFF80) != 0;
            }
        }
        byte[] data = new byte[b.length - (int)Math.floor((25 + offset) / 8) + 1];
        data[0] = 0;
        data[1] = 0;
        data[2] = (byte)(0x80 | tr >> 6 & 3);
        data[3] = (byte)(tr << 2 & 0xFC | 2);
        data[4] = (byte)((isSSI ? 128 : 0) | (isDC ? 64 : 0) | (isFPFR ? 32 : 0) | srcFmt << 2 & 0x1C | (isPFrame ? 2 : 0) | (isUMV ? 1 : 0));
        data[5] = (byte)((isSAC ? 128 : 0) | (isAP ? 64 : 0) | qscale & 0x1F);
        data[6] = (byte)(isCPM ? 128 : 0);
        int byte_src = (int)Math.floor((75 + offset) / 8);
        int bit_src = 128 >> 75 + offset - byte_src * 8;
        int byte_dst = 6;
        int bit_dst = 32;
        while (true) {
            data[byte_dst] = (byte)(data[byte_dst] | ((b[byte_src] & bit_src) != 0 ? bit_dst : 0));
            if ((b[byte_src] == 0 && b[byte_src - 1] == 0 || byte_src == b.length - 1) && bit_src == 1) break;
            if ((bit_src = (byte)((bit_src & 0xFF) >> 1)) == 0) {
                bit_src = -128;
                ++byte_src;
            }
            if ((bit_dst = (int)((byte)((bit_dst & 0xFF) >> 1))) != 0) continue;
            bit_dst = -128;
            ++byte_dst;
        }
        if (byte_src < b.length - 1) {
            System.arraycopy(b, byte_src + 1, data, byte_dst + 1, b.length - byte_src - 1);
        }
        if ((b = data)[(length = b.length) - 1] == 0) {
            --length;
        }
        Vector<RTPPacket> packets = new Vector<RTPPacket>();
        while (n < length) {
            int psc = 0;
            boolean isPsc = false;
            int payloadLength = 0;
            if (b[n] == 0 && b[n + 1] == 0 && (b[n + 2] & 0xFFFFFF80) == -128 && length - n > 3) {
                psc = 2;
                isPsc = true;
            } else {
                psc = 0;
                isPsc = false;
            }
            for (int i = n + psc; i < length - 2; i += 2) {
                if (b[i] != 0) continue;
                if (b[i + 1] == 0 && b[i + 2] != 0) {
                    payloadLength = i - n;
                    break;
                }
                if (b[i - 1] != 0 || b[i + 1] == 0) continue;
                payloadLength = i - n - 1;
                break;
            }
            if (payloadLength == 0) {
                payloadLength = length - n;
            }
            RTPPacket packet = new RTPPacket(payloadLength - psc + 14);
            packet.setVersion(RTP.VERSION);
            byte[] pkt = packet.getBuffer();
            pkt[12] = (byte)(isPsc ? 4 : 0);
            pkt[13] = 0;
            System.arraycopy(b, n + psc, pkt, 14, payloadLength - psc);
            packets.add(packet);
            n += payloadLength;
        }
        return packets;
    }

    private Vector parseH263FrameRFC2190(byte[] data) {
        int payloadLength;
        Vector<RTPPacket> packets = new Vector<RTPPacket>();
        byte[] head = new byte[]{0, 0, 0, 0};
        int data_len = data.length;
        head[1] = (byte)(head[1] | (data[4] & 0x1E) << 3);
        for (int n = 0; n < data_len; n += payloadLength) {
            int maxPayloadLength = 1024;
            payloadLength = Math.min(data_len - n, maxPayloadLength);
            if (payloadLength == maxPayloadLength) {
                int start = n;
                int end = start + payloadLength;
                int k = -1;
                for (int i = end - 1; i > start + 1; i -= 2) {
                    if (data[i] != 0) continue;
                    if (data[i + 1] == 0 && data[i + 2] != 0) {
                        k = i;
                        break;
                    }
                    if (data[i - 1] != 0 || data[i + 1] == 0) continue;
                    k = i - 1;
                    break;
                }
                if (k > 0) {
                    payloadLength = k - n;
                }
            }
            RTPPacket packet = new RTPPacket(payloadLength + 16);
            packet.setVersion(RTP.VERSION);
            byte[] pkt = packet.getBuffer();
            System.arraycopy(head, 0, pkt, 12, 4);
            System.arraycopy(data, n, pkt, 16, payloadLength);
            packets.add(packet);
        }
        return packets;
    }
}

