/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.ios;

import com.smile.telephony.PipeInputStream;
import com.smile.telephony.PipeOutputStream;
import com.smile.telephony.audio.SignalProcessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import smile.cti.phone.DeviceListener;
import smile.cti.phone.audio.AudioSystem;
import smile.util.ResourceStore;
import smile.util.Utils;

public class AudioDevice
implements AudioSystem {
    public static final String DEVICE_RECEIVER = "Receiver";
    public static final String DEVICE_SPEAKER = "Speaker";
    public static final String DEVICE_MICROPHONE = "Microphone";
    public static final int SAMPLE_RATE = 48000;
    public static final int STREAM_DELAY_MS = 120;
    private byte[] GAUSSIAN = new byte[600000];
    private String activePlaybackLine;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SignalProcessor spPlayback;
    private SignalProcessor spRecord;
    private int stream_delay_ms = 120;
    private int agcPlaybackMode = 3;
    private int agcRecordMode = 3;
    private boolean mute;
    private int scount;
    private int stcount;
    public int nativesize;
    public int samplerate = 48000;
    private byte[] output = new byte[160];
    private byte[] input = new byte[160];
    private boolean vadMode = true;
    private int g;
    private int testSoundId = 1105;
    private long testStart;
    private byte[] in;
    private int inoff;
    private int invad;
    private boolean stopped;
    private boolean silon;
    private long rhandle;
    private long phandle;

    public AudioDevice() {
        this.init(48000, 10);
        this.spRecord = new SignalProcessor(80, 8000, this.samplerate);
        this.spRecord.setResampler(this.samplerate, 8000);
        this.spRecord.setAGCCompressionGain(18);
        this.spRecord.setAGCLevel(0);
        this.spRecord.setAGC(this.agcRecordMode);
        this.spRecord.setVAD(1);
        this.spRecord.setFilter();
        this.spRecord.setNoiseSuppression(2);
        this.spRecord.setEchoCancellation(this.stream_delay_ms);
        this.spPlayback = new SignalProcessor(80, 8000, this.samplerate);
        this.spPlayback.setResampler(8000, this.samplerate);
        this.spPlayback.setNoiseSuppression(2);
        this.spPlayback.setFilter();
        this.spPlayback.setAGC(this.agcPlaybackMode);
        this.spPlayback.setVAD(1);
        this.spPlayback.setAGCCompressionGain(9);
        this.spPlayback.setAGCLevel(3);
        this.nativesize = 160 * this.samplerate / 8000;
        this.in = new byte[this.nativesize];
        Random random = new Random();
        int max = 8;
        int i = 0;
        do {
            int n = (int)(Math.round((double)max * random.nextDouble()) - (long)(max / 2));
            this.GAUSSIAN[i++] = (byte)(n & 0xFF);
            this.GAUSSIAN[i++] = (byte)(n >> 8);
        } while (i < this.GAUSSIAN.length);
        ResourceStore.toLog(this + " init");
    }

    @Override
    public void setState(boolean on) {
        ResourceStore.toLog("setAudioSessionState " + on + " handle=" + this.rhandle + " phandle=" + this.phandle + " stopped=" + this.stopped);
        if (on) {
            new Thread(){

                @Override
                public void run() {
                    AudioDevice.this.startAudio();
                }
            }.start();
        } else {
            this.stopAudio();
        }
    }

    @Override
    public void setDeviceListener(DeviceListener listener) {
    }

    private synchronized void stopAudio() {
        this.stopped = true;
        if (this.phandle != 0L) {
            this.stopPlayback(this.phandle, this.rhandle == 0L);
        }
        if (this.rhandle != 0L) {
            this.stopRecord(this.rhandle, true);
        }
        new Thread(){

            @Override
            public void run() {
                AudioDevice.this.sendKeepAlive();
            }
        }.start();
    }

    private synchronized void startAudio() {
        if (!this.stopped && this.phandle != 0L && this.rhandle != 0L) {
            return;
        }
        if (this.phandle != 0L) {
            this.stopPlayback(this.phandle, this.rhandle == 0L);
        }
        if (this.rhandle != 0L) {
            this.stopRecord(this.rhandle, true);
        }
        if (this.stopped) {
            this.init(this.samplerate, 10);
            if (DEVICE_SPEAKER.equals(this.activePlaybackLine)) {
                this.routeOutputToSpeaker(true);
            }
        }
        if (this.inputStream != null) {
            this.startPlayback(this.inputStream);
        }
        if (this.outputStream != null) {
            this.startCapture(this.outputStream);
        }
        this.stopped = this.rhandle == 0L && this.outputStream != null || this.phandle == 0L && this.inputStream != null;
    }

    @Override
    public Enumeration<String> getCaptureLines() {
        String[] deviceNames = new String[]{DEVICE_MICROPHONE};
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < deviceNames.length; ++i) {
            v.add(deviceNames[i]);
        }
        ResourceStore.toLog("getCaptureLines: " + v);
        return v.elements();
    }

    @Override
    public Enumeration<String> getPlaybackLines() {
        String[] deviceNames = new String[]{DEVICE_RECEIVER, DEVICE_SPEAKER};
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < deviceNames.length; ++i) {
            v.add(deviceNames[i]);
        }
        ResourceStore.toLog("getPlaybackLines: " + v);
        return v.elements();
    }

    @Override
    public void openCaptureLine(String linename) throws Exception {
    }

    @Override
    public synchronized void openPlaybackLine(String linename) throws Exception {
        ResourceStore.toLog("openPlaybackLine " + linename + " activePlaybackLine=" + this.activePlaybackLine);
        this.routeOutputToSpeaker(linename.equals(DEVICE_SPEAKER));
        if (linename.equals(this.activePlaybackLine)) {
            return;
        }
        this.activePlaybackLine = linename;
        if (this.phandle != 0L) {
            this.stopPlayback(this.phandle, false);
            this.startPlayback(this.inputStream);
        }
    }

    @Override
    public void closeCaptureLine() {
    }

    @Override
    public void closePlaybackLine() {
        ResourceStore.toLog("closePlaybackLine " + this.activePlaybackLine);
        if (this.activePlaybackLine != null) {
            if (this.activePlaybackLine.equals(DEVICE_SPEAKER)) {
                this.routeOutputToSpeaker(false);
            }
            this.activePlaybackLine = null;
        }
    }

    private void amp(byte[] pcm, double d) {
        for (int i = 0; i < pcm.length; i += 2) {
            int s = (int)((double)(pcm[i + 1] << 8 | pcm[i] & 0xFF) * d);
            pcm[i] = (byte)(s & 0xFF);
            pcm[i + 1] = (byte)(s >> 8);
        }
    }

    public void putFrame(byte[] data, int len) {
        if (this.mute && ++this.scount < 100) {
            return;
        }
        try {
            int dlen;
            int length = Math.min(len, this.nativesize - this.inoff);
            System.arraycopy(data, 0, this.in, this.inoff, length);
            this.inoff += length;
            if (this.inoff >= this.nativesize) {
                this.spRecord.resample(this.in, this.output);
                int vad = this.spRecord.process(this.output);
                if (vad == 0 && !this.silon) {
                    this.silon = true;
                    this.stcount = Utils.intRandom(50, 100);
                } else if (vad != 0 && this.silon) {
                    this.silon = false;
                    this.stcount = 0;
                }
                if (!this.vadMode || !(this.outputStream instanceof PipeOutputStream) || vad != 0 || ++this.scount > 300 || this.stcount-- > 0) {
                    this.scount = 0;
                    this.outputStream.write(this.output, 0, this.output.length);
                }
                this.inoff -= this.nativesize;
            }
            if ((dlen = len - length) > 0) {
                System.arraycopy(data, length, this.in, this.inoff, dlen);
                this.inoff += dlen;
                if (this.inoff >= this.nativesize) {
                    this.inoff -= this.nativesize;
                }
            }
        }
        catch (Exception e) {
            ResourceStore.toLog("putFrame: " + e);
        }
    }

    private void sendKeepAlive() {
        byte[] data = new byte[160];
        this.fillNoise(data, 0, 160);
        try {
            while (this.rhandle == 0L && this.outputStream instanceof PipeOutputStream) {
                this.outputStream.write(data, 0, data.length);
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getLevel(byte[] data) {
        int midvalue = 0;
        for (int i = 0; i < data.length; i += 2) {
            midvalue += Math.abs(data[i + 1] << 8 | data[i] & 0xFF);
        }
        return midvalue / data.length;
    }

    public byte[] getFrame(int len) {
        int nativesize = 160 * this.samplerate / 8000;
        byte[] out = new byte[nativesize];
        if (this.inputStream == null) {
            return out;
        }
        try {
            int n;
            byte[] input = new byte[160];
            boolean hasdata = false;
            int vad = 0;
            while ((n = this.inputStream.read(input, 0, input.length)) > 0) {
                hasdata = true;
                if (this.inputStream instanceof PipeInputStream) {
                    vad = this.spPlayback.process(input);
                }
                if (vad != 1 && this.inputStream instanceof PipeInputStream && this.inputStream.available() > ((PipeInputStream)this.inputStream).getMinBufferSize()) continue;
            }
            if (!hasdata) {
                this.fillNoise(input, 0, input.length);
            }
            this.invad = vad == 1 ? ++this.invad : 0;
            this.spPlayback.resample(input, out);
            if (this.rhandle != 0L) {
                this.spRecord.render(input);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private void fillNoise(byte[] data, int offset, int length) {
        if (this.g + data.length >= this.GAUSSIAN.length) {
            this.g = 0;
        }
        System.arraycopy(this.GAUSSIAN, this.g, data, offset, length);
        this.g += length;
    }

    private native void init(int var1, int var2);

    private native String[] getCaptureDevices();

    private native String[] getPlaybackDevices();

    private native void routeOutputToSpeaker(boolean var1);

    private native int getSamplingRate();

    protected native boolean setAudioSessionActive(boolean var1);

    @Override
    public native float getCaptureLevel();

    @Override
    public native float getPlaybackLevel();

    @Override
    public native void setCaptureLevel(float var1);

    @Override
    public native void setPlaybackLevel(float var1);

    private native long startRecorder(int var1);

    private native void stopRecorder(long var1, boolean var3);

    @Override
    public synchronized void startCapture(OutputStream stream) {
        ResourceStore.toLog("startCapture rhandle=" + this.rhandle + " phandle=" + this.phandle + " stopped=" + this.stopped);
        this.outputStream = stream;
        this.spRecord.reset();
        if (this.rhandle == 0L) {
            this.inoff = 0;
            this.silon = false;
            this.rhandle = this.startRecorder(this.samplerate);
        }
        ResourceStore.toLog("startCapture handle=" + this.rhandle + " stream=" + stream + " sample_rate=" + this.getSamplingRate());
    }

    @Override
    public void stopCapture() {
        this.stopRecord(this.rhandle, this.phandle == 0L);
        this.outputStream = null;
        ResourceStore.toLog("stopCapture handle=" + this.rhandle + " phandle=" + this.phandle);
    }

    private synchronized void stopRecord(long h, boolean b) {
        if (this.rhandle == h) {
            ResourceStore.toLog("stopRecorder handle=" + this.rhandle + " b=" + b);
            this.stopRecorder(this.rhandle, b);
            this.rhandle = 0L;
        }
    }

    private synchronized void stopPlayback(long h, boolean b) {
        if (this.phandle == h) {
            ResourceStore.toLog("stopPlayer handle=" + this.phandle + " b=" + b);
            this.stopPlayer(this.phandle, b);
            this.phandle = 0L;
        }
    }

    private native long startPlayer(int var1, double var2);

    private native void stopPlayer(long var1, boolean var3);

    @Override
    public synchronized void startPlayback(InputStream stream) {
        ResourceStore.toLog("startPlayback handle=" + this.phandle + " rhandle=" + this.rhandle + " activePlaybackLine=" + this.activePlaybackLine + " stopped=" + this.stopped);
        this.spPlayback.reset();
        if (this.phandle == 0L) {
            boolean speaker = DEVICE_SPEAKER.equals(this.activePlaybackLine);
            this.spPlayback.setAGCCompressionGain(speaker ? 40 : 18);
            this.spPlayback.setAGCLevel(speaker ? 0 : 3);
            this.phandle = this.startPlayer(this.samplerate, speaker ? 3.0 : 1.0);
        }
        this.inputStream = stream;
        ResourceStore.toLog("startPlayback handle=" + this.phandle + " inputStream=" + this.inputStream + " sample_rate=" + this.getSamplingRate());
    }

    @Override
    public void stopPlayback() {
        ResourceStore.toLog("stopPlayback handle=" + this.phandle + " rhandle=" + this.rhandle);
        this.inputStream = null;
        if (this.phandle != 0L) {
            this.stopPlayback(this.phandle, this.rhandle == 0L);
        }
        ResourceStore.toLog("stopPlayback handle=" + this.phandle);
    }

    @Override
    public void setCaptureAGC(boolean mode) {
        this.spRecord.setAGC(mode ? this.agcRecordMode : -1);
    }

    @Override
    public void setPlaybackAGC(boolean mode) {
        this.spPlayback.setAGC(mode ? this.agcPlaybackMode : -1);
    }

    @Override
    public void setAEC(int mode) {
        if (mode == 0) {
            mode = this.stream_delay_ms;
        }
        this.spRecord.setEchoCancellation(mode);
    }

    @Override
    public int getPlaybackStreamLevel() {
        return 0;
    }

    @Override
    public int getCaptureStreamLevel() {
        return 0;
    }

    @Override
    public void setMute(boolean value) {
        this.mute = value;
        this.spRecord.reset();
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    @Override
    public void setVAD(boolean mode) {
        this.vadMode = mode;
        this.spRecord.setVAD(mode ? 1 : 0);
    }

    static {
        try {
            System.load(SignalProcessor.nativeLibraryPathPrefix + "audio" + SignalProcessor.nativeLibrarySuffix);
            ResourceStore.syslog("Library : " + SignalProcessor.nativeLibraryPathPrefix + "audio" + SignalProcessor.nativeLibrarySuffix + " is loaded");
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            try {
                System.loadLibrary("audio");
            }
            catch (Throwable err) {
                System.out.println(err);
            }
        }
    }
}

