/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.ios;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineEventListener;
import smile.cti.client.LineInfo;
import smile.cti.client.ServiceManager;
import smile.util.ResourceStore;

public class CallKitAdapter
implements LineEventListener {
    private ServiceManager serviceManager;
    private Map activeCalls = new HashMap();
    private Map callsOnHold = new HashMap();
    private String gsmCallNumber;

    public CallKitAdapter(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        String name = serviceManager.getApplicationName();
        String image = "Callkit";
        boolean recents = !Boolean.FALSE.equals(serviceManager.getProperty("includesCallsInRecents"));
        String sound = (String)serviceManager.getProperty("ringtoneSound");
        if (sound == null || sound.equals("Default")) {
            sound = "";
        }
        this.init(name, image, sound, recents);
    }

    @Override
    public void stateChanged(LineInfo lineInfo) {
        switch (lineInfo.getState()) {
            case 2: {
                this.incomingCall(lineInfo);
                break;
            }
            case 1: {
                this.outgoingCall(lineInfo);
                break;
            }
            case 3: 
            case 5: {
                this.callConnected(lineInfo);
                break;
            }
            case 9: {
                this.callResumed(lineInfo);
                break;
            }
            case 0: 
            case 8: {
                this.callEnded(lineInfo);
            }
        }
    }

    @Override
    public void identityChanged(LineInfo lineInfo) {
        for (String id : this.activeCalls.keySet()) {
            if (!lineInfo.equals(this.activeCalls.get(id))) continue;
            String number = lineInfo.getConnectedNumber();
            ContactInfo contactInfo = this.serviceManager.findContactInPhone(number);
            String name = this.getNameString(lineInfo, contactInfo);
            if (contactInfo != null) {
                number = name;
            }
            this.callUpdated(id, number, name, lineInfo.isVideoEnabled());
            ResourceStore.toLog("callUpdated uuid=" + id + " line=" + lineInfo.getName() + " name=" + name + " number=" + number + " pnum=" + lineInfo.getPartyNumber() + " cname=" + lineInfo.getCallerName() + " contact=" + contactInfo);
            break;
        }
    }

    @Override
    public void setRecording(LineInfo lineInfo, boolean b) {
    }

    public void reportIncomingCall(String number) {
        String uuid = this.incomingCall(number, number, false);
        ResourceStore.toLog("reportIncomingCall uuid=" + uuid + " number=" + number);
    }

    public void incomingCall(LineInfo lineInfo) {
        String number = lineInfo.getConnectedNumber();
        ContactInfo contactInfo = this.serviceManager.findContactInPhone(number);
        String name = this.getNameString(lineInfo, contactInfo);
        if (contactInfo != null) {
            number = name;
        }
        String uuid = null;
        for (String str : this.activeCalls.keySet()) {
            if (!lineInfo.equals(this.activeCalls.get(str))) continue;
            uuid = str;
            break;
        }
        if (uuid == null || lineInfo.getCallId() == null) {
            uuid = this.incomingCall(number, name, lineInfo.isVideoEnabled());
            this.activeCalls.put(uuid, lineInfo);
            ResourceStore.toLog("incomingCall uuid=" + uuid + " line=" + lineInfo.getName() + " name=" + name + " number=" + number + " pnum=" + lineInfo.getPartyNumber() + " cname=" + lineInfo.getCallerName() + " contact=" + contactInfo);
        }
    }

    private void outgoingCall(LineInfo lineInfo) {
        if (this.activeCalls.containsValue(lineInfo)) {
            return;
        }
        String number = lineInfo.getConnectedNumber();
        int n = number.indexOf(44);
        if (n != -1) {
            number = number.substring(0, n);
        }
        String name = this.normalizeName(lineInfo.toString());
        String uuid = this.outgoingCall(number, name);
        this.activeCalls.put(uuid, lineInfo);
        ResourceStore.toLog("outgoingCall uuid=" + uuid + " lineInfo=" + lineInfo);
    }

    private String normalizeName(String name) {
        return name.replaceAll("[^\\p{L}\\p{N}\\p{P}\\p{Z}\\p{S}]", "").replaceAll("[\ud83c\udf00-\ud83d\ude4f]|[\ud83d\ude80-\ud83d\udeff]", "");
    }

    private String getNameString(LineInfo lineInfo, ContactInfo contactInfo) {
        String trunkName;
        String number = lineInfo.getConnectedNumber();
        Object name = lineInfo.getPartyName();
        String pnum = lineInfo.getPartyNumber();
        if (!this.serviceManager.isInternalNumber(number)) {
            if (!((String)name).endsWith(pnum)) {
                name = (String)name + " (" + pnum + ")";
            } else if (contactInfo != null) {
                if (((String)name).equals(pnum)) {
                    name = contactInfo.getName() + " (" + pnum + ")";
                } else {
                    int n = ((String)name).indexOf(pnum);
                    if (number.equals(((String)name).substring(n + 1))) {
                        name = ((String)name).substring(0, n) + contactInfo.getName() + " (" + pnum + ")";
                    }
                }
            }
        }
        if ((trunkName = this.serviceManager.getTrunkName(lineInfo.getCalledName(), false)) != null) {
            name = (String)name + " \u2794 " + trunkName;
        }
        return this.normalizeName((String)name);
    }

    private void callConnected(LineInfo lineInfo) {
        LineInfo lineInfo1;
        Iterator itr = this.activeCalls.keySet().iterator();
        ResourceStore.toLog("callConnected lineInfo=" + lineInfo + " callid=" + lineInfo.getCallId() + " activeCalls=" + this.activeCalls + " callsOnHold=" + this.callsOnHold + " prevstate=" + lineInfo.getPreviousState());
        String id = null;
        while (itr.hasNext()) {
            String uuid = (String)itr.next();
            if (lineInfo.equals(this.activeCalls.get(uuid))) {
                if (lineInfo.getCallId() != null) {
                    id = uuid;
                    continue;
                }
                this.callEnded(uuid, 4);
                continue;
            }
            if (this.callsOnHold.containsKey(uuid) || (lineInfo1 = (LineInfo)this.activeCalls.get(uuid)) != null && lineInfo1.getState() == 2) continue;
            this.holdAction(uuid, true);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (id != null) {
            if (this.callsOnHold.remove(id) == null) {
                int previousState = lineInfo.getPreviousState();
                if (previousState == 3 || previousState == 5) {
                    String number = lineInfo.getConnectedNumber();
                    String name = this.normalizeName(lineInfo.getPartyName());
                    this.callUpdated(id, number, name, lineInfo.isVideoEnabled());
                } else if (!lineInfo.isInbound()) {
                    this.callConnected(id);
                }
            } else {
                this.holdAction(id, false);
            }
            if (lineInfo.getConnectedNumber().startsWith("PICKUP*")) {
                for (String uuid : this.activeCalls.keySet()) {
                    lineInfo1 = (LineInfo)this.activeCalls.get(uuid);
                    if (lineInfo1.getState() != 2) continue;
                    this.activeCalls.put(uuid, lineInfo);
                    this.callConnected(uuid);
                    break;
                }
            }
        }
    }

    private void callResumed(LineInfo lineInfo) {
        ResourceStore.toLog("callResumed lineInfo=" + lineInfo + " activeCalls=" + this.activeCalls + " callsOnHold=" + this.callsOnHold);
        for (String uuid : this.activeCalls.keySet()) {
            if (!lineInfo.equals(this.callsOnHold.get(uuid))) continue;
            this.callsOnHold.remove(uuid);
            this.holdAction(uuid, false);
            break;
        }
    }

    private void callEnded(LineInfo lineInfo) {
        ResourceStore.toLog("callEnded activeCalls=" + this.activeCalls + " lineInfo=" + lineInfo);
        ArrayList<String> toremove = new ArrayList<String>();
        for (String uuid : this.activeCalls.keySet()) {
            if (!lineInfo.equals(this.activeCalls.get(uuid))) continue;
            toremove.add(uuid);
        }
        int cause = lineInfo.isInbound() || lineInfo.getConnectionTime() > 0 ? 2 : 3;
        for (int i = 0; i < toremove.size(); ++i) {
            String uuid = (String)toremove.get(i);
            this.callEnded(uuid, cause);
            this.activeCalls.remove(uuid);
            this.callsOnHold.remove(uuid);
        }
    }

    private String getCalledPartyName(String uuid) {
        LineInfo lineInfo = (LineInfo)this.activeCalls.get(uuid);
        if (lineInfo == null) {
            return null;
        }
        String name = lineInfo.toString();
        name = name.replaceAll("[^\\p{L}\\p{N}\\p{P}\\p{Z}\\p{S}]", "");
        return name;
    }

    private void answerCall(String uuid) {
        LineInfo lineInfo = (LineInfo)this.activeCalls.get(uuid);
        ResourceStore.toLog("answerCall uuid=" + uuid + " lineInfo=" + lineInfo);
        if (lineInfo != null) {
            this.serviceManager.answerCall(lineInfo.getName(), false);
        }
    }

    private void dropCall(String uuid) {
        LineInfo lineInfo = (LineInfo)this.activeCalls.remove(uuid);
        if (lineInfo != null && !this.activeCalls.containsValue(lineInfo)) {
            this.serviceManager.dropCall(lineInfo);
        }
        this.callsOnHold.remove(uuid);
        ResourceStore.toLog("dropCall uuid=" + uuid + " lineInfo=" + lineInfo + " activeCalls=" + this.activeCalls);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void unmute() {
        Iterator itr = this.activeCalls.keySet().iterator();
        while (itr.hasNext()) {
            this.muteAction((String)itr.next(), false);
        }
    }

    private void setMute(String uuid, boolean mute) {
        LineInfo lineInfo = (LineInfo)this.activeCalls.get(uuid);
        if (lineInfo != null) {
            lineInfo.setMute(mute);
            this.serviceManager.onMute(mute);
        }
        ResourceStore.toLog("setMute " + mute + " lineInfo=" + lineInfo);
    }

    private void setHold(String uuid, boolean onhold) {
        LineInfo lineInfo = (LineInfo)this.activeCalls.get(uuid);
        if (lineInfo != null) {
            ResourceStore.toLog("setHold activeCalls=" + this.activeCalls + " callsOnHold=" + this.callsOnHold + " uuid=" + uuid + " lineInfo=" + lineInfo + " state=" + lineInfo.getState() + " onhold=" + onhold + " conf=" + lineInfo.isConference());
            if (onhold != this.callsOnHold.containsKey(uuid)) {
                if (this.activeCalls.size() == 1) {
                    if (onhold != (lineInfo.getState() == 4) && !lineInfo.isConference()) {
                        if (onhold) {
                            this.serviceManager.holdCall(lineInfo.getName());
                        } else {
                            this.serviceManager.resumeCall(lineInfo.getName());
                        }
                    }
                } else if (!onhold) {
                    this.serviceManager.setActiveLine(lineInfo.getName());
                }
                if (onhold) {
                    this.callsOnHold.put(uuid, lineInfo);
                } else {
                    this.callsOnHold.remove(uuid);
                }
            }
        }
    }

    private void completionError(String uuid, int code) {
        LineInfo lineInfo = (LineInfo)this.activeCalls.get(uuid);
        ResourceStore.toLog("line " + lineInfo + " uuid=" + uuid + " completionError=" + code);
        if (lineInfo != null && (code == 3 || code == 4)) {
            if (lineInfo.getCallId() != null) {
                this.serviceManager.dropCall(lineInfo);
                this.activeCalls.remove(uuid);
            } else {
                this.serviceManager.rejectCall(lineInfo);
                this.callEnded(uuid, 3);
            }
        }
    }

    private void setAudioState(boolean on) {
        ResourceStore.toLog("setAudioState activeCalls=" + this.activeCalls + " state=" + on);
        this.serviceManager.setAudioSessionState(on);
    }

    private void sendDTMF(String digits) {
        ResourceStore.toLog("sendDTMF digits=" + digits);
        for (int i = 0; i < digits.length(); ++i) {
            this.serviceManager.processActionKey(digits.charAt(i));
        }
    }

    private void callStateChanged(String uuid, int state) {
        block4: {
            block5: {
                block3: {
                    LineInfo lineInfo = (LineInfo)this.activeCalls.get(uuid);
                    ResourceStore.toLog("callStateChanged line " + lineInfo + " uuid=" + uuid + " state=" + state + " callsOnHold=" + this.callsOnHold);
                    if (lineInfo == null) break block3;
                    if (state == 8) {
                        this.activeCalls.remove(uuid);
                        this.callsOnHold.remove(uuid);
                        this.serviceManager.dropCall(lineInfo);
                    }
                    if (state != 3) break block4;
                    this.serviceManager.setAutoconnect(lineInfo);
                    break block4;
                }
                if (this.gsmCallNumber == null) break block5;
                ResourceStore.toLog("GSM call to " + this.gsmCallNumber + " state=" + state);
                if (state != 1) break block4;
                this.serviceManager.logGSMCall(this.gsmCallNumber, 0);
                this.gsmCallNumber = null;
                break block4;
            }
            if (state == 8) {
                for (LineInfo line : this.callsOnHold.values()) {
                    if (!line.isConference()) continue;
                    line.setState(9);
                    break;
                }
            }
        }
    }

    private void groupCall(String uuid, String uuid2) {
        LineInfo lineInfo = (LineInfo)this.activeCalls.get(uuid);
        ResourceStore.toLog("groupCall line " + lineInfo + " uuid=" + uuid + " line2=" + this.activeCalls.get(uuid2) + " uuid2=" + uuid2);
    }

    public void setGSMCall(String number) {
        this.gsmCallNumber = number;
    }

    private native void init(String var1, String var2, String var3, boolean var4);

    private native String incomingCall(String var1, String var2, boolean var3);

    private native String outgoingCall(String var1, String var2);

    private native String callConnected(String var1);

    private native String callUpdated(String var1, String var2, String var3, boolean var4);

    private native String holdAction(String var1, boolean var2);

    private native String muteAction(String var1, boolean var2);

    private native String callEnded(String var1, int var2);

    public native void setRingtoneSound(String var1);

    public native void includeCallsInRecents(boolean var1);

    static {
        try {
            System.loadLibrary("callkit");
        }
        catch (Throwable err) {
            ResourceStore.toLog("CallKitAdapter - " + err.getLocalizedMessage());
        }
    }
}

