/*
 * Decompiled with CFR 0.152.
 */
package org.json.smile;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.json.smile.JSONException;
import org.json.smile.JSONObject;

public class Utility {
    public static String encodeURLParameters(Map<String, Object> params) throws UnsupportedEncodingException {
        if (params == null) {
            return "";
        }
        String encoding = System.getProperty("file.encoding");
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String key : params.keySet()) {
            if (!isFirst) {
                sb.append('&');
            } else {
                isFirst = false;
            }
            sb.append(URLEncoder.encode(key, encoding));
            sb.append('=');
            sb.append(URLEncoder.encode(params.get(key).toString(), encoding));
        }
        return sb.toString();
    }

    public static String openUrl(String urlStr, String method, Map<String, Object> postArgs) throws IOException, MalformedURLException {
        String response;
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", System.getProperties().getProperty("http.agent") + " FacebookJavaSDK");
        connection.setRequestMethod(method);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        if (!method.equals("GET")) {
            if (!postArgs.containsKey("method")) {
                postArgs.put("method", method);
            }
            String encodedPostArgs = Utility.encodeURLParameters(postArgs);
            DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
            dos.writeBytes(encodedPostArgs);
            dos.flush();
            dos.close();
        }
        try {
            response = Utility.read(connection.getInputStream());
        }
        catch (Exception e) {
            response = Utility.read(connection.getErrorStream());
        }
        connection.disconnect();
        return response;
    }

    private static String read(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"), 1000);
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            line = br.readLine();
        }
        in.close();
        return sb.toString();
    }

    public static JSONObject parseJson(String response) throws JSONException {
        if (response.startsWith("[")) {
            response = response.substring(1);
        }
        if (response.equals("false")) {
            throw new JSONException("request failed");
        }
        if (response.equals("true")) {
            response = "{value : true}";
        }
        JSONObject json = new JSONObject(response);
        return json;
    }
}

