/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;
import smile.cti.client.Activity;
import smile.cti.client.ClientEventListener;
import smile.cti.client.CloudFile;
import smile.cti.client.ContactGroup;
import smile.cti.client.ContactInfo;
import smile.cti.client.EmailInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.IvieServiceManager;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.PbxServiceManager;
import smile.cti.client.ServiceContactsListener;
import smile.cti.client.ServiceManager;
import smile.cti.client.SessionInfo;
import smile.cti.client.UnifiedServiceManager;
import smile.cti.phone.PhoneDevice;
import smile.cti.phone.video.DisplayPane;
import smile.util.RedirectionException;
import smile.util.Utils;

public class ClientConnector {
    public static final int SIP_TV_MODE = 0;
    public static final int IVIE_MODE = 1;
    public static final int PBX_MODE = 2;
    public static final int NEED_SIGNUP = 0;
    public static final int NEED_SIGNIN = 1;
    public static final int SIGNED_IN = 2;
    private static ClientConnector connector;
    private String appname;
    private String terminalId;
    private String terminalInfo;
    private String productTitle;
    private String serverAddress;
    private String countryCode;
    private ServiceManager service;
    private ClientEventListener uiClient;
    private File cache_dir;
    private File files_dir;
    private File audio_dir;
    private File video_dir;
    private File images_dir;
    private File avatars_dir;
    private File docs_dir;
    private File temp_dir;
    private long signingIn;
    public static final String BILLING_BALANCE = "AccountBalance";
    public static final String BILLING_HISTORY = "AccountHistory";
    public static final String BILLING_PAYMENTS = "AccountPayments";
    public static final String BILLING_TARIFFS = "AccountTariffs";

    public static synchronized ClientConnector getInstance(String app) throws Exception {
        if (connector == null) {
            connector = new ClientConnector(app, 0);
        }
        return connector;
    }

    public static synchronized ClientConnector getInstance(String app, String key) throws Exception {
        if (connector == null) {
            int mode = key.toLowerCase().startsWith("p") ? 2 : 1;
            connector = new ClientConnector(app, mode);
        }
        return connector;
    }

    private ClientConnector(String app, int mode) throws Exception {
        this.appname = app;
        if (mode == 1) {
            this.productTitle = "iVie";
            this.service = new IvieServiceManager(this);
        } else if (mode == 2) {
            this.productTitle = "Ringotel";
            this.service = new PbxServiceManager(this);
        } else {
            this.productTitle = "Ringotel";
            this.service = new UnifiedServiceManager(this);
        }
        this.cache_dir = new File(this.service.getHomeDir(), "cache");
        if (!this.cache_dir.exists()) {
            this.cache_dir.mkdir();
        }
        this.files_dir = this.cache_dir;
        this.audio_dir = this.cache_dir;
        this.video_dir = this.cache_dir;
        this.images_dir = this.cache_dir;
        this.avatars_dir = this.cache_dir;
        this.docs_dir = this.cache_dir;
    }

    protected String getApplicationName() {
        return this.appname;
    }

    public void setWritelog(boolean b) {
        this.service.setWritelog(b);
    }

    public File getFilesDir() {
        return this.files_dir;
    }

    protected File getVideoDir() {
        return this.video_dir;
    }

    protected File getAudioDir() {
        return this.audio_dir;
    }

    protected File getAvatarsDir() {
        return this.avatars_dir;
    }

    protected File getDocumentsDir() {
        return this.docs_dir;
    }

    public File getImagesDir() {
        return this.images_dir;
    }

    public File getCacheDir() {
        return this.cache_dir;
    }

    protected File getTempDir() {
        if (this.temp_dir == null) {
            this.temp_dir = new File(this.cache_dir, "tmp");
            if (!this.temp_dir.exists()) {
                this.temp_dir.mkdir();
            }
        }
        return this.temp_dir;
    }

    protected File getFileDir(FileInfo fileInfo) {
        File dir = this.files_dir;
        if (fileInfo.isAudio()) {
            dir = this.audio_dir;
        } else if (fileInfo.isVideo()) {
            dir = this.video_dir;
        } else if (fileInfo.isImage()) {
            dir = this.images_dir;
        }
        return dir;
    }

    public void setTempDir(File dir) {
        this.temp_dir = dir;
    }

    public void setCacheDir(File dir) {
        this.cache_dir = dir;
    }

    public void setFilesDir(File dir) {
        this.files_dir = dir;
    }

    public void setVideoDir(File dir) {
        this.video_dir = dir;
    }

    public void setAudioDir(File dir) {
        this.audio_dir = dir;
    }

    public void setImagesDir(File dir) {
        this.images_dir = dir;
    }

    public void setAvatarsDir(File dir) {
        this.avatars_dir = dir;
    }

    public void setDocumentsDir(File dir) {
        this.docs_dir = dir;
    }

    public void setSystemSoundsDir(String path) {
        this.service.setSystemSoundsDir(path);
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String address) {
        this.serverAddress = address;
    }

    public void setClientEventListener(ClientEventListener listener) {
        this.uiClient = listener;
    }

    public String getProductTitle() {
        return this.productTitle + " (" + this.terminalId + ") " + this.terminalInfo;
    }

    public void setDeviceInfo(String info) {
        this.terminalInfo = info;
    }

    public void setTerminalId(String id) {
        this.terminalId = id;
    }

    public void setCountryCode(String code) {
        this.countryCode = code;
    }

    public void applicationStateChanged(boolean active) {
        this.service.applicationStateChanged(active);
    }

    public void networkConnectionChanged() {
        this.service.reconnect();
    }

    public List<Map> getDevices() throws Exception {
        return this.service.getDevices();
    }

    public String getConnectedDeviceInfo() {
        return this.service.getConnectedDeviceInfo();
    }

    public void deleteDevice() throws Exception {
        this.service.deleteUser(this.terminalId);
    }

    public void deleteDevice(String termid) throws Exception {
        this.service.deleteUser(termid);
    }

    public void deleteUser() throws Exception {
        this.service.deleteUser(null);
    }

    public String getUserId() {
        return this.service.getUserId();
    }

    public int getUserState() {
        return this.service.getUserState();
    }

    public ContactInfo getUserInfo() {
        return this.getUserInfo(true);
    }

    public ContactInfo getUserInfo(boolean reload) {
        return this.service.getUserInfo(reload);
    }

    public void setUserInfo(ContactInfo contact, boolean withImage) throws Exception {
        this.service.setUserInfo(contact, withImage);
    }

    public List<LineInfo> getLines() {
        return this.service.getLines();
    }

    public List<String> getLineNames() {
        return this.service.getLineNames();
    }

    public LineInfo getLine(String name) {
        return this.service.getLine(name);
    }

    public Collection getContactListNames() {
        return this.service.getContactGroupNames();
    }

    public String createContactList(String name, List members) throws Exception {
        return this.service.createContactGroup(name, members);
    }

    public void updateContactList(String id, String name, List members) throws Exception {
        this.service.updateContactGroup(id, name, members);
    }

    public void deleteContactList(String id) throws Exception {
        this.service.deleteContactGroup(id);
    }

    public String getContactListId(String name) {
        return this.service.getContactGroupId(name);
    }

    public List getContactList(String name) {
        return this.service.getContactGroupList(name);
    }

    public void addToContactList(ContactInfo contactInfo, String name) {
        this.service.addToGroup(contactInfo, name);
    }

    public void removeFromContactList(ContactInfo contactInfo, String name) {
        this.service.removeFromGroup(contactInfo, name);
    }

    public List<ContactInfo> getContacts() {
        return this.service.getContacts();
    }

    public List getContacts(String groupName) {
        return this.service.getContacts(groupName);
    }

    public List<SessionInfo> getSessions() {
        return this.service.getSessions("");
    }

    public List getSessions(String prefix) {
        return this.service.getSessions(prefix);
    }

    public Object getServiceProperty(String key) {
        return this.service.getServiceProperty(key);
    }

    public Map getProperties() {
        return this.service.getProperties();
    }

    public Object getProperty(String key) {
        return this.service.getProperty(key);
    }

    public void setProperty(String key, Object value) throws Exception {
        this.service.setProperty(key, value, true);
    }

    public void setProperties(Map properties) throws Exception {
        for (String key : properties.keySet()) {
            this.service.setProperty(key, properties.get(key), false);
        }
        this.service.setDeviceProperties();
        this.service.saveProperties();
    }

    public void setOptions(Map options) throws Exception {
        this.service.setOwnerProperties(options);
    }

    public Map getOptions() {
        return this.service.getOwnerProperties();
    }

    public void setAssistentPhone(String number) throws Exception {
        this.service.setAssistentPhone(number);
    }

    public void getContactInfo(ContactInfo contact) throws Exception {
        this.service.getContactInfo(contact);
    }

    public ContactInfo getContactInfo(String userid) {
        return this.service.findContact(userid);
    }

    public ContactInfo getContact(String contactid, String ownerid) throws Exception {
        return this.service.getContact(contactid, ownerid);
    }

    public void changePassword(String oldpass, String newpass) throws Exception {
        this.service.changePassword(oldpass, newpass);
    }

    public void updateUserInfo(Map properties) throws Exception {
        this.service.updatePersonalInfo(properties);
    }

    public Map getQRCodeInfo(File file) throws Exception {
        return this.service.getQRCodeInfo(file);
    }

    public Map codeRequest(Map params) throws Exception {
        return this.service.codeRequest(this.serverAddress, params);
    }

    public Map resetPassword(Map params) throws Exception {
        return this.service.resetPassword(this.serverAddress, params);
    }

    public void addUserContact(Map params) throws Exception {
        this.service.addUserContact(params);
    }

    public void updateUserContact(Map params) throws Exception {
        this.service.updateUserContact(params);
    }

    public void removeUserContact(Map params) throws Exception {
        this.service.removeUserContact(params);
    }

    public Map findLogin(String login) throws Exception {
        return this.service.findLogin(this.serverAddress, login);
    }

    public Map signUp(Map params) throws Exception {
        return this.service.signUp(this.serverAddress, params);
    }

    public boolean signIn() throws Exception {
        return this.service.signIn(this.serverAddress) >= 2;
    }

    public boolean signIn(String login, char[] password, String proxy, boolean save) throws Exception {
        return this.signIn(this.serverAddress, login, password, proxy, save);
    }

    private boolean signIn(String address, String login, char[] password, String proxy, boolean save) throws Exception {
        return this.service.logIn(address, login, password, proxy, save);
    }

    public boolean signOut(boolean b) {
        return this.service.onExit(true, b);
    }

    public boolean onExit(boolean unreg) {
        this.signingIn = 0L;
        return this.service.onExit(unreg);
    }

    public boolean onExit() {
        return this.service.onExit(true);
    }

    public void reconnect() {
        this.service.reconnect();
    }

    public void setState(int state, String note) throws Exception {
        this.service.sendState(state, note, -1, this.terminalId);
    }

    public void setState(int state, String note, int timeout) throws Exception {
        this.service.sendState(state, note, timeout, this.terminalId);
    }

    public int init(boolean forceReconnect) throws Exception {
        long now = System.currentTimeMillis();
        if (now - this.signingIn < 10000L) {
            return 3;
        }
        this.signingIn = now;
        int result = this.service.signIn(this.serverAddress, forceReconnect);
        if (result != 3) {
            this.signingIn = 0L;
        }
        return result;
    }

    public List<MessageInfo> getMessages(SessionInfo session) {
        return this.service.getMessages(session);
    }

    public void loadPreviousMessages(SessionInfo session) {
        this.loadPreviousMessages(session, 0L);
    }

    public void loadPreviousMessages(SessionInfo session, long till) {
        this.service.loadPreviousMessages(session, till);
    }

    public List<MessageInfo> findMessages(SessionInfo session, Map prms) throws Exception {
        return this.service.findMessages(session, prms);
    }

    public List<FileInfo> getImages(SessionInfo sessionInfo) {
        return this.service.getImages(sessionInfo);
    }

    public SessionInfo getSession(ContactInfo contactInfo) {
        return this.service.getSession(contactInfo);
    }

    public SessionInfo getSession(Collection<ContactInfo> contacts) throws Exception {
        return this.service.getSession(contacts);
    }

    public SessionInfo getSession(ContactGroup group) {
        return this.service.getSession(group);
    }

    public SessionInfo getSession(String id) {
        return this.service.getSession(id);
    }

    public long getLocalTime(long timestamp) {
        return this.service.getLocalTime(timestamp);
    }

    public long getServerTime() {
        return this.service.getServerTime();
    }

    public long getLocalTimeOffset() {
        return this.service.getLocalTimeOffset();
    }

    public void setRecordingState(boolean rec) throws Exception {
        this.service.sendRecordingStateRequest(rec);
    }

    public void uploadContacts(Collection<ContactInfo> contactList, boolean shared) {
        this.service.uploadContacts(contactList, shared);
    }

    public void setContactInfo(ContactInfo contact, boolean withImage) throws Exception {
        this.service.setContactInfo(contact, withImage);
    }

    public void createContact(ContactInfo contact, boolean shared) throws Exception {
        this.service.createContact(contact, shared);
    }

    public void shareContact(ContactInfo contact) throws Exception {
        this.service.shareContact(contact);
    }

    public void deleteContact(ContactInfo contact) throws Exception {
        Vector<ContactInfo> list = new Vector<ContactInfo>();
        list.add(contact);
        SessionInfo session = this.service.findSession(list);
        if (session != null) {
            this.deleteSession(session);
        }
        this.service.deleteContact(contact);
    }

    public void blockContact(ContactInfo contact) throws Exception {
        this.service.blockContact(contact);
        Vector<ContactInfo> list = new Vector<ContactInfo>();
        list.add(contact);
        SessionInfo session = this.service.findSession(list);
        if (session != null) {
            this.closeSession(session);
        }
    }

    public void unblockContact(ContactInfo contact) throws Exception {
        this.service.unblockContact(contact);
        Vector<ContactInfo> list = new Vector<ContactInfo>();
        list.add(contact);
        SessionInfo session = this.service.findSession(list);
        if (session != null) {
            try {
                this.service.openSession(session);
                return;
            }
            catch (Exception e) {
                this.service.toLog("openSession " + session + " - " + e);
            }
        }
        this.createSession(list, null);
    }

    public ContactInfo setSpeedDialContact(String name, String number) throws Exception {
        return this.service.setSpeedDialContact(name, number);
    }

    public void deleteSpeedDialContact(ContactInfo contact) throws Exception {
        this.service.deleteSpeedDialContact(contact);
    }

    public ContactInfo findContactByPhoneNumber(String number) {
        return this.service.findContactByPhoneNumber(number);
    }

    public List<ContactInfo> findContacts(Map prms) throws Exception {
        return this.service.findContacts(prms);
    }

    public List<ContactInfo> findContactsByTag(String text) {
        return this.service.findContactsByTag(text);
    }

    protected ContactInfo findContactByUserId(String userid) {
        return this.service.findContactByUserId(userid);
    }

    public ContactInfo getContact(String userid) {
        return this.service.findContactByUserId(userid);
    }

    public List<String> getTags() {
        return this.service.getTags();
    }

    public List<String> getActivitySubjects(int category) {
        return this.service.getActivitySubjects(category);
    }

    public void getActivities(ContactInfo contactInfo) throws Exception {
        this.service.getActivities(contactInfo);
    }

    public void createActivity(ContactInfo contactInfo, String type, String comment, long timedue) throws Exception {
        this.service.createActivity(contactInfo, type, comment, timedue);
    }

    public void updateActivity(Activity activity) throws Exception {
        String type = activity.getType();
        if (type.equals("inbound") || type.equals("outbound") || type.equals("missed") || type.equals("callback")) {
            this.service.updateCallInfo(activity);
        } else {
            this.service.updateActivity(activity, false);
        }
    }

    public void closeActivity(Activity activity) throws Exception {
        this.service.updateActivity(activity, true);
    }

    public ContactGroup getGroup(String id) {
        return this.service.getGroup(id);
    }

    public void updateContactStatus(ContactInfo contact, int status) throws Exception {
        this.service.updateContactStatus(contact, status);
    }

    public void updateContactsStatus(Collection<ContactInfo> contacts, int status) throws Exception {
        this.service.updateContactsStatus(contacts, status);
    }

    protected void connectionSet() {
        this.signingIn = 0L;
    }

    protected void initOk() {
        this.signingIn = 0L;
        if (this.uiClient != null) {
            this.uiClient.initOk();
        }
    }

    protected void initError(String description) {
        this.signingIn = 0L;
        if (this.uiClient != null) {
            this.uiClient.initError(description);
        }
    }

    public boolean hasActiveCalls() {
        return this.service.hasActiveCalls();
    }

    protected void commandReceived(String command, Map parameters) {
        if (this.uiClient != null) {
            this.uiClient.commandReceived(command, parameters);
        }
    }

    protected void contactAdded(ContactInfo contact) {
        if (this.uiClient != null) {
            this.uiClient.contactAdded(contact);
        }
    }

    protected void contactStatusChanged(ContactInfo contact) {
        if (this.uiClient != null) {
            this.uiClient.contactStatusChanged(contact);
        }
    }

    protected void contactImageChanged(ContactInfo contact) {
        if (this.uiClient != null) {
            this.uiClient.contactImageChanged(contact);
        }
    }

    protected void stateChanged(int state) {
        if (this.uiClient != null) {
            this.uiClient.stateChanged(state);
        }
    }

    protected void assistantStateChanged(int state, String name) {
        if (this.uiClient != null) {
            this.uiClient.assistantStateChanged(state, name);
        }
    }

    protected void assistantCallState(int state) {
        if (this.uiClient != null) {
            this.uiClient.assistantCallState(state);
        }
    }

    protected void sessionCreated(SessionInfo sessionInfo) {
        if (this.uiClient != null) {
            this.uiClient.sessionCreated(sessionInfo);
        }
    }

    protected void sessionUpdated(SessionInfo sessionInfo) {
        if (this.uiClient != null) {
            this.uiClient.sessionUpdated(sessionInfo);
        }
    }

    protected void messageReceived(MessageInfo messageInfo, SessionInfo sessionInfo) {
        if (this.uiClient != null) {
            this.uiClient.messageReceived(messageInfo, sessionInfo);
        }
    }

    protected void messageDeleted(MessageInfo messageInfo, SessionInfo sessionInfo) {
        if (this.uiClient != null) {
            this.uiClient.messageDeleted(messageInfo, sessionInfo);
        }
    }

    protected void messageUpdated(MessageInfo messageInfo, SessionInfo sessionInfo) {
        if (this.uiClient != null) {
            this.uiClient.messageUpdated(messageInfo, sessionInfo);
        }
    }

    protected void messageQueueUpdated(MessageInfo messageInfo) {
        if (this.uiClient != null) {
            this.uiClient.messageQueueUpdated(messageInfo);
        }
    }

    protected void fileLoaded(FileInfo fileInfo) {
        if (this.uiClient != null) {
            this.uiClient.fileLoaded(fileInfo);
        }
    }

    protected void groupAdded(ContactGroup group) {
        if (this.uiClient != null) {
            this.uiClient.groupAdded(group);
        }
    }

    protected void contactRemoved(ContactInfo contact) {
        if (this.uiClient != null) {
            this.uiClient.contactRemoved(contact);
        }
    }

    protected void groupRemoved(ContactGroup group) {
        if (this.uiClient != null) {
            this.uiClient.groupRemoved(group);
        }
    }

    protected void contactGroupsListChanged() {
        if (this.uiClient != null) {
            this.uiClient.contactGroupsListChanged();
        }
    }

    protected void contactListUploaded() {
        if (this.uiClient != null) {
            this.uiClient.contactListUploaded();
        }
    }

    protected void sessionDeleted(SessionInfo session) {
        if (this.uiClient != null) {
            this.uiClient.sessionDeleted(session);
        }
    }

    protected void searchUpdated() {
        if (this.uiClient != null) {
            this.uiClient.searchUpdated();
        }
    }

    protected ContactInfo findContact(String number) {
        return this.uiClient != null ? this.uiClient.findContact(number) : null;
    }

    public List<ContactInfo> findContacts(String text) throws Exception {
        if (text.startsWith("#")) {
            return this.findContactsByTag(text);
        }
        return this.findContacts(text, -1, 0);
    }

    public List<ContactInfo> findContacts(String text, int skip, int limit) throws Exception {
        return this.service.findContacts(text, skip, limit);
    }

    public int inviteContact(ContactInfo contact, String text) throws Exception {
        return this.service.inviteContact(contact, text);
    }

    public void sendContactAccept(String userid, String text) throws Exception {
        this.service.sendContactAccept(userid, text);
    }

    public void sendContactReject(String userid) throws Exception {
        this.service.sendContactReject(userid);
    }

    public List findInChats(String text, boolean ext) {
        return this.service.findInChats(text, ext);
    }

    public List findInCalls(String text, boolean ext) {
        return this.service.findInCalls(text, ext);
    }

    public List findInChatsExt(String text) throws Exception {
        return this.service.serverSearchMessages(text);
    }

    public List findInCallsExt(String text) throws Exception {
        return this.service.serverSearchCalls(text);
    }

    public void sendReminder(SessionInfo session, String text, long time) {
        this.service.sendReminder(session, text, time);
    }

    public void sendMessage(String text, SessionInfo session) {
        this.sendMessage(text, session, 0, null);
    }

    public void sendMessage(String text, SessionInfo session, int code, Collection mentions) {
        this.sendMessage(text, session, code, mentions, null);
    }

    public void sendMessage(String text, SessionInfo session, int code, Collection mentions, MessageInfo replied) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setContent(text, 1);
        if (text.indexOf("://") != -1 || text.indexOf("www.") != -1) {
            code |= 8;
        }
        if (code > 0) {
            messageInfo.setCode(code);
        }
        if (replied != null) {
            messageInfo.setRepliedMessage(replied);
        }
        messageInfo.setMentions(mentions);
        this.service.sendMessage(messageInfo, session);
    }

    public void sendMessage(MessageInfo messageInfo, SessionInfo sessionInfo) {
        this.service.sendMessage(messageInfo, sessionInfo);
    }

    public void sendMessage(MessageInfo messageInfo, ContactInfo contactInfo) {
        SessionInfo session = this.getSession(contactInfo);
        this.service.sendMessage(messageInfo, session);
    }

    public void sendMessage(String text, ContactInfo contact) {
        SessionInfo session;
        this.sendMessage(text, session, (session = this.getSession(contact)).getMessageLifetime() > 0 ? -1 : 0, null);
    }

    public void sendAdminMessage(String text, SessionInfo session) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setContent(text, 19);
        int code = 0;
        if (text.contains("://") || text.contains("www.")) {
            code |= 8;
        }
        if (code > 0) {
            messageInfo.setCode(code);
        }
        this.service.sendMessage(messageInfo, session);
    }

    public void sendContact(ContactInfo contact, SessionInfo session, int code) throws Exception {
        this.service.sendContact(contact, session, code);
    }

    public void sendFile(File file, FileTransferListener listener) throws Exception {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFile(file);
        fileInfo.addTransfrerListener(listener);
        this.service.putFile(fileInfo);
    }

    public int sendFile(String resourceName, File file) throws Exception {
        return this.service.putFile(resourceName, file);
    }

    public void sendAvatar(File file, FileTransferListener listener) throws Exception {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFile(file);
        fileInfo.addTransfrerListener(listener);
        this.service.putFile("$AVATAR$", file, fileInfo);
    }

    public void sendFile(File file, SessionInfo session, int code) {
        this.service.sendFile(file, session, code);
    }

    public void setVoicemailPrompt(File file) throws Exception {
        this.service.setVoicemailPrompt(file);
    }

    public void sendVoiceMessage(File file, SessionInfo session, int code) throws Exception {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFile(file);
        fileInfo.setContent(file.getName(), 13);
        fileInfo.setCode(code);
        this.service.sendMessage(fileInfo, session);
    }

    public void shareFile(String resourceName, SessionInfo session) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setContent(resourceName, 7);
        this.service.sendMessage(fileInfo, session);
    }

    public void shareFile(FileInfo fileInfo, SessionInfo session) throws Exception {
        FileInfo messageInfo = (FileInfo)fileInfo.clone();
        messageInfo.setRecepients(new ArrayList());
        messageInfo.setCode(0);
        messageInfo.setContent(fileInfo.getFilename(), 7);
        this.service.sendMessage(messageInfo, session);
    }

    public void sendRead(SessionInfo session) {
        this.service.sendRead(session);
    }

    public void clearMissedCallsIndication() {
        this.service.clearMissedCallsIndication();
    }

    public void sendTypingIndication(SessionInfo session, final boolean state) {
        final String sessionid = session.getSessionId();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ClientConnector.this.service.sendTypingIndication(sessionid, state);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public void updateMessage(SessionInfo session, MessageInfo message) throws Exception {
        this.service.updateMessage(session, message);
    }

    public void deleteMessage(SessionInfo session, MessageInfo message) throws Exception {
        this.service.deleteMessage(session, message);
    }

    public void deleteMessages(SessionInfo session) throws Exception {
        this.service.deleteMessages(session);
    }

    public void removeMessages(SessionInfo session, List<MessageInfo> messages) throws Exception {
        this.service.removeMessages(session, messages);
    }

    public void markMessages(SessionInfo session, List<MessageInfo> messages, int code) throws Exception {
        this.service.markMessages(session, messages, code);
    }

    public void removeCallHistory(String sessionid) throws Exception {
        this.service.removeCallHistory(sessionid);
    }

    public Map getMessageStatus(String messageid) throws Exception {
        return this.service.getMessageStatus(messageid);
    }

    public SessionInfo createSession(Collection<ContactInfo> contacts, String name) throws Exception {
        return this.service.createSession(contacts, name);
    }

    public SessionInfo createSession(Collection<ContactInfo> contacts, String name, int status) throws Exception {
        return this.service.createSession(contacts, name, status);
    }

    public SessionInfo createPublic(String name, Collection<ContactInfo> members, String description, File imageFile) throws Exception {
        return this.service.createPublic(name, members, description, imageFile);
    }

    public List<SessionInfo> getPublicSessions() throws Exception {
        return this.service.getPublicSessions();
    }

    public List<ContactInfo> getPublicMembers(SessionInfo session) throws Exception {
        return this.service.getPublicMembers(session);
    }

    public void setSessionProperty(SessionInfo session, String key, Object value) throws Exception {
        this.service.setSessionProperty(session, key, value);
    }

    public SessionInfo updateSession(SessionInfo session, int action, Collection<ContactInfo> contacts, boolean withImage) throws Exception {
        if (session == null || session.getSessionId() == null) {
            session = this.getSession(contacts);
        } else if (session.getStatus() <= 0 && (action == 0 || action == 1)) {
            Vector<ContactInfo> list = new Vector<ContactInfo>();
            Iterator<ContactInfo> itr = session.getParties().iterator();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
            for (ContactInfo contactInfo : contacts) {
                if (list.contains(contactInfo)) continue;
                list.add(contactInfo);
            }
            session = this.service.createSession(list, null, 3);
        } else {
            this.service.sendSessionUpdate(session, action, contacts, withImage);
        }
        return session;
    }

    public void closeSession(SessionInfo session) throws Exception {
        this.service.closeSession(session, false);
    }

    public void deleteSession(SessionInfo session) throws Exception {
        this.service.closeSession(session, true);
    }

    public void openSession(SessionInfo session) throws Exception {
        this.service.openSession(session);
    }

    public String createMeeting(SessionInfo sessionInfo, String serviceName) throws Exception {
        return this.service.createMeeting(sessionInfo, serviceName);
    }

    public void makePushCall(SessionInfo session) {
        this.service.makePushCall(session);
    }

    public void setIncomingCall(Map params, final boolean b) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    ClientConnector.this.init(b);
                }
                catch (Exception e) {
                    ClientConnector.this.service.toLog(e);
                }
            }
        };
        t.start();
        this.service.setIncomingCall(params);
    }

    public void answerCall(LineInfo line, boolean video) {
        this.service.answerCall(line.getName(), video);
    }

    public void answerCall(String lineName, boolean video) {
        this.service.answerCall(lineName, video);
    }

    public void dropCall(LineInfo line) {
        this.service.dropCall(line);
    }

    public void dropCall(LineInfo line, String number) {
        this.service.dropCall(line, number);
    }

    public void makeCall(String number) {
        this.service.makeCall(number);
    }

    public void makeVideoCall(String number) {
        this.service.makeVideoCall(number);
    }

    public void makeCall(String number, String trunk) {
        this.service.makeCall(number, trunk, false);
    }

    public void makeVideoCall(String number, String trunk) {
        this.service.makeCall(number, trunk, true);
    }

    public void makeCall(ContactInfo contactInfo) {
        this.service.makeCall(contactInfo, false);
    }

    public void makeVideoCall(ContactInfo contactInfo) {
        this.service.makeCall(contactInfo, true);
    }

    public void transferCall(LineInfo activeLine, LineInfo holdLine) {
        this.service.transferCall(activeLine.getName(), holdLine.getName());
    }

    public void transferCall(String number, String lineName) {
        this.service.transferCall(number, lineName);
    }

    public void transferCall(String number, LineInfo line) {
        this.service.transferCall(number, line);
    }

    public void transferCall(LineInfo line) {
        this.service.transferCall(line);
    }

    public void transferCall(String number) {
        this.service.transferCall(number);
    }

    public void transferCall(ContactInfo contactInfo) {
        this.service.transferCall(contactInfo);
    }

    public void holdCall(LineInfo line) {
        this.service.holdCall(line.getName());
    }

    public void holdCall() {
        this.service.holdCall();
    }

    public void resumeCall(LineInfo line) {
        this.service.resumeCall(line.getName());
    }

    public void resumeCall() {
        this.service.resumeCall();
    }

    public void makeCall(SessionInfo sessionInfo, boolean video) {
        this.service.makeCall(sessionInfo, video);
    }

    public void joinToConference(LineInfo holdLine) {
        this.service.joinToConference(holdLine.getName());
    }

    public void joinToConference(String number) {
        this.service.callToConference(number);
    }

    public void joinToConference(ContactInfo contactInfo) {
        this.service.joinToConference(contactInfo);
    }

    public void dropFromConference(ContactInfo contact) throws Exception {
        this.service.dropFromConference(contact);
    }

    public void addToConference(ContactInfo contact) throws Exception {
        this.service.addToConference(contact);
    }

    public boolean isConferenceOwner() {
        return this.service.isConferenceOwner();
    }

    public boolean canRecord() {
        return !Boolean.TRUE.equals(this.getUserInfo(false).getProperty("norec"));
    }

    public boolean canChat() {
        return !Boolean.TRUE.equals(this.getUserInfo(false).getProperty("nochats"));
    }

    public boolean canVideo() {
        return !Boolean.TRUE.equals(this.getUserInfo(false).getProperty("novideo"));
    }

    public boolean canChangeState() {
        return !Boolean.TRUE.equals(this.getUserInfo(false).getProperty("nostates"));
    }

    public boolean canSetPBXOptions() {
        return !Boolean.TRUE.equals(this.getUserInfo(false).getProperty("noptions"));
    }

    public boolean canSeeUsers() {
        return !Boolean.TRUE.equals(this.getUserInfo(false).getProperty("nousers"));
    }

    public boolean canPickup(ContactInfo contact) {
        return contact.callPickupAllowed() && this.service.getOwner().canCallPickup();
    }

    public boolean canBargein(ContactInfo contact) {
        return contact.callBargeinAllowed() && this.service.getOwner().canCallBargein();
    }

    public boolean canMonitor(ContactInfo contact) {
        return contact.callMonitorAllowed() && this.service.getOwner().canCallMonitor();
    }

    public void callPickup(ContactInfo contact) {
        if (this.service instanceof PbxServiceManager) {
            ((PbxServiceManager)this.service).callPickup(contact);
        }
    }

    public void callBargein(ContactInfo contact) {
        if (this.service instanceof PbxServiceManager) {
            ((PbxServiceManager)this.service).callBargein(contact);
        }
    }

    public void callMonitor(ContactInfo contact) {
        if (this.service instanceof PbxServiceManager) {
            ((PbxServiceManager)this.service).callMonitor(contact);
        }
    }

    public void setActiveLine(LineInfo line) {
        this.service.setActiveLine(line.getName());
    }

    public void sendDigit(char key) {
        this.service.processActionKey(key);
    }

    public void onWakeUp() throws Exception {
        this.service.onWakeUp();
    }

    public void setAudioSessionState(boolean b) {
        this.service.setAudioSessionState(b);
    }

    public void setAudioPlaybackChannel(String deviceName) throws Exception {
        this.service.setAudioPlaybackChannel(deviceName);
    }

    public String getAudioPlaybackChannel() {
        return this.service.getAudioPlaybackChannel();
    }

    public void setAudioPagingChannel(String name) throws Exception {
        this.service.setAudioPagingChannel(name);
    }

    public String getAudioPagingChannel() {
        return this.service.getAudioPagingChannel();
    }

    public void setAudioCaptureChannel(String name) throws Exception {
        this.service.setAudioCaptureChannel(name);
    }

    public String getAudioCaptureChannel() {
        return this.service.getAudioCaptureChannel();
    }

    public boolean playFile(File file, int fromSecond, int maxTime, String lineName) throws Exception {
        return this.service.playFile(file, fromSecond, maxTime, lineName);
    }

    public void callWaiting() {
        this.service.playTone("Call Waiting", false);
    }

    public void playTone(String toneid) {
        this.service.playTone(toneid, true);
    }

    public void stopPlay(String lineName) {
        this.service.stopPlay(lineName);
    }

    public void stopPlayRing() {
        this.service.stopPlayRing();
    }

    public void startRecord(OutputStream stream) {
        this.service.startRecord(stream);
    }

    public void stopRecord() {
        this.service.stopRecord();
    }

    public void startVideo() {
        this.service.startVideo();
    }

    public void stopVideo() {
        this.service.stopVideo();
    }

    public boolean isCapturing() {
        return this.service.isCapturing();
    }

    public void setCapturing(boolean mode) {
        this.service.setCapturing(mode);
    }

    public void setVideoMode(int mode) {
        this.service.setVideoMode(mode);
    }

    public int getVideoMode() {
        return this.service.getVideoMode();
    }

    public void setMute(boolean mode) {
        this.service.setMute(mode);
    }

    public boolean getMute() {
        return this.service.getMute();
    }

    public void setVAD(boolean mode) {
        this.service.setVAD(mode);
    }

    public void setPlaybackLevel(float level) {
        this.service.setPlaybackLevel(level);
    }

    public float getPlaybackLevel() {
        return this.service.getPlaybackLevel();
    }

    public float getRingLevel() {
        return this.service.getRingLevel();
    }

    public void setRingLevel(float level) {
        this.service.setRingLevel(level);
    }

    public void setRecordLevel(float level) {
        this.service.setRecordLevel(level);
    }

    public float getRecordLevel() {
        return this.service.getRecordLevel();
    }

    public void setDisplayChannel(DisplayPane display) {
        this.service.setDisplayChannel(display);
    }

    public void setLocalView(DisplayPane display) {
        this.service.setLocalView(display);
    }

    public List getCameraFormats(String chname) {
        return this.service.getCameraFormats(chname);
    }

    public String getCaptureFormat() {
        return this.service.getCaptureFormat();
    }

    public String setCaptureChannel(String chname, boolean landscape) throws Exception {
        return this.service.setCaptureChannel(chname, landscape);
    }

    public void setCaptureChannel(String deviceName, String format, String bitrate) throws Exception {
        this.service.setCaptureChannel(deviceName, format, bitrate);
    }

    public List getFiles(String user, String[] filters) throws Exception {
        return this.service.getFiles(user, filters);
    }

    public List<SessionInfo> getChats(String filter) {
        return this.service.getChats(filter);
    }

    public List<SessionInfo> getCalls(String filter) {
        return this.service.getCalls(filter);
    }

    public List<SessionInfo> getExternalSessions(int type, String filter) {
        return this.service.getExternalSessions(type, filter);
    }

    public void getRecord(String filename, FileTransferListener listener) {
        int n = filename.lastIndexOf("/");
        if (n != -1) {
            filename = filename.substring(n + 1);
        }
        final File file = new File(this.audio_dir, filename);
        final FileInfo fileInfo = new FileInfo();
        fileInfo.addTransfrerListener(listener);
        if (file.exists() && file.length() > 0L && !this.service.isLoading(file)) {
            fileInfo.setFile(file);
            fileInfo.setLoaded();
        } else {
            final String resource = "records/" + filename;
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (file.exists() && file.length() > 0L && !ClientConnector.this.service.isLoading(file)) {
                        fileInfo.setFile(file);
                        fileInfo.setLoaded();
                    } else {
                        fileInfo.setFileName(resource);
                        ClientConnector.this.service.loadFile(resource, file, fileInfo);
                    }
                }
            };
            Utils.getTimer().schedule(task, 3000L);
        }
    }

    public void loadFile(File file, FileTransferListener listener) {
        FileInfo fileInfo = new FileInfo();
        String filename = file instanceof CloudFile ? ((CloudFile)file).getResourceName() : file.getName();
        fileInfo.setFileName(filename);
        fileInfo.addTransfrerListener(listener);
        this.service.loadFile(fileInfo, filename);
    }

    public void loadFile(FileInfo fileInfo) {
        this.service.loadFile(fileInfo);
    }

    public void deleteFile(File file) throws Exception {
        if (file instanceof CloudFile) {
            this.service.deleteFile(((CloudFile)file).getResourceName());
        }
        file.delete();
    }

    public void deleteFile(FileInfo fileInfo) throws Exception {
        File file = fileInfo.getFile();
        if (file instanceof CloudFile) {
            this.service.deleteFile(((CloudFile)file).getResourceName());
        }
        file.delete();
    }

    public File getFile(FileInfo fileInfo) throws Exception {
        return this.service.getFile(fileInfo);
    }

    public void setAvatar(ContactInfo contact, File file) throws Exception {
        this.service.setAvatar(contact, file);
    }

    public void setAvatar(SessionInfo session, File file) throws Exception {
        this.service.setAvatar(session, file);
    }

    public File getAvatar(ContactInfo contact) {
        return this.service.getAvatar(contact);
    }

    public File getAvatar(SessionInfo session) {
        return this.service.getAvatar(session);
    }

    public void loadAvatar(ContactInfo contact) {
        this.service.loadAvatar(contact);
    }

    public void loadAvatar(SessionInfo session) {
        this.service.loadAvatar(session);
    }

    public void deleteAvatar() throws Exception {
        this.service.deleteAvatar();
    }

    public void deleteFiles() throws Exception {
        this.service.deleteFiles();
    }

    public SessionInfo getSessionInfo(String id) {
        return this.service.getSessionInfo(id);
    }

    public SessionInfo getSessionInfoByMessageId(String id) {
        return this.service.getSessionInfoByMessageId(id);
    }

    public MessageInfo getMessageInfo(String id) {
        return this.service.getMessageInfo(id);
    }

    public MessageInfo getMessageInfo(String id, String sessionid) {
        return this.service.getMessageInfo(id, sessionid);
    }

    public void removeMessageInfo(String id) {
        this.service.removeMessageInfo(id);
    }

    public SessionInfo getPostSession(Map commentInfo) {
        return this.service.getPostSession(commentInfo);
    }

    public SessionInfo getSession(ContactInfo contact, Activity activity) {
        return this.service.getSession(contact, activity);
    }

    public List<MessageInfo> getMessageQueue(String filter) {
        return this.service.getMessageQueue(filter);
    }

    public SessionInfo getChatRequest(MessageInfo message) throws Exception {
        return this.service.getChatRequest(message);
    }

    public SessionInfo acceptChatRequest(MessageInfo message) throws Exception {
        return this.service.acceptChatRequest(message);
    }

    public SessionInfo getActivitySession(MessageInfo message) throws Exception {
        return this.service.getActivitySession(message);
    }

    public void transferSession(SessionInfo sessionInfo, ContactInfo contactInfo) throws Exception {
        this.service.transferSession(sessionInfo, contactInfo);
    }

    public SessionInfo sendMail(SessionInfo session, String to, String cc, String bcc, String from, String subject, String text, String html, List<File> attachments, FileTransferListener listener) throws Exception {
        return this.service.sendMail(session, to, cc, bcc, from, subject, text, html, attachments, listener);
    }

    public String startSelectorConference(String confid, boolean video) {
        return this.service.startSelectorConference(confid, video);
    }

    public void conferenceAddParty(String confid, String userid) throws Exception {
        this.service.conferenceAddParty(confid, userid);
    }

    public void conferenceDropParty(String confid, String userid) throws Exception {
        this.service.conferenceDropParty(confid, userid);
    }

    public void conferenceSetSpeaker(String confid, String userid) throws Exception {
        this.service.conferenceSetSpeaker(confid, userid);
    }

    public void conferenceAddSpeaker(String confid, String userid) throws Exception {
        this.service.conferenceAddSpeaker(confid, userid);
    }

    public void conferenceRemoveSpeaker(String confid, String userid) throws Exception {
        this.service.conferenceRemoveSpeaker(confid, userid);
    }

    public void conferenceClose(String confid) throws Exception {
        this.service.conferenceClose(confid);
    }

    public void conferenceSetOptions(Map map) throws Exception {
        this.service.conferenceSetOptions(map);
    }

    public void addConferenceSpeaker(String user, String lineName) {
        this.service.addConferenceSpeaker(user, lineName);
    }

    public void removeConferenceSpeaker(String user, String lineName) {
        this.service.removeConferenceSpeaker(user, lineName);
    }

    public void setConferenceMainSpeaker(String user, String lineName) {
        this.service.setConferenceMainSpeaker(user, lineName);
    }

    public void setConferenceSpeakersMode(int mode, String lineName) {
        this.service.setConferenceSpeakersMode(mode, lineName);
    }

    public void setConferencePromptMode(int mode, String lineName) {
        this.service.setConferencePromptMode(mode, lineName);
    }

    public void setConferenceLayoutMode(int mode, String lineName) {
        this.service.setConferenceLayoutMode(mode, lineName);
    }

    public void setConferenceViewMode(int mode, String lineName) {
        this.service.setConferenceViewMode(mode, lineName);
    }

    public void setConferenceLayout(int mode, String lineName) {
        this.service.setConferenceLayout(mode, lineName);
    }

    public int getConferenceControlActions(int x, int y, String lineName) {
        return this.service.getConferenceControlActions(x, y, lineName);
    }

    public void setConferenceControl(int controlCode, String lineName) {
        this.service.setConferenceControl(controlCode, lineName);
    }

    public void setConferenceBitrate(int mode, String lineName) {
        this.service.setConferenceBitrate(mode, lineName);
    }

    public void conferenceUpdateRequest(String confid, String number) throws Exception {
        this.service.sendConferenceUpdateRequest(confid, number);
    }

    public void sendLineControl(String lineName, String actionCommand) {
        this.service.processActionCommand(lineName, actionCommand);
    }

    public List getTrunks() {
        return this.service.getTrunks();
    }

    public List getTrunks(String number) {
        return this.service.getTrunks(number);
    }

    public boolean isTrunkEnabled(String trunkNumber) {
        return this.service.isTrunkEnabled(trunkNumber);
    }

    public void makeSIPCall(String number, String trunk) {
        this.makeCall(number, trunk);
    }

    public String getDefaultSIPTrunk() {
        return this.service.getDefaultSIPTrunk();
    }

    public void setDefaultSIPTrunk(String deftrunk) {
        this.service.setDefaultSIPTrunk(deftrunk);
    }

    public List<String> getSIPTrunks() {
        return this.service.getSIPTrunks(null);
    }

    public List<Map> getSIPAccounts() throws Exception {
        return this.service.getSIPAccounts();
    }

    public Map setSIPAccount(Map params) throws Exception {
        return this.service.setSIPAccount(params);
    }

    public void setSIPAccountState(String id, int state) throws Exception {
        this.service.setSIPAccountState(id, state);
    }

    public void deleteSIPAccount(String id) throws Exception {
        this.service.deleteSIPAccount(id);
    }

    public List getSIPTrunksForSMS() {
        return this.service.getSIPTrunksForSMS();
    }

    public List getSIPTrunksForMMS() {
        return this.service.getSIPTrunksForMMS();
    }

    public List getSIPTrunksForSMS(SessionInfo sessionInfo) {
        return this.service.getSIPTrunksForSMS(sessionInfo);
    }

    public List getSIPTrunksForMMS(SessionInfo sessionInfo) {
        return this.service.getSIPTrunksForMMS(sessionInfo);
    }

    public Map getSIPCredentials(boolean resetPassword) throws Exception {
        return this.service.getSIPCredentials(resetPassword);
    }

    public List getEmailChannels() {
        return this.service.getEmailChannels();
    }

    public String setEmailChannel(Map map) throws Exception {
        return this.service.setEmailChannel(map);
    }

    public void deleteEmailChannel(String oid) throws Exception {
        this.service.deleteEmailChannel(oid);
    }

    public void setEmailSignature(String address, String signature) {
        this.service.setEmailSignature(address, signature);
    }

    public String getEmailSignature(String address) {
        return this.service.getEmailSignature(address);
    }

    public void saveMessage(final MessageInfo messageInfo, final SessionInfo sessionInfo) {
        new Thread(){

            @Override
            public void run() {
                try {
                    ClientConnector.this.service.saveMessage(messageInfo, sessionInfo);
                }
                catch (Exception e) {
                    ClientConnector.this.service.toLog("saveMessage - " + e);
                }
            }
        }.start();
    }

    public SessionInfo sendMail(SessionInfo session, EmailInfo emailInfo) throws Exception {
        return this.service.sendMail(session, emailInfo);
    }

    public void mailRead(final EmailInfo emailInfo, final SessionInfo sessionInfo) {
        new Thread(){

            @Override
            public void run() {
                ClientConnector.this.service.mailRead(emailInfo, sessionInfo);
            }
        }.start();
    }

    public void adRead(MessageInfo messageInfo, SessionInfo sessionInfo) throws Exception {
        this.service.adRead(messageInfo, sessionInfo);
    }

    public void markSpam(MessageInfo messageInfo) throws Exception {
        this.service.markSpam(messageInfo);
    }

    public List<MessageInfo> getArcMessages(String filter) {
        return this.service.getArcMessages(filter);
    }

    public List<SessionInfo> getChannelSessions(String filter) {
        return this.service.getChannelSessions(filter);
    }

    public SessionInfo sendSMS(String number, String text, String trunk) {
        return this.service.sendSMS(number, text, trunk);
    }

    public void sendSMS(SessionInfo sessionInfo, String number, String text, String trunk) {
        this.service.sendSMS(sessionInfo, number, text, trunk);
    }

    public SessionInfo sendMMS(String number, File file, String trunk) {
        return this.service.sendMMS(number, file, trunk);
    }

    public void sendMMS(SessionInfo session, String number, File file, String trunk) {
        this.service.sendMMS(session, number, file, trunk);
    }

    public void setIncomingMessage(String text, Map info) {
        String filename = (String)info.get("filename");
        info.put("content", filename != null ? filename : text);
        this.service.setIncomingMessage(info);
    }

    public Object getBillingInfo(String type, Map params) throws Exception {
        HashMap<String, String> prms = params;
        if (prms == null) {
            prms = new HashMap<String, String>();
        }
        prms.put("method", type);
        return this.service.getBillingInfo(prms);
    }

    public void sendDeviceInfo(Map params) throws Exception {
        this.service.sendDeviceInfo(params);
    }

    public Object getCustomInfo(Map params) throws Exception {
        return this.service.getCustomInfo(params);
    }

    public void sendCustomInfo(Map params) throws Exception {
        this.service.sendCustomInfo(params);
    }

    public void setLocation(double latitude, double longitude) {
        try {
            this.service.setLocation(latitude, longitude);
        }
        catch (Exception e) {
            this.service.toLog("setLocation " + e);
        }
    }

    public void setDeviceToken(String svcid, String token, int type) throws Exception {
        this.service.setDeviceToken(svcid, token, type);
    }

    public List<ContactInfo> findNearbyUsers(double latitude, double longitude, int skip, int limit, int gender) throws Exception {
        return this.service.findNearbyUsers(latitude, longitude, skip, limit, gender);
    }

    public List<ContactInfo> getChannels(int skip, int limit) throws Exception {
        return this.service.getChannels(skip, limit);
    }

    public List getComments(String postid) throws Exception {
        return this.service.getComments(postid);
    }

    public Map getNewMessagesCount() {
        return this.service.getNewMessagesCount();
    }

    public int getTotalNewMessagesCount() {
        return this.service.getTotalNewMessagesCount();
    }

    protected String getTerminalInfo() {
        return this.terminalInfo;
    }

    public String getTerminalId() {
        if (this.terminalId == null) {
            this.terminalId = Utils.getTerminalId();
        }
        return this.terminalId;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getConsentLink(ContactInfo contact, String profileid) {
        return this.service.getConsentLink(contact, profileid);
    }

    public void uploadCustomerConsent(ContactInfo contact, int basis, File file) throws Exception {
        this.service.uploadCustomerConsent(contact, basis, file);
    }

    public File downloadCustomerConsent(ContactInfo contact) throws Exception {
        return this.service.downloadCustomerConsent(contact);
    }

    public PhoneDevice getPhoneDevice() {
        return this.service.getDevice();
    }

    public List<ContactInfo> getServiceContacts(String serviceid, String prefix, ServiceContactsListener listener) throws Exception {
        return this.service.getServiceContacts(serviceid, prefix, listener);
    }

    public void setServiceContact(ContactInfo contact) throws Exception {
        this.service.setServiceContact(contact);
    }

    public void deleteServiceContact(ContactInfo contact) throws Exception {
        this.service.deleteServiceContact(contact);
    }

    public ContactInfo mergeContacts(ContactInfo contact1, ContactInfo contact2) throws Exception {
        return this.service.mergeContacts(contact1, contact2);
    }

    public List<String> checkUpdates(File binDir) throws Exception {
        return this.service.checkUpdates(binDir);
    }

    public List<String> checkUpdates(File binDir, String version) throws Exception {
        return this.service.checkUpdates(binDir, version);
    }

    public boolean loadUpdates(List<String> updates, File binDir, String execname) {
        return this.service.loadUpdates(updates, binDir, execname);
    }

    public boolean loadUpdates(List<String> updates, File binDir, String execname, String version) {
        return this.service.loadUpdates(updates, binDir, execname, version);
    }

    public Object loadObject(String name) throws Exception {
        return this.service.loadObject(name);
    }

    public void saveObject(String name, Object obj) throws Exception {
        this.service.saveObject(name, obj);
    }

    public void setMessage(Map params) {
        this.service.setMessage(params);
    }

    public List getProviders() {
        return this.service.getProviders();
    }

    public Map getOffer(String provider) throws Exception {
        return this.service.getOffer(provider);
    }

    public Map getPhoneNumber(String provider, String phone_number, String package_id) throws Exception {
        return this.service.getPhoneNumber(provider, phone_number, package_id);
    }

    public Map connectPhoneNumber(String provider, String phone_number, String package_id, String code) throws Exception {
        return this.service.connectPhoneNumber(provider, phone_number, package_id, code);
    }

    public Map getPhoneNumberBalance(String provider, String phone_number) throws Exception {
        return this.service.getPhoneNumberBalance(provider, phone_number);
    }

    public List getServices() {
        return this.service.getServices();
    }

    public String getServiceName(String serviceid) {
        return this.service.getServiceName(serviceid);
    }

    public List getServices(int type) {
        return this.service.getServices(type);
    }

    public List getMeetingServices() {
        return this.getServices(1024);
    }

    public List getCalendarServices() {
        return this.getServices(512);
    }

    public List getStotrageServices() {
        return this.getServices(256);
    }

    public void setSubscription(String serviceid) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceid", serviceid);
        Map result = (Map)this.service.sendCommand("setSubscription", params);
        Integer status = (Integer)result.get("status");
        if (status != null && status == 303) {
            String location = (String)result.get("location");
            throw new RedirectionException(location);
        }
    }

    public Map getFallbackMode() {
        return this.service.getFallbackMode();
    }

    public List getEmergencyNumbers() {
        return this.service.getEmergencyNumbers();
    }

    public List getCustomPages() {
        return this.service.getCustomPages();
    }

    public List getContactLinks(ContactInfo contactInfo) {
        return this.service.getContactLinks(contactInfo);
    }

    public void removeCalls(String sessionid) throws Exception {
        this.service.removeCalls(sessionid);
    }

    public boolean canSendSMS(ContactInfo contactInfo) {
        if (contactInfo.isPhone()) {
            return !this.service.getTrunksForSIPSimple().isEmpty();
        }
        return !this.service.getSIPTrunksForSMS().isEmpty() && !contactInfo.isUser();
    }

    public boolean canSendMMS(ContactInfo contactInfo) {
        if (contactInfo.isPhone()) {
            return !this.service.getTrunksForSIPSimple().isEmpty();
        }
        return !this.service.getSIPTrunksForMMS().isEmpty() && !contactInfo.isUser();
    }

    public boolean canSendSMS() {
        return !this.service.getSIPTrunksForSMS().isEmpty();
    }

    public boolean canSendMMS() {
        return !this.service.getSIPTrunksForMMS().isEmpty();
    }

    public void logGSMCall(String number, int duration) {
        this.service.logGSMCall(number, duration);
    }

    public String getTrunkName(String number, boolean singletrunk) {
        return this.service.getTrunkName(number, singletrunk);
    }

    public boolean hasSIPDevice() {
        return this.service.hasSIPDevice();
    }

    public String getSIPDevice() {
        return this.service.getSIPDevice();
    }

    public Iterator getSessionInfos() {
        return this.service.sessionsIterator();
    }

    public Iterator getContactInfos() {
        return this.service.contactsIterator();
    }
}

