/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import smile.cti.client.ConferenceEventListener;
import smile.cti.client.ContactGroup;
import smile.cti.client.SessionInfo;

public class ConferenceGroup
extends ContactGroup {
    static final long serialVersionUID = 8603489018351213416L;
    private transient int state;
    private transient Set<ConferenceEventListener> listeners = new HashSet<ConferenceEventListener>();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new HashSet<ConferenceEventListener>();
    }

    public ConferenceGroup(SessionInfo sessionInfo) {
        this.setId(sessionInfo.getDialogId());
        this.setSessionId(sessionInfo.getSessionId());
        this.setName(sessionInfo.getName());
        this.setMembers(sessionInfo.getParties());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("videomode", "640x480");
        this.setProperty("options", options);
        this.setProperty("oid", sessionInfo.getDialogId());
    }

    public ConferenceGroup(Map map) {
        super(map);
    }

    public void addListener(ConferenceEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ConferenceEventListener listener) {
        this.listeners.remove(listener);
    }

    public void setState(int s) {
        this.state = s;
        Iterator<ConferenceEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(this.state);
        }
    }

    public int getState() {
        return this.state;
    }

    public void setPartyStatus(String party, String status) {
        Iterator<ConferenceEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
        }
    }
}

