/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import smile.cti.client.ContactInfo;

public class ContactGroup
implements Serializable {
    static final long serialVersionUID = 4682246824561304601L;
    public static final String NoAuth = "NoAuth";
    public static final String WaitingForAuth = "WaitingForAuth";
    public static final String AuthRequest = "AuthRequest";
    public static final String Authorized = "Authorized";
    public static final String WhiteList = "WhiteList";
    public static final String BlackList = "BlackList";
    public static final String Favorites = "Favorites";
    public static final String Telephones = "Telephones";
    public static final String All = "All";
    public static final String Users = "users";
    public static final String Phones = "phones";
    public static final String Equipment = "equipment";
    public static final String Selector = "selector";
    private String id;
    private String name = null;
    private File imageFile;
    private List<ContactInfo> members = new Vector<ContactInfo>();
    private Map properties = new HashMap();
    private boolean permanent;
    private String sessionid;

    public ContactGroup() {
        this.properties = new HashMap();
    }

    protected ContactGroup(String id) {
        this.id = id;
    }

    protected ContactGroup(Map map) {
        this.id = (String)map.get("id");
        if (this.id == null) {
            this.id = (String)map.get("oid");
        }
        this.name = (String)map.get("name");
        this.setPermanent(map.get("kind") != null);
        this.setProperties(map);
    }

    public void add(ContactInfo contact) {
        for (ContactInfo contactInfo : this.members) {
            if (!contactInfo.equals(contact)) continue;
            this.members.remove(contactInfo);
            break;
        }
        this.members.add(contact);
    }

    public List<ContactInfo> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<ContactInfo> list) {
        this.members.clear();
        Iterator<ContactInfo> it = list.iterator();
        while (it.hasNext()) {
            this.members.add(it.next());
        }
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(File file) {
        this.imageFile = file;
    }

    public void remove(ContactInfo contact) {
        this.members.remove(contact);
    }

    public boolean contains(ContactInfo contact) {
        return this.members.contains(contact);
    }

    public String getKind() {
        return (String)this.properties.get("kind");
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equalsSet(Set<ContactInfo> set) {
        int h1 = 0;
        int h2 = 0;
        Iterator<ContactInfo> it1 = set.iterator();
        while (it1.hasNext()) {
            h1 += it1.next().getUserID().hashCode();
        }
        Iterator<ContactInfo> it2 = this.members.iterator();
        while (it2.hasNext()) {
            h2 += it2.next().getUserID().hashCode();
        }
        return h1 == h2;
    }

    public void removeAll() {
        this.members.clear();
    }

    public int getSize() {
        return this.members.size();
    }

    public String membersToString() {
        Object str = "";
        Iterator<ContactInfo> it = this.members.iterator();
        while (it.hasNext()) {
            if (((String)str).length() > 0) {
                str = (String)str + ",";
            }
            str = (String)str + it.next().toString();
        }
        return str;
    }

    protected void setSessionId(String id) {
        this.sessionid = id;
    }

    public String getSessionId() {
        return this.sessionid;
    }

    public void setPermanent(boolean mode) {
        this.permanent = mode;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    protected void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    protected void setProperties(Map map) {
        this.properties.putAll(map);
    }

    protected Map getPropertiesMap(String key) {
        return (Map)this.properties.get(key);
    }

    public boolean canMakeVideoCall() {
        if (this.name == null) {
            return false;
        }
        String kind = (String)this.properties.get("kind");
        if (kind != null && !kind.equals(Users) && !kind.equals("conference")) {
            return false;
        }
        Iterator<ContactInfo> it = this.members.iterator();
        while (it.hasNext()) {
            if (it.next().canReceiveVideoCalls()) continue;
            return false;
        }
        return true;
    }

    public boolean canMakeCall() {
        if (this.name == null) {
            return false;
        }
        String kind = (String)this.properties.get("kind");
        if (!(kind == null || kind.equals(Users) || kind.equals(Phones) || kind.equals("conference"))) {
            return false;
        }
        Iterator<ContactInfo> it = this.members.iterator();
        while (it.hasNext()) {
            if (!it.next().canReceiveCalls()) continue;
            return true;
        }
        return false;
    }

    public boolean canSendMessage() {
        if (this.name == null) {
            return false;
        }
        Iterator<ContactInfo> it = this.members.iterator();
        while (it.hasNext()) {
            if (!it.next().canReceiveMessages()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldBeShown() {
        if (Telephones.equals(this.id) || NoAuth.equals(this.id) || WaitingForAuth.equals(this.id) || AuthRequest.equals(this.id) || Authorized.equals(this.id)) {
            return !this.members.isEmpty();
        }
        if (this.name == null && !Favorites.equals(this.id) && !WhiteList.equals(this.id)) {
            return false;
        }
        return !this.permanent || !this.members.isEmpty();
    }

    public String toString() {
        return this.name != null ? this.name : this.id;
    }
}

