/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.HttpConnection;
import smile.cti.client.ServiceManager;
import smile.cti.client.SessionInfo;
import smile.util.ResourceStore;
import smile.web.client.Tracker;

public class FileLoader
implements Runnable {
    private ServiceManager serviceManager;
    private HttpConnection httpConnection;
    private Vector<Job> queue = new Vector();
    private Map<String, Job> loadingFiles = new HashMap<String, Job>();
    private int threadPoolSize;
    private int runcount;
    int c = 0;

    public FileLoader(ServiceManager serviceManager, int threadPoolSize) {
        this.serviceManager = serviceManager;
        this.threadPoolSize = threadPoolSize;
        this.httpConnection = new HttpConnection(true);
    }

    public void setServer(String server, String proxy) {
        this.httpConnection.setAddress(server);
        this.httpConnection.setProxy(proxy);
    }

    public void setUsername(String username) {
        this.httpConnection.setUsername(username);
    }

    public void setPassword(String password) {
        this.httpConnection.setPassword(password);
    }

    public String getPassword() {
        return this.httpConnection.getPassword();
    }

    public Map sendCommand(String serverAddress, String method, Map params) throws Exception {
        if (this.httpConnection != null && serverAddress.equals(this.httpConnection.getAddress())) {
            return this.httpConnection.sendCommand(method, params);
        }
        HttpConnection http = new HttpConnection(true);
        http.setAddress(serverAddress);
        return http.sendCommand(method, params);
    }

    public int getFile(String resource, File file, Tracker tracker, Map properties) throws Exception {
        return this.httpConnection.getFile(resource, file, tracker, properties, this.serviceManager.getCipher(file));
    }

    public int postFile(String resource, Map params) throws Exception {
        return this.httpConnection.postFile(resource, params);
    }

    public int putFile(String resource, File file, Tracker tracker) throws Exception {
        return this.httpConnection.putFile(resource, file, tracker);
    }

    public int deleteFile(String resource) throws Exception {
        return this.httpConnection.deleteFile(resource);
    }

    private void putJob(Job job) {
        this.queue.add(job);
        if (this.runcount < this.threadPoolSize) {
            ++this.runcount;
            new Thread(this).start();
        }
    }

    private synchronized Job getJob() {
        return this.queue.isEmpty() ? null : this.queue.remove(0);
    }

    @Override
    public void run() {
        Job job;
        while ((job = this.getJob()) != null) {
            job.run();
        }
        --this.runcount;
    }

    public synchronized void load(String resource, File file, Object listener) {
        Job job = this.loadingFiles.get(file.getAbsolutePath());
        if (job != null) {
            if (job.object != listener) {
                job.setListener(listener);
            }
            return;
        }
        job = new Job(resource, file, listener);
        this.loadingFiles.put(file.getAbsolutePath(), job);
        this.putJob(job);
    }

    public boolean isLoading(File file) {
        return this.loadingFiles.containsKey(file.getAbsolutePath());
    }

    class Job {
        String resource;
        File file;
        Object object;

        public Job(String resource, File file, Object object) {
            this.resource = resource;
            this.file = file;
            this.object = object;
        }

        public void setListener(Object listener) {
            if (!(listener instanceof FileTransferListener)) {
                return;
            }
            if (this.object instanceof FileInfo) {
                ((FileInfo)this.object).addTransfrerListener((FileTransferListener)listener);
            }
        }

        public void run() {
            String path;
            block19: {
                int status = 0;
                path = this.file.getAbsolutePath();
                if (this.object instanceof FileInfo) {
                    FileInfo fileInfo = (FileInfo)this.object;
                    fileInfo.setProperty("timestamp", fileInfo.getTime());
                    String errorMessage = null;
                    try {
                        status = FileLoader.this.getFile(this.resource, this.file, fileInfo, fileInfo.getProperties());
                    }
                    catch (Exception e) {
                        errorMessage = e.getLocalizedMessage();
                    }
                    FileLoader.this.serviceManager.toLog("Load resource=" + this.resource + " file=" + this.file + " len=" + this.file.length() + " props=" + fileInfo.getProperties() + " status=" + status + " err=" + errorMessage);
                    if (errorMessage == null && (status == 200 || status == 304 && this.file.exists())) {
                        fileInfo.setFile(this.file);
                        fileInfo.setLoaded();
                        if (status == 200) {
                            FileLoader.this.serviceManager.fileLoaded(fileInfo);
                        }
                    } else {
                        if (errorMessage == null) {
                            errorMessage = String.valueOf(status);
                        }
                        fileInfo.cancel(errorMessage);
                        fileInfo.setFile(null);
                        this.file.delete();
                    }
                } else {
                    try {
                        if (this.object instanceof ContactInfo) {
                            status = FileLoader.this.getFile(this.resource, this.file, null, ((ContactInfo)this.object).getProperties());
                            if (status == 200) {
                                FileLoader.this.serviceManager.avatarLoaded((ContactInfo)this.object, this.file);
                            } else if (status == 404) {
                                this.file.delete();
                                FileLoader.this.serviceManager.avatarLoaded((ContactInfo)this.object, this.file);
                            }
                        }
                        if (this.object instanceof SessionInfo) {
                            status = FileLoader.this.getFile(this.resource, this.file, null, ((SessionInfo)this.object).getProperties());
                            if (status == 200) {
                                FileLoader.this.serviceManager.avatarLoaded((SessionInfo)this.object, this.file);
                            } else if (status == 404) {
                                this.file.delete();
                                FileLoader.this.serviceManager.avatarLoaded((SessionInfo)this.object, this.file);
                            }
                        }
                        FileLoader.this.serviceManager.toLog("c=" + ++FileLoader.this.c + " getFile " + this.resource + " status=" + status + " object=" + this.object + " len=" + this.file.length());
                    }
                    catch (Exception e) {
                        ResourceStore.error("getFile " + this.resource, e);
                        this.file.delete();
                        if (this.object instanceof ContactInfo) {
                            FileLoader.this.serviceManager.avatarLoaded((ContactInfo)this.object, this.file);
                        }
                        if (!(this.object instanceof SessionInfo)) break block19;
                        FileLoader.this.serviceManager.avatarLoaded((SessionInfo)this.object, this.file);
                    }
                }
            }
            FileLoader.this.loadingFiles.remove(path);
        }
    }
}

