/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.SIPMessageConnector;
import smile.cti.client.ServiceManager;
import smile.cti.client.SessionInfo;

public class IvieServiceManager
extends ServiceManager {
    private Map globalProperties;

    public IvieServiceManager(ClientConnector client) throws Exception {
        super(client);
        this.localConfmode = true;
        this.globalProperties = new HashMap();
        this.setServerConnector(new SIPMessageConnector(this, "$SERVICE$"));
    }

    @Override
    public int signIn(String serverAddress) throws Exception {
        try {
            return super.signIn(serverAddress);
        }
        catch (Exception e) {
            this.toLog("signIn: " + e.getMessage());
            if ("Unauthorized".equals(e.getMessage())) {
                return 1;
            }
            if ("Forbidden".equals(e.getMessage())) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public boolean logIn(String serverAddress, String login, char[] password, String proxy, boolean save) throws Exception {
        try {
            if (!super.logIn(serverAddress, login, password, proxy, save)) {
                return false;
            }
            HashMap<String, String> prms = new HashMap<String, String>();
            prms.put("termid", this.client.getTerminalId());
            prms.put("devinfo", this.client.getTerminalInfo());
            String termpass = (String)this.sendCommand("getTerminalPassword", prms);
            super.setProperty("termpass", termpass.toCharArray(), true);
            this.toLog("registered termid=" + this.client.getTerminalId() + " termpass=" + termpass);
            return true;
        }
        catch (Exception e) {
            if (!"Unauthorized".equals(e.getMessage())) {
                throw e;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("login", login);
            map.put("passw", String.valueOf(password));
            Map result = this.signUp(serverAddress, map);
            Integer code = (Integer)result.get("code");
            if (code == 0) {
                // empty if block
            }
            throw new Exception(String.valueOf(result.get("message")));
        }
    }

    @Override
    protected void contactChanged(Map map, boolean b) {
        this.addContactInfo(new ContactInfo(map), b);
    }

    @Override
    protected SessionInfo createSession(Collection<ContactInfo> collection, String name, int status) throws Exception {
        if (status == -3) {
            status = 0;
        }
        return super.createSession(collection, name, status);
    }

    @Override
    public String normalizePhoneNumber(String number, String countryCode) {
        String phoneNumber = super.normalizePhoneNumber(number, countryCode);
        if (phoneNumber.startsWith("+")) {
            phoneNumber = phoneNumber.substring(1);
        }
        return phoneNumber;
    }

    @Override
    public List<String> getPhoneNumbers(ContactInfo contactInfo) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> numbers = super.getPhoneNumbers(contactInfo);
        for (int i = 0; i < numbers.size(); ++i) {
            String number = numbers.get(i);
            if (number.startsWith("+")) {
                number = number.substring(1);
            }
            list.add(number);
        }
        return list;
    }
}

