/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.json.smile.JSONObject;
import smile.cti.client.Activity;
import smile.cti.client.ServiceManager;

public class MessageInfo
implements Serializable,
Comparable,
Cloneable {
    static final long serialVersionUID = 934587102512512453L;
    public static final int MESSAGE_OUTGOING = 0;
    public static final int MESSAGE_INCOMING_NEW = 1;
    public static final int MESSAGE_INCOMING = 2;
    public static final int MESSAGE_OUTGOING_NEW = 3;
    public static final int MESSAGE_OUTGOING_READ = 4;
    public static final int MESSAGE_CALL_INCOMING = 5;
    public static final int MESSAGE_CALL_OUTGOING = 6;
    public static final int MESSAGE_CALL_MISSED_NEW = 12;
    public static final int MESSAGE_DELETED = 8;
    public static final int MESSAGE_CONF_EVENT = 10;
    public static final int MESSAGE_NOT_SENT = -1;
    public static final int MESSAGE_DRAFT = -2;
    public static final int MESSAGE_ERROR = -3;
    public static final int MESSAGE_TYPE_TEXT = 1;
    public static final int MESSAGE_TYPE_FILE = 2;
    public static final int MESSAGE_TYPE_CONF_ADD = 3;
    public static final int MESSAGE_TYPE_CONF_REMOVE = 4;
    public static final int MESSAGE_TYPE_EMAIL = 5;
    public static final int MESSAGE_TYPE_PHOTO = 6;
    public static final int MESSAGE_TYPE_FILE_LINK = 7;
    public static final int MESSAGE_TYPE_CALL = 8;
    public static final int MESSAGE_TYPE_PUSH = 9;
    public static final int MESSAGE_TYPE_CONTACT = 10;
    public static final int MESSAGE_TYPE_LOCATION = 11;
    public static final int MESSAGE_TYPE_CONF_CHANGE = 12;
    public static final int MESSAGE_TYPE_AUDIO = 13;
    public static final int MESSAGE_TYPE_TYPING = 14;
    public static final int MESSAGE_TYPE_COMMENT = 15;
    public static final int MESSAGE_TYPE_TTS = 16;
    public static final int MESSAGE_TYPE_MENU = 17;
    public static final int MESSAGE_TYPE_COMMAND = 18;
    public static final int MESSAGE_TYPE_AD = 19;
    public static final int MESSAGE_TYPE_SMS = 20;
    public static final int MESSAGE_TYPE_CALLBACK = 21;
    public static final int MESSAGE_TYPE_REMINDER = 22;
    public static final int MESSAGE_TYPE_MEETING = 23;
    public static final int MESSAGE_ATTRIBUTE_MARK = 1;
    public static final int MESSAGE_ATTRIBUTE_QUOTE = 2;
    public static final int MESSAGE_ATTRIBUTE_LIKE = 4;
    public static final int MESSAGE_ATTRIBUTE_LINK = 8;
    public static final int MESSAGE_ATTRIBUTE_READONLY = 16;
    public static final int MESSAGE_ATTRIBUTE_TASK = 32;
    public static final int MESSAGE_ATTRIBUTE_SPAM = 64;
    public static final int MESSAGE_ATTRIBUTE_ARC = 128;
    public static final int MESSAGE_ATTRIBUTE_HIDDEN = 256;
    public static final int MESSAGE_ATTRIBUTE_UPDATED = 512;
    public static final int MESSAGE_ATTRIBUTE_COMMENT = 1024;
    public static final int MESSAGE_ATTRIBUTE_TRUNK_RELATED = 0x100000;
    public static final int DELETE_TIMEOUT = 3600000;
    private String id;
    private String senderid;
    private String content;
    private String extid;
    private String subjectid;
    private List recipients;
    private Collection mentions;
    private int type;
    private int status;
    private long time;
    private long lifetime;
    private long expired = Long.MAX_VALUE;
    private long delivered;
    private long localtime;
    private int code;
    private String sessionid;
    private MessageInfo replied;
    private transient TimerTask expiredTask;
    private transient Map callInfo;

    protected MessageInfo() {
        this.localtime = System.currentTimeMillis();
    }

    protected MessageInfo(String id, String senderid, String content, int type, int status, long time) {
        this.id = id;
        this.senderid = senderid;
        this.content = content;
        this.type = type;
        this.status = status;
        this.time = time;
    }

    protected Map getMap() {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("id", this.id);
        prms.put("type", this.type);
        prms.put("content", this.content);
        prms.put("lifetime", this.lifetime);
        prms.put("code", this.code);
        prms.put("mode", 1);
        if (this.recipients != null) {
            prms.put("dest", this.recipients);
        }
        if (this.mentions != null) {
            prms.put("mentions", this.mentions);
        }
        if (this.sessionid != null) {
            prms.put("sessionid", this.sessionid);
        }
        if (this.replied != null) {
            prms.put("replied", this.replied.getId());
        }
        return prms;
    }

    public boolean equals(Object obj) {
        return obj instanceof MessageInfo && this.id != null && this.id.equals(((MessageInfo)obj).id);
    }

    public int getCode() {
        return this.code;
    }

    public String getContent() {
        return this.content;
    }

    public String getText() {
        if (!this.content.startsWith("{")) {
            return this.content;
        }
        int n = this.content.indexOf("\"text\":\"");
        if (n == -1) {
            n = this.content.indexOf("\"content\":\"");
            if (n == -1) {
                return this.content;
            }
            n += 3;
        }
        return this.content.substring(n += 8, this.content.indexOf(34, n));
    }

    public long getDeliveryTime() {
        return this.delivered;
    }

    public long getExpired() {
        return this.expired;
    }

    public String getId() {
        return this.id;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public String getSenderId() {
        return this.senderid;
    }

    public int getStatus() {
        return this.status;
    }

    public long getTime() {
        return this.time;
    }

    public int getType() {
        return this.type;
    }

    public void setCode(int c) {
        this.code = c;
    }

    public void setContent(String content, int type) {
        this.content = content;
        this.type = type;
        this.callInfo = null;
    }

    public List getRecepients() {
        return this.recipients;
    }

    protected void setRecepients(List list) {
        this.recipients = list;
    }

    public Collection getMentions() {
        return this.mentions;
    }

    protected void setMentions(Collection list) {
        this.mentions = list;
    }

    public void setDeliveryTime(long l) {
        this.delivered = l;
    }

    protected void setExpired(long l) {
        this.expired = l;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setType(int type) {
        this.type = type;
    }

    protected void setLifetime(long t) {
        this.lifetime = t;
        if (this.lifetime > 0L) {
            this.expired = System.currentTimeMillis() + this.lifetime * 1000L;
        }
    }

    protected void setSenderId(String senderid) {
        this.senderid = senderid;
    }

    protected void setStatus(int s) {
        this.status = s;
    }

    protected void setTime(long t) {
        this.time = t;
        this.localtime = System.currentTimeMillis();
    }

    public long getLocalTime() {
        return this.localtime;
    }

    protected void setSessionId(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getSessionId() {
        return this.sessionid;
    }

    protected void setExpiredTask(TimerTask task) {
        this.expiredTask = task;
    }

    protected TimerTask getExpiredTask() {
        return this.expiredTask;
    }

    protected boolean update(MessageInfo mi) {
        boolean b;
        boolean bl = b = this.status != mi.status || this.delivered != mi.delivered || this.code != mi.code || this.type != mi.type || this.content == null || !this.content.equals(mi.content);
        if (!b) {
            return false;
        }
        this.status = mi.status;
        this.content = mi.content;
        this.delivered = mi.delivered;
        this.code = mi.code;
        this.type = mi.type;
        this.recipients = mi.recipients;
        return true;
    }

    protected long getAcceptedTime() {
        return Math.max(this.time, this.delivered);
    }

    public String toString() {
        return ServiceManager.DATETIME_FORMAT.format(this.time) + " (" + this.status + "," + this.type + "): " + this.id;
    }

    public int compareTo(Object o) {
        return this.time - ((MessageInfo)o).time > 0L ? 1 : -1;
    }

    public boolean canBeDeleted() {
        return this.status == -1 || this.status == 0 || this.status == 3 || this.status == 4 && System.currentTimeMillis() - this.localtime < 3600000L;
    }

    public Activity getActivity() {
        Map<String, Long> map = new HashMap<String, String>();
        if (this.type == 2) {
            String type = this.status == 2 || this.status == 1 ? "received" : "sent";
            map.put("type", (Long)((Object)type));
        } else if (this.type == 8) {
            try {
                map = new JSONObject(this.content).getMap();
            }
            catch (Exception type) {
                // empty catch block
            }
            String type = this.status == 6 ? "outbound" : "inbound";
            map.put("type", (Long)((Object)type));
        } else if (this.type == 21) {
            try {
                map = new JSONObject(this.content).getMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put("type", (Long)((Object)"callback"));
        } else {
            try {
                map = new JSONObject(this.content).getMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put("type", (Long)((Object)"comment"));
        }
        if (!map.containsKey("timestart")) {
            map.put("timestart", this.time);
        }
        return new Activity(map);
    }

    protected void setSubjectId(String subj) {
        this.subjectid = subj;
    }

    public String getSubjectId() {
        return this.subjectid;
    }

    protected void setChannel(String id) {
        this.extid = id;
    }

    public String getChannel() {
        return this.extid;
    }

    protected void setRepliedMessage(MessageInfo message) {
        this.replied = message;
    }

    public MessageInfo getRepliedMessage() {
        return this.replied;
    }

    public String getCallTrunkNumber() {
        if (this.status == 5 || this.status == 12) {
            return this.getCallCalledNumber();
        }
        if (this.status == 6) {
            return this.getCallCallerNumber();
        }
        return null;
    }

    public String getCallPartyNumber() {
        if (this.status == 5 || this.status == 12) {
            return this.getCallCallerNumber();
        }
        if (this.status == 6) {
            return this.getCallCalledNumber();
        }
        return null;
    }

    public String getCallCallerNumber() {
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        return (String)this.callInfo.get("caller");
    }

    public String getCallCalledNumber() {
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        return (String)this.callInfo.get("called");
    }

    public String getCallTransfereeNumber() {
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        return (String)this.callInfo.get("transferee");
    }

    public String getCallConnectedNumber() {
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        return (String)this.callInfo.get("connected");
    }

    public int getCallDuration() {
        Integer duration;
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        if ((duration = (Integer)this.callInfo.get("duration")) == null) {
            duration = 0;
        }
        return duration;
    }

    public int getCallCauseCode() {
        Integer cause;
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        if ((cause = (Integer)this.callInfo.get("cause")) == null) {
            cause = 0;
        }
        return cause;
    }

    public String getCallCauseDescription() {
        return ServiceManager.getCauseDescription(this.getCallCauseCode());
    }

    public String getCallSubject() {
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        return (String)this.callInfo.get("subject");
    }

    public String getCallComment() {
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        return (String)this.callInfo.get("comment");
    }

    public String getCallChannel() {
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        return (String)this.callInfo.get("channel");
    }

    public String getTrunkId() {
        if (this.callInfo == null || this.callInfo.isEmpty()) {
            this.callInfo = this.getCallInfo();
        }
        return (String)this.callInfo.get("trunkid");
    }

    public Map getCallInfo() {
        if (this.callInfo == null) {
            try {
                this.callInfo = new JSONObject(this.content).getMap();
            }
            catch (Exception e) {
                return new HashMap();
            }
        }
        return this.callInfo;
    }

    public MessageInfo clone() throws CloneNotSupportedException {
        return (MessageInfo)super.clone();
    }
}

