/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.util.Map;
import java.util.Random;
import smile.cti.client.ServiceManager;
import smile.cti.phone.PhoneManager;
import smile.util.ConnectionInfo;
import smile.util.ResourceStore;

public abstract class ServerConnector
extends PhoneManager {
    static final int LOCALPORT = 59600;
    static final String TRANSPORT = "WSS";
    static final String DEFAULT_SERVER = "localhost";
    private ServiceManager client;
    private boolean registered;

    public ServerConnector(ServiceManager client) throws Exception {
        super(client);
        this.client = client;
    }

    public void register(String serverAddress, String authname, char[] password, String proxy, String devinfo, boolean reconnect) throws Exception {
        this.toLog("register to " + serverAddress + " registered=" + this.registered);
        if (serverAddress == null || serverAddress.length() == 0) {
            serverAddress = DEFAULT_SERVER;
        }
        int p = serverAddress.indexOf(58);
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setProductName(devinfo);
        int[] cap = new int[]{28166, 3074, 1282, 2306};
        connectionInfo.setParameter("h323.capabilities", cap);
        connectionInfo.setParameter("sip.reg_expires", this.client.isMobileVersion() ? 600 : 60);
        connectionInfo.setTransport(TRANSPORT);
        connectionInfo.setParameter("sip.noretry", "true");
        connectionInfo.setServer(serverAddress);
        connectionInfo.setAuthName(authname);
        connectionInfo.setPassword(new String(password));
        if (proxy != null && proxy.length() > 0) {
            connectionInfo.setProxy(proxy);
        }
        connectionInfo.setParameter("sip.reconnect", reconnect);
        int listPort = (this.client.isMobileVersion() ? 40000 : 50000) + new Random(System.currentTimeMillis()).nextInt(10000);
        connectionInfo.setParameter("h323.port", listPort);
        this.connect(connectionInfo);
    }

    public void connect(ConnectionInfo connectionInfo) throws Exception {
        super.register(connectionInfo);
    }

    public abstract Object sendCommand(String var1, Map var2, long var3) throws Exception;

    public abstract void sendIndication(String var1, Map var2) throws Exception;

    protected void processCommand(String method, Map parameters) {
        try {
            this.client.processCommand(method, parameters);
        }
        catch (Exception e) {
            ResourceStore.error(method, e);
        }
    }

    @Override
    public void connectionLost() {
        this.registered = false;
        super.connectionLost();
    }

    public void connectionSet() {
        this.registered = true;
    }

    @Override
    public void toLog(String text) {
        if (this.client != null) {
            this.client.toLog(text);
        }
    }
}

