/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import com.smile.telephony.AudioConverter;
import com.smile.telephony.ToneGenerator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sipsnet.client.ios.CallKitAdapter;
import org.json.smile.JSONObject;
import smile.cti.client.Activity;
import smile.cti.client.ClientConnector;
import smile.cti.client.CloudFile;
import smile.cti.client.ContactGroup;
import smile.cti.client.ContactInfo;
import smile.cti.client.EmailInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.FileLoader;
import smile.cti.client.FileTransferListener;
import smile.cti.client.LineEventListener;
import smile.cti.client.LineInfo;
import smile.cti.client.MenuInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.ServerConnector;
import smile.cti.client.ServiceContactsListener;
import smile.cti.client.SessionInfo;
import smile.cti.phone.Line;
import smile.cti.phone.LinePane;
import smile.cti.phone.PhoneDevice;
import smile.cti.phone.video.DisplayPane;
import smile.util.ConnectionInfo;
import smile.util.MyLogger;
import smile.util.RedirectionException;
import smile.util.ResourceStore;
import smile.util.Utils;
import smile.web.client.HttpRequest;

public abstract class ServiceManager {
    public static final SimpleDateFormat DAYTIME_FORMAT = new SimpleDateFormat("HH:mm");
    public static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("MM.dd HH.mm.ss");
    protected ClientConnector client;
    protected ServerConnector server;
    private List<LineInfo> lines;
    protected FileLoader fileLoader;
    protected boolean localConfmode;
    private Map localProperties;
    private Map serviceProperties;
    private ContactInfo myInfo;
    private String userlogin;
    private String serverAddr;
    private File homedir;
    private File filedir;
    private Map timerTasks;
    private long deltaTime;
    private long lastSavedTime = -1L;
    private long lastSavedTimeBak;
    private int messagesByRequest = 25;
    private Map<String, ContactInfo> numbers;
    private Map<String, ContactInfo> contacts;
    private Map<String, SessionInfo> sessions;
    private Map<String, Map> contactgroups;
    private boolean startedOnline;
    private boolean online;
    private boolean exited;
    private TimerTask unsentTask;
    private TimerTask saveTask;
    private TimerTask logTask;
    private UploadContactsTask ucTask;
    private List subjects;
    private List tags;
    private List providers;
    private LineEventListener lineEventListener;
    private KeyStore keyStore;
    private Map<String, File> tmpFiles;
    private Map pushmessage;
    private char[] pass;
    private boolean writelog;
    private boolean ismobile;
    private boolean offline;
    private List searhChatsResult;
    private List searhCallsResult;
    private Map serviceContacts;
    private boolean serviceContactsSearch;
    private boolean serviceContactsRequest;
    public static final int LOG_SIZE = 2500;
    public static final int EVENT_MESSAGE_INCOMING_NEW = 1;
    public static final int EVENT_MESSAGE_INCOMING = 2;
    public static final int EVENT_MESSAGE_OUTGOING_NEW = 3;
    public static final int EVENT_MESSAGE_OUTGOING = 4;
    public static final int EVENT_CALL_INCOMING = 5;
    public static final int EVENT_CALL_OUTGOING = 6;
    public static final int EVENT_VIDEOCALL_INCOMING = 7;
    public static final int EVENT_VIDEOCALL_OUTGOING = 8;
    public static final int EVENT_CONFERENCE_CALL = 9;
    public static final int EVENT_CONFERENCE_CHAT = 10;
    public static final int EVENT_CALL_MISSED_NEW = 12;
    public static final int EVENT_CALL_INCOMING_MISSED = 13;
    public static final int EVENT_CALL_OUTGOING_MISSED = 14;
    public static final int EVENT_SUBSCRIPTION_REQUEST = 15;
    public static final int EVENT_SUBSCRIPTION_ACCEPT = 16;
    public static final int EVENT_SUBSCRIPTION_REJECT = 17;
    public static final int EVENT_INVITATION = 18;
    public static final int EVENT_INVITATION_ACCEPT = 19;
    public static final int EVENT_INVITATION_REJECT = 20;
    public static final int EVENT_LOG_ON = 21;
    public static final int EVENT_LOG_OFF = 22;
    public static final int EVENT_CONFERENCE_ADD = 1;
    public static final int EVENT_CONFERENCE_REMOVE = 2;
    public static final int EVENT_CONFERENCE_DROPPED = 3;
    public static final String METHOD_CHECK_UPDATES = "checkUpdates";
    public static final String METHOD_LOAD_OBJECTS = "loadObjects";
    public static final String METHOD_SEND_MESSAGE = "sendMessage_";
    public static final String METHOD_UPDATE_MESSAGE = "updateMessage";
    public static final String METHOD_DELETE_MESSAGE = "deleteMessage";
    public static final String METHOD_DELETE_MESSAGES = "deleteMessages";
    public static final String METHOD_REMOVE_MESSAGES = "removeMessages";
    public static final String METHOD_MARK_MESSAGES = "markMessages";
    public static final String METHOD_MESSAGE_DELIVERED = "messageDelivered";
    public static final String METHOD_MESSAGE_READ = "messageRead";
    public static final String METHOD_MESSAGE_SHOWN = "messageShown";
    public static final String METHOD_MESSAGE_UPDATED = "messageUpdated";
    public static final String METHOD_MESSAGE_DELETED = "messageDeleted";
    public static final String METHOD_MESSAGE_TYPED = "messageTyped";
    public static final String METHOD_GET_MESSAGE = "getMessage";
    public static final String METHOD_GET_MESSAGE_STATUS = "getMessageStatus";
    public static final String METHOD_SET_STATE = "setState";
    public static final String METHOD_UPDATE_SESSION = "updateSession";
    public static final String METHOD_CREATE_SESSION = "createSession";
    public static final String METHOD_CLOSE_SESSION = "closeSession";
    public static final String METHOD_OPEN_SESSION = "openSession";
    public static final String METHOD_SESSION_UPDATED = "sessionUpdated";
    public static final String METHOD_SESSION_DELETED = "sessionDeleted";
    public static final String METHOD_GET_SESSION = "getSession";
    public static final String METHOD_FIND_CONTACT = "findContact";
    public static final String METHOD_INVITE_CONTACT = "inviteContact";
    public static final String METHOD_CONTACT_REQUEST = "contactRequest";
    public static final String METHOD_CONTACT_ACCEPT = "contactAccept";
    public static final String METHOD_CONTACT_REJECT = "contactReject";
    public static final String METHOD_CONTACT_REQUESTED = "contactRequested";
    public static final String METHOD_CONTACT_ACCEPTED = "contactAccepted";
    public static final String METHOD_CONTACT_REJECTED = "contactRejected";
    public static final String METHOD_CONTACT_CREATED = "contactCreated";
    public static final String METHOD_CONTACT_UPDATED = "contactUpdated";
    public static final String METHOD_CONTACT_DELETED = "contactDeleted";
    public static final String METHOD_GET_PROFILE = "getProfile";
    public static final String METHOD_GET_USERINFO = "getUserInfo";
    public static final String METHOD_SET_USERINFO = "setUserInfo";
    public static final String METHOD_ADD_USER_CONTACT = "addUserContact";
    public static final String METHOD_UPDATE_USER_CONTACT = "updateUserContact";
    public static final String METHOD_REMOVE_USER_CONTACT = "removeUserContact";
    public static final String METHOD_SET_PASSWORD = "setUserPassword";
    public static final String METHOD_SET_USER_PROPERTIES = "setUserProperties";
    public static final String METHOD_GET_USER_PROPERTIES = "getUserProperties";
    public static final String METHOD_GET_CONTACTS = "getContacts";
    public static final String METHOD_GET_CONTACT = "getContact";
    public static final String METHOD_GET_CALLS = "getCalls";
    public static final String METHOD_GET_EVENTS = "getEvents";
    public static final String METHOD_GET_GROUPS = "getGroups";
    public static final String METHOD_GET_DEVICES = "getDevices";
    public static final String METHOD_GET_SESSIONS = "getSessions";
    public static final String METHOD_GET_MESSAGES = "getMessages";
    public static final String METHOD_GET_FILES = "getFiles";
    public static final String METHOD_REGISTRATION_REQUEST = "registrationRequest";
    public static final String METHOD_REGISTRATION_COMPLETE = "registrationComplete";
    public static final String METHOD_CREATE_GROUP = "createGroup";
    public static final String METHOD_UPDATE_GROUP = "updateGroup";
    public static final String METHOD_DELETE_GROUP = "deleteGroup";
    public static final String METHOD_CREATE_CONTACT = "createContact";
    public static final String METHOD_UPDATE_CONTACT = "updateContact";
    public static final String METHOD_DELETE_CONTACT = "deleteContact";
    public static final String METHOD_SHARE_CONTACT = "shareContact";
    public static final String METHOD_MERGE_CONTACTS = "mergeContacts";
    public static final String METHOD_EXPORT_CONTACTS = "exportContacts";
    public static final String METHOD_UPDATE_CONTACTS = "updateContacts";
    public static final String METHOD_UPDATE_CONTACT_INFO = "updateContactInfo";
    public static final String METHOD_UPDATE_CONTACT_STATUS = "updateContactStatus";
    public static final String METHOD_CONFERENCE_CREATED = "conferenceCreated";
    public static final String METHOD_CONFERENCE_DELETED = "conferenceDeleted";
    public static final String METHOD_CONFERENCE_UPDATED = "conferenceUpdated";
    public static final String METHOD_CONFERENCE_UPDATE_REQUEST = "conferenceUpdateRequest";
    public static final String METHOD_GET_CONFERENCE_CALLS = "getConferenceCalls";
    public static final String METHOD_CALL_REPORT = "callReport";
    public static final String METHOD_SET_RECORDING_STATE = "setRecordingState";
    public static final String METHOD_VOICE_RECORDING = "voiceRecording";
    public static final String METHOD_DELETE_FILE = "deleteFile";
    public static final String METHOD_DELETE_FILES = "deleteFiles";
    public static final String METHOD_DELETE_RECORD = "deleteRecord";
    public static final String METHOD_GET_CHANNEL_STATE = "getChannelState";
    public static final String METHOD_MICROPHONE_STATE = "microphoneState";
    public static final String METHOD_SPEAKER_STATE = "speakerState";
    public static final String METHOD_DEVICE_INFO = "deviceInfo";
    public static final String METHOD_CUSTOM_EXTENSION = "customExtension";
    public static final String METHOD_BILLING_EXTENSION = "billingExtension";
    public static final String METHOD_IMAGE_CHANGED = "imageChanged";
    public static final String METHOD_STATE_CHANGED = "stateChanged";
    public static final String METHOD_SET_DEVICE_TOKEN = "setDeviceToken";
    public static final String METHOD_DELETE_CALL_HISTORY = "deleteCallHistory";
    public static final String METHOD_GET_CHAT_REQUEST = "getChatRequest";
    public static final String METHOD_ACCEPT_CHAT_REQUEST = "acceptChatRequest";
    public static final String METHOD_ACCEPT_TASK = "acceptTask";
    public static final int ONE_DAY = 4;
    public static final int ONE_WEEK = 3;
    public static final int ONE_MONTH = 2;
    public static final int ONE_YEAR = 1;
    public static final String NAME_AVATAR = "$AVATAR$";
    public static final String VMAIL_GREETING = "$voicemail_greeting$.wav";
    public static final String EXPORT_CONTACTS = "exportContacts";
    public static final String SHOW_STATUS = "showstatus";
    public static final String SEND_DELIVERY_REPORT = "senddeliveryreport";
    public static final String PREVIEW = "preview";
    public static final String SHARE_DOCS = "sharedocs";
    public static final String SHOW_AVATAR = "showavatar";
    public static final String SHOW_PUSH_MESSAGES = "showpushmessages";
    public static final String PUSH_MESSAGE = "push_message";
    public static final String POPUP_WINDOWS = "popupwindows";
    public static final String INCLUSION_WINDOWS = "inclusionwindows";
    public static final String UNLOCK_SCREEN = "unlockscreen";
    public static final String OUTGOING_MESS_NOTIFY = "outgoingmessnotify";
    public static final String SYSTEM_NOTIFY = "systemnotify";
    public static final String VIDEO_CALL = "videocall";
    public static final String ENTER_KEY = "enterkey";
    public static final String AUTOLOAD_MEDIA = "autoloadmedia";
    public static final String SAVE_MEDIA_IN_CLOUD = "savemadiaincloud";
    public static final String SAVE_TO_GALLERY = "savetogallery";
    public static final String SHOW_M1_TOOLBAR = "showm1toolbar";
    public static final String WIFI_POLICY = "wifipolicy";
    public static final String CONNECT_TO_M1 = "connecttom1";
    public static final String LIVETV_CAMERA = "livetvcamera";
    public static final String TERMINAL_TYPE = "terminalType";
    public static final String NEARBY_USERS_LIST = "nearbyUsersList";
    public static final String SERVICE_TRUNK_NAME = "serviceTrunkName";
    public static final String POLICY_URL = "policy_url";
    public static final String ENCRYPT_DATA = "encrypt_data";
    public static final String APPLICATION_MODE = "application_mode";
    public static final String GSM_NUMBER = "gsm_number";
    public static final String ALWAYS_ONLINE = "alwaysonline";
    public static final String NO_LOCAL_COPY = "nolocalcopy";
    public static final String LOCAL_COPY = "localcopy";
    public static final String CALL_FROM_PHONE = "callfromphone";
    public static final String APNS = "apns";
    public static final String APNS_DEV = "apns_dev";
    public static final String APNS_VOIP = "apns_voip";
    public static final String APNS_VOIP_DEV = "apns_voip_dev";
    public static final String GCM = "gcm";

    public ServiceManager(ClientConnector client) {
        this.client = client;
        this.lines = new Vector<LineInfo>();
        this.timerTasks = new HashMap();
        this.serviceProperties = new HashMap();
        this.fileLoader = new FileLoader(this, 2);
        this.homedir = new File(System.getProperty("user.home") + "/." + client.getApplicationName().toLowerCase());
        if (!this.homedir.exists()) {
            this.homedir.mkdir();
        }
        this.contacts = new HashMap<String, ContactInfo>();
        this.sessions = new HashMap<String, SessionInfo>();
        this.tmpFiles = new HashMap<String, File>();
        this.contactgroups = new HashMap<String, Map>();
        try {
            this.localProperties = (Map)this.loadObject(new File(this.homedir, "properties.ser"));
        }
        catch (Exception e) {
            this.localProperties = new HashMap();
        }
        String osname = System.getProperty("os.name").toLowerCase();
        boolean bl = this.ismobile = "ios".equalsIgnoreCase(osname) || "dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"));
        if (osname.indexOf("ios") != -1 && !"x86_64".equals(System.getProperty("os.arch"))) {
            this.lineEventListener = new CallKitAdapter(this);
        } else {
            this.writelog = true;
        }
        MyLogger.getInstance().setServiceManager(this);
        this.toLog(this + " created");
    }

    public boolean isMobileVersion() {
        return this.ismobile;
    }

    protected void setWritelog(boolean b) {
        this.writelog = b;
    }

    protected void setServerAddress(String address) {
        this.fileLoader.setServer(address, null);
    }

    protected void setServerConnector(ServerConnector server) {
        this.server = server;
        this.initProperties();
    }

    protected void applicationStateChanged(boolean active) {
        if (active) {
            for (int i = 0; i < this.lines.size(); ++i) {
                LineInfo lineInfo = this.lines.get(i);
                if (lineInfo.getState() != 4) continue;
                lineInfo.setState(9);
            }
        }
    }

    protected void networkConnectionChanged() {
        if (!this.hasActiveCalls()) {
            this.reconnect();
        }
    }

    protected File getHomeDir() {
        return this.homedir;
    }

    private void setUserDir(String server, String user) {
        int n = server.indexOf(58);
        if (n != -1) {
            server = server.substring(0, n);
        }
        this.filedir = new File(this.homedir, server + "/" + user);
        if (!this.filedir.exists()) {
            this.filedir.mkdirs();
        }
    }

    public void userRegistered(String secret) {
        this.online = true;
        if (secret != null) {
            this.pass = secret.toCharArray();
        }
        if (this.numbers == null) {
            this.loadObjects(secret != null ? secret.toCharArray() : null);
        }
    }

    private void loadObjects(char[] pass) {
        File objfile = new File(this.filedir, "objects.ser");
        String alg = (String)this.localProperties.get(ENCRYPT_DATA);
        this.toLog("loadObjects alg=" + alg + " pass=" + pass + " file=" + objfile + " size=" + objfile.length() + " local=" + this.localProperties.get(LOCAL_COPY));
        try {
            Number delta;
            if (alg != null) {
                if (pass == null) {
                    return;
                }
                this.loadKeyStore(pass);
            }
            this.numbers = new Hashtable<String, ContactInfo>();
            if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
                this.contacts = new HashMap<String, ContactInfo>();
                this.sessions = new HashMap<String, SessionInfo>();
                this.contactgroups = new HashMap<String, Map>();
                this.lastSavedTime = 0L;
                return;
            }
            Map localObjects = (Map)this.loadObject(objfile, alg);
            Number timestamp = (Number)localObjects.get("timestamp");
            if (timestamp != null) {
                this.lastSavedTime = timestamp.longValue();
            }
            if ((delta = (Number)localObjects.get("delta")) != null) {
                this.deltaTime = delta.longValue();
            }
            this.myInfo = (ContactInfo)localObjects.get("profile");
            this.contacts = (Map)localObjects.get("contacts");
            this.sessions = (Map)localObjects.get("sessions");
            this.contactgroups = (Map)localObjects.get("contactgroups");
            if (this.contactgroups == null) {
                this.contactgroups = new HashMap<String, Map>();
            }
            this.toLog("loadObjects: timestamp=" + this.lastSavedTime + " deltaTime=" + this.deltaTime + " t=" + timestamp + " contacts=" + this.contacts.size() + " sessions=" + this.sessions.size());
        }
        catch (Throwable e) {
            this.toLog("loadObjects: " + e);
            this.resetCache(pass);
            this.contacts = new HashMap<String, ContactInfo>();
            this.sessions = new HashMap<String, SessionInfo>();
            this.numbers = new Hashtable<String, ContactInfo>();
            this.contactgroups = new HashMap<String, Map>();
            this.pushmessage = null;
            this.lastSavedTime = 0L;
            this.deltaTime = 0L;
            return;
        }
        Iterator itr = this.contactsIterator();
        while (itr.hasNext()) {
            try {
                this.setNumbers((ContactInfo)itr.next());
            }
            catch (Exception exception) {}
        }
        if (this.pushmessage != null) {
            this.setIncomingMessage(this.pushmessage);
            this.pushmessage = null;
        }
        this.loadSessions();
        this.checkAvatars();
        this.toLog("loadObjects OK");
    }

    private void loadSessions() {
        try {
            List list = this.getSorted(this.sessionsIterator());
            for (int i = 0; i < list.size(); ++i) {
                File file;
                SessionInfo sessionInfo = (SessionInfo)list.get(i);
                this.loadMessages(sessionInfo, 200, true, 0L);
                String filename = sessionInfo.getSessionId();
                if (filename == null || !(file = new File(this.client.getAvatarsDir(), filename)).exists() || file.length() <= 0L) continue;
                sessionInfo.setImageFile(file);
            }
        }
        catch (Throwable e) {
            this.toLog("loadSessions: " + e);
        }
    }

    private void checkAvatars() {
        Iterator itr = this.contactsIterator();
        while (itr.hasNext()) {
            ContactInfo contact = (ContactInfo)itr.next();
            File file = new File(this.client.getAvatarsDir(), contact.getImageId());
            if (!file.exists() && contact.getLocalId() != null) {
                file = new File(this.client.getAvatarsDir(), contact.getLocalId() + "ava");
            }
            if (!file.exists() || file.length() <= 0L) continue;
            contact.setImageFile(file);
        }
    }

    private void resetCache(char[] pass) {
        this.deleteCache();
        this.keyStore = null;
        if (pass != null) {
            try {
                this.loadKeyStore(pass);
            }
            catch (Exception ex) {
                this.toLog("loadKeyStore - " + ex);
                ex.printStackTrace();
            }
        }
    }

    private void setNumbers(ContactInfo contactInfo) {
        if (contactInfo.isDeleted()) {
            return;
        }
        String userid = contactInfo.getUserID();
        if (userid != null) {
            this.numbers.put(userid, contactInfo);
        }
        if (contactInfo.isBlf()) {
            return;
        }
        String extension = (String)contactInfo.getProperty("extension");
        if (extension == null) {
            extension = (String)contactInfo.getProperty("ext");
        }
        if (extension != null) {
            this.numbers.put(extension, contactInfo);
        }
        String cc = this.client.getCountryCode();
        List<String> phones = this.getPhoneNumbers(contactInfo);
        for (int i = 0; i < phones.size(); ++i) {
            String phone = phones.get(i);
            ContactInfo contact = this.numbers.put(phone, contactInfo);
            if (contact != null && !contact.equals(contactInfo) && (contact.getState() != -1 && contactInfo.getState() == -1 || contact.getStatus() >= 4 && contactInfo.getStatus() < 4)) {
                this.numbers.put(phone, contact);
                continue;
            }
            if (cc == null) continue;
            this.numbers.put(this.normalizePhoneNumber(phone, cc), contactInfo);
        }
    }

    private void removeNumbers(ContactInfo contactInfo) {
        String extension;
        String userid = contactInfo.getUserID();
        if (userid != null) {
            this.numbers.remove(userid);
        }
        if ((extension = (String)contactInfo.getProperty("extension")) != null) {
            this.numbers.remove(extension);
        }
        String cc = this.client.getCountryCode();
        List<String> phones = this.getPhoneNumbers(contactInfo);
        for (int i = 0; i < phones.size(); ++i) {
            String number = phones.get(i);
            this.numbers.remove(number);
            if (cc == null) continue;
            this.numbers.remove(this.normalizePhoneNumber(number, cc));
        }
    }

    public boolean isInternalNumber(String number) {
        ContactInfo contact = this.numbers.get(number);
        return contact != null && (contact.isUser() || contact.isPhone());
    }

    private void saveObjects() {
        if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
            return;
        }
        this.lastSavedTimeBak = this.lastSavedTime;
        if (this.online && this.startedOnline) {
            this.lastSavedTime = this.getServerTime();
        }
        if (this.saveTask == null) {
            this.saveTask = new TimerTask(){

                @Override
                public void run() {
                    new Thread(){

                        @Override
                        public void run() {
                            ServiceManager.this.saveObjects_();
                            ServiceManager.this.saveTask = null;
                        }
                    }.start();
                }
            };
            try {
                Utils.getTimer().schedule(this.saveTask, 3000L);
            }
            catch (Exception e) {
                this.toLog("saveObjects() - " + e);
            }
        }
    }

    private void saveObjects_() {
        if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
            return;
        }
        HashMap<String, Object> localObjects = new HashMap<String, Object>();
        localObjects.put("profile", this.myInfo);
        localObjects.put("contacts", this.contacts);
        localObjects.put("sessions", this.sessions);
        localObjects.put("timestamp", this.lastSavedTime);
        localObjects.put("delta", new Long(this.deltaTime));
        localObjects.put("contactgroups", this.contactgroups);
        this.toLog("saveObjects timestamp=" + this.lastSavedTime);
        try {
            File file = new File(this.filedir, "objects.ser");
            this.saveObject(file, localObjects, (String)this.localProperties.get(ENCRYPT_DATA));
            this.toLog("saveObjects file=" + file + " size=" + file.length());
        }
        catch (Throwable e) {
            this.toLog("saveObjects: " + e);
            this.lastSavedTime = this.lastSavedTimeBak;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator contactsIterator() {
        Map<String, ContactInfo> map = this.contacts;
        synchronized (map) {
            Map clone = (Map)((HashMap)this.contacts).clone();
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator sessionsIterator() {
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            Map clone = (Map)((HashMap)this.sessions).clone();
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllMessages() {
        this.saveObjects_();
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            for (SessionInfo sessionInfo : this.sessions.values()) {
                try {
                    this.saveObject(new File(this.filedir, sessionInfo.getSessionId()), sessionInfo.getMessages(), (String)this.localProperties.get(ENCRYPT_DATA));
                }
                catch (Exception e) {
                    this.toLog(sessionInfo + " saveSessionMessages sessionid=" + sessionInfo.getSessionId() + " error=" + e);
                }
            }
        }
    }

    private List loadSessionMessages(SessionInfo sessionInfo) {
        if (sessionInfo.getSessionId() == null) {
            return null;
        }
        File file = new File(this.filedir, sessionInfo.getSessionId());
        if (!file.exists()) {
            return null;
        }
        try {
            return (List)this.loadObject(file, (String)this.localProperties.get(ENCRYPT_DATA));
        }
        catch (Exception e) {
            this.toLog("loadSessionMessages: " + e);
            return new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSessionMessages(SessionInfo sessionInfo, List<MessageInfo> update) {
        if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY)) || update.isEmpty() || !this.sessions.containsKey(sessionInfo.getSessionId())) {
            return;
        }
        SessionInfo sessionInfo2 = sessionInfo;
        synchronized (sessionInfo2) {
            List<MessageInfo> stored = this.loadSessionMessages(sessionInfo);
            if (stored == null) {
                stored = sessionInfo.getMessages();
            } else {
                for (int i = 0; i < update.size(); ++i) {
                    MessageInfo mi = update.get(i);
                    if (mi.getStatus() == 8) {
                        stored.remove(update.get(i));
                        continue;
                    }
                    int n = stored.indexOf(mi);
                    if (n == -1) {
                        stored.add(mi);
                        continue;
                    }
                    stored.set(n, mi);
                }
                try {
                    Collections.sort(stored);
                }
                catch (Exception e) {
                    return;
                }
            }
            try {
                this.saveObject(new File(this.filedir, sessionInfo.getSessionId()), stored, (String)this.localProperties.get(ENCRYPT_DATA));
                this.toLog(sessionInfo + " saveSessionMessages " + update.size() + " stored=" + stored.size());
            }
            catch (Exception e) {
                this.toLog(sessionInfo + " saveSessionMessages sessionid=" + sessionInfo.getSessionId() + " error=" + e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSessionMessage(SessionInfo sessionInfo, MessageInfo mi) {
        if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
            return;
        }
        SessionInfo sessionInfo2 = sessionInfo;
        synchronized (sessionInfo2) {
            int n;
            Vector<MessageInfo> stored = this.loadSessionMessages(sessionInfo);
            if (stored == null) {
                stored = new Vector<MessageInfo>();
            }
            if ((n = stored.indexOf(mi)) == -1) {
                MessageInfo prevmess;
                stored.add(mi);
                if (stored.size() > 1 && (prevmess = (MessageInfo)stored.get(stored.size() - 2)) instanceof MenuInfo) {
                    ((MenuInfo)prevmess).removeMenu();
                }
            } else {
                stored.set(n, mi);
            }
            try {
                this.saveObject(new File(this.filedir, sessionInfo.getSessionId()), stored, (String)this.localProperties.get(ENCRYPT_DATA));
            }
            catch (Exception e) {
                this.toLog("saveSessionMessage: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionMessages(SessionInfo sessionInfo, List<MessageInfo> update) {
        if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
            return;
        }
        SessionInfo sessionInfo2 = sessionInfo;
        synchronized (sessionInfo2) {
            List stored = this.loadSessionMessages(sessionInfo);
            if (stored == null) {
                return;
            }
            if (update == null) {
                stored.clear();
            } else {
                for (int i = 0; i < update.size(); ++i) {
                    stored.remove(update.get(i));
                }
            }
            try {
                this.saveObject(new File(this.filedir, sessionInfo.getSessionId()), stored, (String)this.localProperties.get(ENCRYPT_DATA));
            }
            catch (Exception e) {
                this.toLog("removeSessionMessages: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionMessage(SessionInfo sessionInfo, MessageInfo mi) {
        if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
            return;
        }
        SessionInfo sessionInfo2 = sessionInfo;
        synchronized (sessionInfo2) {
            List stored = this.loadSessionMessages(sessionInfo);
            if (stored == null) {
                return;
            }
            stored.remove(mi);
            try {
                this.saveObject(new File(this.filedir, sessionInfo.getSessionId()), stored, (String)this.localProperties.get(ENCRYPT_DATA));
            }
            catch (Exception e) {
                this.toLog("removeSessionMessage: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllMessages() {
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            for (SessionInfo sessionInfo : this.sessions.values()) {
                sessionInfo.removeAllMessages();
                new File(this.filedir, sessionInfo.getSessionId()).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreAll(String oldenc, String newenc) throws Exception {
        File imageFile;
        if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY)) || newenc != null && newenc.equals(oldenc)) {
            return;
        }
        this.toLog("restoreAll oldenc=" + oldenc + " newenc=" + newenc + " keyStore=" + this.keyStore + " pass=" + this.pass);
        if (this.keyStore == null) {
            this.loadKeyStore(this.pass);
        }
        this.saveObjects_();
        Map<String, Cloneable> map = this.sessions;
        synchronized (map) {
            for (SessionInfo sessionInfo : this.sessions.values()) {
                File file;
                imageFile = sessionInfo.getImageFile();
                if (imageFile != null && imageFile.exists()) {
                    this.restore(imageFile, oldenc, newenc);
                }
                if (!(file = new File(this.filedir, sessionInfo.getSessionId())).exists()) continue;
                try {
                    MessageInfo messageInfo;
                    int i;
                    List<MessageInfo> messages;
                    List stored;
                    Long since = System.currentTimeMillis();
                    MessageInfo firstMessage = sessionInfo.getFirstMessage();
                    if (firstMessage != null) {
                        since = firstMessage.getTime();
                    }
                    if ((stored = (List)this.loadObject(file, oldenc)) != null) {
                        messages = new ArrayList<MessageInfo>();
                        for (i = 0; i < stored.size() && (messageInfo = (MessageInfo)stored.get(i)).getTime() < since; ++i) {
                            messages.add(messageInfo);
                        }
                        sessionInfo.addMessages(messages, false);
                    }
                    messages = sessionInfo.getMessages();
                    for (i = 0; i < messages.size(); ++i) {
                        messageInfo = messages.get(i);
                        if (!(messageInfo instanceof FileInfo)) continue;
                        this.restore((FileInfo)messageInfo, oldenc, newenc);
                    }
                    this.saveObject(file, messages, newenc);
                }
                catch (Exception e) {
                    this.toLog(sessionInfo + " saveSessionMessages sessionid=" + sessionInfo.getSessionId() + " error=" + e);
                }
            }
        }
        map = this.contacts;
        synchronized (map) {
            for (ContactInfo contactInfo : this.contacts.values()) {
                imageFile = contactInfo.getImageFile();
                if (imageFile == null || !imageFile.exists()) continue;
                this.restore(imageFile, oldenc, newenc);
            }
        }
        File imageFile2 = this.myInfo.getImageFile();
        if (imageFile2 != null && imageFile2.exists()) {
            this.restore(imageFile2, oldenc, newenc);
        }
    }

    private void restore(FileInfo fileInfo, String oldenc, String newenc) {
        if (this.restore(fileInfo.getFile(), oldenc, newenc)) {
            fileInfo.setProperty("file-encrypted", newenc != null);
        }
    }

    private boolean restore(File file, String oldenc, String newenc) {
        if (file == null || !file.exists()) {
            return false;
        }
        boolean ok = false;
        try {
            if (oldenc != null) {
                File tmp = this.tmpFiles.get(file.getPath());
                if (tmp == null) {
                    tmp = this.decrypt(file, oldenc);
                }
                boolean bl = ok = file.delete() && tmp.renameTo(file);
            }
            if (newenc != null) {
                this.saveFile(file, file, newenc);
                ok = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            file.delete();
        }
        this.toLog("restore=" + ok + " file=" + file);
        return ok;
    }

    public String getApplicationName() {
        return this.client.getApplicationName();
    }

    public void setSystemSoundsDir(String dir) {
        this.server.setSystemSoundsDir(dir);
    }

    public Map sendCommand(String server, String method, Map params) throws Exception {
        return this.fileLoader.sendCommand(server, method, params);
    }

    public Object sendCommand(String method, Map params) throws Exception {
        return this.sendCommand(method, params, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendCommand(String method, Map params, long timeout) throws Exception {
        if (!this.online) {
            if (this.server.isConnecting()) {
                ServiceManager serviceManager = this;
                synchronized (serviceManager) {
                    this.wait(5000L);
                }
            }
            if (!this.online) {
                throw new IllegalStateException("NotConnected");
            }
        }
        return this.server.sendCommand(method, params, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendIndication(String method, Map params) throws Exception {
        if (!this.online) {
            if (this.server.isConnecting()) {
                ServiceManager serviceManager = this;
                synchronized (serviceManager) {
                    this.wait(5000L);
                }
            }
            if (!this.online) {
                throw new IllegalStateException("NotConnected");
            }
        }
        this.server.sendIndication(method, params);
    }

    protected void processCommand(String method, Map parameters) throws Exception {
        this.toLog("processCommand " + method);
        if (method.equals("state")) {
            this.processState(parameters);
        } else if (method.equals("callinfo")) {
            this.processCallInfo(parameters);
        } else if (method.equals("events")) {
            this.processEvents(parameters);
        } else if (method.equals("message")) {
            this.processMessage(parameters);
        } else if (method.equals("command")) {
            this.processCommand(parameters);
        } else if (method.equals("delivery")) {
            this.messageDelivered(parameters);
        } else if (method.equals("read")) {
            this.messageRead(parameters);
        } else if (method.equals("typing") || method.equals(METHOD_MESSAGE_TYPED)) {
            this.messageTyped(parameters);
        } else if (method.equals("conferenceStart")) {
            this.processConferenceStart(parameters);
        } else if (method.equals("conferenceStop")) {
            this.processConferenceStop(parameters);
        } else if (method.equals("conferenceUpdate")) {
            this.processConferenceUpdate(parameters);
        } else if (method.equals("terminate")) {
            this.terminate(parameters);
        } else if (method.equals("trunkState")) {
            this.trunkState(parameters);
        } else if (method.equals(METHOD_SESSION_UPDATED)) {
            this.sessionUpdated(parameters);
        } else if (method.equals(METHOD_SESSION_DELETED)) {
            this.sessionDeleted(parameters);
        } else if (method.equals(METHOD_IMAGE_CHANGED)) {
            this.imageChanged(parameters);
        } else if (method.equals(METHOD_MESSAGE_UPDATED)) {
            this.messageUpdated(parameters);
        } else if (method.equals(METHOD_MESSAGE_DELETED)) {
            this.messageDeleted(parameters);
        } else if (method.equals(METHOD_CONTACT_REQUESTED)) {
            this.contactRequested(parameters);
        } else if (method.equals(METHOD_CONTACT_ACCEPTED)) {
            this.contactAccepted(parameters);
        } else if (method.equals(METHOD_CONTACT_REJECTED)) {
            this.contactRejected(parameters);
        } else if (method.equals(METHOD_CONTACT_CREATED)) {
            this.contactCreated(parameters);
        } else if (method.equals(METHOD_CONTACT_UPDATED)) {
            this.contactUpdated(parameters);
        } else if (method.equals(METHOD_CONTACT_DELETED)) {
            this.contactDeleted(parameters);
        } else if (method.equals(METHOD_VOICE_RECORDING)) {
            if (!this.setRecordingIndication(parameters)) {
                Thread.sleep(1000L);
                this.setRecordingIndication(parameters);
            }
        } else if (method.equals(METHOD_CONFERENCE_CREATED)) {
            this.conferenceCreated(parameters);
        } else if (method.equals(METHOD_CONFERENCE_DELETED)) {
            this.conferenceDeleted(parameters);
        } else if (method.equals(METHOD_CONFERENCE_UPDATED)) {
            this.conferenceUpdated(parameters);
        } else if (method.equals(METHOD_CONFERENCE_UPDATE_REQUEST)) {
            this.conferenceUpdateRequest(parameters);
        } else if (method.equals("contactGroupCreated") || method.equals("contactGroupUpdated") || method.equals("contactGroupDeleted")) {
            this.setContactGroup(parameters);
        } else if (method.equals("serviceContactDeleted")) {
            this.serviceContactDeleted(parameters);
        } else {
            this.client.commandReceived(method, parameters);
        }
    }

    public LinePane createLinePane(String lineName, LineEventListener listener) {
        LineInfo lineInfo = new LineInfo(lineName);
        this.lines.add(lineInfo);
        lineInfo.addLineEventListener(listener);
        if (this.lineEventListener != null) {
            lineInfo.addLineEventListener(this.lineEventListener);
        }
        return lineInfo;
    }

    public boolean getLocalConferenceMode() {
        return this.localConfmode;
    }

    protected List<LineInfo> getLines() {
        return this.lines;
    }

    public List<String> getLineNames() {
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < this.lines.size(); ++i) {
            names.add(this.lines.get(i).getName());
        }
        return names;
    }

    public LineInfo getLine(String name) {
        for (int i = 0; i < this.lines.size(); ++i) {
            if (!name.equals(this.lines.get(i).getName())) continue;
            return this.lines.get(i);
        }
        return null;
    }

    protected long getLocalTime(long timestamp) {
        return timestamp + this.deltaTime;
    }

    protected long getLocalTimeOffset() {
        return this.deltaTime;
    }

    protected long getServerTime() {
        return System.currentTimeMillis() - this.deltaTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionSet() {
        this.server.connectionSet();
        this.online = true;
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            this.notifyAll();
        }
        this.toLog("connectionSet lastSavedTime=" + this.lastSavedTime + " startedOnline=" + this.startedOnline + " state=" + (this.myInfo != null ? Integer.valueOf(this.myInfo.getState()) : null));
        if (this.startedOnline) {
            if (this.myInfo == null || this.myInfo.getState() == 0) {
                this.stateChanged(1);
            } else {
                this.stateChanged(this.myInfo.getState());
            }
            this.client.connectionSet();
            if (this.lastSavedTime > 0L) {
                long timeout;
                long since = this.lastSavedTime - 1000L;
                long l = timeout = this.isMobileVersion() ? 600000L : 60000L;
                while (this.online) {
                    try {
                        Thread.sleep(500L);
                        this.getEvents(since);
                    }
                    catch (Exception e) {
                        this.toLog(e);
                        this.lastSavedTimeBak = this.lastSavedTime = since;
                        if (System.currentTimeMillis() - this.server.getLastRegistrationTime() <= timeout) continue;
                        this.online = false;
                    }
                    break;
                }
            }
        }
        if (this.online) {
            this.setUnsentTask(5000L);
        }
    }

    public void connectionLost() {
        this.online = false;
        this.client.stateChanged(0);
        if (this.myInfo != null && this.myInfo.getState() != 3 && this.myInfo.getState() != 4) {
            this.myInfo.setState(0);
        }
        this.toLog("connectionLost");
    }

    public String getUserId() {
        return this.myInfo != null ? this.myInfo.getUserID() : null;
    }

    public String getUserExtension() {
        if (this.myInfo == null) {
            return null;
        }
        String ext = (String)this.myInfo.getProperty("extension");
        if (ext == null) {
            ext = (String)this.myInfo.getProperty("ext");
        }
        return ext;
    }

    public int getUserState() {
        return this.myInfo != null ? this.myInfo.getState() : 0;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.server.getConnectionInfo();
    }

    public void unregister() {
        this.server.unregister(true);
    }

    public void deleteTmpDir() {
        File[] tmps = this.client.getTempDir().listFiles();
        if (tmps != null) {
            int c = 0;
            for (int i = 0; i < tmps.length; ++i) {
                if (!tmps[i].delete()) continue;
                ++c;
            }
            this.toLog("deleteTmpDir delete " + c + " files from " + tmps.length);
        }
    }

    public void deleteUser(String termid) throws Exception {
        this.deleteCache();
        this.filedir.delete();
        new File(this.homedir, "properties.ser").delete();
        HashMap<String, String> map = new HashMap<String, String>();
        if (termid != null) {
            map.put("termid", termid);
        }
        this.sendCommand("deleteUser", map);
    }

    private void deleteCache() {
        this.deleteTmpDir();
        this.removeAllMessages();
        this.clearDir(this.filedir);
        this.clearDir(this.client.getCacheDir());
        this.clearDir(this.client.getFilesDir());
    }

    private int clearDir(File dir) {
        if (dir == null) {
            return 0;
        }
        int c = 0;
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    c += this.clearDir(files[i]);
                    continue;
                }
                if (!files[i].delete()) continue;
                ++c;
            }
        }
        this.toLog("delete " + c + " files from " + dir);
        return c;
    }

    public Map findLogin(String serverAddress, String login) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("login", login);
        return this.sendCommand(serverAddress, "findLogin", prms);
    }

    public Map signUp(String serverAddress, Map map) throws Exception {
        Integer code;
        String method;
        if (this.userlogin != null) {
            this.onExit(false, false);
            this.localProperties.remove("termpass");
            this.startedOnline = false;
            this.userlogin = null;
        }
        String string = method = map.containsKey("code") || map.containsKey("callback") ? METHOD_REGISTRATION_COMPLETE : METHOD_REGISTRATION_REQUEST;
        if (method.equals(METHOD_REGISTRATION_REQUEST)) {
            map.put("termid", this.client.getTerminalId());
            map.put("devinfo", this.client.getTerminalInfo());
            map.put("language", Locale.getDefault().getLanguage());
        }
        map.put("country", Locale.getDefault().getCountry());
        this.toLog("signUp method=" + method + " params=" + map);
        Map result = this.sendCommand(serverAddress, method, map);
        String termpass = (String)result.remove("termpass");
        if (termpass != null) {
            this.localProperties.put("termpass", termpass.toCharArray());
            this.saveProperties();
        }
        if ((code = (Integer)result.get("code")) != null && code == 0) {
            this.myInfo = new ContactInfo(result, true);
        }
        this.toLog("signUp result=" + result + " myInfo=" + this.myInfo);
        return result;
    }

    public Map getQRCodeInfo(File file) throws Exception {
        HashMap<String, File> params = new HashMap<String, File>();
        params.put("file", file);
        return this.sendCommand("shell.ringotel.co/support", "getQRCodeInfo", params);
    }

    public Map codeRequest(String serverAddress, Map map) throws Exception {
        return this.sendCommand(serverAddress, "codeRequest", map);
    }

    public Map resetPassword(String serverAddress, Map map) throws Exception {
        return this.sendCommand(serverAddress, "resetPassword", map);
    }

    public int signIn(String serverAddress) throws Exception {
        return this.signIn(serverAddress, false);
    }

    public int signIn(String serverAddress, boolean forceReconnect) throws Exception {
        String proxy;
        String login;
        if (serverAddress == null) {
            serverAddress = (String)this.localProperties.get("server");
        }
        if (serverAddress == null) {
            return 0;
        }
        if (this.online && this.hasActiveCalls() && !forceReconnect) {
            return 2;
        }
        char[] password = (char[])this.localProperties.get("termpass");
        if (password != null) {
            login = this.client.getTerminalId();
        } else {
            login = (String)this.localProperties.get("login");
            password = (char[])this.localProperties.get("password");
        }
        Boolean signout = (Boolean)this.localProperties.get("signout");
        this.toLog("signIn login=" + login + " password=" + password + " signout=" + signout);
        if (login == null) {
            return 0;
        }
        if (password == null) {
            return 1;
        }
        if (signout != null) {
            return 1;
        }
        this.serverAddr = serverAddress;
        this.userlogin = (String)this.localProperties.get("login");
        if (this.userlogin == null) {
            this.userlogin = login;
        }
        this.setUserDir(serverAddress, this.userlogin);
        if (this.numbers == null && this.localProperties.get(ENCRYPT_DATA) == null) {
            if (!this.signIn(login, password)) {
                throw new Exception("Forbidden");
            }
            new Thread(){

                @Override
                public void run() {
                    ServiceManager.this.loadObjects(null);
                }
            }.start();
        }
        if (this.signIn(serverAddress, login, password, proxy = (String)this.localProperties.get("proxy"), forceReconnect)) {
            if (this.startedOnline) {
                return 2;
            }
            if (this.lastSavedTime == -1L) {
                for (int i = 0; i < 50; ++i) {
                    Thread.sleep(200L);
                    if (this.lastSavedTime != -1L) break;
                }
            }
            if (this.localProperties.get(ENCRYPT_DATA) == null && this.lastSavedTime > 0L) {
                final char[] pass = password;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            ServiceManager.this.initOnline(true);
                        }
                        catch (Exception e) {
                            ServiceManager.this.toLog(e);
                            ServiceManager.this.initOffline(pass);
                            ServiceManager.this.client.initError("CommunicationError");
                        }
                    }
                }.start();
                return 3;
            }
            try {
                this.initOnline(true);
                return 2;
            }
            catch (Exception e) {
                this.unregister();
                return 1;
            }
        }
        if (this.localProperties.get(ENCRYPT_DATA) != null || Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
            return 1;
        }
        if (this.signIn(login, password) && this.initOffline(password)) {
            return 2;
        }
        throw new Exception("Forbidden");
    }

    public boolean logIn(String serverAddress, String username, char[] password, String proxy, boolean save) throws Exception {
        if (serverAddress == null) {
            throw new Exception("InvalidServer");
        }
        if (!(this.userlogin == null || this.userlogin.equals(username) && serverAddress.equals(this.serverAddr))) {
            this.onExit(true, false);
            this.localProperties.remove("termpass");
            this.startedOnline = false;
            this.numbers = null;
            this.lastSavedTime = 0L;
        }
        this.userlogin = username;
        this.serverAddr = serverAddress;
        this.setUserDir(serverAddress, this.userlogin);
        String login = username;
        char[] termpass = (char[])this.localProperties.get("termpass");
        if (termpass != null && new String(termpass).equals(new String(password)) && username.equals(this.localProperties.get("login"))) {
            login = this.client.getTerminalId();
        }
        String err = "NotConnected";
        if ("".equals(proxy)) {
            proxy = null;
        }
        if (this.signIn(serverAddress, login, password, proxy, true)) {
            this.saveCredentials(serverAddress, username, password, proxy, save);
            try {
                this.initOnline(true);
                return true;
            }
            catch (Exception e) {
                this.toLog(e);
                this.unregister();
                err = "CommunicationError";
            }
        }
        if (this.numbers != null && !Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY)) && this.signIn(login, password)) {
            this.saveCredentials(serverAddress, username, password, proxy, save);
            if (this.initOffline(password)) {
                return true;
            }
        }
        throw new Exception(err);
    }

    private boolean signIn(String serverAddress, String login, char[] password, String proxy, boolean reconnect) throws Exception {
        boolean result = this.signIn_(serverAddress, login, password, proxy, reconnect);
        if (!result && proxy != null && proxy.length() > 0) {
            result = this.signIn_(serverAddress, login, password, null, reconnect);
        }
        return result;
    }

    private boolean signIn_(String serverAddress, String login, char[] password, String proxy, boolean reconnect) throws Exception {
        this.toLog("signIn login=" + login + " pass=" + password + " domain=" + serverAddress + " proxy=" + proxy);
        try {
            this.pass = password;
            this.server.register(serverAddress, login, password, proxy, this.client.getProductTitle(), reconnect);
            return true;
        }
        catch (Exception e) {
            this.client.stateChanged(0);
            String message = e.getMessage();
            this.toLog("signIn: " + message);
            if (message != null && ("Forbidden".equals(message) || "Unauthorized".equals(message) || "Registration limit reached".equals(message) || message.contains("certificate"))) {
                throw e;
            }
            this.toLog(e);
            String s = "shell.ringotel.co/bugreport/" + serverAddress.substring(0, serverAddress.indexOf(46)) + "-" + login + "-" + this.client.getTerminalId() + ".txt";
            try {
                if (this.sendLog(s)) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof UnknownHostException) {
                return false;
            }
            throw e;
        }
    }

    private boolean signIn(String login, char[] password) {
        String hash;
        char[] pass = (char[])this.localProperties.get("termpass");
        if (pass != null && login.equals(this.client.getTerminalId()) && String.valueOf(password).equals(String.valueOf(pass))) {
            return true;
        }
        pass = (char[])this.localProperties.get("password");
        if (pass != null && login.equals(this.localProperties.get("login")) && String.valueOf(password).equals(String.valueOf(pass))) {
            return true;
        }
        Map hashMap = (Map)this.localProperties.get("passwords");
        if (hashMap != null && (hash = (String)hashMap.get(login)) != null) {
            try {
                return hash.equals(this.hash(new String(password)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected void initProfile(Map profile) {
        Object obj;
        long imgdate;
        this.toLog("initProfile: myInfo=" + this.myInfo + " " + profile);
        ConnectionInfo connectionInfo = this.server.getConnectionInfo();
        this.fileLoader.setServer(connectionInfo.getServer(), connectionInfo.getProxy());
        this.fileLoader.setUsername(connectionInfo.getAuthName());
        this.fileLoader.setPassword(connectionInfo.getPassword());
        String termpass = (String)profile.remove("termpass");
        if (termpass != null) {
            this.localProperties.put("termpass", termpass.toCharArray());
            if (connectionInfo.getAuthName().equals(this.client.getTerminalId())) {
                this.server.setRegistrationPassword(termpass);
            }
            this.fileLoader.setUsername(this.client.getTerminalId());
            this.fileLoader.setPassword(termpass);
            this.saveProperties();
            this.toLog("registered auth=" + connectionInfo.getAuthName() + " termid=" + this.client.getTerminalId() + " termpass=" + termpass);
        }
        String pass = (String)profile.remove("password");
        ContactInfo newinfo = new ContactInfo(profile, true);
        File imageFile = null;
        if (this.myInfo != null) {
            if (this.myInfo.equals(newinfo)) {
                imageFile = this.myInfo.getImageFile();
                newinfo.setProperty("trunks", this.myInfo.getProperty("trunks"));
            } else {
                this.deleteCache();
                this.contacts = new HashMap<String, ContactInfo>();
                this.sessions = new HashMap<String, SessionInfo>();
                this.numbers = new Hashtable<String, ContactInfo>();
                this.contactgroups = new HashMap<String, Map>();
            }
        }
        if ((imgdate = newinfo.getImageTimestamp()) > 0L && (imageFile == null || imageFile.lastModified() < imgdate)) {
            imageFile = new File(this.client.getAvatarsDir(), newinfo.getUserID() + "ava");
            this.loadFile(NAME_AVATAR, imageFile, newinfo);
        }
        newinfo.setImageFile(imageFile);
        this.myInfo = newinfo;
        String country = (String)profile.get("country");
        if (country != null) {
            this.client.setCountryCode(country);
        }
        if (pass != null) {
            this.fileLoader.setUsername(this.getUserId());
            this.fileLoader.setPassword(pass);
        }
        if (Boolean.TRUE.equals(this.myInfo.getProperty("norecents"))) {
            try {
                this.setProperty("includesCallsInRecents", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((obj = this.myInfo.getProperty("acceptedCNs")) != null) {
            try {
                this.setProperty("acceptedCNs", obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.toLog("initProfile " + this.myInfo + " termid=" + this.client.getTerminalId() + " status=" + this.myInfo.getStatus() + " state=" + this.myInfo.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initObjects(Map map) throws Exception {
        Object tones;
        Object obj;
        Object confs;
        String stunserver;
        Object devices;
        Object service = map.get("service");
        if (service != null) {
            Boolean enc;
            this.serviceProperties = (Map)service;
            Integer mod = (Integer)this.serviceProperties.get("mod");
            if (mod != null) {
                if ((mod & 0x40) != 0) {
                    this.localProperties.put(APPLICATION_MODE, "channels");
                } else if ((mod & 0x1000) != 0) {
                    this.localProperties.put(APPLICATION_MODE, "internal");
                } else if ((mod & 0x80) == 0) {
                    this.localProperties.put(APPLICATION_MODE, "phones");
                }
            }
            if ((enc = (Boolean)this.serviceProperties.get("encryption")) != null) {
                this.localProperties.put(ENCRYPT_DATA, enc != false ? "AES" : null);
            }
            Boolean localcopy = (Boolean)this.serviceProperties.get(LOCAL_COPY);
            if (enc != null) {
                this.localProperties.put(LOCAL_COPY, localcopy);
            }
        } else {
            this.localProperties.remove(APPLICATION_MODE);
            this.localProperties.remove(ENCRYPT_DATA);
            this.localProperties.put(LOCAL_COPY, true);
        }
        Long serverTime = (Long)map.get("systime");
        if (serverTime != null) {
            this.deltaTime = System.currentTimeMillis() - serverTime;
            this.localProperties.put("deltaTime", this.deltaTime);
        }
        Boolean b = (Boolean)this.localProperties.get(SHOW_STATUS);
        this.initProfile((Map)map.get("profile"));
        Object trunks = map.get("trunks");
        if (trunks != null) {
            this.myInfo.setProperty("trunks", trunks);
        }
        if ((devices = map.get("devices")) != null) {
            this.myInfo.setProperty("devices", devices);
        }
        this.initContacts((List)map.get("contacts"));
        this.toLog("Init Contacts " + this.contacts.size());
        this.initSessions((List)map.get("sessions"));
        this.toLog("Init Sessions " + this.sessions.size());
        this.checkSessions();
        Object groups = map.get("contactgroups");
        if (groups != null) {
            this.initContactGroups((List)groups);
        }
        if ((stunserver = (String)map.get("stunserver")) != null) {
            this.server.setStun(stunserver);
        }
        if ((confs = map.get("confs")) != null) {
            this.setConferenceStates((List)confs);
        }
        if ((obj = map.get("providers")) != null) {
            this.providers = (List)obj;
        }
        if ((tones = map.get("tones")) != null) {
            ToneGenerator.setTones((List)tones);
        }
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            this.notifyAll();
        }
        this.saveProperties();
    }

    protected void initOnline(boolean b) throws Exception {
        final long since = this.lastSavedTime;
        this.toLog("initOnline since " + since);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (since > 0L || !Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
            params.put("since", since);
        }
        params.put("termid", this.client.getTerminalId());
        params.put("devinfo", this.client.getTerminalInfo());
        params.put("type", this.localProperties.get(TERMINAL_TYPE));
        params.put("signin", b);
        Map result = (Map)this.sendCommand(METHOD_LOAD_OBJECTS, params);
        this.initObjects(result);
        if (since == 0L) {
            this.initLoad(since);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ServiceManager.this.initLoad(since);
                }
            }).start();
        }
        this.startedOnline = true;
        this.client.initOk();
        this.toLog("initOnline OK");
    }

    private void initLoad(long since) {
        try {
            if (since > 0L || !Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
                this.loadMessages(null, since, 0L, 0);
            }
            this.lastSavedTimeBak = this.lastSavedTime;
            this.lastSavedTime = this.getServerTime();
            this.saveObjects_();
        }
        catch (Exception e) {
            this.toLog(e);
        }
        this.loadAvatars();
    }

    protected boolean initOffline(char[] pass) {
        if (this.numbers == null) {
            this.loadObjects(pass);
        }
        if (this.myInfo == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.myInfo == null) {
            return false;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceManager.this.offline = true;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (true) {
                    try {
                        ServiceManager.this.client.stateChanged(0);
                        if (!ServiceManager.this.server.tryReconnect()) break;
                        ServiceManager.this.initOnline(false);
                        ServiceManager.this.setUnsentTask(1000L);
                    }
                    catch (Exception e) {
                        ServiceManager.this.toLog(e);
                        continue;
                    }
                    break;
                }
                ServiceManager.this.offline = false;
            }
        }).start();
        this.toLog("Inited Offline");
        return true;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void saveCredentials(String server, String login, char[] password, String proxy, boolean save) {
        this.localProperties.put("server", server);
        this.localProperties.put("proxy", proxy);
        this.localProperties.put("login", login);
        this.localProperties.put("savepass", save);
        if (save) {
            this.localProperties.put("password", password);
        } else {
            this.localProperties.remove("password");
        }
        this.localProperties.remove("signout");
        HashMap<String, String> hashMap = (HashMap<String, String>)this.localProperties.get("passwords");
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            this.localProperties.put("passwords", hashMap);
        }
        try {
            hashMap.put(this.userlogin, this.hash(new String(password)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveProperties();
    }

    public SessionInfo getSessionInfo(String id) {
        return this.sessions.get(id);
    }

    public SessionInfo getSession(ContactGroup group) {
        SessionInfo sessionInfo = null;
        String sessionid = group.getSessionId();
        if (sessionid != null) {
            sessionInfo = this.sessions.get(sessionid);
        }
        if (sessionInfo == null) {
            try {
                Map map;
                Map map2 = map = group.isPermanent() ? this.loadGroupSession(group.getId()) : this.loadSession(group.getId());
                if (map.isEmpty()) {
                    return null;
                }
                sessionInfo = this.createSession(map);
                this.sessions.put(sessionInfo.getSessionId(), sessionInfo);
                this.client.sessionCreated(sessionInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sessionInfo;
    }

    protected SessionInfo getSession(String id) {
        SessionInfo sessionInfo = this.sessions.get(id);
        if (sessionInfo == null) {
            try {
                if (id == null) {
                    throw new NullPointerException();
                }
                Map map = this.loadSession(id);
                if (!map.isEmpty()) {
                    sessionInfo = this.createNewSession(map);
                }
            }
            catch (Exception e) {
                this.toLog(e);
            }
        }
        return sessionInfo;
    }

    protected SessionInfo getSessionForSMS(String number) {
        ContactInfo contactInfo = this.findContactByPhoneNumber(number);
        if (!contactInfo.isGlobal()) {
            try {
                contactInfo = this.getContactInfo(contactInfo);
            }
            catch (Exception e) {
                this.toLog("getSessionForSMS: " + e);
            }
        }
        SessionInfo sessionInfo = contactInfo.isUser() ? this.findSession(contactInfo) : null;
        this.toLog("getSessionForSMS " + number + " contact=" + contactInfo + " valid=" + contactInfo.isValid() + " session=" + sessionInfo);
        if (sessionInfo == null) {
            sessionInfo = new SessionInfo();
            sessionInfo.setStatus(contactInfo.isUser() ? 0 : -4);
            ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>();
            parties.add(contactInfo);
            sessionInfo.setParties(parties);
        }
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionInfo getSessionByPhoneNumber(String number, String name) {
        if (this.myInfo == null) {
            ServiceManager serviceManager = this;
            synchronized (serviceManager) {
                try {
                    this.wait(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        SessionInfo session = null;
        if (number.startsWith("CHANNEL")) {
            String userid = number.substring(7);
            ContactInfo contact = this.numbers.get(userid);
            if (contact != null) {
                try {
                    contact = (ContactInfo)contact.clone();
                }
                catch (Exception exception) {}
            } else {
                contact = this.findContact(userid);
            }
            contact.setStatus(10);
            session = new SessionInfo();
            session.addParty(contact);
            return session;
        }
        if (number.length() > 20 && number.indexOf(64) == -1) {
            if (number.startsWith("P")) {
                number = number.substring(1);
            }
            if ((session = this.sessions.get(number)) == null) {
                session = this.findSessionByDialogId(number);
            }
        }
        if (session == null) {
            ContactInfo contact = this.findContactByPhoneNumber(number, name);
            if (!contact.isGlobal() || contact.isSlot()) {
                try {
                    contact = this.getContactInfo(contact);
                }
                catch (Exception e) {
                    this.toLog("getSessionByPhoneNumber: " + e);
                }
            }
            session = this.findSession(contact);
            this.toLog("findSession=" + session);
            if (session == null) {
                int status = contact.getState() != -1 ? 0 : -3;
                ArrayList<ContactInfo> list = new ArrayList<ContactInfo>();
                list.add(contact);
                try {
                    session = this.createSession(list, null, status);
                }
                catch (Exception e) {
                    this.toLog("getSessionByPhoneNumber: " + e);
                }
                if (session == null) {
                    session = new SessionInfo();
                    session.addParty(contact);
                    session.setStatus(status);
                }
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionInfo findSessionByDialogId(String dialogid) {
        Iterator itr = this.sessionsIterator();
        while (itr.hasNext()) {
            SessionInfo session = (SessionInfo)itr.next();
            if (!dialogid.equals(session.getDialogId())) continue;
            return session;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dialogid", dialogid);
            Map result = (Map)this.sendCommand(METHOD_GET_SESSION, params);
            if (result.isEmpty()) {
                return null;
            }
            SessionInfo session = this.createSession(result);
            Map<String, SessionInfo> map = this.sessions;
            synchronized (map) {
                this.sessions.put(session.getSessionId(), session);
            }
            return session;
        }
        catch (Exception e) {
            ResourceStore.error("findSessionByDialogId", e);
            return null;
        }
    }

    protected SessionInfo getSessionInfoByMessageId(String id) {
        Iterator it = this.sessionsIterator();
        while (it.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)it.next();
            MessageInfo messageInfo = sessionInfo.getMessage(id);
            if (messageInfo == null) continue;
            return sessionInfo;
        }
        return null;
    }

    protected MessageInfo getMessageInfo(String id) {
        Iterator it = this.sessionsIterator();
        while (it.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)it.next();
            MessageInfo messageInfo = sessionInfo.getMessage(id);
            if (messageInfo == null) continue;
            return messageInfo;
        }
        return null;
    }

    protected MessageInfo getMessageInfo(String id, String sessionid) {
        return this.getMessageInfo(id, this.sessions.get(sessionid));
    }

    protected MessageInfo getMessageInfo(String id, SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getMessage(id);
    }

    protected void removeMessageInfo(String id) {
        Iterator it = this.sessionsIterator();
        while (it.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)it.next();
            MessageInfo messageInfo = sessionInfo.removeMessage(id);
            if (messageInfo == null) continue;
            this.removeSessionMessage(sessionInfo, messageInfo);
            return;
        }
    }

    protected SessionInfo findSession(Collection<ContactInfo> contacts) {
        Iterator it = this.sessionsIterator();
        while (it.hasNext()) {
            SessionInfo session = (SessionInfo)it.next();
            if (!session.equalsContacts(contacts)) continue;
            return session;
        }
        return null;
    }

    protected SessionInfo findSession(ContactInfo contact) {
        Iterator it = this.sessionsIterator();
        while (it.hasNext()) {
            List<ContactInfo> parties;
            SessionInfo session = (SessionInfo)it.next();
            int status = session.getStatus();
            if (status > 0 && status != 6 || (parties = session.getParties()).size() != 1 || !contact.equals(parties.get(0))) continue;
            return session;
        }
        return null;
    }

    public int putFile(FileInfo fileInfo) throws Exception {
        return this.fileLoader.putFile(fileInfo.getFilename(), fileInfo.getFile(), fileInfo);
    }

    public int putFile(String resourceName, File file) throws Exception {
        return this.fileLoader.putFile(resourceName, file, null);
    }

    public int putFile(String resourceName, File file, FileInfo fileInfo) throws Exception {
        return this.fileLoader.putFile(resourceName, file, fileInfo);
    }

    public int putContactImage(ContactInfo contact) throws Exception {
        return this.putFile(contact.equals(this.myInfo) ? NAME_AVATAR : contact.getGlobalId(), this.getAvatar(contact));
    }

    public int setVoicemailPrompt(File file) throws Exception {
        return this.fileLoader.putFile(VMAIL_GREETING, file, null);
    }

    public void deleteAvatar() throws Exception {
        new File(this.client.getAvatarsDir(), this.getUserId() + "ava").delete();
        this.deleteFile(this.getUserId() + "-$AVATAR$");
    }

    public void deleteFile(String fileid) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("id", fileid);
        this.server.sendIndication(METHOD_DELETE_FILE, prms);
    }

    public void deleteFiles() throws Exception {
        this.server.sendIndication(METHOD_DELETE_FILES, new HashMap());
    }

    public void setOwnerProperties(Map options) throws Exception {
        this.myInfo.setProperty("features", options);
        this.sendIndication("setProfile", this.myInfo.getProperties());
        Boolean callWaiting = (Boolean)options.get("CallWaiting");
        if (callWaiting != null) {
            int lines = this.server.getMaxIncomingLines();
            if (!callWaiting.booleanValue()) {
                lines = 1;
            } else if (lines < 2) {
                lines = 2;
            }
            this.setProperty("Incoming lines", lines, true);
        }
    }

    public Map getOwnerProperties() {
        Map features;
        try {
            Map profile = this.getProfile(new HashMap());
            features = (Map)profile.get("features");
        }
        catch (Exception e) {
            features = this.myInfo.getPropertiesMap("features");
        }
        Boolean callWaiting = (Boolean)features.get("CallWaiting");
        if (callWaiting == null) {
            callWaiting = true;
        }
        int lines = this.server.getMaxIncomingLines();
        if (!callWaiting.booleanValue()) {
            lines = 1;
        } else if (lines < 2) {
            lines = 2;
        }
        try {
            this.setProperty("Incoming lines", lines, true);
        }
        catch (Exception e) {
            this.server.setMaxIncomingLines(lines);
        }
        features.put("CallWaiting", callWaiting);
        this.myInfo.setProperty("features", features);
        return features;
    }

    public void setAssistentPhone(String number) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (number == null) {
            number = this.myInfo.getNumber();
        }
        params.put("followme", number);
        this.sendIndication("setProfile", params);
    }

    public void answerCall(String lineName, boolean video) {
        this.server.answerCall(lineName, video);
    }

    public void rejectCall(LineInfo line) {
        this.server.rejectCall(line.getName());
    }

    public void dropCall(LineInfo line) {
        this.server.dropCall(line.getName());
    }

    public void dropCall(LineInfo line, String number) {
        this.server.dropCall(line.getName(), number);
    }

    protected void makeCall(ContactInfo contact, boolean video) {
        if (contact.isUser() || contact.isPhone() || contact.isChannel()) {
            this.makeCall(contact.getNumber(), video);
        } else if (video) {
            this.makeVideoCall(contact.getNumber());
        } else {
            this.makeCall(contact.getNumber());
        }
    }

    public void makeConferenceCall(String sessionId, boolean video) {
        this.makeCall(sessionId, video);
    }

    public void transferCall(LineInfo line) {
        if (line.getState() == 1) {
            this.server.transferCall2(line.getName());
        } else {
            this.server.dropCall(line.getName());
        }
    }

    public void transferCall(ContactInfo contactInfo) {
        String number = (String)contactInfo.getProperty(contactInfo.isSlot() ? "park" : "extension");
        if (number == null) {
            number = contactInfo.getNumber();
        }
        this.server.transferCall(number);
    }

    public void transferCall(String number) {
        this.server.transferCall(this.normalizePhoneNumber(number, this.client.getCountryCode()));
    }

    public void transferCall(String number, String lineName) {
        this.server.transferCall(this.normalizePhoneNumber(number, this.client.getCountryCode()), lineName);
    }

    public void transferCall(String number, LineInfo line) {
        this.transferCall(number, line.getName());
    }

    public void holdCall() {
        this.server.holdCall();
    }

    public void holdCall(String lineName) {
        this.server.holdCall(lineName);
    }

    public void resumeCall() {
        this.server.resumeCall();
    }

    public void resumeCall(String lineName) {
        this.server.resumeCall(lineName);
    }

    public void makePushCall(SessionInfo session) {
        this.makeCall("wss:P" + session.getSessionId(), false);
    }

    public void setActiveLine(String lineName) {
        this.server.setActiveLine(lineName);
    }

    public void processActionCommand(String line, String actionCommand) {
        this.server.processMenuCommand(line, actionCommand);
    }

    public void processActionKey(char key) {
        this.server.processKey(key);
    }

    public void showLineActionMenu(String lineName, int x, int y) {
        this.server.lineActionMenu(lineName, x, y);
    }

    public void callToConference(String number) {
        this.server.callToConference(this.getTrunkNumber(number, null));
    }

    public void joinToConference(ContactInfo contactInfo) {
        String number = contactInfo.getStatus() >= 4 ? contactInfo.getNumber() : this.getTrunkNumber(contactInfo.getPrimaryPhoneNumber(), null);
        this.server.callToConference(number);
    }

    public void joinToConference(String line) {
        this.server.joinToConference(line);
    }

    public String startSelectorConference(String id, boolean video) {
        return this.server.startSelectorConference(id, video);
    }

    public void addConferenceSpeaker(String user, String lineName) {
        this.server.addConferenceSpeaker(user, lineName);
    }

    public void removeConferenceSpeaker(String user, String lineName) {
        this.server.removeConferenceSpeaker(user, lineName);
    }

    public void setConferenceMainSpeaker(String user, String lineName) {
        this.server.setConferenceMainSpeaker(user, lineName);
    }

    public void setConferenceSpeakersMode(int mode, String lineName) {
        this.server.setConferenceSpeakersMode(mode, lineName);
    }

    public void setConferencePromptMode(int mode, String lineName) {
        this.server.setConferencePromptMode(mode, lineName);
    }

    public void setConferenceLayoutMode(int mode, String lineName) {
        this.server.setConferenceLayoutMode(mode, lineName);
    }

    public void setConferenceViewMode(int mode, String lineName) {
        this.server.setConferenceViewMode(mode, lineName);
    }

    public void setConferenceLayout(int mode, String lineName) {
        this.server.setConferenceLayout(mode, lineName);
    }

    public int getConferenceControlActions(int x, int y, String lineName) {
        return this.server.getConferenceControlActions(x, y, lineName);
    }

    public void setConferenceControl(int controlCode, String lineName) {
        this.server.setConferenceControl(controlCode, lineName);
    }

    public void setConferenceBitrate(int mode, String lineName) {
        this.server.setConferenceBitrate(mode, lineName);
    }

    public boolean hasActiveCalls() {
        return this.server.getLines().getActiveLinesCount() > 0;
    }

    public String[] getCaptureDeviceNames() {
        return this.server.getCaptureDeviceNames();
    }

    public List getCameraFormats(String chname) {
        return this.server.getCameraFormats(chname);
    }

    public String getCaptureFormat() {
        return this.server.getCaptureFormat();
    }

    public void setCaptureChannel(String deviceName, String format, String bitrate) throws Exception {
        this.server.setCaptureChannel(deviceName, format, bitrate);
    }

    public String setCaptureChannel(String chname, boolean landscape) throws Exception {
        return this.server.setCaptureChannel(chname, landscape);
    }

    public boolean isCapturing() {
        return this.server.isCapturing();
    }

    public void setCapturing(boolean mode) {
        this.server.setCapturing(mode);
    }

    public void setVideoMode(int mode) {
        this.server.setVideoMode(mode);
    }

    public int getVideoMode() {
        return this.server.getVideoMode();
    }

    public void startVideo() {
        this.server.startVideo();
    }

    public void stopVideo() {
        this.server.stopVideo();
    }

    public void setDisplayChannel(DisplayPane videoPanel) {
        this.server.getDevice().setDisplayChannel(videoPanel);
    }

    public void setLocalView(DisplayPane videoPanel) {
        this.server.getDevice().setLocalView(videoPanel);
    }

    public void setAudioSessionState(boolean b) {
        this.server.setAudioSessionState(b);
    }

    public void setAudioPlaybackChannel(String deviceName) throws Exception {
        this.server.setAudioPlaybackChannel(deviceName);
    }

    public String getAudioPlaybackChannel() {
        return this.server.getAudioPlaybackChannel();
    }

    public void setAudioPagingChannel(String name) throws Exception {
        this.server.setAudioPagingChannel(name);
    }

    public String getAudioPagingChannel() {
        return this.server.getAudioPagingChannel();
    }

    public void setAudioCaptureChannel(String name) throws Exception {
        this.server.setAudioCaptureChannel(name);
    }

    public String getAudioCaptureChannel() {
        return this.server.getAudioCaptureChannel();
    }

    public int getFileDuration(File file) {
        return this.server.getFileDuration(file);
    }

    public boolean playFile(File file, int fromSecond, int maxtime, String lineName) throws Exception {
        return this.server.playFile(file, fromSecond, maxtime, lineName);
    }

    public void playTone(String toneid, boolean paging) {
        this.server.playTone(toneid, paging);
    }

    public void stopPlay(String lineName) {
        this.server.stopPlay(lineName);
    }

    public void stopPlayRing() {
        this.server.stopPlayRing();
    }

    public void startRecord(OutputStream stream) {
        this.server.startRecord(stream);
    }

    public void stopRecord() {
        this.server.stopRecord();
    }

    public void onMute(boolean mute) {
        this.server.setMute(mute);
    }

    public void setMute(boolean mode) {
        if (!mode && this.lineEventListener instanceof CallKitAdapter) {
            ((CallKitAdapter)this.lineEventListener).unmute();
        }
        this.server.setMute(mode);
    }

    public boolean getMute() {
        return this.server.getMute();
    }

    public void setVAD(boolean mode) {
        this.server.setVAD(mode);
    }

    public void setPlaybackLevel(float level) {
        this.server.setPlaybackLevel(level);
    }

    public float getPlaybackLevel() {
        return this.server.getPlaybackLevel();
    }

    public float getRingLevel() {
        return this.server.getRingLevel();
    }

    public void setRingLevel(float level) {
        this.server.setRingLevel(level);
    }

    public void setRecordLevel(float level) {
        this.server.setRecordLevel(level);
    }

    public float getRecordLevel() {
        return this.server.getRecordLevel();
    }

    public Object getServiceProperty(String key) {
        return this.serviceProperties.get(key);
    }

    public void setDeviceProperties() throws Exception {
        this.server.setDeviceProperties(this.localProperties);
    }

    public Map getProperties() {
        return this.localProperties;
    }

    public Object getProperty(String key) {
        if (key.equals(SHOW_AVATAR)) {
            Object value = this.myInfo.getSettings().get(key);
            if (value == null) {
                value = true;
            }
            return value;
        }
        return this.localProperties.get(key);
    }

    public void setProperty(String key, Object value) throws Exception {
        this.setProperty(key, value, false);
    }

    public void setProperty(String key, Object value, boolean save) throws Exception {
        this.toLog("setProperty " + key + "=" + value);
        Object oldvalue = this.localProperties.put(key, value);
        this.checkPropertyAction(key, value);
        if (key.equals(SHOW_STATUS)) {
            this.sendStateIndication((Boolean)value != false ? 1 : 4, "", -1, (String)this.localProperties.get("termid"));
        } else if (key.equals("Ring device")) {
            this.server.setAudioPagingChannel((String)value);
        } else if (key.equals("Speaker device")) {
            this.server.setAudioPlaybackChannel((String)value);
        } else if (key.equals("Microphone device")) {
            this.server.setAudioCaptureChannel((String)value);
        } else if (key.equals("VAD")) {
            this.server.setVAD((Boolean)value);
        } else if (key.equals("Incoming lines")) {
            this.server.setMaxIncomingLines((Integer)value);
        } else if (key.equals("Ring tone")) {
            this.server.setRingtone((String)value);
        } else if (key.equals("Play Ringtone")) {
            this.server.setRingMode((Integer)value);
        } else if (key.equals(TERMINAL_TYPE)) {
            this.setTerminalType((Integer)value);
        } else if (!key.equals(SHARE_DOCS)) {
            if (key.equals("exportContacts")) {
                if (value.equals(Boolean.FALSE)) {
                    this.removeContacts();
                }
            } else if (key.equals(SHOW_AVATAR)) {
                this.setUserProperty(key, value);
            } else if (key.equals(PUSH_MESSAGE)) {
                if (value == null) {
                    value = "";
                }
                this.setUserProperty(key, value);
                this.localProperties.put(SHOW_PUSH_MESSAGES, value.toString().length() == 0);
            } else if (key.equals(LOCAL_COPY)) {
                if (Boolean.FALSE.equals(value)) {
                    this.deleteCache();
                    this.localProperties.put(SHARE_DOCS, false);
                    this.localProperties.put(SAVE_TO_GALLERY, false);
                    this.localProperties.put(ENCRYPT_DATA, null);
                } else if (Boolean.FALSE.equals(oldvalue)) {
                    this.saveAllMessages();
                }
            } else if (key.equals(ENCRYPT_DATA)) {
                this.restoreAll((String)oldvalue, (String)value);
            } else if (key.equals("includesCallsInRecents")) {
                if (this.lineEventListener instanceof CallKitAdapter) {
                    ((CallKitAdapter)this.lineEventListener).includeCallsInRecents((Boolean)value);
                }
            } else if (key.equals("ringtoneSound") && this.lineEventListener instanceof CallKitAdapter) {
                ((CallKitAdapter)this.lineEventListener).setRingtoneSound((String)value);
            }
        }
        if (save) {
            this.saveProperties();
        }
    }

    private void setUserProperty(String key, Object value) throws Exception {
        Map settings = this.myInfo.getSettings();
        Object oldval = settings.get(key);
        settings.put(key, value);
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("settings", settings);
        try {
            this.sendIndication(METHOD_SET_USERINFO, map);
        }
        catch (Exception e) {
            settings.put(key, oldval);
            throw e;
        }
    }

    private void checkPropertyAction(String key, Object value) throws Exception {
        if (key.equals("Autoanswer")) {
            this.setAllowAutoanswer();
        } else if (key.equals("Autoanswer On") || key.equals("Autoanswer Off")) {
            this.setTimerTask(key, value);
            this.setAllowAutoanswer();
        } else if (key.equals(TERMINAL_TYPE)) {
            this.server.setAutoanswerMode((Integer)value);
        } else if (key.equals("acceptedCNs")) {
            System.setProperty(key, String.valueOf(value));
        }
    }

    private void setShareDocs(boolean b) {
        if (this.client.getFilesDir().equals(this.client.getDocumentsDir())) {
            return;
        }
        if (!b) {
            File[] files = this.client.getDocumentsDir().listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(this.client.getFilesDir(), files[i].getName());
                files[i].renameTo(file);
            }
        }
    }

    public void saveProperties() {
        File file = new File(this.homedir, "properties.ser");
        try {
            this.saveObject(file, (Object)this.localProperties);
            file.setWritable(true, true);
        }
        catch (Exception e) {
            this.toLog("saveProperties - " + e.getLocalizedMessage());
        }
    }

    public void initProperties() {
        try {
            this.toLog("localProperties=" + this.localProperties);
            for (String key : this.localProperties.keySet()) {
                this.checkPropertyAction(key, this.localProperties.get(key));
            }
            Number delta = (Number)this.localProperties.get("deltaTime");
            if (delta != null) {
                this.deltaTime = delta.longValue();
            }
        }
        catch (Throwable e) {
            this.toLog("initProperties - " + e.getLocalizedMessage());
        }
    }

    public void onError(String error) {
        this.fileLoader.setUsername(null);
        this.client.initError(error);
    }

    public boolean onExit(boolean unreg) {
        return this.onExit(unreg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onExit(boolean unreg, boolean confirm) {
        this.toLog("onExit unreg=" + unreg + " confirm=" + confirm + " online=" + this.online);
        this.server.clearLines();
        if (Boolean.FALSE.equals(this.localProperties.get(LOCAL_COPY))) {
            this.deleteCache();
        } else {
            this.deleteTmpDir();
        }
        if (!unreg || this.myInfo == null) {
            this.server.unregister(unreg);
            return true;
        }
        if (confirm) {
            if (!this.online) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.online) {
                return false;
            }
        }
        this.server.unregister(true);
        if (confirm) {
            ServiceManager serviceManager = this;
            synchronized (serviceManager) {
                if (!this.exited) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.toLog("onExit unreg=" + unreg + " status=" + this.myInfo.getStatus() + " exited=" + this.exited + " c=" + confirm);
        if (this.exited || !confirm) {
            this.server.closeAudioLines();
            if (this.saveTask != null) {
                this.saveTask.cancel();
            }
            this.lastSavedTimeBak = this.lastSavedTime;
            this.lastSavedTime = this.getServerTime();
            this.fileLoader.setUsername(null);
            this.saveObjects_();
            this.numbers = null;
            this.localProperties.put("signout", true);
            this.saveProperties();
            this.exited = false;
            return true;
        }
        new Thread(){

            @Override
            public void run() {
                ServiceManager.this.server.tryReconnect();
            }
        }.start();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExited() {
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            this.exited = true;
            this.notifyAll();
        }
    }

    public void reconnect() {
        this.server.reconnect();
    }

    public void onWakeUp() {
        try {
            this.server.resetAudioLines();
        }
        catch (Exception e) {
            this.toLog(e);
        }
        if (this.online && System.currentTimeMillis() - this.lastSavedTime > 30000L) {
            try {
                this.getEvents(this.lastSavedTime);
            }
            catch (Exception e) {
                this.toLog(e);
            }
        }
    }

    public PhoneDevice getPhoneDevice() {
        return this.server.getDevice();
    }

    public ContactInfo getUserInfo() {
        return this.getUserInfo(false);
    }

    public ContactInfo getUserInfo(boolean reload) {
        if (this.myInfo == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (reload || this.myInfo == null) {
            try {
                ContactInfo newinfo = new ContactInfo(this.getProfile(new HashMap()), true);
                if (this.myInfo != null) {
                    newinfo.setImageFile(this.myInfo.getImageFile());
                    newinfo.setProperty("trunks", this.myInfo.getProperty("trunks"));
                }
                this.loadAvatar(newinfo);
                this.myInfo = newinfo;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.myInfo;
    }

    public ContactInfo getOwner() {
        return this.myInfo;
    }

    public String getProductTitle() {
        return this.client.getProductTitle();
    }

    public Map getFallbackMode() {
        return (Map)this.myInfo.getProperty("fallback");
    }

    public List getEmergencyNumbers() {
        ArrayList numbers = (ArrayList)this.myInfo.getProperty("emergency");
        if (numbers == null) {
            numbers = new ArrayList();
        }
        return numbers;
    }

    public List getCustomPages() {
        ArrayList pages = (ArrayList)this.myInfo.getProperty("custompages");
        if (pages == null) {
            pages = new ArrayList();
        }
        return pages;
    }

    public List getContactLinks(ContactInfo contactInfo) {
        ArrayList links = new ArrayList();
        Map map = contactInfo.getLinks();
        for (String serviceid : map.keySet()) {
            String name = this.getServiceName(serviceid);
            if (name == null) continue;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("title", name);
            m.put("url", (String)map.get(serviceid));
            links.add(m);
        }
        return links;
    }

    public String getConsentLink(ContactInfo contact, String profileid) {
        return "https://" + this.localProperties.get("server") + "/public/consent.html?basis=2&profileid=" + profileid + "&customerid=" + contact.getUserID() + "&userid=" + this.getUserId();
    }

    public void uploadCustomerConsent(ContactInfo contact, int basis, File file) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customerid", contact.getUserID());
        params.put("basis", basis);
        params.put("file", file);
        int n = this.fileLoader.postFile("setCustomerConsent", params);
        this.getContactInfo(contact);
    }

    public File downloadCustomerConsent(ContactInfo contact) throws Exception {
        String resource = "consent?customerid=" + contact.getUserID();
        File tmp = File.createTempFile("aaa", "xxx");
        HashMap map = new HashMap();
        int responseCode = this.fileLoader.getFile(resource, tmp, null, map);
        String filename = (String)map.get("filename");
        if (filename == null) {
            return null;
        }
        File file = new File(tmp.getParent(), filename);
        tmp.renameTo(file);
        return file;
    }

    private void setAllowAutoanswer() {
        Boolean on = (Boolean)this.localProperties.get("Autoanswer");
        if (on == null) {
            on = true;
        }
        if (on.booleanValue()) {
            Object time1 = this.localProperties.get("Autoanswer On");
            Object time2 = this.localProperties.get("Autoanswer Off");
            if (time1 instanceof String) {
                String time = DAYTIME_FORMAT.format(new Date());
                String timeoff = (String)time2;
                String timeon = (String)time1;
                on = timeoff.compareTo(timeon) == 1 ? time.compareTo(timeon) == 1 && time.compareTo(timeoff) == -1 : time.compareTo(timeon) == 1 || time.compareTo(timeoff) == -1;
            } else if (time1 instanceof Number) {
                try {
                    long time = DAYTIME_FORMAT.parse(DAYTIME_FORMAT.format(new Date())).getTime();
                    long timeon = ((Number)time1).longValue();
                    long timeoff = ((Number)time2).longValue();
                    on = timeoff > timeon ? time > timeon && time < timeoff : time > timeon || time < timeoff;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e.getLocalizedMessage());
                }
            }
        }
        this.server.setAutoanswerMode(on != false ? 1 : 0);
    }

    protected void setAllowAutoanswer(boolean b) {
        this.server.setAutoanswerMode(b ? 1 : 0);
    }

    private void setTimerTask(String key, Object value) {
        TimerTask task = (TimerTask)this.timerTasks.remove(key);
        if (task != null) {
            task.cancel();
        }
        if (value != null) {
            try {
                task = new MyTimerTask(key);
                long time = value instanceof Number ? ((Number)value).longValue() : DAYTIME_FORMAT.parse((String)value).getTime();
                long now = DAYTIME_FORMAT.parse(DAYTIME_FORMAT.format(new Date())).getTime();
                long diff = time - now;
                if (diff < 0L) {
                    diff += 86400000L;
                }
                Utils.getTimer().schedule(task, diff, 86400000L);
                this.timerTasks.put(key, task);
            }
            catch (ParseException e) {
                this.localProperties.remove(key);
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
    }

    public Object getBillingInfo(Map prms) throws Exception {
        return this.sendCustomCommand(METHOD_BILLING_EXTENSION, prms);
    }

    public void sendDeviceInfo(Map prms) throws Exception {
        this.sendIndication(METHOD_DEVICE_INFO, prms);
    }

    public void sendCustomInfo(Map prms) throws Exception {
        this.sendIndication(METHOD_CUSTOM_EXTENSION, prms);
    }

    public Object getCustomInfo(Map prms) throws Exception {
        return this.sendCustomCommand(METHOD_CUSTOM_EXTENSION, prms);
    }

    private Object sendCustomCommand(String method, Map prms) throws Exception {
        return this.sendCommand(method, prms);
    }

    protected Map getProfile(Map params) throws Exception {
        return (Map)this.sendCommand(METHOD_GET_PROFILE, params);
    }

    protected void initContactGroups(List list) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            this.setContactGroup((Map)itr.next());
        }
    }

    private void setContactGroup(Map map) {
        String id = (String)map.get("id");
        if (map.get("name") != null) {
            this.contactgroups.put(id, map);
        } else {
            this.contactgroups.remove(id);
        }
        this.client.contactGroupsListChanged();
    }

    protected Collection getContactGroupNames() {
        HashSet<String> names = new HashSet<String>();
        for (Map map : this.contactgroups.values()) {
            String name = (String)map.get("name");
            if (name == null) continue;
            names.add(name);
        }
        return names;
    }

    protected void initContacts(List list) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            this.contactChanged((Map)itr.next(), false);
        }
    }

    protected List getContactGroupList(String name) {
        for (Map map : this.contactgroups.values()) {
            if (!name.equals(map.get("name"))) continue;
            ArrayList members = (ArrayList)map.get("members");
            if (members == null) {
                members = new ArrayList();
            }
            return members;
        }
        return new ArrayList();
    }

    protected void addToGroup(ContactInfo contactInfo, String groupName) {
        String userid = contactInfo.getUserID();
        for (Map map : this.contactgroups.values()) {
            if (!groupName.equals(map.get("name"))) continue;
            List members = (List)map.get("members");
            if (members.contains(userid)) break;
            members.add(userid);
            break;
        }
    }

    protected void removeFromGroup(ContactInfo contactInfo, String groupName) {
        for (Map map : this.contactgroups.values()) {
            if (!groupName.equals(map.get("name"))) continue;
            List members = (List)map.get("members");
            members.remove(contactInfo.getUserID());
            break;
        }
    }

    public String getContactGroupId(String name) {
        for (Map map : this.contactgroups.values()) {
            if (!name.equals(map.get("name"))) continue;
            return (String)map.get("id");
        }
        return null;
    }

    public List<ContactInfo> findContacts(String text, int skip, int limit) throws Exception {
        Vector<ContactInfo> retval = new Vector<ContactInfo>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", text);
        if (skip != -1) {
            params.put("skip", skip);
        }
        if (limit > 0) {
            params.put("limit", limit);
        }
        List list = (List)this.sendCommand(METHOD_FIND_CONTACT, params);
        for (int i = 0; i < list.size(); ++i) {
            ContactInfo contactInfo = new ContactInfo((Map)list.get(i));
            ContactInfo contact = this.findContactByUserId(contactInfo.getUserID());
            if (contact != null) {
                contact.updateProperties(contactInfo.getProperties());
                if (contact.getStatus() == -1) {
                    contact.setStatus(0);
                }
            } else {
                contact = contactInfo;
                contact.setStatus(0);
            }
            retval.add(contact);
            if (Boolean.FALSE.equals(contact.getSettings().get(SHOW_AVATAR))) continue;
            this.loadAvatar(contact);
        }
        return retval;
    }

    public ContactInfo getContact(String id, String ownerid) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("owner", ownerid);
        map.put("country", this.client.getCountryCode());
        Map result = (Map)this.sendCommand(METHOD_GET_CONTACT, map);
        return this.addContactInfo(new ContactInfo(result), true);
    }

    public void sendContact(ContactInfo contact, SessionInfo session, int code) throws Exception {
        String contactid = contact.getGlobalId();
        if (contactid == null) {
            contactid = this.createContact(contact, false);
        }
        MessageInfo messageInfo = new MessageInfo();
        String content = contact.toString() + " <" + contactid + ">";
        messageInfo.setContent(content, 10);
        if (code > 0) {
            messageInfo.setCode(code);
        }
        this.sendMessage(messageInfo, session);
    }

    public void changePassword(String oldpass, String newpass) throws Exception {
        Map hashMap;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("password", newpass);
        map.put("oldpass", oldpass);
        this.sendCommand(METHOD_SET_PASSWORD, map);
        ConnectionInfo connectionInfo = this.server.getConnectionInfo();
        if (!connectionInfo.getAuthName().equals(this.client.getTerminalId())) {
            connectionInfo.setPassword(newpass);
        }
        if (oldpass.equals(this.fileLoader.getPassword())) {
            this.fileLoader.setPassword(newpass);
        }
        if ((hashMap = (Map)this.localProperties.get("passwords")) != null) {
            hashMap.remove(oldpass);
            hashMap.put(this.userlogin, this.hash(newpass));
        }
        if (this.keyStore != null) {
            this.saveKeystore(new File(this.filedir, ".k"), newpass.toCharArray());
        }
    }

    public void addUserContact(Map params) throws Exception {
        Map result = (Map)this.sendCommand(METHOD_ADD_USER_CONTACT, params);
        Integer code = (Integer)result.get("code");
        if (code != 0) {
            throw new Exception((String)result.get("message"));
        }
    }

    public void updateUserContact(Map properties) throws Exception {
        this.sendIndication(METHOD_UPDATE_USER_CONTACT, properties);
    }

    public void removeUserContact(Map properties) throws Exception {
        this.sendIndication(METHOD_REMOVE_USER_CONTACT, properties);
    }

    public void updatePersonalInfo(Map properties) throws Exception {
        File file = (File)properties.remove("file");
        this.toLog("setUserInfo " + properties);
        if (!properties.isEmpty()) {
            this.sendIndication(METHOD_SET_USERINFO, properties);
            this.myInfo.updateUserDetails(properties);
        }
        if (file != null) {
            this.putFile(NAME_AVATAR, file);
            this.setAvatar(this.myInfo, file);
        }
        this.saveObjects();
    }

    public void setUserProperties(Map properties) throws Exception {
        this.sendIndication(METHOD_SET_USER_PROPERTIES, properties);
    }

    public List<Map> getDevices() throws Exception {
        Vector<Map> retval = new Vector<Map>();
        List list = (List)this.sendCommand(METHOD_GET_DEVICES, new HashMap());
        for (int i = 0; i < list.size(); ++i) {
            retval.add((Map)list.get(i));
        }
        return retval;
    }

    public Map getUserInfo(String userid) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("userid", userid);
        return (Map)this.sendCommand(METHOD_GET_USERINFO, prms);
    }

    public ContactInfo getContactInfo(ContactInfo contact) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String id = contact.getGlobalId();
        if (!(id == null || id.length() <= 0 || contact.isSlot() || contact.getProperty("serviceid") != null && contact.getUserID() == null)) {
            params.put("id", id);
        } else {
            String userid = contact.getUserID();
            if (userid != null && userid.length() > 0) {
                params.put("userid", userid);
            } else {
                Map usinfo;
                contact.setHash();
                String name = contact.getName();
                if (name != null && name.length() > 0) {
                    params.put("name", name);
                }
                if ((usinfo = contact.getCustomDetailsMap()).isEmpty()) {
                    usinfo = contact.getUserDetailsMap();
                }
                params.put("extid", contact.getLocalId());
                params.put("usinfo", usinfo);
                params.put("country", this.client.getCountryCode());
                params.put("status", contact.getStatus());
                params.put("hash", contact.getHash());
            }
        }
        Map map = (Map)this.sendCommand(METHOD_GET_CONTACT, params);
        if (map.isEmpty()) {
            return contact;
        }
        ContactInfo contactInfo = new ContactInfo(map);
        if (!contact.isSlot()) {
            contactInfo.setLocalId(contact.getLocalId());
            contactInfo.update(contact);
            if ("".equals(contactInfo.getName()) && !"".equals(contact.getName())) {
                contactInfo.setName(contact.getName());
            }
        }
        return this.addContactInfo(contactInfo, true);
    }

    public void updateContactStatus(ContactInfo contact, int status) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("id", contact.getGlobalId());
        prms.put("userid", contact.getUserID());
        String name = contact.getName();
        if (!"".equals(name)) {
            prms.put("name", name);
        }
        prms.put("status", status);
        this.sendIndication(METHOD_UPDATE_CONTACT, prms);
        contact.setStatus(status);
        this.saveObjects();
    }

    public void updateContactsStatus(Collection<ContactInfo> updated, int status) throws Exception {
        HashMap<String, Serializable> prms = new HashMap<String, Serializable>();
        HashSet<String> ids = new HashSet<String>();
        Iterator<ContactInfo> itr = updated.iterator();
        while (itr.hasNext()) {
            String id = itr.next().getGlobalId();
            if (id == null) continue;
            ids.add(id);
        }
        if (!ids.isEmpty()) {
            prms.put("ids", ids);
            prms.put("status", Integer.valueOf(status));
            this.sendIndication(METHOD_UPDATE_CONTACTS, prms);
        }
        itr = updated.iterator();
        while (itr.hasNext()) {
            ContactInfo contactInfo = this.contacts.get(itr.next().getId());
            if (contactInfo == null) continue;
            contactInfo.setStatus(status);
        }
        this.saveObjects();
    }

    public List<ContactInfo> findContacts(Map prms) throws Exception {
        Vector<ContactInfo> retval = new Vector<ContactInfo>();
        List list = (List)this.sendCommand("findContacts", prms);
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String userid = (String)map.get("userid");
            ContactInfo contact = this.findContactByUserId(userid);
            if (contact != null) {
                contact.updateProperties(map);
            } else {
                contact = new ContactInfo(map);
            }
            retval.add(contact);
        }
        return retval;
    }

    public List<ContactInfo> findContactsByTag(String text) {
        Vector<String> tags = new Vector<String>();
        String[] str = text.split("#");
        for (int i = 0; i < str.length; ++i) {
            String tag = str[i].trim();
            if (tag.length() <= 0) continue;
            tags.add(tag);
        }
        if (tags.isEmpty()) {
            return new ArrayList<ContactInfo>();
        }
        try {
            HashMap<String, Vector<String>> prms = new HashMap<String, Vector<String>>();
            prms.put("tags", tags);
            return this.findContacts(prms);
        }
        catch (Exception e) {
            ResourceStore.error("findContactsByTag " + text, e);
            ArrayList<ContactInfo> list = new ArrayList<ContactInfo>();
            Iterator itr = this.contactsIterator();
            while (itr.hasNext()) {
                ContactInfo contact = (ContactInfo)itr.next();
                if (!contact.hasTag(tags)) continue;
                list.add(contact);
            }
            return list;
        }
    }

    public ContactInfo mergeContacts(ContactInfo contact1, ContactInfo contact2) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("cid1", contact1.getUserID());
        prms.put("cid2", contact2.getUserID());
        Map result = (Map)this.sendCommand(METHOD_MERGE_CONTACTS, prms);
        ContactInfo contactInfo = this.findContactByUserId((String)result.get("userid"));
        this.setServiceContact(contactInfo);
        return contactInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createContact(ContactInfo contact, boolean shared) throws Exception {
        String localId = contact.getLocalId();
        if (localId != null) {
            Map<String, ContactInfo> map = this.contacts;
            synchronized (map) {
                this.contacts.put(localId, contact);
            }
        }
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("id", contact.getGlobalId());
        prms.put("name", contact.getName());
        prms.put("extid", localId);
        prms.put("userid", contact.getUserID());
        prms.put("usinfo", contact.getCustomDetailsMap());
        prms.put("country", this.client.getCountryCode());
        prms.put("hash", contact.setHash());
        prms.put("status", contact.getStatus());
        prms.put("shared", shared);
        String id = (String)this.sendCommand(METHOD_CREATE_CONTACT, prms);
        contact.setGlobalId(id);
        return id;
    }

    public void updateContact(ContactInfo contact) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("id", contact.getGlobalId());
        prms.put("userid", contact.getUserID());
        prms.put("name", contact.getName());
        prms.put("hash", contact.setHash());
        prms.put("usinfo", contact.getCustomDetailsMap());
        int status = contact.getStatus();
        if (status == 3) {
            status = contact.isUser() ? 4 : -1;
        }
        prms.put("status", status);
        contact.setUpdating(true);
        this.sendIndication(METHOD_UPDATE_CONTACT, prms);
        contact.setUpdating(false);
        contact.setStatus(status);
    }

    public void shareContact(ContactInfo contact) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("id", contact.getGlobalId());
        prms.put("userid", contact.getUserID());
        prms.put("name", contact.getName());
        prms.put("hash", contact.setHash());
        prms.put("info", contact.getUserDetailsMap());
        prms.put("usinfo", contact.getCustomDetailsMap());
        prms.put("status", contact.getStatus());
        this.sendIndication(METHOD_SHARE_CONTACT, prms);
    }

    public void deleteContact(ContactInfo contactInfo) throws Exception {
        this.removeContactInfo(contactInfo);
        if (contactInfo.getGlobalId() != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", contactInfo.getGlobalId());
            params.put("userid", contactInfo.getUserID());
            this.sendIndication(METHOD_DELETE_CONTACT, params);
            this.deleteServiceContact(contactInfo);
        }
    }

    public void blockContact(ContactInfo contactInfo) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", contactInfo.getGlobalId());
        params.put("userid", contactInfo.getUserID());
        params.put("status", 3);
        this.sendIndication(METHOD_UPDATE_CONTACT, params);
        contactInfo.setStatus(3);
        this.saveObjects();
    }

    public void unblockContact(ContactInfo contactInfo) throws Exception {
        int status = contactInfo.isUser() ? 4 : -1;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", contactInfo.getGlobalId());
        params.put("userid", contactInfo.getUserID());
        params.put("status", status);
        this.sendIndication(METHOD_UPDATE_CONTACT, params);
        contactInfo.setStatus(status);
        this.saveObjects();
    }

    public String createContactGroup(String name, List members) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("members", members);
        String result = (String)this.sendCommand("createContactGroup", params);
        params.put("id", result);
        this.contactgroups.put(result, params);
        this.saveObjects();
        return result;
    }

    public void updateContactGroup(String id, String name, List members) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("name", name);
        params.put("members", members);
        this.sendIndication("updateContactGroup", params);
        this.contactgroups.put(id, params);
        this.saveObjects();
    }

    public void deleteContactGroup(String id) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        this.sendIndication("deleteContactGroup", params);
        this.contactgroups.remove(id);
        this.saveObjects();
    }

    public List<MessageInfo> getMessageQueue(String filter) {
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>();
        Iterator itr = this.sessionsIterator();
        while (itr.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)itr.next();
            if (!sessionInfo.isChannel()) continue;
            if (filter != null && filter.length() > 0) {
                boolean matched = false;
                String[] names = sessionInfo.toString().split(" ");
                for (int j = 0; j < names.length; ++j) {
                    if (!names[j].contains(filter)) continue;
                    matched = true;
                    break;
                }
                if (!matched) continue;
            }
            List<MessageInfo> messages = sessionInfo.getMessages();
            for (int i = 0; i < messages.size(); ++i) {
                MessageInfo messageInfo = messages.get(i);
                if (messageInfo.getCode() != 32) continue;
                messageInfo.setSessionId(sessionInfo.getSessionId());
                list.add(messageInfo);
            }
        }
        return list;
    }

    public List<MessageInfo> getArcMessages(String filter) {
        return this.getMessages(128, filter);
    }

    private List<MessageInfo> getMessages(int attibutes, String filter) {
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>();
        Iterator itr = this.sessionsIterator();
        while (itr.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)itr.next();
            if (sessionInfo.getStatus() < 1) continue;
            if (filter != null && filter.length() > 0) {
                boolean matched = false;
                String[] names = sessionInfo.toString().split(" ");
                for (int j = 0; j < names.length; ++j) {
                    if (!names[j].contains(filter)) continue;
                    matched = true;
                    break;
                }
                if (!matched) continue;
            }
            List<MessageInfo> messages = sessionInfo.getMessages();
            for (int i = 0; i < messages.size(); ++i) {
                MessageInfo messageInfo = messages.get(i);
                if ((messageInfo.getCode() & attibutes) != attibutes) continue;
                messageInfo.setSessionId(sessionInfo.getSessionId());
                list.add(messageInfo);
            }
        }
        return list;
    }

    protected List<SessionInfo> getChannelSessions(String filter) {
        ArrayList<SessionInfo> list = new ArrayList<SessionInfo>();
        Iterator iterator = this.sessionsIterator();
        while (iterator.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)iterator.next();
            if (!sessionInfo.isChannel() || filter != null && filter.length() != 0 && !sessionInfo.toString().contains(filter)) continue;
            list.add(sessionInfo);
        }
        return list;
    }

    protected List<SessionInfo> getExternalSessions(int type, String prefix) {
        prefix = prefix.toLowerCase();
        ArrayList<SessionInfo> list = new ArrayList<SessionInfo>();
        Iterator iterator = this.sessionsIterator();
        while (iterator.hasNext()) {
            MessageInfo messageInfo;
            SessionInfo session = (SessionInfo)iterator.next();
            if (session.getMessages().isEmpty() && session.getMessagesCount() == 0) continue;
            String name = session.toString().toLowerCase();
            int status = session.getStatus();
            if ((type == 0 && (status == -4 || status == -3) || type == 1 && status == -4) && (prefix.length() == 0 || name.startsWith(prefix) || name.contains(" " + prefix))) {
                list.add(session);
                continue;
            }
            if (status != -3 || prefix.length() != 0 && !name.startsWith(prefix) && !name.contains(" " + prefix) || (messageInfo = session.getLastMessage(type)) == null) continue;
            try {
                SessionInfo sessionInfo = session.clone();
                ArrayList<MessageInfo> messages = new ArrayList<MessageInfo>();
                messages.add(messageInfo);
                sessionInfo.setMessages(messages);
                list.add(sessionInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<SessionInfo> getChats(String prefix) {
        String p1 = null;
        String p2 = null;
        if (prefix.length() > 0) {
            int n = (prefix = prefix.toLowerCase()).indexOf(32);
            if (n == prefix.length() - 1) {
                prefix = prefix.substring(0, n);
            } else if (n > 0) {
                p1 = prefix.substring(0, n);
                p2 = prefix.substring(n + 1);
            }
        }
        ArrayList<SessionInfo> list = new ArrayList<SessionInfo>();
        Iterator iterator = this.sessionsIterator();
        while (iterator.hasNext()) {
            MessageInfo messageInfo;
            SessionInfo session = (SessionInfo)iterator.next();
            if (session.getStatus() == 10 || (messageInfo = session.getLastChatMessage()) == null && !session.isGroup()) continue;
            String name = session.toString().toLowerCase();
            if (p1 != null) {
                int m = name.indexOf(32);
                if (m == -1) continue;
                String fname = name.substring(0, m);
                String sname = name.substring(m + 1);
                if (!fname.startsWith(p1) || !sname.startsWith(p2)) {
                    continue;
                }
            } else if (prefix.length() != 0 && !name.startsWith(prefix) && !name.contains(" " + prefix)) continue;
            try {
                SessionInfo sessionInfo = session.clone();
                if (messageInfo != null) {
                    ArrayList<MessageInfo> messages = new ArrayList<MessageInfo>();
                    messages.add(messageInfo);
                    sessionInfo.setMessages(messages);
                }
                list.add(sessionInfo);
                sessionInfo.setCompareType(1);
            }
            catch (Exception e) {
                this.toLog(e);
            }
        }
        return list;
    }

    protected List<SessionInfo> getCalls(String prefix) {
        String p1 = null;
        String p2 = null;
        if (prefix.length() > 0) {
            int n = (prefix = prefix.toLowerCase()).indexOf(32);
            if (n == prefix.length() - 1) {
                prefix = prefix.substring(0, n);
            } else if (n > 0) {
                p1 = prefix.substring(0, n);
                p2 = prefix.substring(n + 1);
            }
        }
        ArrayList<SessionInfo> list = new ArrayList<SessionInfo>();
        Iterator iterator = this.sessionsIterator();
        while (iterator.hasNext()) {
            SessionInfo session = (SessionInfo)iterator.next();
            if (session.getStatus() == 10) continue;
            String name = session.toString().toLowerCase();
            MessageInfo messageInfo = session.getLastCall();
            if (messageInfo == null) continue;
            String number = messageInfo.getCallPartyNumber();
            if (prefix.length() != 0) {
                if (p1 != null) {
                    int m = name.indexOf(32);
                    if (m == -1) continue;
                    String fname = name.substring(0, m);
                    String sname = name.substring(m + 1);
                    if (!fname.startsWith(p1) || !sname.startsWith(p2)) {
                        continue;
                    }
                } else if (!name.startsWith(prefix) && !name.contains(" " + prefix) && (number == null || !number.contains(prefix))) continue;
            }
            try {
                SessionInfo sessionInfo = session.clone();
                ArrayList<MessageInfo> messages = new ArrayList<MessageInfo>();
                messages.add(messageInfo);
                sessionInfo.setMessages(messages);
                list.add(sessionInfo);
                sessionInfo.setCompareType(2);
            }
            catch (Exception e) {
                this.toLog(e);
            }
        }
        return list;
    }

    protected void checkSessions() throws Exception {
        Iterator itr = this.sessionsIterator();
        while (itr.hasNext()) {
            SessionInfo session = (SessionInfo)itr.next();
            List<ContactInfo> parties = session.getParties();
            for (int i = 0; i < parties.size(); ++i) {
                ContactInfo contact;
                ContactInfo contactInfo = parties.get(i);
                String userid = contactInfo.getUserID();
                if (userid != null && (contact = this.numbers.get(userid)) != null) {
                    parties.set(i, contact);
                    contactInfo = contact;
                }
                contactInfo.addListener(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSessions(List list) throws Exception {
        HashMap<String, SessionInfo> createdSessions = new HashMap<String, SessionInfo>();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            Integer status = (Integer)map.get("status");
            if (status != null && status == 10) {
                Map<String, SessionInfo> map2 = this.sessions;
                synchronized (map2) {
                    this.sessions.remove(map.get("id"));
                    continue;
                }
            }
            SessionInfo sessionInfo = this.createSession(map);
            Map message = (Map)map.get("top");
            if (message != null) {
                MessageInfo messageInfo = this.getMessageInfo(message, sessionInfo);
                sessionInfo.addMessage(messageInfo);
                this.saveSessionMessage(sessionInfo, messageInfo);
            }
            createdSessions.put(sessionInfo.getSessionId(), sessionInfo);
        }
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            this.sessions.putAll(createdSessions);
        }
    }

    public List getFiles(String user, String[] filters) throws Exception {
        Boolean share = (Boolean)this.localProperties.get(SHARE_DOCS);
        File dir = share != null && share != false ? this.client.getDocumentsDir() : this.client.getFilesDir();
        HashMap<String, Object> prms = new HashMap<String, Object>();
        if (user == null) {
            user = "*";
        }
        prms.put("userid", user);
        if (filters != null) {
            prms.put("filters", filters);
        }
        List list = (List)this.sendCommand(METHOD_GET_FILES, prms);
        Vector<CloudFile> files = new Vector<CloudFile>();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String name = (String)map.get("id");
            String owner = (String)map.get("owner");
            CloudFile file = new CloudFile(dir, name, owner, this.getUserId().equals(owner));
            file.setSize(((Number)map.get("size")).longValue());
            file.setTimestamp((Long)map.get("time"));
            files.add(file);
        }
        return files;
    }

    private int loadMessages(SessionInfo sessionInfo, long since, long till, int limit) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        if (sessionInfo != null) {
            prms.put("sessionid", sessionInfo.getSessionId());
            if (sessionInfo.isGroup() || sessionInfo.isPublic()) {
                prms.put("groupid", sessionInfo.getDialogId());
            }
        }
        prms.put("since", since);
        if (till > 0L) {
            prms.put("till", till);
        }
        prms.put("limit", limit);
        this.toLog(sessionInfo + " loadMessages: since=" + since + " limit=" + limit);
        List<Map> list = this.getMessages(prms);
        this.toLog(sessionInfo + " loadMessages: " + list.size());
        if (!list.isEmpty()) {
            if (sessionInfo == null) {
                this.processMessages(list, false);
            } else {
                Vector<MessageInfo> messages = new Vector<MessageInfo>();
                HashMap<String, MessageInfo> msgs = new HashMap<String, MessageInfo>();
                HashMap replied = new HashMap();
                for (int i = 0; i < list.size(); ++i) {
                    MessageInfo messageInfo = this.getMessageInfo(list.get(i), sessionInfo, msgs, list.size(), replied);
                    messages.add(messageInfo);
                    msgs.put(messageInfo.getId(), messageInfo);
                }
                HashMap<String, List> toload = new HashMap<String, List>();
                for (String id : replied.keySet()) {
                    List mess = (List)replied.get(id);
                    MessageInfo mi = sessionInfo.getMessage(id);
                    if (mi != null) {
                        for (int i = 0; i < mess.size(); ++i) {
                            ((MessageInfo)mess.get(i)).setRepliedMessage(mi);
                        }
                        continue;
                    }
                    toload.put(id, mess);
                }
                List<MessageInfo> tosave = sessionInfo.addMessages(messages, true);
                if (sessionInfo.getStatus() != -6) {
                    this.saveSessionMessages(sessionInfo, tosave);
                }
                if (!toload.isEmpty()) {
                    this.loadRepliedMessages(toload, sessionInfo);
                }
                this.toLog(sessionInfo + " loadMessages: since=" + since + " limit=" + limit + " new=" + list.size() + " loaded=" + tosave.size() + " total=" + sessionInfo.getMessages().size() + " toload=" + toload.size());
                return tosave.size();
            }
        }
        return 0;
    }

    public List<Map> getMessages(Map prms) throws Exception {
        return (List)this.sendCommand(METHOD_GET_MESSAGES, prms);
    }

    public List<MessageInfo> getMessages(SessionInfo sessionInfo) {
        List<MessageInfo> messages = sessionInfo.getMessages();
        if (sessionInfo.needMore()) {
            this.loadPreviousMessages(sessionInfo, 0L);
        }
        return messages;
    }

    public void loadPreviousMessages(final SessionInfo session, final long till) {
        if (session.getSessionId() == null) {
            return;
        }
        Thread mloader = new Thread(){

            @Override
            public void run() {
                ServiceManager.this.loadMessages(session, till);
            }
        };
        mloader.start();
    }

    public void sendReminder(SessionInfo sessionInfo, String text, long time) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setContent(text, 22);
        messageInfo.setLifetime((time - System.currentTimeMillis()) / 1000L);
        this.sendMessage(messageInfo, sessionInfo);
    }

    public SessionInfo sendSMS(String number, String text, String trunk) {
        SessionInfo sessionInfo = this.getSessionForSMS(number);
        this.sendSMS(sessionInfo, number, text, trunk);
        return sessionInfo;
    }

    public void sendSMS(SessionInfo sessionInfo, String number, String text, String trunk) {
        MessageInfo messageInfo = new MessageInfo();
        Object content = "{";
        List trunks = (List)this.myInfo.getProperty("trunks");
        for (int i = 0; i < trunks.size(); ++i) {
            Map m = (Map)trunks.get(i);
            String name = (String)m.get("name");
            if (!new Boolean(true).equals(m.get("sms")) || trunk != null && !trunk.equals(name)) continue;
            content = (String)content + "\"trunkid\":\"" + m.get("oid") + "\",\"from\":\"" + name + "\",";
            break;
        }
        text = text.replace("\"", "\u201c");
        content = (String)content + "\"number\":\"" + this.normalizePhoneNumber(number, null) + "\",\"text\":\"" + text + "\"}";
        messageInfo.setContent((String)content, 20);
        this.sendMessage(messageInfo, sessionInfo);
    }

    public SessionInfo sendMMS(String number, File file, String trunk) {
        SessionInfo sessionInfo = this.getSessionForSMS(number);
        this.sendMMS(sessionInfo, number, file, trunk);
        return sessionInfo;
    }

    public void sendMMS(SessionInfo session, String number, File file, String trunk) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFile(file);
        Object content = "{";
        List trunks = (List)this.myInfo.getProperty("trunks");
        for (int i = 0; i < trunks.size(); ++i) {
            Map m = (Map)trunks.get(i);
            String name = (String)m.get("name");
            if (!new Boolean(true).equals(m.get("mms")) || trunk != null && !trunk.equals(name)) continue;
            content = (String)content + "\"trunkid\":\"" + m.get("oid") + "\",\"from\":\"" + name + "\",";
            break;
        }
        String filename = file instanceof CloudFile ? ((CloudFile)file).getResourceName() : this.getUserId() + "-" + file.getName();
        content = (String)content + "\"number\":\"" + this.normalizePhoneNumber(number, null) + "\",\"content\":\"" + filename + "\"}";
        fileInfo.setContent((String)content, 20);
        this.sendMessage(fileInfo, session);
    }

    private void sendFile(File file, SessionInfo session) {
        this.sendFile(file, session, 0);
    }

    public void sendFile(File file, SessionInfo session, int code) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFile(file);
        if (file instanceof CloudFile) {
            fileInfo.setContent(((CloudFile)file).getResourceName(), 7);
        } else {
            fileInfo.setContent(file.getName(), 2);
        }
        fileInfo.setCode(code);
        this.sendMessage(fileInfo, session);
    }

    public SessionInfo sendMail(SessionInfo session, String to, String cc, String bcc, String from, String subject, String text, String html, List<File> attachments, FileTransferListener listener) throws Exception {
        return this.sendMail(session, new EmailInfo(to, cc, bcc, from, subject, text, html, attachments));
    }

    public SessionInfo sendMail(SessionInfo session, EmailInfo emailInfo) throws Exception {
        String fileid = System.currentTimeMillis() + ".eml";
        File file = new File(this.client.getCacheDir(), fileid);
        emailInfo.writeTo(file);
        emailInfo.setFile(file);
        if (session == null) {
            session = this.getSession(emailInfo);
        }
        this.sendMessage(emailInfo, session);
        return session;
    }

    protected void saveMessage(MessageInfo messageInfo, SessionInfo sessionInfo) throws Exception {
        if (sessionInfo == null) {
            sessionInfo = this.getSession((EmailInfo)messageInfo);
        }
        messageInfo.setStatus(-2);
        messageInfo.setTime(this.getServerTime());
        messageInfo.setLifetime(-1L);
        messageInfo.setSenderId(this.getUserId());
        messageInfo.setId(Utils.generateGUID(this.getServerTime()));
        sessionInfo.addMessage(messageInfo);
        this.toLog("saveMessage " + messageInfo + " time=" + messageInfo.getTime() + " sid=" + sessionInfo.getSessionId() + " status=" + sessionInfo.getStatus());
        this.saveSessionMessage(sessionInfo, messageInfo);
    }

    protected void sendMessage(final MessageInfo messageInfo, final SessionInfo sessionInfo) {
        if (messageInfo.getStatus() == 0) {
            messageInfo.setStatus(-1);
        }
        messageInfo.setTime(this.getServerTime());
        messageInfo.setSenderId(this.getUserId());
        messageInfo.setId(Utils.generateGUID(this.getServerTime()));
        if (messageInfo.getType() != 22) {
            messageInfo.setLifetime(sessionInfo.getMessageLifetime());
        }
        sessionInfo.addMessage(messageInfo);
        if (this.online) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        ServiceManager.this.sendMessage_(messageInfo, sessionInfo);
                    }
                    catch (Exception e) {
                        ServiceManager.this.toLog("sendMessage - " + e);
                        String err = e.getMessage();
                        if ("InvalidSession".equals(err) || "ChatClosed".equals(err)) {
                            sessionInfo.removeMessage(messageInfo.getId());
                            sessionInfo.setStatus(4);
                        }
                        ServiceManager.this.setUnsentTask(5000L);
                    }
                }
            }.start();
        } else {
            this.toLog("sendMessage " + messageInfo + " state=offline time=" + messageInfo.getTime());
            this.saveSessionMessage(sessionInfo, messageInfo);
            this.setUnsentTask(5000L);
        }
    }

    private void sendMessage_(MessageInfo messageInfo, SessionInfo sessionInfo) throws Exception {
        SessionInfo session = sessionInfo;
        String id = session.getSessionId();
        if (id == null) {
            if (sessionInfo.getStatus() == -3) {
                sessionInfo.setStatus(-4);
            }
            session = this.getSessionInfo(sessionInfo);
            sessionInfo.setSessionId(session.getSessionId());
        }
        messageInfo.setSessionId(session.getSessionId());
        Map prms = messageInfo.getMap();
        if (session.getStatus() == -1) {
            ArrayList<String> dest = new ArrayList<String>();
            List<ContactInfo> parties = session.getParties();
            for (int i = 0; i < parties.size(); ++i) {
                dest.add(parties.get(i).getUserID());
            }
            prms.put("dest", dest);
        }
        if (messageInfo instanceof FileInfo && messageInfo.getType() != 7) {
            File file;
            FileInfo fileInfo;
            block18: {
                fileInfo = (FileInfo)messageInfo;
                file = fileInfo.getFile();
                this.toLog("sendingFile " + file);
                if (file == null) {
                    return;
                }
                File copy = this.createNewFile(file.getName());
                if (Utils.copyFile(file, copy)) {
                    file = copy;
                    fileInfo.setFile(file);
                }
                file.setLastModified(messageInfo.getTime());
                messageInfo.setTime(file.lastModified());
                prms.put("timestamp", file.lastModified());
                fileInfo.addTransfrerListener(session);
                fileInfo.setLoading(true);
                try {
                    int status = this.putFile(fileInfo);
                    if (status == 200) {
                        fileInfo.setLoaded();
                    } else {
                        fileInfo.cancel("Error " + status);
                    }
                }
                catch (Exception e) {
                    this.toLog(e.toString());
                    fileInfo.cancel(e.getLocalizedMessage());
                    if (!(e instanceof FileNotFoundException) && this.getServerTime() - messageInfo.getTime() <= 86400000L) break block18;
                    fileInfo.removeTransfrerListener(session);
                    fileInfo.setStatus(-3);
                    return;
                }
            }
            fileInfo.removeTransfrerListener(session);
            if (fileInfo.isCancelled()) {
                throw new Exception(fileInfo.getErrorMessage());
            }
            if (messageInfo instanceof EmailInfo) {
                String fileid = this.getUserId() + "-" + fileInfo.getFile().getName();
                Map content = (Map)prms.get("content");
                content.put("file", fileid);
            }
            File outfile = new File(this.client.getCacheDir(), "@" + file.getName());
            String alg = (String)this.localProperties.get(ENCRYPT_DATA);
            if (alg != null) {
                try {
                    this.saveFile(file, outfile, alg);
                    fileInfo.setFile(outfile);
                    fileInfo.setLoadedBytes(outfile.length());
                    fileInfo.setProperty("file-encrypted", true);
                }
                catch (Exception e) {
                    this.toLog("saveFile " + file + " - " + e);
                }
                if (file.getParentFile().equals(outfile.getParentFile())) {
                    file.delete();
                }
            }
        }
        this.sendIndication(METHOD_SEND_MESSAGE, prms);
        if (messageInfo.getStatus() == -1) {
            messageInfo.setStatus(0);
            session.notifyMessageUpdated(messageInfo);
        }
        this.toLog("sendMessage " + messageInfo);
    }

    private void setUnsentTask(long delay) {
        if (this.unsentTask == null) {
            this.unsentTask = new TimerTask(){

                @Override
                public void run() {
                    new Thread(){

                        @Override
                        public void run() {
                            ServiceManager.this.unsentTask = null;
                            ServiceManager.this.checkUnsentMessages();
                        }
                    }.start();
                }
            };
            Utils.getTimer().schedule(this.unsentTask, delay);
        }
    }

    private void checkUnsentMessages() {
        this.toLog("checkUnsentMessages online=" + this.online);
        if (!this.online) {
            return;
        }
        boolean retry = false;
        Iterator iterator = this.sessionsIterator();
        while (iterator.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)iterator.next();
            List<MessageInfo> messages = sessionInfo.getMessages();
            for (int i = messages.size() - 1; i >= 0; --i) {
                MessageInfo message = messages.get(i);
                if (message.getStatus() != -1) continue;
                try {
                    this.sendMessage_(message, sessionInfo);
                    continue;
                }
                catch (Exception e) {
                    this.toLog("sendMessage: " + e);
                    String err = e.getMessage();
                    if ("InvalidSession".equals(err) || "ChatClosed".equals(err)) {
                        sessionInfo.removeMessage(message.getId());
                        sessionInfo.setStatus(4);
                        continue;
                    }
                    retry = true;
                }
            }
            if (!sessionInfo.hasRead() || sessionInfo.getNewMessagesCount() != 0) continue;
            try {
                this.sendRead(sessionInfo);
            }
            catch (Exception i) {}
        }
        Iterator iterator1 = this.contactsIterator();
        while (iterator1.hasNext()) {
            ContactInfo contactInfo = (ContactInfo)iterator1.next();
            if (!contactInfo.isUpdating()) continue;
            try {
                this.updateContact(contactInfo);
            }
            catch (Exception e) {
                this.toLog("updateContact: " + e);
                retry = true;
            }
        }
        if (retry) {
            this.setUnsentTask(30000L);
        }
    }

    private void getEvents(long since) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("since", since);
        params.put("now", System.currentTimeMillis());
        Integer type = (Integer)this.localProperties.get(TERMINAL_TYPE);
        if (type != null) {
            params.put("type", type);
            params.put("termid", this.client.getTerminalId());
        }
        Map events = (Map)this.sendCommand(METHOD_GET_EVENTS, params);
        this.processEvents(events);
        this.saveObjects();
    }

    private Map loadSession(String sessionid) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sessionid", sessionid);
        return (Map)this.sendCommand(METHOD_GET_SESSION, params);
    }

    private Map loadGroupSession(String groupid) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupid", groupid);
        return (Map)this.sendCommand(METHOD_GET_SESSION, params);
    }

    public SessionInfo getSession(EmailInfo emailInfo) throws Exception {
        String to = emailInfo.getTo();
        int n = to.indexOf(32);
        if (n == -1) {
            n = to.indexOf(44);
        }
        if (n == -1) {
            n = to.indexOf(59);
        }
        if (n != -1) {
            to = to.substring(0, n);
        }
        ContactInfo contact = null;
        Iterator it = this.contactsIterator();
        while (it.hasNext()) {
            ContactInfo contactInfo = (ContactInfo)it.next();
            if (!contactInfo.hasEmail(to)) continue;
            contact = contactInfo;
            break;
        }
        if (contact == null) {
            contact = new ContactInfo();
            contact.addCustomDetail("Email", to);
        }
        return this.getSession(contact);
    }

    public SessionInfo getSession(ContactInfo contactInfo) {
        SessionInfo session;
        if (!contactInfo.isGlobal()) {
            List<String> list = contactInfo.getPhoneNumbers();
            for (int i = 0; i < list.size(); ++i) {
                ContactInfo contact = this.numbers.get(list.get(i));
                if (contact == null) continue;
                contactInfo = contact;
                break;
            }
        }
        if ((session = this.findSession(contactInfo)) == null || session.getStatus() == 5) {
            session = new SessionInfo();
            session.addParty(contactInfo);
            if (contactInfo.getState() == -1) {
                session.setStatus(-3);
            }
        }
        this.toLog(contactInfo + " getSession=" + session + " STATUS=" + session.getStatus());
        return session;
    }

    public SessionInfo getSession(Collection<ContactInfo> contacts) throws Exception {
        SessionInfo session = this.findSession(contacts);
        if (session == null) {
            session = contacts.size() > 1 ? this.createSession(contacts, null, 1) : this.createSession(contacts, null);
        }
        return session;
    }

    public SessionInfo createSession(Collection<ContactInfo> collection, String name) throws Exception {
        int status;
        if (collection.isEmpty()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        if (collection.size() != 1) {
            status = 3;
        } else {
            ContactInfo contact = collection.iterator().next();
            if (contact.getState() == -1) {
                if (!this.contacts.containsKey(contact.getId())) {
                    SessionInfo sessionInfo = new SessionInfo();
                    sessionInfo.addParty(contact);
                    return sessionInfo;
                }
                status = -3;
            } else {
                status = 0;
            }
        }
        return this.createSession(collection, name, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo getSessionInfo(SessionInfo sessionInfo) throws Exception {
        String subject;
        String description;
        boolean isnew;
        if (sessionInfo.getParties().isEmpty()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        Vector<String> parties = new Vector<String>();
        Vector<ContactInfo> contacts = new Vector<ContactInfo>();
        for (ContactInfo contact : sessionInfo.getParties()) {
            String userid = contact.getUserID();
            contact = userid != null ? this.findContact(userid) : this.getContactInfo(contact);
            parties.add(contact.getUserID());
            contacts.add(contact);
        }
        sessionInfo.setParties(contacts);
        int status = sessionInfo.getStatus();
        if (parties.size() > 1 && status == 0) {
            status = 3;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parties", parties);
        params.put("status", status);
        params.put("myname", this.myInfo.toString());
        Map map = (Map)this.sendCommand(METHOD_CREATE_SESSION, params);
        String sessionId = (String)map.get("id");
        SessionInfo session = this.sessions.get(sessionId);
        boolean bl = isnew = session == null;
        if (isnew) {
            session = sessionInfo;
            session.setSessionId(sessionId);
            session.setCreated(this.getServerTime());
            session.setStatus((Integer)map.get("status"));
            Map<String, SessionInfo> map2 = this.sessions;
            synchronized (map2) {
                this.sessions.put(sessionId, session);
            }
        } else {
            session.addMessages(sessionInfo.getMessages(), false);
            session.setSessionEventListeners(sessionInfo.getSessionEventListeners());
        }
        String dialogid = (String)map.get("dialogid");
        if (dialogid != null) {
            session.setDialogId((String)map.get("dialogid"));
        }
        if ((description = (String)map.get("description")) != null) {
            session.setDescription(description);
        }
        if ((subject = (String)map.get("subject")) != null) {
            session.setSubject(subject);
        }
        if (isnew) {
            this.client.sessionCreated(sessionInfo);
        }
        return session;
    }

    protected SessionInfo createSession(Collection<ContactInfo> collection, String name, int status) throws Exception {
        Vector<String> parties = new Vector<String>();
        Vector<ContactInfo> contacts = new Vector<ContactInfo>();
        for (ContactInfo contactInfo : collection) {
            String userid = contactInfo.getUserID();
            if (userid == null) {
                contactInfo = this.getContactInfo(contactInfo);
                userid = contactInfo.getUserID();
            }
            if (userid == null) continue;
            parties.add(userid);
            contacts.add(contactInfo);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parties", parties);
        if (status != -1) {
            params.put("status", status);
        }
        if (name != null && name.length() > 0) {
            params.put("name", name);
        }
        params.put("myname", this.myInfo.toString());
        Map result = (Map)this.sendCommand(METHOD_CREATE_SESSION, params);
        status = (Integer)result.get("status");
        SessionInfo sessionInfo = this.createSessionInfo(result, contacts, name, status);
        this.client.sessionCreated(sessionInfo);
        return sessionInfo;
    }

    protected SessionInfo createPublic(String name, Collection<ContactInfo> list, String description, File imageFile) throws Exception {
        long ts = this.getServerTime();
        Object image = null;
        if (imageFile != null) {
            image = Utils.generateGUID(ts);
            int result = this.putFile((String)image, imageFile);
            image = result == 200 ? this.getUserId() + "-" + (String)image : null;
        }
        if (description == null) {
            description = "";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("image", image);
        params.put("description", description);
        if (list != null && !list.isEmpty()) {
            HashSet<String> members = new HashSet<String>();
            Iterator<ContactInfo> itr = list.iterator();
            while (itr.hasNext()) {
                members.add(itr.next().getUserID());
            }
            params.put("members", members);
        }
        Map result = (Map)this.sendCommand("createPublic", params);
        SessionInfo sessionInfo = this.createSessionInfo(result, new ArrayList<ContactInfo>(), name, 3);
        sessionInfo.setDialogType(2);
        sessionInfo.setDescription(description);
        if (image != null) {
            this.setAvatar(sessionInfo, imageFile);
        }
        this.client.sessionCreated(sessionInfo);
        return sessionInfo;
    }

    protected List<SessionInfo> getPublicSessions() throws Exception {
        ArrayList<SessionInfo> result = new ArrayList<SessionInfo>();
        HashMap params = new HashMap();
        List list = (List)this.sendCommand("getPublicSessions", params);
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            SessionInfo sessionInfo = this.createSession(map);
            result.add(sessionInfo);
            if (sessionInfo.getImageId() == null) continue;
            this.loadAvatar(sessionInfo);
        }
        return result;
    }

    protected void setPublicStatus(SessionInfo session, boolean signed) throws Exception {
        boolean adm;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", session.getSessionId());
        params.put("signed", signed);
        boolean bl = adm = session.isPublic() && session.getAdmins().contains(this.getUserId());
        if (signed && adm) {
            params.put("admin", true);
        }
        this.sendIndication("setPublicStatus", params);
        session.setStatus(signed ? (adm ? 3 : 2) : 5);
    }

    protected void deletePublic(SessionInfo session) throws Exception {
        this.toLog("deletePublic " + session + " admins=" + session.getAdmins() + " userid=" + this.getUserId());
        if (!session.getAdmins().contains(this.getUserId())) {
            throw new Exception("InsuffiencePermissions");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dialogid", session.getDialogId());
        this.sendIndication("deletePublic", params);
        this.saveObjects();
    }

    protected List<ContactInfo> getPublicMembers(SessionInfo session) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dialogid", session.getDialogId());
        List result = (List)this.sendCommand("getPublicMembers", params);
        ArrayList<ContactInfo> contacts = new ArrayList<ContactInfo>();
        for (int i = 0; i < result.size(); ++i) {
            String userid = (String)result.get(i);
            contacts.add(this.findContact(userid));
        }
        return contacts;
    }

    public void setSessionProperty(SessionInfo session, String key, Object value) throws Exception {
        if (key.equals("nodisturb")) {
            if (session.getDialogType() == 2) {
                this.setPublicStatus(session, (Boolean)value == false);
            } else {
                this.updateSessionProperty(session, key, value);
            }
        } else if (key.equals("messageTTL")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sessionid", session.getSessionId());
            params.put("messagettl", value);
            this.sendCommand(METHOD_UPDATE_SESSION, params);
            session.setMessageLifetime((Integer)value);
            this.saveObjects();
        } else {
            session.setProperty(key, value);
            this.saveObjects();
        }
    }

    public void updateSessionProperty(SessionInfo session, String key, Object value) throws Exception {
        Object oldval = session.getProperty(key);
        try {
            session.setProperty(key, value);
            this.sendSessionUpdate(session, -1, null, false);
        }
        catch (Exception e) {
            session.setProperty(key, oldval);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo createSessionInfo(Map map, Collection<ContactInfo> contacts, String name, int status) {
        String subject;
        String description;
        Integer type;
        String sessionId = (String)map.get("id");
        if (sessionId == null) {
            sessionId = (String)map.get("sessionid");
        }
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setSessionId(sessionId);
        String dialogid = (String)map.get("dialogid");
        if (dialogid != null) {
            sessionInfo.setDialogId(dialogid);
        }
        if ((type = (Integer)map.get("type")) != null) {
            sessionInfo.setDialogType(type);
        }
        if ((description = (String)map.get("description")) != null) {
            sessionInfo.setDescription(description);
        }
        if ((subject = (String)map.get("subject")) != null) {
            sessionInfo.setSubject(subject);
        }
        if (name != null) {
            sessionInfo.setName(name);
        }
        sessionInfo.setStatus(status);
        long time = this.getServerTime();
        sessionInfo.setCreated(time);
        sessionInfo.setLastUpdated(time);
        List parties = (List)map.get("parties");
        if (parties != null && !parties.isEmpty()) {
            for (ContactInfo contact : contacts) {
                if (!parties.contains(contact.getUserID())) continue;
                sessionInfo.addParty(contact);
            }
        }
        Map<String, SessionInfo> map2 = this.sessions;
        synchronized (map2) {
            this.sessions.put(sessionInfo.getSessionId(), sessionInfo);
        }
        return sessionInfo;
    }

    public void sendSessionUpdate(SessionInfo session, int event, Collection<ContactInfo> contacts, boolean withImage) throws Exception {
        String description;
        String id;
        String img = null;
        if (withImage && session.hasAvatar()) {
            int status = this.putFile(session.getSessionId(), this.getAvatar(session));
            this.toLog("uploadIcon " + session + " len=" + session.getImageFile().length() + " status=" + status);
            img = this.getUserId() + "-" + session.getSessionId();
        }
        if ((id = session.getSessionId()) == null) {
            session = this.getSessionInfo(session);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sessionid", session.getSessionId());
        String name = session.getName();
        if (name != null && name.length() > 0) {
            params.put("name", name);
        }
        if (img != null) {
            params.put("image", img);
        }
        if ((description = session.getDescription()) != null) {
            params.put("description", description);
        }
        params.put("properties", session.getProperties());
        List<String> admins = session.getAdmins();
        if (admins != null) {
            params.put("admins", admins);
        }
        if (contacts != null && event != -1) {
            Vector<String> parties = new Vector<String>();
            Iterator<ContactInfo> it = contacts.iterator();
            while (it.hasNext()) {
                parties.add(it.next().getUserID());
            }
            params.put("event", event);
            if (event == 0) {
                params.put("parties", parties);
            } else if (event == 1) {
                params.put("add", parties);
            } else {
                params.put("remove", parties);
            }
        }
        this.sendCommand(METHOD_UPDATE_SESSION, params);
        if (img != null) {
            session.setImageId(img);
            session.setImageTimestamp(this.getServerTime());
        }
        if (contacts != null && event != -1) {
            if (event == 0) {
                session.getParties().clear();
            }
            Iterator<ContactInfo> it = contacts.iterator();
            while (it.hasNext()) {
                if (event == 2) {
                    session.removeParty(it.next().getUserID());
                    continue;
                }
                session.addParty(it.next());
            }
        }
        this.toLog(session + "(" + session.hashCode() + ") updateSession params=" + params + " STATUS=" + session.getStatus() + " parties=" + session.getParties());
        this.saveObjects();
    }

    public void openSession(SessionInfo session) throws Exception {
        String id = session.getSessionId();
        if (id == null) {
            session = this.getSessionInfo(session);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sessionid", session.getSessionId());
        this.sendCommand(METHOD_OPEN_SESSION, params);
        session.setStatus(0);
        this.saveObjects();
    }

    public void closeSession(SessionInfo session, boolean delete) throws Exception {
        if (session.getSessionId() == null) {
            this.sessions.remove(null);
            return;
        }
        if (!delete || session.getStatus() == 3) {
            // empty if block
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sessionid", session.getSessionId());
        params.put("delete", delete);
        this.sendIndication(METHOD_CLOSE_SESSION, params);
        session.setStatus(5);
        if (delete) {
            this.sessionDeleted(session.getSessionId());
        }
    }

    public MessageInfo getMessage(String messageid, SessionInfo session) throws Exception {
        HashMap<String, String> smap = new HashMap<String, String>();
        smap.put("id", messageid);
        Map map = (Map)this.sendCommand(METHOD_GET_MESSAGE, smap);
        return this.getMessageInfo(map, session);
    }

    public Map getMessageStatus(String messageid) throws Exception {
        HashMap<String, String> smap = new HashMap<String, String>();
        smap.put("messageid", messageid);
        List list = (List)this.sendCommand(METHOD_GET_MESSAGE_STATUS, smap);
        HashMap<String, Long> retval = new HashMap<String, Long>();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String userid = (String)map.get("userid");
            if (userid.equals(this.getUserId())) continue;
            Long deliveryTime = ((Number)map.get("delivered")).longValue();
            retval.put(userid, deliveryTime);
        }
        return retval;
    }

    private void sendDeliveryReport(SessionInfo session, MessageInfo message) throws Exception {
        Boolean b = (Boolean)this.localProperties.get(SEND_DELIVERY_REPORT);
        if (b != null && !b.booleanValue()) {
            return;
        }
        HashMap<String, String> smap = new HashMap<String, String>();
        smap.put("messageid", message.getId());
        smap.put("sessionid", session.getSessionId());
        this.sendIndication(METHOD_MESSAGE_DELIVERED, smap);
        message.setDeliveryTime(this.getServerTime());
    }

    private void sendDeliveryReport(SessionInfo session, List<MessageInfo> messages) throws Exception {
        Boolean b = (Boolean)this.localProperties.get(SEND_DELIVERY_REPORT);
        if (b != null && !b.booleanValue()) {
            return;
        }
        ArrayList<String> messageIds = new ArrayList<String>();
        for (int i = 0; i < messages.size(); ++i) {
            messageIds.add(messages.get(i).getId());
        }
        this.toLog(session + " sendDeliveryReport: messageIds=" + messageIds);
        HashMap<String, Object> smap = new HashMap<String, Object>();
        smap.put("messageid", messageIds);
        smap.put("sessionid", session.getSessionId());
        this.sendIndication(METHOD_MESSAGE_DELIVERED, smap);
        for (int i = 0; i < messages.size(); ++i) {
            messages.get(i).setDeliveryTime(this.getServerTime());
        }
    }

    public void sendRead(final SessionInfo session) {
        final List messages = session.setRead(this.getServerTime());
        this.toLog(session + " sendRead messages=" + messages.size());
        if (messages.isEmpty() && !session.hasRead()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    ServiceManager.this.sendRead(session.getSessionId());
                    session.readSent();
                    if (!messages.isEmpty()) {
                        ServiceManager.this.saveSessionMessages(session, messages);
                    }
                }
                catch (Exception e) {
                    ServiceManager.this.toLog(session + " sendRead - " + e);
                }
            }
        }.start();
    }

    private void sendRead(String sessionid) throws Exception {
        HashMap<String, String> smap = new HashMap<String, String>();
        smap.put("sessionid", sessionid);
        this.sendIndication(METHOD_MESSAGE_READ, smap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMissedCallsIndication() {
        HashMap<SessionInfo, List<MessageInfo>> toSave = new HashMap<SessionInfo, List<MessageInfo>>();
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            for (SessionInfo sessionInfo : this.sessions.values()) {
                List<MessageInfo> messages = sessionInfo.clearMissedCalls();
                if (messages.isEmpty()) continue;
                toSave.put(sessionInfo, messages);
            }
        }
        if (!toSave.isEmpty()) {
            for (SessionInfo sessionInfo : toSave.keySet()) {
                List messages = (List)toSave.get(sessionInfo);
                this.saveSessionMessages(sessionInfo, messages);
            }
            this.saveObjects();
        }
    }

    public void sendTypingIndication(String sessionid, boolean state) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionid", sessionid);
        map.put("typing", state);
        this.sendIndication(METHOD_MESSAGE_TYPED, map);
    }

    public void updateMessage(SessionInfo session, MessageInfo messageInfo) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("sessionid", session.getSessionId());
        prms.put("id", messageInfo.getId());
        int code = messageInfo.getCode();
        if (this.getUserId().equals(messageInfo.getSenderId())) {
            prms.put("content", messageInfo.getContent());
            code |= 0x200;
        }
        prms.put("code", code);
        this.sendIndication(METHOD_UPDATE_MESSAGE, prms);
    }

    public void deleteMessage(SessionInfo session, MessageInfo message) throws Exception {
        if (message.canBeDeleted()) {
            if (message.getStatus() > -1) {
                HashMap<String, String> prms = new HashMap<String, String>();
                prms.put("id", message.getId());
                this.sendIndication(METHOD_DELETE_MESSAGE, prms);
            }
            session.removeMessage(message.getId());
            this.removeSessionMessage(session, message);
        } else {
            Vector<MessageInfo> messages = new Vector<MessageInfo>();
            messages.add(message);
            this.removeMessages(session, messages);
        }
    }

    public void deleteMessages(SessionInfo session) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("sessionid", session.getSessionId());
        this.sendIndication(METHOD_DELETE_MESSAGES, prms);
        session.removeAllMessages();
        new File(this.filedir, session.getSessionId()).delete();
    }

    public void removeCalls(String sessionid) throws Exception {
        HashMap<SessionInfo, List> map = new HashMap<SessionInfo, List>();
        if (sessionid != null) {
            SessionInfo session = this.sessions.get(sessionid);
            map.put(session, session.getCalls());
        } else {
            Iterator itr = this.sessionsIterator();
            while (itr.hasNext()) {
                SessionInfo session = (SessionInfo)itr.next();
                map.put(session, session.getCalls());
            }
        }
        ArrayList<String> messageIds = new ArrayList<String>();
        for (List calls : map.values()) {
            for (int i = 0; i < calls.size(); ++i) {
                messageIds.add(((MessageInfo)calls.get(i)).getId());
            }
        }
        if (messageIds.isEmpty()) {
            return;
        }
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("messages", messageIds);
        prms.put("sessionid", sessionid);
        this.sendIndication(METHOD_REMOVE_MESSAGES, prms);
        for (SessionInfo session : map.keySet()) {
            session.removeCalls();
            this.removeSessionMessages(session, (List)map.get(session));
        }
    }

    public void removeMessages(SessionInfo session, List<MessageInfo> messages) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        if (!(session != null && session.getStatus() != -5 || messages == null || messages.isEmpty())) {
            Iterator itr = this.sessionsIterator();
            while (itr.hasNext()) {
                MessageInfo mess;
                SessionInfo sessionInfo = (SessionInfo)itr.next();
                if (!sessionInfo.isGroup() && !sessionInfo.isChannel() || (mess = sessionInfo.getMessage(messages.get(0).getId())) == null) continue;
                session = sessionInfo;
                break;
            }
        }
        if (session != null) {
            prms.put("sessionid", session.getSessionId());
        }
        Vector<String> ids = new Vector<String>();
        if (messages != null) {
            for (int i = 0; i < messages.size(); ++i) {
                ids.add(messages.get(i).getId());
            }
            prms.put("messages", ids);
        }
        this.sendIndication(METHOD_REMOVE_MESSAGES, prms);
        if (session != null) {
            if (messages == null) {
                session.removeAllMessages();
            } else {
                for (int i = 0; i < ids.size(); ++i) {
                    session.removeMessage((String)ids.get(i));
                }
            }
            this.removeSessionMessages(session, messages);
        } else {
            this.removeAllMessages();
        }
    }

    public void markMessages(SessionInfo session, List<MessageInfo> messages, int code) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        if (session == null) {
            Iterator itr = this.sessionsIterator();
            while (itr.hasNext()) {
                MessageInfo mess;
                SessionInfo sessionInfo = (SessionInfo)itr.next();
                if (!sessionInfo.isGroup() && !sessionInfo.isChannel() || (mess = sessionInfo.getMessage(messages.get(0).getId())) == null) continue;
                session = sessionInfo;
                break;
            }
        }
        prms.put("sessionid", session.getSessionId());
        prms.put("code", code);
        if (messages != null) {
            MessageInfo message;
            if (code == 1 && messages.size() == 1 && (message = messages.get(0)).canBeDeleted()) {
                prms.put("id", message.getId());
                this.sendIndication(METHOD_UPDATE_MESSAGE, prms);
                return;
            }
            Vector<String> ids = new Vector<String>();
            for (int i = 0; i < messages.size(); ++i) {
                MessageInfo message2 = messages.get(i);
                ids.add(message2.getId());
                if (code != 128) continue;
                message2.setStatus(2);
            }
            prms.put("messages", ids);
        }
        this.sendIndication(METHOD_MARK_MESSAGES, prms);
    }

    protected void removeCallHistory(String sessionid) throws Exception {
        SessionInfo sessionInfo = this.sessions.get(sessionid);
        List ids = sessionInfo.removeCallHistory();
        if (ids.isEmpty()) {
            return;
        }
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("sessionid", sessionid);
        prms.put("messages", ids);
        this.sendIndication(METHOD_REMOVE_MESSAGES, prms);
    }

    public void sendState(int state, String note, int timeout, String termid) throws Exception {
        this.toLog("sendState " + state + " termid=" + termid);
        if (state == 0) {
            this.unregister();
        } else {
            boolean dp;
            if (!this.online) {
                if (!this.server.isReconnecting()) {
                    this.signIn(this.client.getServerAddress());
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!this.online && state != 0) {
                    throw new Exception("NotConnected");
                }
            }
            boolean bl = dp = state == 5;
            if (dp) {
                state = 4;
            }
            this.sendStateIndication(state, note, timeout, termid);
            this.localProperties.put(CALL_FROM_PHONE, dp);
            this.saveProperties();
        }
    }

    public void sendStateIndication(int state, String note, int timeout, String termid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("state", state);
        params.put("note", note);
        params.put("termid", termid);
        if (timeout > 0) {
            params.put("timeout", timeout);
        }
        this.sendIndication(METHOD_SET_STATE, params);
    }

    protected SessionInfo getPostSession(Map commentInfo) {
        String sessionid = (String)commentInfo.get("sessionid");
        SessionInfo sessionInfo = this.sessions.get(sessionid);
        if (sessionInfo == null) {
            sessionInfo = new SessionInfo();
            sessionInfo.setSessionId(sessionid);
            ContactInfo contact = this.findContact((String)commentInfo.get("userid"));
            sessionInfo.setName((String)commentInfo.get("name"));
            sessionInfo.addParty(contact);
            sessionInfo.setSubject((String)commentInfo.get("subject"));
            sessionInfo.setDescription((String)commentInfo.get("serviceid"));
            String ownerid = (String)commentInfo.get("owner");
            if (ownerid != null && !ownerid.equals(this.getUserId())) {
                sessionInfo.addParty(this.findContact(ownerid));
            }
            sessionInfo.setProperty("post", commentInfo.get("post"));
            sessionInfo.setProperty("postid", commentInfo.get("postid"));
            sessionInfo.setStatus(-6);
        }
        return sessionInfo;
    }

    protected SessionInfo getSession(ContactInfo contact, Activity activity) {
        String id = activity.getSessionId();
        SessionInfo sessionInfo = this.sessions.get(id);
        if (sessionInfo == null) {
            sessionInfo = new SessionInfo();
            sessionInfo.setSessionId(id);
            sessionInfo.setName(contact.toString());
            sessionInfo.addParty(contact);
            String ownerid = activity.getOwnerId();
            if (ownerid != null && !ownerid.equals(this.getUserId())) {
                sessionInfo.addParty(this.findContact(ownerid));
            }
            sessionInfo.setStatus(-6);
        }
        return sessionInfo;
    }

    protected SessionInfo getChatRequest(MessageInfo message) throws Exception {
        String senderid = message.getSenderId();
        ContactInfo contact = this.findContact(senderid);
        int status = message.getCode() == 32 ? -5 : -6;
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.addParty(contact);
        sessionInfo.addMessage(message);
        sessionInfo.setStatus(status);
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionInfo acceptChatRequest(MessageInfo message) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        String id = message.getId();
        params.put("id", id);
        Map map = (Map)this.sendCommand(METHOD_ACCEPT_CHAT_REQUEST, params);
        SessionInfo sessionInfo = null;
        Iterator itr = this.sessionsIterator();
        while (itr.hasNext()) {
            SessionInfo session = (SessionInfo)itr.next();
            if (!session.isChannel() || session.getMessage(id) == null) continue;
            sessionInfo = session;
            break;
        }
        this.toLog("acceptChatRequest channel=" + sessionInfo);
        message.setCode(message.getCode() | 0x10);
        sessionInfo.notifyMessageUpdated(message);
        if (map.isEmpty()) {
            throw new Exception("RequestAlreadyAssigned");
        }
        String sessionId = (String)map.get("id");
        SessionInfo session = this.sessions.get(sessionId);
        this.toLog("acceptChatRequest session=" + session);
        if (session == null) {
            session = this.createSession(map);
            Map<String, SessionInfo> map2 = this.sessions;
            synchronized (map2) {
                this.sessions.put(session.getSessionId(), session);
            }
        }
        session.addMessage(message);
        List messages = (List)map.get("messages");
        if (messages != null) {
            for (int i = 0; i < messages.size(); ++i) {
                MessageInfo mess;
                String mid = (String)messages.get(i);
                if (mid.equals(message.getId()) || (mess = sessionInfo.getMessage(mid)) == null) continue;
                session.addMessage(mess);
            }
        }
        return session;
    }

    protected SessionInfo getActivitySession(MessageInfo message) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("messageid", message.getId());
        Map map = (Map)this.sendCommand("getActivitySession", params);
        String sessionId = (String)map.get("sessionid");
        return this.getSession(sessionId);
    }

    public void transferSession(SessionInfo sessionInfo, ContactInfo contactInfo) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sessionid", sessionInfo.getSessionId());
        params.put("userid", contactInfo.getUserID());
        this.sendIndication("transferSession", params);
    }

    protected List getActivitySubjects(int category) {
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            if (category != -1) {
                params.put("category", category);
            }
            this.subjects = (List)this.sendCommand("getActivitySubjects", params);
        }
        catch (Exception e) {
            this.subjects = new Vector();
        }
        return this.subjects;
    }

    protected List<String> getTags() {
        try {
            this.tags = (List)this.sendCommand("getTags", new HashMap());
        }
        catch (Exception e) {
            this.tags = new Vector();
        }
        return this.tags;
    }

    protected void getActivities(ContactInfo contactInfo) throws Exception {
        List list;
        if (!this.online) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", contactInfo.getUserID());
        List<Activity> activities = contactInfo.getActivities();
        if (!activities.isEmpty()) {
            params.put("since", activities.get(0).getLastUpdatedTime());
        }
        if ((list = (List)this.sendCommand("getActivities", params)).isEmpty()) {
            return;
        }
        ArrayList<Activity> newActivities = new ArrayList<Activity>();
        for (int i = 0; i < list.size(); ++i) {
            Activity activity = new Activity((Map)list.get(i));
            String userid = activity.getOwnerId();
            if (userid == null) continue;
            ContactInfo owner = userid.equals(this.getUserId()) ? this.myInfo : this.findContact(userid);
            activity.setOwnerName(owner.toString());
            newActivities.add(activity);
        }
        contactInfo.addActivities(newActivities);
        this.saveObjects();
    }

    protected void createActivity(ContactInfo contactInfo, String type, String comment, long timedue) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", contactInfo.getUserID());
        params.put("comment", comment);
        if (timedue != 0L) {
            params.put("timedue", timedue);
        }
        Map map = (Map)this.sendCommand("createActivity", params);
        String id = (String)map.get("id");
        long timestart = (Long)map.get("timestart");
        Activity activity = new Activity(type);
        activity.setId(id);
        activity.setComment(comment);
        activity.setTimedue(timedue);
        activity.setTimestart(timestart);
        contactInfo.addActivity(activity);
    }

    protected void updateActivity(Activity activity, boolean close) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", activity.getId());
        params.put("subject", activity.getSubject());
        params.put("comment", activity.getComment());
        if (close) {
            long timestop = this.getServerTime();
            activity.setTimestop(timestop);
            params.put("timestop", timestop);
        } else {
            long timedue = activity.getTimedue();
            if (timedue > 0L) {
                params.put("timedue", timedue);
            }
        }
        this.sendIndication("updateActivity", params);
        this.saveObjects();
    }

    protected void updateCallInfo(Activity activity) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String activityid = activity.getId();
        if (activityid != null) {
            params.put("activityid", activityid);
        }
        params.put("subject", activity.getSubject());
        params.put("comment", activity.getComment());
        params.put("timestart", activity.getTimestart());
        params.put("ref", activity.getRef());
        this.sendIndication("updateCallInfo", params);
        this.saveObjects();
    }

    protected void sendCallInfo(Map callinfo, String userid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callinfo", callinfo);
        params.put("userid", userid);
        this.sendIndication("sendCallInfo", params);
    }

    private void processCallInfo(Map params) {
        String url;
        ResourceStore.toLog("processCallInfo " + params);
        for (LineInfo line : this.lines) {
            if (!line.setCallInfo(params)) continue;
            ResourceStore.toLog("processCallInfo line=" + line + " activity=" + line.getActivity());
            break;
        }
        if ((url = (String)params.get("run")) != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", url);
            this.client.commandReceived("runApplication", map);
        }
    }

    protected void processConferenceStart(Map params) {
        String id = (String)params.get("id");
        List parties = (List)params.get("parties");
        Boolean video = (Boolean)params.get("video");
        SessionInfo session = this.findSessionByDialogId(id);
        if (session != null) {
            session.setConferenceState(video != false ? 2 : 1);
        }
        ResourceStore.toLog("processConferenceStart " + params + " session=" + session);
        for (LineInfo line : this.lines) {
            if (!line.isConference()) continue;
            for (String userid : parties) {
                if (userid.equals(this.getUserId())) continue;
                line.addContactInfo(this.findContact(userid));
            }
        }
    }

    protected void processConferenceStop(Map params) {
        String id = (String)params.get("id");
        SessionInfo session = this.findSessionByDialogId(id);
        if (session != null) {
            session.setConferenceState(0);
        }
    }

    protected void processConferenceUpdate(Map params) {
        this.toLog("processConferenceUpdate " + params);
        String id = (String)params.get("id");
        String number = (String)params.get("number");
        Integer state = (Integer)params.get("state");
        SessionInfo session = this.findSessionByDialogId(id);
        if (session != null) {
            session.processConferenceUpdate(params);
        }
        if (state != null) {
            this.conferenceUpdated(id, number, state == 1 ? 1 : 2);
        }
    }

    private void conferenceCreated(Map map) {
        String id = (String)map.get("id");
        String owner = (String)map.get("owner");
        List parties = (List)map.get("parties");
        String userid = this.getUserId();
        if (!userid.equals(owner)) {
            for (int i = 0; i < this.lines.size(); ++i) {
                LineInfo line = this.lines.get(i);
                if (!line.containsParty(owner)) continue;
                for (int j = 0; j < parties.size(); ++j) {
                    String uid = (String)parties.get(j);
                    if (uid.equals(userid)) continue;
                    line.addContactInfo(this.findContact(uid));
                }
                line.setConferenceId(id, owner);
                break;
            }
        }
    }

    private void conferenceUpdated(Map map) {
        String id = (String)map.get("id");
        String party = (String)map.get("party");
        int event = (Integer)map.get("event");
        this.conferenceUpdated(id, party, event);
    }

    private void conferenceUpdated(String id, String number, int event) {
        if (number.equals(this.getUserId())) {
            return;
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            LineInfo line = this.lines.get(i);
            this.toLog("conferenceUpdated line=" + line + " conf=" + line.getConferenceId());
            if (!id.equals(line.getConferenceId())) continue;
            ContactInfo contactInfo = this.findContact(number);
            if (event == 1) {
                line.addContactInfo(contactInfo);
                contactInfo.setConferenceState(1);
            } else {
                line.removeContactInfo(contactInfo);
                contactInfo.setConferenceState(0);
            }
            line.notifyListeners();
            break;
        }
    }

    private void conferenceDeleted(Map map) {
        this.toLog("conferenceDeleted " + map);
        String id = (String)map.get("id");
        String owner = (String)map.get("owner");
        for (int i = 0; i < this.lines.size(); ++i) {
            LineInfo line = this.lines.get(i);
            if (!id.equals(line.getConferenceId())) continue;
            line.setConferenceId(null, null);
            this.server.setConnectedNumber(line.getName(), line.getConnectedNumber());
            break;
        }
    }

    protected void conferenceUpdateRequest(Map map) {
        String id = (String)map.get("id");
        String user = (String)map.get("user");
        String party = (String)map.get("party");
        String action = (String)map.get("action");
        for (int i = 0; i < this.lines.size(); ++i) {
            LineInfo line = this.lines.get(i);
            if (!id.equals(line.getConferenceId())) continue;
            ContactInfo contact = this.findContact(party);
            this.makeCall(contact, line.isVideoEnabled());
            break;
        }
    }

    public void sendConferenceUpdateRequest(String confid, String number) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", confid);
        params.put("party", number);
        params.put("action", "add");
        this.sendIndication(METHOD_CONFERENCE_UPDATE_REQUEST, params);
    }

    public String sendConferenceCreated(List parties, boolean video) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("parties", parties);
        prms.put("owner", this.getUserId());
        prms.put("media", video ? 1 : 0);
        return (String)this.sendCommand(METHOD_CONFERENCE_CREATED, prms);
    }

    public void sendConferenceDeleted(String conferenceId) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("id", conferenceId);
        this.sendIndication(METHOD_CONFERENCE_DELETED, prms);
    }

    public void sendConferenceUpdated(String conferenceId, String party, int event) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("id", conferenceId);
        prms.put("owner", this.getUserId());
        prms.put("party", party);
        prms.put("event", event);
        this.sendIndication(METHOD_CONFERENCE_UPDATED, prms);
    }

    public void addToConference(ContactInfo contact) throws Exception {
        if (!this.localConfmode) {
            for (int i = 0; i < this.lines.size(); ++i) {
                String confid = this.lines.get(i).getConferenceId();
                if (confid == null || confid.length() <= 0) continue;
                this.conferenceAddParty(confid, contact.getUserID());
            }
        }
    }

    public void dropFromConference(ContactInfo contact) throws Exception {
        if (this.localConfmode) {
            this.server.dropConnectedParty(contact.getNumber());
            for (int i = 0; i < this.lines.size(); ++i) {
                LineInfo line = this.lines.get(i);
                if (!line.removeContactInfo(contact)) continue;
                this.conferenceUpdated(line, contact.getNumber(), 2);
                break;
            }
        } else {
            for (int i = 0; i < this.lines.size(); ++i) {
                String confid = this.lines.get(i).getConferenceId();
                if (confid == null || confid.length() <= 0) continue;
                this.conferenceDropParty(confid, contact.getUserID());
            }
        }
    }

    public boolean isConferenceOwner() {
        for (int i = 0; i < this.lines.size(); ++i) {
            String cowner;
            if (this.lines.get(i).getConferenceId() == null || (cowner = this.lines.get(i).getConferenceOwner()) != null && !cowner.equals(this.getUserId())) continue;
            return true;
        }
        return false;
    }

    private void contactStatusChanged(ContactInfo contact) {
        if (!this.localConfmode && contact.getState() <= 1) {
            for (int i = 0; i < this.lines.size(); ++i) {
                LineInfo line = this.lines.get(i);
                if (line.getConferenceId() == null || !line.removeContactInfo(contact)) continue;
                this.conferenceUpdated(line, contact.getUserID(), 2);
                break;
            }
        }
        this.client.contactStatusChanged(contact);
    }

    protected void setLineSession(LineInfo lineInfo, String number) {
        ContactInfo contactInfo = this.numbers.get(number);
        if (contactInfo != null) {
            lineInfo.addContactInfo(contactInfo);
        }
        SessionInfo session = this.getSessionByPhoneNumber(number, lineInfo.getState() == 2 ? lineInfo.getCallerName() : null);
        lineInfo.setSessionInfo(session);
        if (session.getStatus() > 0 && session.getStatus() < 4) {
            lineInfo.setConferenceId(session.getDialogId(), lineInfo.getState() == 1 ? this.getUserId() : "");
        }
        this.toLog(lineInfo.getName() + " setSession=" + session + " status=" + session.getStatus() + " confid=" + lineInfo.getConferenceId());
    }

    public void lineIdentityChanged(String number, Line line) {
        this.toLog("lineIdentityChanged number=" + number + " line=" + line);
        LineInfo lineInfo = (LineInfo)line.getLinePane();
        if (number.equals(lineInfo.getConnectedNumber())) {
            return;
        }
        SessionInfo session = lineInfo.getSessionInfo();
        if (session == null || !session.isGroup()) {
            line.setConnectedNumber(number);
            lineInfo.setSessionInfo(this.getSessionByPhoneNumber(number, ""), number);
        }
    }

    public void lineStateChanged(int state, String number, String description, Line line) {
        LineInfo lineInfo = (LineInfo)line.getLinePane();
        this.toLog("lineStateChanged state=" + state + " number=" + number + " description=" + description + " line=" + lineInfo.getName() + " confid=" + lineInfo.getConferenceId() + " mode=" + this.localConfmode);
        if (state == 1 || state == 2) {
            if (lineInfo.getSessionInfo() == null) {
                this.setLineSession(lineInfo, number);
            }
        } else if (state == 18) {
            lineInfo.setStateDescription(description);
        } else if (state == 8) {
            if (lineInfo.getConferenceId() != null && !this.localConfmode) {
                try {
                    this.sendConferenceUpdated(lineInfo.getConferenceId(), this.getUserId(), 3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (state == 19) {
            if (lineInfo.getConferenceId() == null) {
                this.conferenceCreated(lineInfo, description.equals("videoconference"));
            }
        } else if (state == 21) {
            ContactInfo contact = this.findContactByPhoneNumber(number, lineInfo.getPartyName());
            this.toLog("findContactByPhoneNumber " + number + " contact=" + contact + " valid=" + contact.isValid());
            lineInfo.addContactInfo(contact);
            if (lineInfo.getConferenceId() != null) {
                this.conferenceUpdated(lineInfo, contact.getUserID(), 1);
            } else {
                this.conferenceCreated(lineInfo, lineInfo.isVideoEnabled());
            }
        } else if (state == 22) {
            ContactInfo contact = this.findContactByPhoneNumber(number, lineInfo.getPartyName());
            if (lineInfo.removeContactInfo(contact)) {
                this.conferenceUpdated(lineInfo, number, 3);
            }
        } else if (state == 20) {
            this.conferenceDeleted(lineInfo.getConferenceId());
        }
    }

    public void conferenceAdded(Line line1, Line line2) {
        LineInfo lineInfo = (LineInfo)line1.getLinePane();
        LineInfo lineInfo2 = (LineInfo)line2.getLinePane();
        for (ContactInfo contactInfo : lineInfo2.getContacts()) {
            lineInfo.addContactInfo(contactInfo);
            if (lineInfo.getConferenceId() == null) continue;
            this.conferenceUpdated(lineInfo, contactInfo.getUserID(), 1);
        }
        if (lineInfo.getConferenceId() == null) {
            if (lineInfo2.isRecording()) {
                lineInfo.setRecording(true);
            }
            this.conferenceCreated(lineInfo, lineInfo.isVideoEnabled());
        }
    }

    protected void conferenceCreated(LineInfo line, boolean video) {
        try {
            String userid = this.getUserId();
            Vector<String> parties = new Vector<String>();
            parties.add(userid);
            Iterator<ContactInfo> it = line.getContacts().iterator();
            while (it.hasNext()) {
                parties.add(it.next().getUserID());
            }
            String conferenceId = this.sendConferenceCreated(parties, video);
            line.setConferenceId(conferenceId, userid);
            this.toLog("conferenceCreated line=" + line + " conf=" + conferenceId + " parties=" + parties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void conferenceDeleted(String conferenceId) {
        this.toLog("conferenceDeleted conf=" + conferenceId);
        try {
            this.sendConferenceDeleted(conferenceId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void conferenceUpdated(LineInfo linePanel, String party, int event) {
        try {
            this.sendConferenceUpdated(linePanel.getConferenceId(), party, event);
            this.toLog("conferenceUpdated line=" + linePanel + " conf=" + linePanel.getConferenceId() + " party=" + party + " event=" + event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendRecordingStateRequest(boolean rec) throws Exception {
        HashMap<String, Boolean> prms = new HashMap<String, Boolean>();
        prms.put("rec", rec);
        this.sendIndication(METHOD_SET_RECORDING_STATE, prms);
    }

    protected boolean setRecordingIndication(Map parameters) {
        Boolean state = (Boolean)parameters.get("rec");
        for (int i = 0; i < this.lines.size(); ++i) {
            LineInfo line = this.lines.get(i);
            if (line.getState() != 3 && line.getState() != 5 && line.getState() != 4) continue;
            line.setRecording(state);
            return true;
        }
        return false;
    }

    public void deleteRecord(String recordid) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("id", recordid);
        this.sendIndication(METHOD_DELETE_FILE, prms);
    }

    protected boolean isTrunksDisabled() {
        if (this.myInfo == null) {
            return false;
        }
        List trunks = (List)this.myInfo.getProperty("trunks");
        if (trunks == null || trunks.isEmpty()) {
            return false;
        }
        for (int i = 0; i < trunks.size(); ++i) {
            Map m = (Map)trunks.get(i);
            if (!new Integer(1).equals(m.get("state"))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trunkState(Map params) {
        ArrayList<Map> trunks;
        this.toLog("trunkState: " + params + " myinfo=" + this.myInfo);
        if (this.myInfo == null) {
            ServiceManager serviceManager = this;
            synchronized (serviceManager) {
                try {
                    this.wait(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((trunks = (ArrayList<Map>)this.myInfo.getProperty("trunks")) == null) {
            trunks = new ArrayList<Map>();
        }
        String oid = (String)params.get("oid");
        String name = (String)params.get("name");
        Integer state = (Integer)params.get("state");
        if (state == null) {
            state = (Boolean)params.get("enabled") != false ? 1 : 0;
        }
        Map trunk = null;
        Map oldtrunk = null;
        for (int i = 0; i < trunks.size(); ++i) {
            Map m = (Map)trunks.get(i);
            if (oid.equals(m.get("oid"))) {
                trunk = m;
                break;
            }
            if (name == null || !name.equals(m.get("name"))) continue;
            oldtrunk = m;
        }
        if (trunk != null) {
            trunk.put("state", state);
        } else {
            trunks.add(params);
            if (oldtrunk != null) {
                trunks.remove(oldtrunk);
            }
        }
        this.toLog("trunkState: trunks=" + trunks);
    }

    protected String getTrunkNumber(String number, String trunk) {
        if (number.contains("@") || trunk == null && (number.contains("CHANNEL") || number.indexOf(42) > 0)) {
            return number;
        }
        String defaultTrunk = (String)this.getProperty(SERVICE_TRUNK_NAME);
        List trunks = null;
        if (this.myInfo != null) {
            trunks = (List)this.myInfo.getProperty("trunks");
        }
        if (trunk != null && trunk.equals(defaultTrunk)) {
            return this.normalizePhoneNumber(number, this.client.getCountryCode());
        }
        if (trunk == null && defaultTrunk != null || trunks == null || trunks.isEmpty()) {
            return this.normalizePhoneNumber(number, this.client.getCountryCode());
        }
        if (trunk == null && trunks.size() > 1) {
            return "TRUNK*" + this.normalizePhoneNumber(number, this.client.getCountryCode());
        }
        for (int i = 0; i < trunks.size(); ++i) {
            Map m = (Map)trunks.get(i);
            if (trunk != null && !trunk.equals(m.get("name")) || !new Integer(1).equals(m.get("state"))) continue;
            String cc = (String)m.get("country");
            if (cc == null) {
                cc = this.client.getCountryCode();
            }
            return "TRUNK" + m.get("oid") + "*" + this.normalizePhoneNumber(number, cc);
        }
        return number;
    }

    public void makeCall(String number) {
        if (number.length() == 0) {
            return;
        }
        ContactInfo contactInfo = this.numbers.get(number);
        if (contactInfo == null || !number.equals(contactInfo.getUserID())) {
            number = this.getTrunkNumber(number, null);
        }
        this.makeCall(number, false);
    }

    public void makeVideoCall(String number) {
        if (number.length() == 0) {
            return;
        }
        ContactInfo contactInfo = this.numbers.get(number);
        if (contactInfo == null || !number.equals(contactInfo.getUserID())) {
            number = this.getTrunkNumber(number, null);
        }
        this.makeCall(number, true);
    }

    public void makeCall(String number, String trunk, boolean video) {
        if (number.length() == 0) {
            return;
        }
        this.makeCall(this.getTrunkNumber(number, trunk), video);
    }

    private void makeCall(String number, boolean video) {
        if (!video && this.hasSIPDevice() && !number.equals(this.myInfo.getNumber()) && !this.hasActiveCalls()) {
            this.initCall(number);
        } else {
            this.server.makeCall(number, video);
        }
    }

    private void initCall(final String number) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceManager.this.client.assistantCallState(0);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("termid", ServiceManager.this.getUserId());
                params.put("tonumber", number);
                try {
                    Integer result = (Integer)ServiceManager.this.sendCommand("initCall", params);
                    ServiceManager.this.client.assistantCallState(result == 200 ? 1 : (result == 480 ? 2 : 3));
                }
                catch (Exception e) {
                    ServiceManager.this.toLog(e);
                    ServiceManager.this.client.assistantCallState(3);
                }
            }
        }).start();
    }

    public boolean hasSIPDevice() {
        return Boolean.TRUE.equals(this.localProperties.get(CALL_FROM_PHONE)) && this.getSIPDevice() != null;
    }

    public String getSIPDevice() {
        List devices = (List)this.myInfo.getProperty("devices");
        if (devices == null) {
            return null;
        }
        for (int i = 0; i < devices.size(); ++i) {
            Map device = (Map)devices.get(i);
            int state = (Integer)device.get("state");
            if (!this.getUserId().equals(device.get("id")) || state != 1) continue;
            return (String)device.get("ua");
        }
        return null;
    }

    public List getTrunks() {
        if (this.myInfo == null) {
            return new ArrayList();
        }
        List trunks = (List)this.myInfo.getProperty("trunks");
        return trunks != null ? trunks : new ArrayList();
    }

    public List getTrunks(String number) {
        return this.getSIPTrunks(number);
    }

    public String getDefaultSIPTrunk() {
        List trunks;
        String def = null;
        if (this.myInfo != null && (trunks = (List)this.myInfo.getProperty("trunks")) != null) {
            for (int i = 0; i < trunks.size(); ++i) {
                Map trunk = (Map)trunks.get(i);
                if (!Boolean.TRUE.equals(trunk.get("default"))) continue;
                def = (String)trunk.get("name");
            }
        }
        if (def == null) {
            def = (String)this.localProperties.get(SERVICE_TRUNK_NAME);
        }
        return def;
    }

    public void setDefaultSIPTrunk(String deftrunk) {
        List trunks = (List)this.myInfo.getProperty("trunks");
        if (trunks == null) {
            return;
        }
        for (int i = 0; i < trunks.size(); ++i) {
            Map trunk = (Map)trunks.get(i);
            if (deftrunk.equals(trunk.get("name"))) {
                trunk.put("default", true);
                continue;
            }
            trunk.remove("default");
        }
        this.saveObjects();
    }

    public List getSIPTrunks(String number) {
        ArrayList<String> list = new ArrayList<String>();
        String svctrunk = (String)this.getProperty(SERVICE_TRUNK_NAME);
        if (svctrunk != null) {
            list.add(svctrunk);
        }
        if (this.myInfo != null) {
            List trunks;
            MessageInfo messageInfo;
            SessionInfo sessionInfo;
            ContactInfo contactInfo;
            String trunkid = null;
            if (number != null && (contactInfo = this.numbers.get(number)) != null && (sessionInfo = this.findSession(contactInfo)) != null && (messageInfo = sessionInfo.getLastCall(number)) != null) {
                trunkid = messageInfo.getCallTrunkNumber();
            }
            if ((trunks = (List)this.myInfo.getProperty("trunks")) != null) {
                for (int i = 0; i < trunks.size(); ++i) {
                    Map trunk = (Map)trunks.get(i);
                    Integer state = (Integer)trunk.get("state");
                    if (state == null || state == 2) continue;
                    if (trunkid != null && (trunkid.equals(trunk.get("number")) || trunkid.equals(trunk.get("user")))) {
                        list.clear();
                        list.add((String)trunk.get("name"));
                        break;
                    }
                    list.add((String)trunk.get("name"));
                }
            }
            this.toLog("getSIPTrunks number=" + number + " trunkid=" + trunkid + " list=" + list);
        }
        return list;
    }

    public List getSIPTrunksForSMS() {
        return this.getSIPTrunksForSMS(null);
    }

    public List getSIPTrunksForMMS() {
        return this.getSIPTrunksForMMS(null);
    }

    public List getSIPTrunksForSMS(SessionInfo sessionInfo) {
        return this.getTrunksForSMS(sessionInfo, "sms");
    }

    public List getSIPTrunksForMMS(SessionInfo sessionInfo) {
        return this.getTrunksForSMS(sessionInfo, "mms");
    }

    private List getTrunksForSMS(SessionInfo sessionInfo, String type) {
        List trunks;
        ArrayList list = new ArrayList();
        if (this.myInfo == null) {
            return list;
        }
        boolean simple = false;
        String trunkid = null;
        if (sessionInfo != null) {
            MessageInfo messageInfo = sessionInfo.getLastMessage(20);
            if (messageInfo != null) {
                trunkid = messageInfo.getTrunkId();
            }
            if (sessionInfo.getParties().size() == 1 && sessionInfo.getParties().get(0).isPhone()) {
                simple = true;
            }
        }
        if ((trunks = (List)this.myInfo.getProperty("trunks")) != null) {
            for (int i = 0; i < trunks.size(); ++i) {
                Map trunk = (Map)trunks.get(i);
                if (!new Boolean(true).equals(trunk.get(type))) continue;
                if (trunkid != null && trunkid.equals(trunk.get("oid"))) {
                    list.clear();
                    list.add(trunk.get("name"));
                    break;
                }
                if (simple && !trunk.containsKey("user")) continue;
                list.add(trunk.get("name"));
            }
        }
        return list;
    }

    public List getTrunksForSIPSimple() {
        ArrayList list = new ArrayList();
        List trunks = (List)this.myInfo.getProperty("trunks");
        if (trunks != null) {
            for (int i = 0; i < trunks.size(); ++i) {
                Map trunk = (Map)trunks.get(i);
                if (!new Boolean(true).equals(trunk.get("sms")) || !trunk.containsKey("user")) continue;
                list.add(trunk.get("name"));
            }
        }
        return list;
    }

    public List getSIPAccounts() throws Exception {
        HashMap params = new HashMap();
        Object object = this.sendCommand("getSIPAccounts", params);
        if (object instanceof List) {
            this.myInfo.setProperty("trunks", object);
            return (List)object;
        }
        ArrayList list = (ArrayList)this.myInfo.getProperty("trunks");
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public Map setSIPAccount(Map params) throws Exception {
        Map map = (Map)this.sendCommand("setSIPAccount", params);
        if (map == null) {
            throw new Exception("CommunicationError");
        }
        Integer state = (Integer)map.get("state");
        if (state == null || state == -1) {
            throw new Exception((String)map.get("description"));
        }
        params.put("oid", map.get("id"));
        params.put("state", state);
        ArrayList<Map> trunks = (ArrayList<Map>)this.myInfo.getProperty("trunks");
        if (trunks == null) {
            trunks = new ArrayList<Map>();
        }
        trunks.add(params);
        this.saveObjects();
        return params;
    }

    public void setSIPAccountState(String id, int state) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("oid", id);
        prms.put("enabled", state != 0);
        this.sendIndication("setSIPAccountState", prms);
        List trunks = (List)this.myInfo.getProperty("trunks");
        for (int i = 0; i < trunks.size(); ++i) {
            Map trunk = (Map)trunks.get(i);
            if (!id.equals(trunk.get("oid"))) continue;
            trunk.put("state", state);
            break;
        }
        this.saveObjects();
    }

    public void deleteSIPAccount(String id) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("oid", id);
        this.sendCommand("deleteSIPAccount", prms);
        List trunks = (List)this.myInfo.getProperty("trunks");
        for (int i = 0; i < trunks.size(); ++i) {
            Map trunk = (Map)trunks.get(i);
            if (!id.equals(trunk.get("oid"))) continue;
            trunks.remove(i);
            break;
        }
        this.saveObjects();
    }

    public Map getSIPCredentials(boolean resetPassword) throws Exception {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("reset", resetPassword);
        return (Map)this.sendCommand("getSIPCredentials", params);
    }

    public List getEmailChannels() {
        boolean add;
        Vector<Map> result = new Vector<Map>();
        String myEmail = this.myInfo.getPrimaryEmail();
        boolean bl = add = myEmail != null && myEmail.length() > 0;
        if (this.online) {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("type", "Email");
                List array = (List)this.sendCommand("getChannels", params);
                for (int i = 0; i < array.size(); ++i) {
                    Map map = (Map)array.get(i);
                    result.add(map);
                    if (myEmail == null || !myEmail.equalsIgnoreCase((String)map.get("profileid"))) continue;
                    add = false;
                }
            }
            catch (Exception e) {
                ResourceStore.error("getChannels", e);
            }
        }
        if (add) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("profileid", myEmail);
            map.put("private", true);
            map.put("name", this.myInfo.toString());
            result.add(map);
        }
        return result;
    }

    public String setEmailChannel(Map map) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "Email");
        params.put("name", map.get("name"));
        params.put("profileid", map.get("username"));
        params.put("enabled", map.get("enabled"));
        params.put("properties", map);
        String oid = (String)this.sendCommand("setChannel", params);
        return oid;
    }

    public void deleteEmailChannel(String oid) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oid", oid);
        this.sendCommand("deleteChannel", params);
    }

    public void setEmailSignature(String address, String signature) {
        HashMap<String, String> signatures = (HashMap<String, String>)this.myInfo.getProperty("email_signatures");
        if (signatures == null) {
            signatures = new HashMap<String, String>();
            this.myInfo.setProperty("email_signatures", signatures);
        }
        signatures.put(address, signature);
        this.saveProperties();
        try {
            HashMap<String, HashMap<String, String>> params = new HashMap<String, HashMap<String, String>>();
            params.put("email_signatures", signatures);
            this.sendIndication("setProfile", params);
        }
        catch (Exception e) {
            ResourceStore.error("setEmailSignature", e);
        }
    }

    public String getEmailSignature(String address) {
        Map signatures = (Map)this.myInfo.getProperty("email_signatures");
        return signatures != null ? (String)signatures.get(address) : null;
    }

    public void mailRead(EmailInfo emailInfo, SessionInfo sessionInfo) {
        String sessionid = sessionInfo.getSessionId();
        if (sessionid == null) {
            sessionid = emailInfo.getSessionId();
            sessionInfo = this.sessions.get(sessionid);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sessionid", sessionid);
        map.put("messageid", emailInfo.getId());
        try {
            this.sendIndication("mailRead", map);
        }
        catch (Exception e) {
            List object = sessionInfo.messageRead(map);
            this.saveSessionMessage(sessionInfo, (MessageInfo)((Object)object));
            this.client.sessionUpdated(sessionInfo);
        }
    }

    public void adRead(MessageInfo messageInfo, SessionInfo sessionInfo) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionid", sessionInfo.getSessionId());
        ArrayList<String> messageIds = new ArrayList<String>();
        messageIds.add(messageInfo.getId());
        map.put("messages", messageIds);
        this.sendIndication(METHOD_MESSAGE_READ, map);
    }

    public void markSpam(MessageInfo message) throws Exception {
        message.setStatus(2);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("messageid", message.getId());
        this.sendIndication("markSpam", map);
    }

    public void conferenceAddParty(String confid, String userid) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confid", confid);
        map.put("party", userid);
        this.sendIndication("conferenceAddParty", map);
    }

    public void conferenceDropParty(String confid, String userid) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confid", confid);
        map.put("party", userid);
        this.sendIndication("conferenceDropParty", map);
    }

    public void conferenceSetSpeaker(String confid, String userid) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confid", confid);
        map.put("party", userid);
        this.sendIndication("conferenceSetSpeaker", map);
    }

    public void conferenceAddSpeaker(String confid, String userid) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confid", confid);
        map.put("party", userid);
        this.sendIndication("conferenceAddSpeaker", map);
    }

    public void conferenceRemoveSpeaker(String confid, String userid) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confid", confid);
        map.put("party", userid);
        this.sendIndication("conferenceRemoveSpeaker", map);
    }

    public void conferenceClose(String confid) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confid", confid);
        this.sendIndication("conferenceClose", map);
    }

    public void conferenceSetOptions(Map map) throws Exception {
        this.sendIndication("conferenceSetOptions", map);
    }

    private Object loadObject(File file) throws Exception {
        return this.loadObject(new FileInputStream(file));
    }

    private Object loadObject(InputStream is) throws Exception {
        int readBytes;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((readBytes = is.read(buffer)) != -1) {
            bos.write(buffer, 0, readBytes);
        }
        is.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    public void saveObject(File file, Object obj) throws Exception {
        this.saveObject(new FileOutputStream(file), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveObject(OutputStream out, Object obj) throws Exception {
        Object object = obj;
        synchronized (object) {
            BufferedOutputStream buf = new BufferedOutputStream(out, 2000000);
            ObjectOutputStream oos = new ObjectOutputStream(buf);
            oos.writeObject(obj);
            oos.flush();
            oos.close();
        }
    }

    public Object loadObject(File file, String alg) throws Exception {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(file));
        if (alg != null) {
            is = new CipherInputStream(is, this.getCipher(2, alg));
        }
        return this.loadObject(is);
    }

    public void saveObject(File file, Object obj, String alg) throws Exception {
        OutputStream out = new FileOutputStream(file);
        if (alg != null) {
            out = new CipherOutputStream(out, this.getCipher(1, alg));
        }
        this.saveObject(out, obj);
    }

    public Object loadObject(String name) throws Exception {
        return this.loadObject(new File(this.filedir, name), (String)this.localProperties.get(ENCRYPT_DATA));
    }

    public void saveObject(String name, Object obj) throws Exception {
        this.saveObject(new File(this.filedir, name), obj, (String)this.localProperties.get(ENCRYPT_DATA));
    }

    protected Cipher getCipher(int mode, String alg) throws Exception {
        KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(this.client.getTerminalId().toCharArray());
        KeyStore.SecretKeyEntry keyEntry = (KeyStore.SecretKeyEntry)this.keyStore.getEntry("fkey", pp);
        Cipher cipher = Cipher.getInstance(alg);
        cipher.init(mode, keyEntry.getSecretKey());
        return cipher;
    }

    protected void loadKeyStore(char[] pass) throws Exception {
        String kstype = KeyStore.getDefaultType();
        if (kstype.equalsIgnoreCase("JKS")) {
            kstype = "JCEKS";
        }
        this.toLog("loadKeyStore type=" + kstype + " def=" + KeyStore.getDefaultType());
        this.keyStore = KeyStore.getInstance(kstype);
        File keystoreFile = new File(this.filedir, ".k");
        if (keystoreFile.exists()) {
            this.loadKeystore(keystoreFile, pass);
        } else {
            this.createKeyStore(keystoreFile, pass);
        }
    }

    private void loadKeystore(File keystoreFile, char[] storepass) throws Exception {
        FileInputStream input = new FileInputStream(keystoreFile);
        this.keyStore.load(input, storepass);
        ((InputStream)input).close();
    }

    private void createKeyStore(File keystoreFile, char[] storepass) throws Exception {
        this.keyStore.load(null, storepass);
        byte[] key = Utils.generateCryptoKey(128);
        SecretKeySpec spec = new SecretKeySpec(key, "AES");
        KeyStore.SecretKeyEntry keyEntry = new KeyStore.SecretKeyEntry(spec);
        KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(this.client.getTerminalId().toCharArray());
        this.keyStore.setEntry("fkey", keyEntry, pp);
        this.saveKeystore(keystoreFile, storepass);
    }

    private void saveKeystore(File keystoreFile, char[] storepass) throws Exception {
        FileOutputStream output = new FileOutputStream(keystoreFile);
        this.keyStore.store(output, storepass);
        output.close();
    }

    private void loadAvatars() {
        List list1 = this.getSorted(this.sessionsIterator());
        for (int i = 0; i < list1.size(); ++i) {
            SessionInfo sessionInfo = (SessionInfo)list1.get(i);
            this.checkAvatar(sessionInfo);
            try {
                this.loadAvatar(sessionInfo);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List list2 = this.getSorted(this.contactsIterator());
        for (int i = 0; i < list2.size(); ++i) {
            ContactInfo contactInfo = (ContactInfo)list2.get(i);
            this.checkAvatar(contactInfo);
            try {
                this.loadAvatar(contactInfo);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadMessages(SessionInfo sessionInfo, long till) {
        int limit = till > 0L ? Integer.MAX_VALUE : this.messagesByRequest;
        this.loadMessages(sessionInfo, limit, till);
    }

    public void loadMessages(SessionInfo sessionInfo, int count, long till) {
        this.loadMessages(sessionInfo, count, false, till);
    }

    private void loadMessages(SessionInfo sessionInfo, int count, boolean checknew, long till) {
        int loaded = 0;
        long since = 0L;
        List stored = this.loadSessionMessages(sessionInfo);
        if (stored != null && stored.size() > 0) {
            try {
                Vector<MessageInfo> messages = new Vector<MessageInfo>();
                long now = System.currentTimeMillis();
                if (checknew) {
                    MessageInfo message;
                    int i = stored.size();
                    int j = Math.max(i - count, 0);
                    --i;
                    while (i >= j) {
                        message = (MessageInfo)stored.get(i);
                        if (message.getType() != 14 && message.getExpired() - now > 0L) {
                            if (message instanceof FileInfo) {
                                this.checkFileInfo((FileInfo)message);
                            }
                            messages.add(message);
                        }
                        --i;
                    }
                    while (i >= 0 && ((message = (MessageInfo)stored.get(i)).getStatus() == 1 || message.getStatus() == 12)) {
                        if (message.getExpired() - now > 0L) {
                            if (message instanceof FileInfo) {
                                this.checkFileInfo((FileInfo)message);
                            }
                            messages.add(message);
                        }
                        --i;
                    }
                    loaded = sessionInfo.addMessages(messages, false).size();
                    since = ((MessageInfo)stored.get(stored.size() - 1)).getAcceptedTime();
                } else {
                    MessageInfo firstMessage = sessionInfo.getFirstMessage();
                    if (firstMessage == null) {
                        since = System.currentTimeMillis();
                    } else if (firstMessage.getTime() > ((MessageInfo)stored.get(0)).getTime()) {
                        int i;
                        for (i = stored.size(); i > 0 && firstMessage.getTime() <= ((MessageInfo)stored.get(i - 1)).getTime(); --i) {
                        }
                        --i;
                        while (i >= 0) {
                            MessageInfo message = (MessageInfo)stored.get(i);
                            if (message.getType() != 14) {
                                long lifetime = message.getExpired() - now;
                                if (lifetime > 0L) {
                                    if (message instanceof FileInfo) {
                                        this.checkFileInfo((FileInfo)message);
                                    }
                                    messages.add(message);
                                }
                                if (message.getTime() < till || till == 0L && messages.size() >= 100) break;
                            }
                            --i;
                        }
                        loaded = sessionInfo.addMessages(messages, true).size();
                        if (i > 0) {
                            return;
                        }
                        since = ((MessageInfo)stored.get(0)).getTime();
                    } else {
                        since = firstMessage.getTime();
                    }
                }
            }
            catch (Exception e) {
                this.toLog(sessionInfo + " loadMessages - " + e.getMessage());
                this.toLog(e);
            }
        }
        if (since == 0L) {
            MessageInfo firstMessage = sessionInfo.getFirstMessage();
            since = firstMessage != null ? firstMessage.getTime() : System.currentTimeMillis();
        }
        if (!checknew) {
            if (this.startedOnline && this.online) {
                try {
                    loaded = this.loadMessages(sessionInfo, since, till, count);
                }
                catch (Exception e) {
                    this.toLog(e);
                }
            }
            if (loaded == 0) {
                sessionInfo.messageNotLoaded();
            }
        }
    }

    private void checkFileInfo(FileInfo fileInfo) {
        File file = fileInfo.getFile();
        if (!(file != null && file.exists() || fileInfo.getFilename() == null)) {
            String name = file != null ? file.getName() : fileInfo.getFilename();
            file = new File(this.client.getFileDir(fileInfo), name);
            if (!file.exists()) {
                file = new File(this.client.getCacheDir(), name);
            }
            if (file.exists()) {
                fileInfo.setFile(file);
            }
            this.toLog("checkFileInfo " + file + " exists=" + file.exists());
        }
    }

    public List<MessageInfo> findMessages(SessionInfo sessionInfo, Map prms) throws Exception {
        MessageInfo messageInfo;
        int i;
        List<MessageInfo> messages;
        List stored;
        MessageInfo firstMessage;
        Vector<MessageInfo> list = new Vector<MessageInfo>();
        String find = (String)prms.get("find");
        String orig = (String)prms.get("orig");
        Integer code = (Integer)prms.get("code");
        Integer type = (Integer)prms.get("type");
        Long since = (Long)prms.get("since");
        long time = System.currentTimeMillis();
        if (since == null) {
            since = time;
        }
        if ((firstMessage = sessionInfo.getFirstMessage()) != null) {
            time = Math.min(since, firstMessage.getTime());
        }
        if ((stored = this.loadSessionMessages(sessionInfo)) != null) {
            messages = new ArrayList<MessageInfo>();
            for (i = 0; i < stored.size() && (messageInfo = (MessageInfo)stored.get(i)).getTime() < time; ++i) {
                messages.add(messageInfo);
            }
            sessionInfo.addMessages(messages, false);
        }
        messages = sessionInfo.getMessages();
        for (i = 0; i < messages.size() && (messageInfo = messages.get(i)).getTime() < since; ++i) {
            if (find != null) {
                if (messageInfo.getContent().toLowerCase().contains(find.toLowerCase())) {
                    list.add(messageInfo);
                }
            } else if (type != null) {
                if (messageInfo.getType() == type.intValue()) {
                    list.add(messageInfo);
                }
            } else if (orig != null) {
                if (messageInfo.getSenderId().equals(orig)) {
                    list.add(messageInfo);
                }
            } else if (code != null && (messageInfo.getCode() & code) != 0) {
                list.add(messageInfo);
            }
            if (!(messageInfo instanceof FileInfo)) continue;
            this.checkFileInfo((FileInfo)messageInfo);
        }
        if (this.online && list.size() < 20) {
            if (!messages.isEmpty() && since > messages.get(0).getTime()) {
                since = messages.get(0).getTime();
            }
            prms.put("sessionid", sessionInfo.getSessionId());
            prms.put("since", since);
            prms.put("limit", this.messagesByRequest);
            List<Map> mess = this.getMessages(prms);
            for (int i2 = 0; i2 < mess.size(); ++i2) {
                MessageInfo message = this.getMessageInfo(mess.get(i2), sessionInfo);
                list.insertElementAt(message, 0);
            }
        }
        this.toLog("findMessages since=" + since + " list=" + list.size());
        return list;
    }

    public List findInChats(final String text, boolean ext) {
        if (text.length() < 2) {
            this.searhChatsResult = null;
            return new ArrayList();
        }
        if (this.searhChatsResult == null) {
            this.searhChatsResult = this.localSearchMessages(text);
            if (ext) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            List result = ServiceManager.this.serverSearchMessages(text);
                            if (result.size() > ServiceManager.this.searhChatsResult.size()) {
                                ServiceManager.this.searhChatsResult = result;
                                ServiceManager.this.client.searchUpdated();
                            }
                        }
                        catch (Exception e) {
                            ServiceManager.this.toLog(e);
                        }
                    }
                }.start();
            }
            return this.searhChatsResult;
        }
        String str = text.toLowerCase();
        ArrayList<SessionInfo> result = new ArrayList<SessionInfo>();
        for (SessionInfo sessionInfo : this.searhChatsResult) {
            String content;
            MessageInfo messageInfo = sessionInfo.getFirstMessage();
            if (messageInfo == null || !(content = messageInfo.getText().toLowerCase()).startsWith(str) && !content.contains(" " + str)) continue;
            result.add(sessionInfo);
        }
        return result;
    }

    protected List serverSearchMessages(String text) throws Exception {
        ArrayList<SessionInfo> result = new ArrayList<SessionInfo>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("text", text);
        List list = (List)this.sendCommand("searchMessages", params);
        for (int i = 0; i < list.size(); ++i) {
            SessionInfo sessionInfo;
            Map map = (Map)list.get(i);
            String sessionid = (String)map.get("sessionid");
            String content = (String)map.get("content");
            Long created = (Long)map.get("created");
            Integer type = (Integer)map.get("type");
            Integer status = (Integer)map.get("status");
            String name = (String)map.get("name");
            if (name == null && (sessionInfo = this.getSession(sessionid)) != null) {
                name = sessionInfo.toString();
            }
            if (name == null) continue;
            SessionInfo session = new SessionInfo();
            session.setSessionId(sessionid);
            session.setName(name);
            String id = (String)map.get("id");
            String orig = (String)map.get("orig");
            MessageInfo message = new MessageInfo(id, orig, content, type, status, created);
            message.setSessionId(sessionid);
            session.addMessage(message);
            result.add(session);
        }
        return result;
    }

    private List localSearchMessages(String text) {
        text = text.toLowerCase();
        ArrayList<SessionInfo> result = new ArrayList<SessionInfo>();
        Iterator itr = this.sessionsIterator();
        while (itr.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)itr.next();
            if (sessionInfo.getStatus() == 10) continue;
            for (MessageInfo messageInfo : sessionInfo.getMessages()) {
                String content;
                int type = messageInfo.getType();
                if (type != 1 && type != 20 || !(content = messageInfo.getText().toLowerCase()).startsWith(text) && !content.contains(" " + text)) continue;
                SessionInfo session = new SessionInfo();
                session.setSessionId(sessionInfo.getSessionId());
                session.setName(sessionInfo.toString());
                session.addMessage(messageInfo);
                messageInfo.setSessionId(sessionInfo.getSessionId());
                result.add(session);
            }
        }
        return result;
    }

    public List findInCalls(final String text, boolean ext) {
        if (text.length() < 2) {
            this.searhCallsResult = null;
            return new ArrayList();
        }
        if (this.searhCallsResult == null) {
            this.searhCallsResult = this.localSearchCalls(text);
            if (ext) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            List result = ServiceManager.this.serverSearchCalls(text);
                            if (result.size() > ServiceManager.this.searhCallsResult.size()) {
                                ServiceManager.this.searhCallsResult = result;
                                ServiceManager.this.client.searchUpdated();
                            }
                        }
                        catch (Exception e) {
                            ServiceManager.this.toLog(e);
                        }
                    }
                }.start();
            }
            return this.searhCallsResult;
        }
        String str = text.toLowerCase();
        boolean isnumber = true;
        try {
            Long.parseLong(text);
        }
        catch (Exception e) {
            isnumber = false;
        }
        ArrayList<SessionInfo> result = new ArrayList<SessionInfo>();
        for (SessionInfo sessionInfo : this.searhCallsResult) {
            MessageInfo messageInfo = sessionInfo.getFirstMessage();
            String content = messageInfo.getContent().toLowerCase();
            if (!(isnumber && content.contains(text) || !isnumber && content.contains(" " + str)) && !content.contains("\"" + str)) continue;
            result.add(sessionInfo);
        }
        return result;
    }

    protected List serverSearchCalls(String text) throws Exception {
        ArrayList<SessionInfo> result = new ArrayList<SessionInfo>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("text", text);
        List list = (List)this.sendCommand("searchCalls", params);
        for (int i = 0; i < list.size(); ++i) {
            SessionInfo sessionInfo;
            Map map = (Map)list.get(i);
            String sessionid = (String)map.get("sessionid");
            String content = (String)map.get("content");
            Long created = (Long)map.get("created");
            Integer status = (Integer)map.get("status");
            String messageid = (String)map.get("id");
            String name = (String)map.get("name");
            if (name == null && (sessionInfo = this.getSession(sessionid)) != null) {
                name = sessionInfo.toString();
            }
            if (name == null) continue;
            SessionInfo session = new SessionInfo();
            session.setSessionId(sessionid);
            session.setName(name);
            MessageInfo messageInfo = new MessageInfo(messageid, null, content, 8, status, created);
            messageInfo.setSessionId(sessionid);
            session.addMessage(messageInfo);
            result.add(session);
        }
        return result;
    }

    private List localSearchCalls(String text) {
        text = text.toLowerCase();
        ArrayList<SessionInfo> result = new ArrayList<SessionInfo>();
        Iterator itr = this.sessionsIterator();
        block0: while (itr.hasNext()) {
            SessionInfo sessionInfo = (SessionInfo)itr.next();
            if (sessionInfo.getStatus() == 10) continue;
            List<MessageInfo> messages = sessionInfo.getMessages();
            for (int i = messages.size() - 1; i >= 0; --i) {
                MessageInfo message = messages.get(i);
                if (message.getType() != 8) continue;
                String subject = message.getCallSubject();
                String comment = message.getCallComment();
                String number = message.getCallPartyNumber();
                if ((number == null || !number.contains(text)) && (subject == null || !subject.toLowerCase().startsWith(text) && !subject.toLowerCase().contains(" " + text)) && (comment == null || !comment.toLowerCase().startsWith(text) && !comment.toLowerCase().contains(" " + text))) continue;
                SessionInfo session = new SessionInfo();
                session.setSessionId(sessionInfo.getSessionId());
                session.setName(sessionInfo.toString());
                session.addMessage(message);
                result.add(session);
                continue block0;
            }
        }
        return result;
    }

    public List<FileInfo> getImages(SessionInfo sessionInfo) {
        MessageInfo messageInfo;
        int i;
        List<MessageInfo> messages;
        List stored;
        Vector<FileInfo> list = new Vector<FileInfo>();
        Long since = System.currentTimeMillis();
        MessageInfo firstMessage = sessionInfo.getFirstMessage();
        if (firstMessage != null) {
            since = firstMessage.getTime();
        }
        if ((stored = this.loadSessionMessages(sessionInfo)) != null) {
            messages = new ArrayList<MessageInfo>();
            for (i = 0; i < stored.size() && (messageInfo = (MessageInfo)stored.get(i)).getTime() < since; ++i) {
                messages.add(messageInfo);
            }
            sessionInfo.addMessages(messages, false);
        }
        messages = sessionInfo.getMessages();
        for (i = 0; i < messages.size(); ++i) {
            messageInfo = messages.get(i);
            if (!(messageInfo instanceof FileInfo) || !((FileInfo)messageInfo).isImage()) continue;
            FileInfo fileInfo = (FileInfo)messageInfo;
            this.checkFileInfo(fileInfo);
            list.add(fileInfo);
        }
        return list;
    }

    public void setAutoconnect(LineInfo lineInfo) {
        this.server.setAutoconnect(lineInfo.getName());
    }

    public String getTrunkName(String number, boolean singletrunk) {
        if (number == null || number.length() == 0) {
            return null;
        }
        List trunks = this.getTrunks();
        if (trunks.size() > (singletrunk ? 0 : 1)) {
            for (int i = 0; i < trunks.size(); ++i) {
                Map trunk = (Map)trunks.get(i);
                if (!number.equals(trunk.get("number")) && !number.equals(trunk.get("user"))) continue;
                return (String)trunk.get("name");
            }
        }
        return null;
    }

    public void logGSMCall(String number, int duration) {
        this.toLog("logGSMCall number=" + number + " t=" + duration);
        if (duration == -1) {
            if (this.lineEventListener instanceof CallKitAdapter) {
                ((CallKitAdapter)this.lineEventListener).setGSMCall(number);
            }
        } else {
            SessionInfo sessionInfo = this.getSessionByPhoneNumber(number, null);
            String from = (String)this.getProperty(GSM_NUMBER);
            if (from == null) {
                List<ContactInfo.Detail> details = this.myInfo.getUserDetails();
                for (int i = 0; i < details.size(); ++i) {
                    ContactInfo.Detail detail = details.get(i);
                    String label = detail.getLabel().toLowerCase();
                    if (label.contains("phone")) {
                        from = detail.toString();
                        continue;
                    }
                    if (!label.contains("mobile")) continue;
                    from = detail.toString();
                    break;
                }
            }
            if (from == null || from.length() == 0) {
                from = "GSM";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("called", number);
            map.put("caller", from);
            map.put("duration", duration);
            map.put("channel", "GSM");
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setContent(new JSONObject(map).toString(), 8);
            messageInfo.setStatus(6);
            this.sendMessage(messageInfo, sessionInfo);
        }
    }

    protected void setIncomingCall(Map params) {
        Line line;
        String phone;
        String number;
        String name;
        block10: {
            block11: {
                ContactInfo contactInfo;
                block12: {
                    String prefix;
                    name = (String)params.get("name");
                    number = (String)params.get("number");
                    if (number == null) {
                        if (this.lineEventListener instanceof CallKitAdapter) {
                            ((CallKitAdapter)this.lineEventListener).reportIncomingCall("unknown");
                        }
                        return;
                    }
                    phone = number;
                    if (name == null) {
                        name = phone;
                    }
                    if (this.numbers == null || number.length() <= 0) break block10;
                    contactInfo = this.numbers.get(number);
                    if (contactInfo == null && this.myInfo != null && (prefix = (String)this.myInfo.getProperty("branch")) != null) {
                        contactInfo = this.numbers.get(prefix + number);
                    }
                    if (contactInfo == null) break block11;
                    name = contactInfo.toString();
                    String ext = (String)contactInfo.getProperty("extension");
                    if (ext == null) {
                        ext = (String)contactInfo.getProperty("ext");
                    }
                    if (ext == null) break block12;
                    phone = ext;
                    break block10;
                }
                if (!number.equals(contactInfo.getUserID())) break block10;
                phone = name;
                break block10;
            }
            Iterator itr = this.sessionsIterator();
            while (itr.hasNext()) {
                SessionInfo session = (SessionInfo)itr.next();
                if (!number.equals(session.getDialogId())) continue;
                name = session.toString();
                break;
            }
        }
        if ((line = this.server.setIncomingCall(null, number, new HashMap())) != null) {
            LineInfo lineInfo = (LineInfo)line.getLinePane();
            lineInfo.setConnectedNumber(phone);
            lineInfo.setStateDescription(name);
            if (this.lineEventListener instanceof CallKitAdapter) {
                ((CallKitAdapter)this.lineEventListener).incomingCall(lineInfo);
            }
        } else if (this.lineEventListener instanceof CallKitAdapter) {
            ((CallKitAdapter)this.lineEventListener).reportIncomingCall(number);
        }
    }

    protected void setIncomingMessage(Map map) {
        String sessionid = (String)map.get("sessionid");
        SessionInfo sessionInfo = this.sessions.get(sessionid);
        if (sessionInfo != null) {
            map.put("status", 1);
            MessageInfo messageInfo = this.getMessageInfo(map, sessionInfo);
            sessionInfo.addMessage(messageInfo);
            this.client.messageReceived(messageInfo, sessionInfo);
            this.toLog("setIncomingMessage " + messageInfo + " sessionInfo=" + sessionInfo);
            try {
                Thread.sleep(1000L);
                this.sendDeliveryReport(sessionInfo, messageInfo);
            }
            catch (Exception e) {
                this.toLog(sessionInfo + " sendDeliveryReport: " + e.toString());
            }
        } else if (this.numbers == null) {
            this.pushmessage = map;
        }
    }

    private MessageInfo getMessageInfo(Map map, SessionInfo sessionInfo) {
        return this.getMessageInfo(map, sessionInfo, null, 0, null);
    }

    private MessageInfo getMessageInfo(Map map, SessionInfo sessionInfo, Map msgs, int mc, Map repliedMessages) {
        String replied;
        String subjid;
        String extid;
        List mentions;
        List dest;
        Number deliveryTime;
        Integer code;
        MessageInfo messageInfo;
        String orig;
        Integer status = (Integer)map.get("event");
        if (status == null) {
            status = (Integer)map.get("status");
        }
        long time = (Long)map.get("time");
        String id = (String)map.get("id");
        if (id == null) {
            id = (String)map.get("mid");
        }
        if ((orig = (String)map.get("orig")) == null) {
            orig = "";
        }
        int type = (Integer)map.get("type");
        String content = (String)map.get("content");
        switch (type) {
            case 5: {
                messageInfo = new EmailInfo(id, orig, content, type, status, time);
                Number length = (Number)map.get("length");
                if (length == null) break;
                ((FileInfo)messageInfo).setFileLength(length.longValue());
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 13: {
                FileInfo fileInfo = new FileInfo(id, orig, content, type, status, time);
                Number length = (Number)map.get("length");
                if (length != null) {
                    fileInfo.setFileLength(length.longValue());
                }
                messageInfo = fileInfo;
                break;
            }
            case 17: {
                messageInfo = new MenuInfo(id, orig, content, type, status, time);
                break;
            }
            case 20: {
                if (content.contains("\"content\":\"")) {
                    messageInfo = new FileInfo(id, orig, content, type, status, time);
                    break;
                }
            }
            default: {
                messageInfo = new MessageInfo(id, orig, content, type, status, time);
            }
        }
        messageInfo.setSessionId(sessionInfo.getSessionId());
        Integer lifetime = (Integer)map.get("lifetime");
        if (lifetime != null && lifetime > 0) {
            messageInfo.setLifetime(lifetime.intValue());
        }
        if ((code = (Integer)map.get("code")) != null) {
            messageInfo.setCode(code);
        }
        if ((deliveryTime = (Number)map.get("delivery")) != null) {
            messageInfo.setDeliveryTime(deliveryTime.longValue());
        }
        if ((dest = (List)map.get("dest")) != null) {
            messageInfo.setRecepients(dest);
        }
        if ((mentions = (List)map.get("mentions")) != null) {
            messageInfo.setMentions(mentions);
        }
        if (!(messageInfo instanceof FileInfo) || !orig.equals(this.getUserId()) && mc < 100) {
            this.checkUpdateContent(sessionInfo, messageInfo);
        }
        if (!orig.equals(this.getUserId()) && (extid = (String)map.get("extid")) != null) {
            messageInfo.setChannel(extid);
        }
        if ((subjid = (String)map.get("subjid")) != null) {
            messageInfo.setSubjectId(subjid);
        }
        if ((replied = (String)map.get("replied")) != null) {
            MessageInfo message = null;
            if (msgs != null) {
                message = (MessageInfo)msgs.get(replied);
            }
            if (message == null) {
                message = this.getMessageInfo(replied, sessionInfo);
            }
            if (message != null) {
                messageInfo.setRepliedMessage(message);
            } else if (repliedMessages != null) {
                ArrayList<MessageInfo> list = (ArrayList<MessageInfo>)repliedMessages.get(replied);
                if (list == null) {
                    list = new ArrayList<MessageInfo>();
                    repliedMessages.put(replied, list);
                }
                list.add(messageInfo);
            } else {
                this.loadRepliedMessage(messageInfo, replied, sessionInfo, mc == 0);
            }
        }
        return messageInfo;
    }

    private void loadRepliedMessage(final MessageInfo messageInfo, final String replied, final SessionInfo sessionInfo, final boolean notify) {
        new Thread(){

            @Override
            public void run() {
                try {
                    MessageInfo message = ServiceManager.this.getMessage(replied, sessionInfo);
                    messageInfo.setRepliedMessage(message);
                    if (message != null && notify) {
                        sessionInfo.notifyMessageUpdated(messageInfo);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    private void loadRepliedMessages(final Map map, final SessionInfo sessionInfo) {
        new Thread(){

            @Override
            public void run() {
                ArrayList<MessageInfo> messages = new ArrayList<MessageInfo>();
                for (String id : map.keySet()) {
                    try {
                        HashMap<String, String> smap = new HashMap<String, String>();
                        smap.put("id", id);
                        Map map2 = (Map)ServiceManager.this.sendCommand(ServiceManager.METHOD_GET_MESSAGE, smap);
                        MessageInfo message = ServiceManager.this.getMessageInfo(map2, sessionInfo, null, 1, null);
                        if (message == null) continue;
                        List list = (List)map2.get(id);
                        for (int i = 0; i < list.size(); ++i) {
                            ((MessageInfo)list.get(i)).setRepliedMessage(message);
                        }
                        messages.add(message);
                    }
                    catch (Exception exception) {}
                }
                if (!messages.isEmpty()) {
                    List<MessageInfo> tosave = sessionInfo.addMessages(messages, true);
                    if (sessionInfo.getStatus() != -6) {
                        ServiceManager.this.saveSessionMessages(sessionInfo, tosave);
                    }
                }
            }
        }.start();
    }

    protected void loadAvatar(ContactInfo contact) {
        String resource;
        if (contact.getImageTimestamp() <= 0L) {
            return;
        }
        File file = contact.getImageFile();
        if (file == null) {
            file = new File(this.client.getAvatarsDir(), contact.getImageId());
        }
        this.toLog(contact + " loadAvatar file=" + file.getName() + " ex=" + file.exists() + " len=" + file.length() + " mod=" + file.lastModified() + " ts=" + contact.getImageTimestamp() + " t=" + (Serializable)(contact.getImageFile() == null ? "" : Long.valueOf(contact.getImageFile().lastModified())) + " imageFile=" + contact.getImageFile() + " contact.isCustom()=" + contact.isCustom() + " id=" + contact.getGlobalId() + " online=" + this.online);
        if (file.exists() && file.lastModified() >= contact.getImageTimestamp()) {
            if (!file.equals(contact.getImageFile())) {
                contact.setImageFile(file);
            }
            return;
        }
        if (!this.online) {
            return;
        }
        if (contact.isUser() || contact.isChannel() || contact.isPhone()) {
            String userid = contact.getUserID();
            if (contact.isChannel()) {
                userid = userid.substring(7);
            }
            resource = "$AVATAR$?userid=" + userid;
        } else {
            if (contact.getGlobalId() == null) {
                return;
            }
            resource = this.getUserId() + "-" + contact.getGlobalId();
        }
        this.loadFile(resource, file, contact);
    }

    protected void loadAvatar(SessionInfo session) {
        if (this.online) {
            if (session.getImageTimestamp() > 0L) {
                File file = new File(this.client.getAvatarsDir(), session.getSessionId());
                if (file.exists() && file.length() > 0L && file.lastModified() >= session.getImageTimestamp()) {
                    session.setImageFile(file);
                } else if (session.getImageId() != null) {
                    this.loadFile(session.getImageId(), file, session);
                }
            } else if (!session.isGroup() && session.getParties().size() == 1) {
                this.loadAvatar(session.getParties().get(0));
            }
        } else {
            File file = new File(this.client.getAvatarsDir(), session.getSessionId());
            if (file.exists() && file.length() > 0L) {
                session.setImageFile(file);
            }
        }
    }

    private void checkAvatar(ContactInfo contactInfo) {
        File file = contactInfo.getImageFile();
        if (file != null && !file.exists() && (file = new File(this.client.getAvatarsDir(), file.getName())).exists()) {
            contactInfo.setImageFile(file);
        }
    }

    private void checkAvatar(SessionInfo sessionInfo) {
        File file = sessionInfo.getImageFile();
        if (file != null && !file.exists() && (file = new File(this.client.getAvatarsDir(), file.getName())).exists()) {
            sessionInfo.setImageFile(file);
        }
    }

    private void imageChanged(Map params) {
        String id = (String)params.get("userid");
        if (id != null) {
            ContactInfo contact;
            ContactInfo contactInfo = contact = id.equals(this.getUserId()) ? this.myInfo : this.findContactByUserId(id);
            if (contact != null) {
                contact.setImageTimestamp(this.getServerTime());
                this.loadAvatar(contact);
            }
        }
    }

    private void sessionUpdated(Map params) throws Exception {
        SessionInfo sessionInfo;
        String id = (String)params.get("id");
        if (id == null) {
            id = (String)params.get("sessionid");
        }
        if (id != null && (sessionInfo = this.getSession(id)) != null) {
            this.sessionUpdated(sessionInfo, params);
        }
    }

    private void sessionUpdated(SessionInfo sessionInfo, Map params) throws Exception {
        Map properties;
        Integer messagettl;
        Integer type;
        Integer status;
        List userids;
        List admins;
        String image;
        String subject;
        String description;
        String name = (String)params.get("name");
        if (name != null) {
            sessionInfo.setName(name);
        }
        if ((description = (String)params.get("description")) != null) {
            sessionInfo.setDescription(description);
        }
        if ((subject = (String)params.get("subject")) != null) {
            sessionInfo.setSubject(subject);
        }
        if ((image = (String)params.get("imgfile")) == null) {
            image = (String)params.get("image");
        }
        if (image != null) {
            File file = new File(this.client.getAvatarsDir(), sessionInfo.getSessionId());
            this.loadFile(image, file, sessionInfo);
            Long imgdate = (Long)params.get("imgdate");
            if (imgdate != null) {
                sessionInfo.setImageTimestamp(imgdate);
            }
        }
        if ((admins = (List)params.get("admins")) != null) {
            sessionInfo.setAdmins(admins);
            if (sessionInfo.getStatus() != 3) {
                if (sessionInfo.getAdmins().contains(this.getUserId())) {
                    sessionInfo.setStatus(1);
                } else {
                    sessionInfo.setStatus(2);
                }
            }
        }
        if ((userids = (List)params.get("parties")) != null) {
            ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>();
            for (int j = 0; j < userids.size(); ++j) {
                String userid = (String)userids.get(j);
                if (userid.equals(this.getUserId()) && (!sessionInfo.getParties().isEmpty() || parties.size() != 2 || j < parties.size() - 1)) continue;
                ContactInfo contact = this.findContactByUserId(userid);
                if (contact == null) {
                    contact = this.getContactInfo(new ContactInfo(userid));
                }
                parties.add(contact);
            }
            sessionInfo.setParties(parties);
        }
        if ((status = (Integer)params.get("status")) != null) {
            sessionInfo.setStatus(status);
        }
        if ((type = (Integer)params.get("type")) != null) {
            sessionInfo.setDialogType(type);
        }
        if ((messagettl = (Integer)params.get("messagettl")) != null) {
            sessionInfo.setMessageLifetime(messagettl);
        }
        if ((properties = (Map)params.get("properties")) != null) {
            sessionInfo.setProperties(properties);
        }
        this.client.sessionUpdated(sessionInfo);
        this.saveObjects();
        this.toLog(sessionInfo + "(" + sessionInfo.hashCode() + ") sessionUpdated params=" + params + " STATUS=" + sessionInfo.getStatus() + " parties=" + sessionInfo.getParties());
    }

    private void sessionDeleted(Map params) {
        this.sessionDeleted((String)params.get("id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionDeleted(String sessionid) {
        SessionInfo sessionInfo;
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            sessionInfo = this.sessions.remove(sessionid);
        }
        if (sessionInfo != null) {
            sessionInfo.removeAllMessages();
            new File(this.filedir, sessionid).delete();
            this.client.sessionDeleted(sessionInfo);
            this.saveObjects();
        }
    }

    protected Map getNewMessagesCount() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Iterator itr = this.sessionsIterator();
        while (itr.hasNext()) {
            int n;
            SessionInfo session = (SessionInfo)itr.next();
            int status = session.getStatus();
            if (status < -4 || status > 3) continue;
            if (session.isChannel()) {
                status = -6;
            }
            if ((n = session.getNewMessagesCount()) <= 0) continue;
            Integer c = (Integer)map.get(status);
            if (c == null) {
                c = 0;
            }
            map.put(status, c + n);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTotalNewMessagesCount() {
        int n = 0;
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            Iterator itr = this.sessionsIterator();
            while (itr.hasNext()) {
                SessionInfo session = (SessionInfo)itr.next();
                if (session.getStatus() >= 4) continue;
                n += session.getNewMessagesCount();
            }
        }
        return n;
    }

    protected Cipher getCipher(File file) throws Exception {
        Cipher cipher = null;
        String alg = (String)this.localProperties.get(ENCRYPT_DATA);
        if (alg != null) {
            File dir = file.getParentFile();
            cipher = this.getCipher(1, alg);
        }
        return cipher;
    }

    protected File getFile(FileInfo fileInfo) throws Exception {
        File f;
        File file = fileInfo.getFile();
        if (file == null || !file.exists() || file.length() == 0L) {
            return file;
        }
        if (fileInfo.isThumbnail() && (f = new File(this.client.getFileDir(fileInfo), fileInfo.getFilename())).exists() && f.length() > 0L) {
            fileInfo.setFile(f);
            file = f;
        }
        if (Boolean.TRUE.equals(fileInfo.getProperty("file-encrypted"))) {
            File tmp = this.tmpFiles.get(file.getPath());
            if (tmp != null && tmp.exists() && tmp.length() > 0L) {
                return tmp;
            }
            tmp = this.decrypt(file, (String)this.localProperties.get(ENCRYPT_DATA));
            this.tmpFiles.put(file.getPath(), tmp);
            if (file.getName().toLowerCase().endsWith(".wav")) {
                try {
                    fileInfo.setMediaDuration(AudioConverter.getMediaDuration(tmp));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            file = tmp;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getAvatar(ContactInfo contact) {
        ContactInfo contactInfo = contact;
        synchronized (contactInfo) {
            File file = this.getAvatar(contact.getImageFile());
            if (file == null && contact.hasAvatar()) {
                contact.getImageFile().delete();
                contact.setImageFile(null);
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getAvatar(SessionInfo session) {
        SessionInfo sessionInfo = session;
        synchronized (sessionInfo) {
            File file = this.getAvatar(session.getImageFile());
            if (file == null && session.hasAvatar()) {
                session.getImageFile().delete();
                session.setImageFile(null);
            }
            return file;
        }
    }

    public File getAvatar(File file) {
        String alg = (String)this.localProperties.get(ENCRYPT_DATA);
        if (file != null && alg != null) {
            File tmp = this.tmpFiles.get(file.getPath());
            if (tmp != null && tmp.exists() && tmp.length() > 0L) {
                return tmp;
            }
            try {
                tmp = this.decrypt(file, alg);
                this.tmpFiles.put(file.getPath(), tmp);
                file = tmp;
            }
            catch (Exception e) {
                this.toLog("getAvatar - " + e);
                return null;
            }
        }
        return file;
    }

    private File decrypt(File file, String alg) throws Exception {
        int readBytes;
        long t = System.currentTimeMillis();
        Cipher cipher = this.getCipher(2, alg);
        File tmp = new File(this.client.getTempDir(), file.getName());
        FileOutputStream fos = new FileOutputStream(tmp);
        CipherInputStream is = new CipherInputStream(new FileInputStream(file), cipher);
        byte[] buffer = new byte[1024];
        while ((readBytes = ((InputStream)is).read(buffer)) != -1) {
            fos.write(buffer, 0, readBytes);
        }
        ((InputStream)is).close();
        fos.close();
        long dt = System.currentTimeMillis() - t;
        if (dt > 25L) {
            this.toLog("decrypt " + file.getName() + " len=" + file.length() + " out=" + tmp.length() + " t=" + dt);
        }
        return tmp;
    }

    public boolean isLoading(File file) {
        return this.fileLoader.isLoading(file);
    }

    private File createNewFile(String name) {
        File file;
        Object p = "";
        do {
            file = new File(this.client.getCacheDir(), (String)p + name);
            p = (String)p + "_";
        } while (file.exists() || this.fileLoader.isLoading(file));
        return file;
    }

    protected void loadFile(FileInfo fileInfo) {
        this.loadFile(fileInfo, fileInfo.getFilename());
    }

    protected void loadFile(FileInfo fileInfo, String filename) {
        File file = this.createNewFile(filename);
        String resource = file instanceof CloudFile ? ((CloudFile)file).getResourceName() : fileInfo.getFilename();
        this.loadFile(resource, file, fileInfo);
    }

    protected void loadFile(String resource, File file, Object listener) {
        this.fileLoader.load(resource, file, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileLoaded(FileInfo fileInfo) {
        this.tmpFiles.remove(fileInfo.getFile().getPath());
        SessionInfo session = null;
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            for (SessionInfo sessionInfo : this.sessions.values()) {
                if (!sessionInfo.containsMessage(fileInfo)) continue;
                session = sessionInfo;
                break;
            }
        }
        if (session != null) {
            this.saveSessionMessage(session, fileInfo);
        }
        this.client.fileLoaded(fileInfo);
    }

    protected void avatarLoaded(ContactInfo contactInfo, File file) {
        this.clearAvacache(file);
        if (file.exists() && file.length() > 0L) {
            contactInfo.setImageFile(file);
            contactInfo.setImageTimestamp(this.getServerTime());
        } else {
            contactInfo.setImageFile(null);
            contactInfo.setImageTimestamp(0L);
        }
        this.client.contactImageChanged(contactInfo);
    }

    protected void avatarLoaded(SessionInfo sessionInfo, File file) {
        this.clearAvacache(file);
        if (file.exists() && file.length() > 0L) {
            sessionInfo.setImageFile(file);
            sessionInfo.setImageTimestamp(this.getServerTime());
        } else {
            sessionInfo.setImageFile(null);
            sessionInfo.setImageTimestamp(0L);
        }
        this.client.sessionUpdated(sessionInfo);
    }

    private void clearAvacache(File file) {
        this.toLog("clearAvacache " + file + " exists=" + file.exists());
        this.tmpFiles.remove(file.getPath());
        String filename = file.getName();
        File[] files = file.getParentFile().listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (!f.getName().startsWith(filename) || f.getName().length() <= filename.length()) continue;
            boolean b = f.delete();
            this.toLog("clearAvacache file=" + f + " del=" + b);
        }
    }

    protected void setAvatar(ContactInfo contact, File file) throws Exception {
        if (file == null) {
            if (contact.hasAvatar()) {
                contact.getImageFile().delete();
            }
            contact.setImageFile(null);
            return;
        }
        File outfile = new File(this.client.getAvatarsDir(), contact.getImageId());
        String alg = (String)this.localProperties.get(ENCRYPT_DATA);
        if (!outfile.equals(file) || alg != null) {
            this.saveFile(file, outfile, alg);
        }
        contact.setImageFile(outfile);
    }

    protected void setAvatar(SessionInfo session, File file) throws Exception {
        if (file == null) {
            if (session.hasAvatar()) {
                session.getImageFile().delete();
            }
            session.setImageFile(null);
            return;
        }
        File outfile = new File(this.client.getAvatarsDir(), file.getName());
        String alg = (String)this.localProperties.get(ENCRYPT_DATA);
        if (!outfile.equals(file) || alg != null) {
            this.saveFile(file, outfile, alg);
        }
        session.setImageFile(outfile);
    }

    private void saveFile(File file, File outfile, String alg) throws Exception {
        int n;
        long length;
        byte[] b;
        FileInputStream is;
        OutputStream out;
        File tmp = null;
        if (file.equals(outfile)) {
            tmp = new File(this.client.getCacheDir(), System.currentTimeMillis() + ".tmp");
            if (!file.renameTo(tmp)) {
                this.toLog("Could not rename " + file + " to " + tmp);
                out = new FileOutputStream(tmp);
                is = new FileInputStream(file);
                b = new byte[4096];
                length = file.length();
                while ((n = ((InputStream)is).read(b, 0, (int)Math.min(length, (long)b.length))) != -1) {
                    out.write(b, 0, n);
                    if ((length -= (long)n) > 0L) continue;
                }
                ((InputStream)is).close();
                out.close();
            }
            file = tmp;
        }
        out = new FileOutputStream(outfile);
        if (alg != null) {
            out = new CipherOutputStream(out, this.getCipher(1, alg));
        }
        is = new FileInputStream(file);
        b = new byte[4096];
        length = file.length();
        while ((n = ((InputStream)is).read(b, 0, (int)Math.min(length, (long)b.length))) != -1) {
            out.write(b, 0, n);
            if ((length -= (long)n) > 0L) continue;
        }
        ((InputStream)is).close();
        out.close();
        if (tmp != null) {
            tmp.delete();
        }
        this.tmpFiles.remove(outfile.getPath());
        this.toLog("saveFile " + file + " len=" + file.length() + " to " + outfile + " len=" + outfile.length());
    }

    private void processEvents(Map map) throws Exception {
        Long serverTime;
        Integer state;
        List list = (List)map.get("states");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.setContactState((Map)list.get(i));
            }
        }
        if ((list = (List)map.get("contacts")) != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                this.contactChanged((Map)itr.next(), true);
            }
        }
        if ((list = (List)map.get("sessions")) != null) {
            for (Map params : list) {
                SessionInfo session = this.sessions.get(params.get("id"));
                Integer status = (Integer)params.get("status");
                if (status != null && status == 10) {
                    this.sessionDeleted(params);
                    continue;
                }
                if (session != null) {
                    this.sessionUpdated(session, params);
                    continue;
                }
                this.createNewSession(params);
            }
        }
        if ((list = (List)map.get("messages")) != null) {
            this.processMessages(list, true);
        }
        if ((list = (List)map.get("confs")) != null) {
            this.setConferenceStates(list);
        }
        if ((list = (List)map.get("trunks")) != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                this.trunkState((Map)itr.next());
            }
        }
        if ((list = (List)map.get("devices")) != null) {
            this.myInfo.setProperty("devices", list);
        }
        if ((state = (Integer)map.get("state")) != null) {
            this.stateChanged(state);
        }
        if ((list = (List)map.get("contactgroups")) != null) {
            this.initContactGroups(list);
        }
        if ((serverTime = (Long)map.get("systime")) != null) {
            this.deltaTime = System.currentTimeMillis() - serverTime;
            this.localProperties.put("deltaTime", this.deltaTime);
            this.saveProperties();
        }
    }

    private void setConferenceStates(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            String id = (String)m.get("id");
            SessionInfo session = this.sessions.get(id);
            if (session == null) {
                session = this.findSessionByDialogId(id);
            }
            this.toLog("setConferenceStates id=" + id + " session=" + session + " params=" + m);
            if (session == null) continue;
            session.setConferenceState(m);
        }
    }

    private void processMessages(List list, boolean b) {
        SessionInfo sessionInfo;
        boolean t = false;
        HashMap<SessionInfo, Vector<MessageInfo>> sessionsMap = new HashMap<SessionInfo, Vector<MessageInfo>>();
        HashMap<String, MessageInfo> msgs = new HashMap<String, MessageInfo>();
        for (int i = 0; i < list.size(); ++i) {
            Map mmap = (Map)list.get(i);
            sessionInfo = this.getSession((String)mmap.get("sessionid"));
            if (sessionInfo == null || sessionInfo.getStatus() == 5) continue;
            MessageInfo messageInfo = this.getMessageInfo(mmap, sessionInfo, msgs, list.size(), null);
            Vector<MessageInfo> messages = (Vector<MessageInfo>)sessionsMap.get(sessionInfo);
            if (messages == null) {
                messages = new Vector<MessageInfo>();
                sessionsMap.put(sessionInfo, messages);
            }
            messages.add(messageInfo);
            msgs.put(messageInfo.getId(), messageInfo);
            if (t || messageInfo.getCode() != 0x100000) continue;
            t = true;
        }
        Iterator itr = sessionsMap.keySet().iterator();
        while (itr.hasNext()) {
            Vector<MessageInfo> delivered = new Vector<MessageInfo>();
            sessionInfo = (SessionInfo)itr.next();
            List messages = (List)sessionsMap.get(sessionInfo);
            boolean read = false;
            List<MessageInfo> newmess = sessionInfo.addMessages(messages, b);
            for (int i = 0; i < newmess.size(); ++i) {
                MessageInfo messageInfo = newmess.get(i);
                if (messageInfo.getStatus() == 1) {
                    this.client.messageReceived(messageInfo, sessionInfo);
                    if (messageInfo.getType() == 16 || messageInfo.getType() == 18) {
                        messageInfo.setStatus(2);
                    }
                    delivered.add(messageInfo);
                    continue;
                }
                if (messageInfo.getStatus() == 2) {
                    read = true;
                    continue;
                }
                if (messageInfo.getType() != 8) continue;
                if (b && messageInfo.getStatus() == 5 && messageInfo.getContent().contains("\"duration\":0") && !messageInfo.getContent().contains("\"cause\":26")) {
                    messageInfo.setStatus(12);
                }
                if (messageInfo.getStatus() != 12) continue;
                this.client.messageReceived(messageInfo, sessionInfo);
            }
            if (!delivered.isEmpty()) {
                try {
                    this.sendDeliveryReport(sessionInfo, delivered);
                }
                catch (Exception e) {
                    this.toLog(sessionInfo + " sendDeliveryReport: " + e.toString());
                }
            }
            if (read) {
                try {
                    this.sendRead(sessionInfo.getSessionId());
                }
                catch (Exception e) {
                    this.toLog(sessionInfo + " sendRead: " + e.toString());
                }
            }
            this.client.sessionUpdated(sessionInfo);
            this.saveSessionMessages(sessionInfo, messages);
        }
        if (t) {
            try {
                this.getSIPAccounts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processMessage(Map map) {
        SessionInfo sessionInfo = this.getSession((String)map.get("sessionid"));
        if (sessionInfo != null && sessionInfo.getStatus() != 5) {
            MessageInfo messageInfo = this.getMessageInfo(map, sessionInfo);
            if (messageInfo.getStatus() == 5 && messageInfo.getContent().contains("\"duration\":0") && !messageInfo.getContent().contains("\"cause\":26")) {
                messageInfo.setStatus(12);
            }
            if (sessionInfo.addMessage(messageInfo)) {
                int status = messageInfo.getStatus();
                if (status == 1) {
                    this.client.messageReceived(messageInfo, sessionInfo);
                    if (messageInfo.getType() == 16 || messageInfo.getType() == 18) {
                        messageInfo.setStatus(2);
                    }
                    if (messageInfo.getType() != 8 && messageInfo.getType() != 5 && this.online && messageInfo.getStatus() == 1) {
                        try {
                            this.sendDeliveryReport(sessionInfo, messageInfo);
                        }
                        catch (Exception e) {
                            this.toLog(sessionInfo + " sendDeliveryReport: " + e.toString());
                        }
                    }
                    if (messageInfo.getCode() == 0x100000) {
                        try {
                            this.getSIPAccounts();
                        }
                        catch (Exception exception) {}
                    }
                } else if (messageInfo.getType() == 8) {
                    this.client.messageReceived(messageInfo, sessionInfo);
                    if (status == 12) {
                        // empty if block
                    }
                } else if (messageInfo.getType() == 18 && messageInfo.getContent().contains("#yourphoto$")) {
                    this.client.messageReceived(messageInfo, sessionInfo);
                }
                this.saveSessionMessage(sessionInfo, messageInfo);
                this.saveObjects();
            } else {
                MessageInfo updatedMessage = sessionInfo.getMessage(messageInfo.getId());
                if (updatedMessage != null) {
                    this.saveSessionMessage(sessionInfo, updatedMessage);
                }
            }
        }
    }

    protected void loadCallRecord(MessageInfo messageInfo) {
        Activity activity = messageInfo.getActivity();
        String filename = activity.getFile();
        if (filename == null) {
            return;
        }
        int n = filename.lastIndexOf("/");
        if (n != -1) {
            filename = filename.substring(n + 1);
        }
        final File file = new File(this.client.getAudioDir(), filename);
        final String resource = "records/" + filename;
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                ServiceManager.this.loadFile(resource, file, new FileInfo());
            }
        };
        Utils.getTimer().schedule(task, 3000L);
    }

    protected void setMessage(Map map) {
        SessionInfo sessionInfo = this.getSession((String)map.get("sessionid"));
        if (sessionInfo != null && sessionInfo.getStatus() != 5) {
            MessageInfo messageInfo = this.getMessageInfo(map, sessionInfo);
            sessionInfo.addMessage(messageInfo);
            this.saveSessionMessage(sessionInfo, messageInfo);
        }
    }

    private void processCommand(Map map) {
        SessionInfo sessionInfo = new SessionInfo();
        MessageInfo messageInfo = this.getMessageInfo(map, sessionInfo);
        this.client.messageReceived(messageInfo, sessionInfo);
    }

    private void checkUpdateContent(SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (messageInfo instanceof FileInfo) {
            this.checkNeedLoadFile((FileInfo)messageInfo, sessionInfo);
        } else if (messageInfo.getType() != 10) {
            if (messageInfo.getType() == 4) {
                Object content = "";
                String[] parties = messageInfo.getContent().split(",");
                for (int i = 0; i < parties.length; ++i) {
                    if (parties[i].equals(this.getUserId())) {
                        sessionInfo.setStatus(4);
                        content = this.myInfo.getName();
                        this.client.sessionUpdated(sessionInfo);
                        break;
                    }
                    if (parties[i].equals(messageInfo.getSenderId())) {
                        sessionInfo.removeParty(parties[i]);
                        content = "";
                        break;
                    }
                    ContactInfo contactInfo = sessionInfo.removeParty(parties[i]);
                    if (contactInfo == null) {
                        contactInfo = this.findContact(parties[i]);
                    }
                    if (((String)content).length() > 0) {
                        content = (String)content + ", ";
                    }
                    content = (String)content + contactInfo.toString();
                }
                messageInfo.setContent((String)content, 4);
            } else if (messageInfo.getType() == 3) {
                Object content = "";
                String[] parties = messageInfo.getContent().split(",");
                for (int i = 0; i < parties.length; ++i) {
                    if (parties[i].equals(this.getUserId())) {
                        content = this.myInfo.getName();
                        break;
                    }
                    ContactInfo contactInfo = this.findContact(parties[i]);
                    sessionInfo.addParty(contactInfo);
                    if (((String)content).length() > 0) {
                        content = (String)content + ", ";
                    }
                    content = (String)content + contactInfo.toString();
                }
                messageInfo.setContent((String)content, 3);
            } else if (messageInfo.getType() == 12) {
                String message = messageInfo.getContent();
                int n = message.indexOf("added:") + 6;
                int m = message.indexOf(" removed:");
                String[] parties = message.substring(m + 9).split(",");
                Object removed = "";
                for (int i = 0; i < parties.length; ++i) {
                    if (parties[i].equals(this.getUserId())) {
                        messageInfo.setContent(this.myInfo.getName(), 4);
                        return;
                    }
                    ContactInfo contactInfo = sessionInfo.removeParty(parties[i]);
                    if (contactInfo == null) {
                        contactInfo = this.findContact(parties[i]);
                    }
                    if (((String)removed).length() > 0) {
                        removed = (String)removed + ",";
                    }
                    removed = (String)removed + contactInfo.toString();
                }
                parties = message.substring(n, m).split(",");
                Object added = "";
                for (int i = 0; i < parties.length; ++i) {
                    if (parties[i].equals(this.getUserId())) {
                        messageInfo.setContent(this.myInfo.getName(), 3);
                        return;
                    }
                    ContactInfo contactInfo = this.findContact(parties[i]);
                    sessionInfo.addParty(contactInfo);
                    if (((String)added).length() > 0) {
                        added = (String)added + ",";
                    }
                    added = (String)added + contactInfo.toString();
                }
                messageInfo.setContent("added:" + (String)added + " removed:" + (String)removed, 12);
            }
        }
    }

    private void checkNeedLoadFile(FileInfo fileInfo, SessionInfo sessionInfo) {
        Boolean b;
        if (!this.online || fileInfo.isLoaded() || fileInfo.getStatus() != 1 || this.hasActiveCalls()) {
            return;
        }
        String filename = fileInfo.getFilename();
        if (filename == null) {
            return;
        }
        int n = filename.lastIndexOf(46);
        if (n == -1) {
            return;
        }
        if (fileInfo.isSound()) {
            if (sessionInfo.isAutoPlayback()) {
                fileInfo.addTransfrerListener(new FileTransferListener(){

                    @Override
                    public void transferStarted(FileInfo fileInfo) {
                    }

                    @Override
                    public void transferProgress(FileInfo fileInfo) {
                    }

                    @Override
                    public void transferEnded(FileInfo fileInfo) {
                        if (fileInfo.isLoaded()) {
                            try {
                                ServiceManager.this.server.playFile(fileInfo.getFile());
                            }
                            catch (Exception e) {
                                ServiceManager.this.toLog("backplayFile: " + e);
                            }
                        }
                    }
                });
            }
            fileInfo.setLoading(true);
            this.loadFile(fileInfo);
        } else if (fileInfo.isImage() && ((b = (Boolean)this.localProperties.get(PREVIEW)) == null || b.booleanValue())) {
            fileInfo.setLoading(true);
            this.loadFile(fileInfo, filename + ".jpg");
        }
    }

    private void messageRead(Map map) {
        String sessionid = (String)map.get("sessionid");
        SessionInfo session2 = this.sessions.get(sessionid);
        if (session2 != null) {
            List messages = session2.messageRead(map);
            if (!messages.isEmpty()) {
                this.saveSessionMessages(session2, messages);
                this.client.sessionUpdated(session2);
            }
        } else {
            for (SessionInfo session2 : this.sessions.values()) {
                List messages = session2.messageRead(map);
                if (messages.isEmpty()) continue;
                this.saveSessionMessages(session2, messages);
                this.client.sessionUpdated(session2);
            }
        }
    }

    private void messageDelivered(Map map) {
        for (SessionInfo session : this.sessions.values()) {
            Object object = session.messageDelivered(map);
            if (object instanceof MessageInfo) {
                this.saveSessionMessage(session, (MessageInfo)object);
                break;
            }
            if (!(object instanceof List) || ((List)object).isEmpty()) continue;
            this.saveSessionMessages(session, (List)object);
            break;
        }
    }

    private void messageUpdated(Map map) {
        block13: {
            SessionInfo session;
            MessageInfo messageInfo;
            Object mid;
            block11: {
                block12: {
                    mid = map.get("id");
                    messageInfo = null;
                    session = null;
                    String sessionid = (String)map.get("sessionid");
                    if (sessionid != null) {
                        session = this.sessions.get(sessionid);
                    }
                    if (session == null) break block11;
                    if (!(mid instanceof List)) break block12;
                    List messages = session.messageUpdated(map, (List)mid);
                    if (messages.size() <= 0) break block13;
                    for (int i = 0; i < messages.size(); ++i) {
                        MessageInfo message = (MessageInfo)messages.get(i);
                        if ((message.getCode() & 0x20) != 0 || message.getCode() == 128) {
                            this.client.messageQueueUpdated(message);
                            continue;
                        }
                        this.client.messageUpdated(message, session);
                    }
                    this.saveSessionMessages(session, messages);
                    break block13;
                }
                messageInfo = session.messageUpdated(map, (String)mid);
                if (messageInfo == null) break block13;
                if ((messageInfo.getCode() & 0x20) != 0 || messageInfo.getCode() == 128) {
                    this.client.messageQueueUpdated(messageInfo);
                } else {
                    this.client.messageUpdated(messageInfo, session);
                }
                this.saveSessionMessage(session, messageInfo);
                break block13;
            }
            Iterator it = this.sessionsIterator();
            while (it.hasNext()) {
                session = (SessionInfo)it.next();
                if (mid instanceof List) {
                    List messages = session.messageUpdated(map, (List)mid);
                    if (messages.size() <= 0) continue;
                    for (int i = 0; i < messages.size(); ++i) {
                        MessageInfo message = (MessageInfo)messages.get(i);
                        if ((message.getCode() & 0x20) != 0 || message.getCode() == 128) {
                            this.client.messageQueueUpdated(message);
                            continue;
                        }
                        this.client.messageUpdated(message, session);
                    }
                    this.saveSessionMessages(session, messages);
                    return;
                }
                messageInfo = session.messageUpdated(map, (String)mid);
                if (messageInfo == null) continue;
                if ((messageInfo.getCode() & 0x20) != 0 || messageInfo.getCode() == 128) {
                    this.client.messageQueueUpdated(messageInfo);
                } else {
                    this.client.messageUpdated(messageInfo, session);
                }
                this.saveSessionMessage(session, messageInfo);
                break;
            }
        }
    }

    private void messageDeleted(Map map) {
        Object obj = map.get("id");
        if (obj instanceof String) {
            String messageid = (String)obj;
            Iterator it = this.sessionsIterator();
            while (it.hasNext()) {
                SessionInfo session = (SessionInfo)it.next();
                MessageInfo messageInfo = session.removeMessage(messageid);
                if (messageInfo == null) continue;
                if ((messageInfo.getCode() & 0x20) != 0) {
                    this.client.messageQueueUpdated(messageInfo);
                }
                this.removeSessionMessage(session, messageInfo);
                this.client.messageDeleted(messageInfo, session);
                break;
            }
        } else if (obj instanceof List) {
            List list = (List)obj;
            Iterator it = this.sessionsIterator();
            while (it.hasNext()) {
                SessionInfo session = (SessionInfo)it.next();
                ArrayList<MessageInfo> removed = new ArrayList<MessageInfo>();
                for (int i = list.size() - 1; i >= 0; --i) {
                    MessageInfo messageInfo = session.removeMessage((String)list.get(i));
                    if (messageInfo == null) continue;
                    removed.add(messageInfo);
                    list.remove(i);
                    if ((messageInfo.getCode() & 0x20) != 0) {
                        this.client.messageQueueUpdated(messageInfo);
                    }
                    this.client.messageDeleted(messageInfo, session);
                }
                this.removeSessionMessages(session, removed);
            }
        } else {
            String sessionid = (String)map.get("sessionid");
            if (sessionid != null) {
                SessionInfo session = this.sessions.get(sessionid);
                if (session != null) {
                    session.removeAllMessages();
                }
                new File(this.filedir, sessionid).delete();
            } else {
                this.removeAllMessages();
            }
        }
    }

    private void messageTyped(Map map) {
        String userid = (String)map.get("userid");
        String sessionid = (String)map.get("sessionid");
        SessionInfo session = this.sessions.get(sessionid);
        if (session != null) {
            Boolean state = (Boolean)map.get("typing");
            if (state == null) {
                state = true;
            }
            session.messageTyped(userid, state);
        }
    }

    private void processState(Map map) {
        this.toLog("processState: " + map);
        String user = (String)map.get("userid");
        String tid = (String)map.get("termid");
        if (user != null && user.equals(this.getUserId())) {
            Integer state = (Integer)map.get("state");
            if (state == null) {
                return;
            }
            if (tid == null) {
                this.myStateChanged(map);
            } else {
                Integer prevstate = 0;
                if (!tid.equals(this.client.getTerminalId()) && this.myInfo != null) {
                    boolean exists = false;
                    List devices = (List)this.myInfo.getProperty("devices");
                    for (int i = 0; i < devices.size(); ++i) {
                        Map device = (Map)devices.get(i);
                        if (!tid.equals(device.get("id"))) continue;
                        prevstate = (Integer)device.get("state");
                        device.put("state", state);
                        device.put("ua", map.get("devinfo"));
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        HashMap<String, Object> device = new HashMap<String, Object>();
                        device.put("id", tid);
                        device.put("ua", map.get("devinfo"));
                        device.put("state", state);
                        devices.add(device);
                    }
                }
                if (tid.equals(this.getUserId()) && (state == 0 || state == 1 && prevstate == 0)) {
                    this.client.assistantStateChanged(state, (String)map.get("devinfo"));
                }
                if (state == 8) {
                    this.myStateChanged(map);
                }
            }
        } else if (user == null && tid != null && tid.equals(this.client.getTerminalId())) {
            this.myStateChanged(map);
        } else {
            this.setContactState(map);
        }
    }

    public void stateChanged(int state) {
        this.client.stateChanged(state);
        if (this.myInfo != null) {
            this.myInfo.setState(state);
        }
    }

    protected void myStateChanged(Map map) {
        Integer state = (Integer)map.get("state");
        if (state <= 5) {
            this.stateChanged(state);
            String note = (String)map.get("note");
            if (note != null && this.myInfo != null) {
                this.myInfo.setNote(note);
            }
        } else {
            this.client.stateChanged(state);
            if (this.myInfo != null) {
                this.myInfo.setState(state);
            }
        }
    }

    protected String getConnectedDeviceInfo() {
        if (this.myInfo == null) {
            return null;
        }
        List devices = (List)this.myInfo.getProperty("devices");
        if (devices != null) {
            for (int i = 0; i < devices.size(); ++i) {
                Integer state;
                Map device = (Map)devices.get(i);
                if (this.client.getTerminalId().equals(device.get("id")) || (state = (Integer)device.get("state")) != 8) continue;
                return (String)device.get("ua");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo createNewSession(Map params) throws Exception {
        SessionInfo session = this.createSession(params);
        Map<String, SessionInfo> map = this.sessions;
        synchronized (map) {
            this.sessions.put(session.getSessionId(), session);
        }
        this.client.sessionCreated(session);
        if (session.isPublic()) {
            this.loadPreviousMessages(session, 0L);
        }
        return session;
    }

    private SessionInfo createSession(Map map) throws Exception {
        Integer mc;
        Integer nm;
        Integer tm;
        Integer messagettl;
        Long imgdate;
        List admins;
        Long time;
        String subject;
        String description;
        String createdby;
        Number created;
        Object object;
        List parties;
        Integer type;
        SessionInfo sessionInfo = new SessionInfo();
        String sessionId = (String)map.get("id");
        sessionInfo.setSessionId(sessionId);
        String dialogid = (String)map.get("dialogid");
        sessionInfo.setDialogId(dialogid);
        Integer status = (Integer)map.get("status");
        if (status != null) {
            sessionInfo.setStatus(status);
        }
        if ((type = (Integer)map.get("type")) != null) {
            sessionInfo.setDialogType(type);
        }
        if ((parties = (List)map.get("parties")) != null && !parties.isEmpty()) {
            for (int j = 0; j < parties.size(); ++j) {
                ContactInfo contactInfo;
                String number;
                String uid = (String)parties.get(j);
                if (uid.equals(this.getUserId()) && (!sessionInfo.getParties().isEmpty() || parties.size() > 2 || j < parties.size() - 1)) continue;
                ContactInfo contact = this.findContactByUserId(uid);
                if (contact == null) {
                    contact = this.getContactInfo(new ContactInfo(uid));
                }
                if (!contact.isUser() && contact.getStatus() == 0 && "".equals(contact.getName()) && (number = contact.getPrimaryPhoneNumber()) != null && (contactInfo = this.client.findContact(number)) != null) {
                    contact.setName(contactInfo.getName());
                    this.updateContact(contact);
                }
                sessionInfo.addParty(contact);
            }
        }
        if ((object = map.get("properties")) != null) {
            sessionInfo.setProperties((Map)object);
        }
        if ((created = (Number)map.get("created")) != null) {
            sessionInfo.setCreated(created.longValue());
        }
        if ((createdby = (String)map.get("createdby")) != null) {
            sessionInfo.setCreatedBy(createdby);
        }
        if ((description = (String)map.get("description")) != null) {
            sessionInfo.setDescription(description);
        }
        if ((subject = (String)map.get("subject")) != null) {
            sessionInfo.setSubject(subject);
        }
        if ((time = (Long)map.get("updated")) != null) {
            sessionInfo.setLastUpdated(time);
        } else if (created != null) {
            sessionInfo.setLastUpdated(created.longValue());
        }
        String name = (String)map.get("name");
        if (name != null && name.length() > 0) {
            sessionInfo.setName(name);
        }
        if ((admins = (List)map.get("admins")) != null) {
            sessionInfo.setAdmins(admins);
        }
        if ((object = map.get("top")) != null) {
            sessionInfo.addMessage(this.getMessageInfo((Map)object, sessionInfo));
        }
        if ((imgdate = (Long)map.get("imgdate")) == null) {
            imgdate = 0L;
        }
        sessionInfo.setImageTimestamp(imgdate);
        String imgfile = (String)map.get("imgfile");
        if (imgfile != null && imgfile.length() > 0) {
            sessionInfo.setImageId(imgfile);
            File file = new File(this.client.getAvatarsDir(), sessionId);
            this.loadFile(imgfile, file, sessionInfo);
        }
        if ((messagettl = (Integer)map.get("messagettl")) != null) {
            sessionInfo.setMessageLifetime(messagettl);
        }
        if ((tm = (Integer)map.get("tm")) != null) {
            sessionInfo.setMessagesCount(tm);
        }
        if ((nm = (Integer)map.get("nm")) != null) {
            sessionInfo.setNewMessagesCount(nm);
        }
        if ((mc = (Integer)map.get("mc")) != null) {
            sessionInfo.setMissesCallsCount(mc);
        }
        return sessionInfo;
    }

    private ContactInfo setContactState(Map map) {
        Number imgdate;
        ContactInfo contactInfo = null;
        String userid = (String)map.get("userid");
        if (userid == null) {
            userid = (String)map.get("ext");
        }
        if (userid != null) {
            contactInfo = this.findContactByUserId(userid);
        } else {
            String id = (String)map.get("oid");
            if (id != null) {
                contactInfo = this.contacts.get(id);
            }
        }
        if (contactInfo == null) {
            return null;
        }
        Integer state = (Integer)map.get("state");
        if (state == null) {
            Boolean enabled = (Boolean)map.get("enabled");
            state = enabled != null && enabled != false ? 1 : 0;
        }
        String note = (String)map.get("note");
        Number stime = (Number)map.get("stime");
        contactInfo.setStateTime(stime != null ? stime.longValue() : this.getServerTime());
        if (note != null) {
            contactInfo.setNote(note);
        }
        if (state == 0) {
            contactInfo.setProperty("location", null);
        }
        if ((imgdate = (Number)map.get("imgdate")) != null) {
            contactInfo.setImageTimestamp(imgdate.longValue());
            this.loadAvatar(contactInfo);
        }
        contactInfo.setState(state);
        if (contactInfo.isSlot()) {
            this.client.contactStatusChanged(contactInfo);
        }
        return contactInfo;
    }

    private ContactInfo addContactInfo(String userid, boolean b) {
        ContactInfo contact = new ContactInfo(userid);
        try {
            return this.getContactInfo(contact);
        }
        catch (Exception e) {
            this.toLog("getContactInfo: " + e);
            return this.addContactInfo(contact, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContactInfo addContactInfo(ContactInfo contactInfo, boolean b) {
        Map<String, ContactInfo> map;
        Object id = contactInfo.getId();
        String userid = contactInfo.getUserID();
        String localid = contactInfo.getLocalId();
        int status = contactInfo.getStatus();
        ContactInfo c = this.contacts.get(id);
        if (c != null) {
            if (c != contactInfo) {
                this.removeNumbers(c);
                c.update(contactInfo);
                contactInfo = c;
            }
        } else {
            if (userid != null) {
                c = this.findContactByUserId(userid);
            } else {
                List<String> phonenumbers = this.getPhoneNumbers(contactInfo);
                for (int i = 0; i < phonenumbers.size() && (c = this.numbers.get(this.normalizePhoneNumber(phonenumbers.get(i), this.client.getCountryCode()))) == null; ++i) {
                }
            }
            if (c != null && c != contactInfo && c != this.myInfo) {
                id = c.getId();
                this.toLog("findContactByUserId " + c + " (" + c.getCustomDetailsMap() + ") status=" + c.getStatus() + " id=" + (String)id);
                this.removeNumbers(c);
                c.update(contactInfo);
                contactInfo = c;
                contactInfo.setGlobalId((String)id);
            }
            if (c == null && localid != null && (c = this.contacts.get(localid)) != null && c != contactInfo) {
                c.update(contactInfo);
                contactInfo = c;
            }
            if (id != null) {
                map = this.contacts;
                synchronized (map) {
                    this.contacts.put((String)id, contactInfo);
                }
            }
        }
        this.toLog("addContactInfo " + contactInfo + " (" + contactInfo.getUserDetailsMap() + ", " + contactInfo.getCustomDetailsMap() + ") status=" + contactInfo.getStatus() + " id=" + (String)id + " userid=" + userid + " c=" + c + " e=" + (c == contactInfo));
        this.setNumbers(contactInfo);
        if (localid != null && (this.contacts.containsKey(localid) || !Boolean.TRUE.equals(this.getProperty("exportContacts")))) {
            map = this.contacts;
            synchronized (map) {
                this.contacts.put(localid, contactInfo);
            }
        }
        if (b) {
            if (contactInfo.getId() == null) {
                id = this.getUserId() + "-" + userid;
                contactInfo.setGlobalId((String)id);
                map = this.contacts;
                synchronized (map) {
                    this.contacts.put((String)id, contactInfo);
                }
            }
            if (c == null) {
                this.client.contactAdded(contactInfo);
            } else {
                this.contactStatusChanged(contactInfo);
            }
            this.loadAvatar(contactInfo);
            this.saveObjects();
        }
        return contactInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContactInfo(ContactInfo contact) {
        Map<String, ContactInfo> map = this.contacts;
        synchronized (map) {
            this.contacts.remove(contact.getGlobalId());
            this.contacts.remove(contact.getLocalId());
        }
        this.removeNumbers(contact);
        this.removeFromSessions(contact);
        this.client.contactRemoved(contact);
        this.saveObjects();
    }

    protected ContactInfo findContact(String id) {
        ContactInfo contactInfo = this.contacts.get(id);
        if (contactInfo != null) {
            return contactInfo;
        }
        if (id != null) {
            contactInfo = this.findContactByUserId(id);
        }
        if (contactInfo == null) {
            contactInfo = this.addContactInfo(id, true);
        }
        return contactInfo;
    }

    protected ContactInfo findContactByUserId(String userid) {
        if (userid == null || this.numbers == null) {
            return null;
        }
        if (userid.equals(this.getUserId())) {
            return this.myInfo;
        }
        ContactInfo contactInfo = this.numbers.get(userid);
        return contactInfo;
    }

    protected ContactInfo findContactByPhoneNumber(String number) {
        return this.findContactByPhoneNumber(number, null);
    }

    protected ContactInfo findContactByPhoneNumber(String number, String name) {
        ContactInfo contactInfo;
        List<String> phones;
        String prefix;
        ContactInfo contact = null;
        if (this.myInfo != null && (prefix = (String)this.myInfo.getProperty("branch")) != null) {
            contact = this.numbers.get(prefix + number);
        }
        if (!(contact != null || (contact = this.numbers.get(number)) == null || contact.isUser() || contact.isPhone() || contact.isFeature() || (phones = this.getPhoneNumbers(contact)).contains(number))) {
            this.numbers.remove(number);
            contact = null;
        }
        if (contact == null) {
            contact = this.numbers.get(this.normalizePhoneNumber(number, this.client.getCountryCode()));
        }
        if ((contact == null || contact.getStatus() == 0) && (contactInfo = this.client.findContact(number)) != null) {
            if (contact != null) {
                contact.update(contactInfo);
            } else if (name == null || name.endsWith(number)) {
                contact = contactInfo;
            }
        }
        if (contact == null) {
            contact = ContactInfo.createContact(null);
            contact.addCustomDetail(number.indexOf(64) != -1 ? "sip" : "phone", number);
        }
        this.toLog("findContactByPhoneNumber number=" + number + " name=" + name + " contact=" + contact + " status=" + contact.getStatus() + " valid=" + contact.isValid() + " global=" + contact.isGlobal() + " state=" + contact.getState());
        return contact;
    }

    public ContactInfo findContactInPhone(String number) {
        return this.client.findContact(number);
    }

    public ContactInfo setSpeedDialContact(String name, String number) throws Exception {
        ContactInfo contact = this.numbers.get(number);
        if (contact == null || contact.getStatus() == 3) {
            contact = ContactInfo.createContact(null);
        }
        if ("".equals(contact.getName())) {
            contact.setName(name);
        }
        contact.setSpeedDialNumber(number);
        if (contact.getGlobalId() != null) {
            this.updateContact(contact);
        } else {
            this.createContact(contact, false);
        }
        return contact;
    }

    public void deleteSpeedDialContact(ContactInfo contact) throws Exception {
        if (contact.isFeature()) {
            this.deleteContact(contact);
        } else {
            contact.deleteCustomSpeedDial();
            this.updateContact(contact);
        }
    }

    protected void uploadContacts(Collection<ContactInfo> contactList, boolean shared) {
        if (this.ucTask == null) {
            this.ucTask = new UploadContactsTask();
            new Timer().schedule((TimerTask)this.ucTask, 500L);
        }
        this.ucTask.setContactList(contactList, shared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContacts(Collection<ContactInfo> contactList, boolean shared) throws Exception {
        Object localid;
        boolean export = Boolean.TRUE.equals(this.getProperty("exportContacts")) || shared;
        HashSet<ContactInfo> exported = new HashSet<ContactInfo>();
        HashSet<String> localIds = new HashSet<String>();
        for (ContactInfo contact : contactList) {
            contact.setCountryCode(this.client.getCountryCode());
            localid = contact.getLocalId();
            if (localid != null) {
                localIds.add((String)localid);
                ContactInfo contactInfo = this.contacts.get(localid);
                if (contactInfo != null) {
                    contactInfo.setLocalId((String)localid);
                    long hash = contact.calculateHash();
                    if (hash != contactInfo.getHash()) {
                        contactInfo.setCustomDetails(contact.getCustomDetails());
                        contactInfo.setHash();
                        if (export && contactInfo.getGlobalId() != null) {
                            exported.add(contactInfo);
                        }
                    }
                    if (export) {
                        if (contactInfo.getGlobalId() != null) continue;
                        exported.add(contactInfo);
                        continue;
                    }
                    contactInfo.setImageFile(contact.getImageFile());
                    continue;
                }
                contact.setHash();
                Map<String, ContactInfo> hash = this.contacts;
                synchronized (hash) {
                    this.contacts.put((String)localid, contact);
                }
                if (export) {
                    exported.add(contact);
                    continue;
                }
                this.addContactInfo(contact, false);
                continue;
            }
            contact.setHash();
            if (export) {
                exported.add(contact);
            } else {
                this.addContactInfo(contact, false);
            }
            if (contact.getId() == null) continue;
            Map<String, ContactInfo> map = this.contacts;
            synchronized (map) {
                this.contacts.put(contact.getId(), contact);
            }
        }
        this.toLog("setContacts: contactList=" + contactList.size() + " exported=" + exported.size() + " localIds=" + localIds.size());
        if (!localIds.isEmpty() || contactList.isEmpty()) {
            Object contactInfo;
            HashMap<String, ContactInfo> map = new HashMap<String, ContactInfo>();
            localid = this.contacts;
            synchronized (localid) {
                for (String id : this.contacts.keySet()) {
                    contactInfo = this.contacts.get(id);
                    if (id != null && (id.equals(((ContactInfo)contactInfo).getGlobalId()) || localIds.contains(((ContactInfo)contactInfo).getLocalId()))) continue;
                    map.put(id, (ContactInfo)contactInfo);
                }
            }
            HashSet<Object> todelete = new HashSet<Object>();
            for (String id : map.keySet()) {
                contactInfo = this.contacts;
                synchronized (contactInfo) {
                    this.contacts.remove(id);
                }
                contactInfo = (ContactInfo)map.get(id);
                ContactInfo contactInfo2 = this.contacts.get(((ContactInfo)contactInfo).getGlobalId());
                if (((ContactInfo)contactInfo).getStatus() > 0 || contactInfo2 != null && id != null && !id.equals(contactInfo2.getLocalId())) continue;
                todelete.add(contactInfo);
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (ContactInfo contactInfo3 : todelete) {
                this.removeContactInfo(contactInfo3);
                String id = contactInfo3.getGlobalId();
                if (id == null) continue;
                ids.add(id);
            }
            if (export && !ids.isEmpty()) {
                HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
                hashMap.put("id", ids);
                this.sendIndication("deleteContacts", hashMap);
            }
        }
        if (!exported.isEmpty()) {
            Vector<ContactInfo> forUpload = new Vector<ContactInfo>();
            Vector list = new Vector();
            for (ContactInfo contactInfo : exported) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", contactInfo.getGlobalId());
                map.put("name", contactInfo.getName());
                map.put("extid", contactInfo.getLocalId());
                map.put("userid", contactInfo.getUserID());
                map.put("usinfo", contactInfo.getCustomDetailsMap());
                map.put("info", contactInfo.getUserDetailsMap());
                map.put("page", contactInfo.getProperty("page"));
                map.put("serviceid", contactInfo.getProperty("serviceid"));
                map.put("hash", contactInfo.getHash());
                list.add(map);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("list", list);
            hashMap.put("shared", shared);
            hashMap.put("country", this.client.getCountryCode());
            List result = (List)this.sendCommand("exportContacts", hashMap);
            ContactInfo contact = null;
            for (Map map : result) {
                Map<String, ContactInfo> map2;
                String extid = (String)map.get("extid");
                String id = (String)map.get("id");
                ContactInfo contactInfo = this.contacts.get(extid != null ? extid : id);
                if (contactInfo == null) continue;
                contactInfo.updateProperties(map);
                String localid2 = null;
                contact = this.contacts.get(id);
                if (contact != null) {
                    localid2 = contact.getLocalId();
                }
                if (localid2 == null && extid != null) {
                    map2 = this.contacts;
                    synchronized (map2) {
                        this.contacts.remove(extid);
                    }
                }
                contact = this.addContactInfo(contactInfo, false);
                this.toLog("contactInfo=" + contactInfo + " (" + contactInfo.hashCode() + ") id=" + contactInfo.getGlobalId() + " localid=" + contactInfo.getLocalId() + " contact=" + contact + " (" + contact.hashCode() + ") id=" + contact.getGlobalId() + " id=" + id + " lid=" + localid2);
                if (localid2 != null && !id.equals(localid2)) {
                    map2 = this.contacts;
                    synchronized (map2) {
                        this.contacts.remove(localid2);
                    }
                    map2 = this.contacts;
                    synchronized (map2) {
                        this.contacts.put(id, contact);
                    }
                }
                if (contact.getImageFile() == null || contactInfo.getImageTimestamp() > 0L || contact.getImageFile().length() <= 0L) continue;
                forUpload.add(contact);
            }
            if (!forUpload.isEmpty()) {
                this.uploadIcons(forUpload);
            }
            if (contact != null) {
                this.client.contactAdded(contact);
            }
        }
        this.saveObjects();
        this.client.contactListUploaded();
    }

    private void uploadIcons(List list) {
        final List part = list;
        Thread mloader = new Thread(){

            @Override
            public void run() {
                for (Object obj : part) {
                    ContactInfo contact = (ContactInfo)obj;
                    try {
                        int status = ServiceManager.this.putContactImage(contact);
                        ContactInfo contactInfo = (ContactInfo)ServiceManager.this.contacts.get(contact.getId());
                        if (contactInfo != null && contact != contactInfo) {
                            contactInfo.setImageFile(contact.getImageFile());
                        }
                        ServiceManager.this.toLog("uploadIcon " + contact + " id=" + contact.getId() + " len=" + contact.getImageFile().length() + " status=" + status);
                    }
                    catch (Exception e) {
                        ServiceManager.this.toLog("uploadIcon " + contact + ": " + e);
                    }
                }
            }
        };
        mloader.start();
    }

    protected void removeContacts() throws Exception {
        this.server.sendIndication("removeContacts", new HashMap());
    }

    protected void setUserInfo(ContactInfo contact, boolean withImage) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", contact.getName());
        map.put("info", contact.getUserDetailsMap());
        this.sendIndication(METHOD_SET_USERINFO, map);
        this.saveObjects();
        if (withImage) {
            this.setAvatar(contact);
        }
    }

    protected void setContactInfo(ContactInfo contact, boolean withImage) throws Exception {
        if (contact.equals(this.myInfo)) {
            this.sendIndication(METHOD_SET_USERINFO, contact.getUserDetailsMap());
            this.myInfo.setUserDetails(contact.getUserDetails());
        } else if (contact.getGlobalId() != null) {
            this.updateContact(contact);
        } else {
            ContactInfo contactInfo = this.findContactByUserId(contact.getUserID());
            if (contactInfo == null) {
                contactInfo = this.contacts.get(contact.getLocalId());
            }
            if (contactInfo == null || contactInfo.getGlobalId() == null) {
                this.createContact(contact, false);
            } else {
                contact.setGlobalId(contactInfo.getGlobalId());
                this.updateContact(contact);
            }
        }
        this.saveObjects();
        if (withImage) {
            this.setAvatar(contact);
        }
        if (!contact.equals(this.myInfo)) {
            this.setServiceContact(contact);
        }
    }

    private void setAvatar(ContactInfo contact) throws Exception {
        this.toLog("setAvatar " + contact + " hasAvatar=" + contact.hasAvatar() + " my=" + contact.equals(this.myInfo));
        if (contact.hasAvatar()) {
            Vector<ContactInfo> list = new Vector<ContactInfo>();
            list.add(contact);
            this.uploadIcons(list);
        } else if (contact.equals(this.myInfo)) {
            this.deleteAvatar();
        } else if (contact.getGlobalId() != null) {
            this.deleteFile(contact.getGlobalId());
        }
    }

    protected List getServices() {
        List services = this.myInfo.getList("services");
        ArrayList<Map> list = new ArrayList<Map>();
        for (int i = 0; i < services.size(); ++i) {
            Map service = (Map)services.get(i);
            Integer types = (Integer)service.get("types");
            if (types == null || (types & 0xF) == 0) continue;
            list.add(service);
        }
        return list;
    }

    protected List getServices(int type) {
        ArrayList list = new ArrayList();
        List services = this.myInfo.getList("services");
        if (services != null) {
            for (int i = 0; i < services.size(); ++i) {
                Map service = (Map)services.get(i);
                Integer types = (Integer)service.get("types");
                if (types == null || (types & type) == 0) continue;
                list.add(service.get("name"));
            }
        }
        return list;
    }

    protected String getServiceId(String serviceName) {
        List services = this.myInfo.getList("services");
        if (services == null) {
            return null;
        }
        for (int i = 0; i < services.size(); ++i) {
            Map service = (Map)services.get(i);
            if (!serviceName.equals(service.get("name"))) continue;
            return (String)service.get("serviceid");
        }
        return null;
    }

    protected String getServiceName(String serviceid) {
        List services = this.myInfo.getList("services");
        if (services == null) {
            return null;
        }
        for (int i = 0; i < services.size(); ++i) {
            Map service = (Map)services.get(i);
            if (!serviceid.equals(service.get("serviceid"))) continue;
            return (String)service.get("name");
        }
        return null;
    }

    public List<ContactInfo> getServiceContacts(final String serviceid, String prefix, final ServiceContactsListener listener) throws Exception {
        List<ContactInfo> contacts;
        Object obj;
        if (this.serviceContacts == null) {
            try {
                this.serviceContacts = (Map)this.loadObject("ServiceContacts");
            }
            catch (Exception e) {
                this.toLog("Loading ServiceContacts - " + e);
            }
            if (this.serviceContacts == null) {
                this.serviceContacts = new HashMap();
            }
        }
        final boolean search = prefix != null && prefix.length() > 1;
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceid", serviceid);
        if (search) {
            params.put("prefix", prefix);
        }
        if ((obj = this.serviceContacts.get(serviceid)) instanceof Map) {
            contacts = new ArrayList(((Map)obj).values());
            final Long time = (Long)this.serviceContacts.get(serviceid + "_ts");
            long now = System.currentTimeMillis();
            if (search && !this.serviceContactsSearch || !search && (time == null || now - time > 30000L)) {
                new Thread(){

                    @Override
                    public void run() {
                        if (!search && time != null) {
                            params.put("since", time);
                        }
                        try {
                            List contacts = ServiceManager.this.getServiceContacts(serviceid, params);
                            if (!contacts.isEmpty()) {
                                listener.serviceContactsUpdated(contacts, serviceid);
                            }
                        }
                        catch (Exception e) {
                            ServiceManager.this.serviceContactsSearch = false;
                        }
                    }
                }.start();
            }
            if (prefix != null && prefix.length() > 0) {
                ArrayList<ContactInfo> result = new ArrayList<ContactInfo>();
                boolean isnumber = true;
                try {
                    Long.parseLong(prefix);
                }
                catch (Exception e) {
                    isnumber = false;
                }
                String pref = prefix.toLowerCase();
                for (ContactInfo contact : contacts) {
                    String name = contact.toString().toLowerCase();
                    String desc = contact.getDescription();
                    if ((!isnumber || contact.findPhoneNumbers(pref).length() <= 0) && !name.startsWith(pref) && !name.contains(" " + pref) && (desc == null || !desc.toLowerCase().startsWith(pref))) continue;
                    result.add(contact);
                }
                contacts = result;
            }
        } else {
            contacts = this.getServiceContacts(serviceid, params);
        }
        this.serviceContactsSearch = search;
        return contacts;
    }

    private List<ContactInfo> getServiceContacts(String serviceid, Map params) throws Exception {
        Object result;
        this.toLog("getServiceContacts serviceid=" + serviceid + " params=" + params + " sr=" + this.serviceContactsRequest);
        Object obj = this.serviceContacts.get(serviceid);
        if (!(obj instanceof Map)) {
            obj = new HashMap();
        }
        Map contactsMap = (Map)obj;
        if (this.serviceContactsRequest) {
            return new ArrayList<ContactInfo>();
        }
        this.serviceContactsRequest = true;
        try {
            result = this.sendCommand("getServiceContacts", params, 60000L);
            this.serviceContactsRequest = false;
        }
        catch (Throwable e) {
            this.serviceContactsRequest = false;
            throw e;
        }
        if (result instanceof List) {
            if (!params.containsKey("prefix")) {
                contactsMap.clear();
            }
            ArrayList<ContactInfo> contacts = new ArrayList<ContactInfo>();
            List list = (List)result;
            for (int i = 0; i < list.size(); ++i) {
                ContactInfo contact = new ContactInfo((Map)list.get(i));
                contact.setProperty("serviceid", serviceid);
                contactsMap.put(contact.getId(), contact);
                contacts.add(contact);
            }
            this.serviceContacts.put(serviceid, contactsMap);
            this.serviceContacts.put(serviceid + "_ts", System.currentTimeMillis());
            try {
                this.saveObject("ServiceContacts", (Object)this.serviceContacts);
            }
            catch (Exception e) {
                this.toLog("Saving ServiceContacts - " + e);
            }
            return contacts;
        }
        Map map = (Map)result;
        String location = (String)map.get("location");
        throw new RedirectionException(location);
    }

    protected void setServiceContact(String serviceid, ContactInfo contact) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serviceid", serviceid);
        params.put("id", contact.getId());
        params.put("userid", contact.getUserID());
        params.put("name", contact.getName());
        params.put("usinfo", contact.getCustomDetailsMap());
        Map result = (Map)this.sendCommand("setServiceContact", params);
        String location = (String)result.get("location");
        if (location != null) {
            throw new RedirectionException(location);
        }
    }

    protected void setServiceContact(ContactInfo contact) throws Exception {
        ContactInfo contactInfo = this.contacts.get(contact.getId());
        if (contactInfo == null) {
            contactInfo = contact;
        }
        List services = this.getServices();
        for (int i = 0; i < services.size(); ++i) {
            Map service = (Map)services.get(i);
            String options = (String)service.get("options");
            if (options == null || !options.contains("write")) continue;
            try {
                this.setServiceContact((String)service.get("serviceid"), contactInfo);
                continue;
            }
            catch (RedirectionException e) {
                throw e;
            }
            catch (Exception x) {
                this.toLog(x);
            }
        }
    }

    protected void deleteServiceContact(String serviceid, ContactInfo contact) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceid", serviceid);
        params.put("id", contact.getId());
        params.put("userid", contact.getUserID());
        Map result = (Map)this.sendCommand("deleteServiceContact", params);
        String location = (String)result.get("location");
        if (location != null) {
            throw new RedirectionException(location);
        }
    }

    protected void deleteServiceContact(ContactInfo contact) throws Exception {
        List services = this.getServices();
        for (int i = 0; i < services.size(); ++i) {
            Map service = (Map)services.get(i);
            String options = (String)service.get("options");
            if (options == null || !options.contains("delete")) continue;
            this.deleteServiceContact((String)service.get("serviceid"), contact);
        }
    }

    protected void serviceContactDeleted(Map parameters) {
        if (this.serviceContacts == null) {
            return;
        }
        String serviceid = (String)parameters.get("serviceid");
        String contactid = (String)parameters.get("contact_id");
        Map map = (Map)this.serviceContacts.get(serviceid);
        try {
            if (map != null && map.remove(contactid) != null) {
                this.saveObject("ServiceContacts", (Object)this.serviceContacts);
            }
        }
        catch (Exception e) {
            this.toLog("Saving ServiceContacts - " + e);
        }
    }

    public List getContacts() {
        HashSet<ContactInfo> set = new HashSet<ContactInfo>();
        Iterator it = this.contactsIterator();
        while (it.hasNext()) {
            ContactInfo contact = (ContactInfo)it.next();
            if (contact.getName().length() <= 0 || this.getUserId().equals(contact.getUserID())) continue;
            set.add(contact);
        }
        return new ArrayList(set);
    }

    public List getContacts(String groupName) {
        ArrayList<ContactInfo> list = new ArrayList<ContactInfo>();
        for (Map map : this.contactgroups.values()) {
            if (!groupName.equals(map.get("name"))) continue;
            List members = (List)map.get("members");
            Iterator itr2 = members.iterator();
            while (itr2.hasNext()) {
                ContactInfo contact = this.numbers.get(itr2.next());
                if (contact == null) continue;
                list.add(contact);
            }
        }
        return list;
    }

    public List getSessions(String prefix) {
        String p1 = null;
        String p2 = null;
        if (prefix.length() > 0) {
            int n = (prefix = prefix.toLowerCase()).indexOf(32);
            if (n == prefix.length() - 1) {
                prefix = prefix.substring(0, n);
            } else if (n > 0) {
                p1 = prefix.substring(0, n);
                p2 = prefix.substring(n + 1);
            }
        }
        ArrayList<SessionInfo> al = new ArrayList<SessionInfo>();
        Iterator it = this.sessionsIterator();
        while (it.hasNext()) {
            int m;
            SessionInfo session = (SessionInfo)it.next();
            if (session.getStatus() == 10) continue;
            if (prefix.length() == 0) {
                al.add(session);
                continue;
            }
            String name = session.toString().toLowerCase();
            if (name.startsWith(prefix) || name.contains(" " + prefix)) {
                al.add(session);
                continue;
            }
            if (p1 == null || (m = name.indexOf(32)) <= 0) continue;
            String fname = name.substring(0, m);
            String sname = name.substring(m + 1);
            if (!fname.startsWith(p1) || !sname.startsWith(p2)) continue;
            al.add(session);
        }
        return al;
    }

    private List getSorted(Iterator itr) {
        ArrayList list = new ArrayList();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        try {
            Collections.sort(list);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public int inviteContact(ContactInfo contact, String text) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", contact.getUserID());
        params.put("destname", contact.getName());
        params.put("origname", this.getOwner().getName());
        if (text != null) {
            params.put("message", text);
        }
        Map result = (Map)this.sendCommand(METHOD_INVITE_CONTACT, params);
        Integer status = (Integer)result.get("status");
        String contactid = (String)result.get("contactid");
        if (contactid == null) {
            return status;
        }
        String sessionid = (String)result.remove("sessionid");
        String messageid = (String)result.remove("messageid");
        String message = (String)result.remove("message");
        contact.updateProperties(result);
        contact = this.addContactInfo(contact, true);
        if (sessionid != null) {
            Long created = (Long)result.get("created");
            if (created == null) {
                created = this.getServerTime();
            }
            Long expired = (Long)result.get("expired");
            SessionInfo sessionInfo = this.sessions.get(sessionid);
            if (sessionInfo != null) {
                sessionInfo.setStatus(0);
            } else {
                sessionInfo = new SessionInfo();
                sessionInfo.setSessionId(sessionid);
                sessionInfo.setStatus(0);
                sessionInfo.addParty(contact);
                sessionInfo.setCreated(created);
                this.sessions.put(sessionid, sessionInfo);
                this.client.sessionCreated(sessionInfo);
            }
            if (messageid != null) {
                if (text == null) {
                    text = message;
                }
                MessageInfo messageInfo = new MessageInfo(messageid, this.getUserId(), text, 1, 3, created);
                if (expired != null) {
                    messageInfo.setExpired(expired);
                }
                sessionInfo.addMessage(messageInfo);
                this.client.messageReceived(messageInfo, sessionInfo);
            }
        }
        return status;
    }

    protected void sendContactAccept(String userid, String text) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userid);
        params.put("message", text);
        Map map = (Map)this.sendCommand(METHOD_CONTACT_ACCEPT, params);
        String sessionid = (String)map.remove("sessionid");
        String messageid = (String)map.remove("messageid");
        String message = (String)map.remove("message");
        ContactInfo contactInfo = this.addContactInfo(new ContactInfo(map), true);
        SessionInfo sessionInfo = this.sessions.get(sessionid);
        if (sessionInfo != null) {
            sessionInfo.getParties().clear();
            sessionInfo.addParty(contactInfo);
            sessionInfo.setStatus(0);
            if (text == null) {
                text = message;
            }
            MessageInfo messageInfo = new MessageInfo(messageid, this.getUserId(), text, 1, 3, System.currentTimeMillis());
            sessionInfo.addMessage(messageInfo);
            this.client.messageReceived(messageInfo, sessionInfo);
        }
    }

    protected void sendContactReject(String userid) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userid);
        this.sendIndication(METHOD_CONTACT_REJECT, params);
        ContactInfo contact = this.findContactByUserId(userid);
        if (contact != null) {
            contact.setStatus(3);
            this.contactStatusChanged(contact);
        }
    }

    private void contactRequested(Map params) {
        String userid = (String)params.get("userid");
        ContactInfo contact = this.findContactByUserId(userid);
        if (contact != null) {
            if (contact.getStatus() == 3) {
                try {
                    this.sendContactReject(userid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (contact.getStatus() >= 4) {
                try {
                    this.sendContactAccept(userid, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        } else {
            contact = this.addContactInfo(new ContactInfo(params), true);
        }
        contact.setStatus(1);
        String mid = (String)params.get("messageid");
        String message = (String)params.get("message");
        long time = (Long)params.get("time");
        String sessionid = (String)params.get("sessionid");
        SessionInfo sessionInfo = this.sessions.get(sessionid);
        if (sessionInfo == null) {
            sessionInfo = new SessionInfo();
            sessionInfo.setSessionId(sessionid);
            sessionInfo.setDialogId((String)params.get("dialogid"));
            sessionInfo.setStatus(0);
            sessionInfo.addParty(contact);
            sessionInfo.setCreated(time);
            sessionInfo.setLastUpdated(time);
            String name = (String)params.get("name");
            if (name == null || name.length() == 0) {
                name = contact.toString();
            }
            sessionInfo.setName(name);
            this.sessions.put(sessionid, sessionInfo);
            this.client.sessionCreated(sessionInfo);
        }
        MessageInfo messageInfo = new MessageInfo(mid, userid, message, 1, 1, time);
        Integer lifetime = (Integer)params.get("lifetime");
        if (lifetime != null && lifetime > 0) {
            messageInfo.setLifetime(lifetime.intValue());
        }
        sessionInfo.addMessage(messageInfo);
        this.client.contactAdded(contact);
        this.client.messageReceived(messageInfo, sessionInfo);
        this.saveSessionMessage(sessionInfo, messageInfo);
    }

    private void contactAccepted(Map map) {
        String userid = (String)map.get("userid");
        ContactInfo contact = this.findContactByUserId(userid);
        if (contact == null) {
            return;
        }
        contact.setStatus(4);
        Integer state = (Integer)map.get("state");
        contact.setState(state);
        String id = (String)map.get("contactid");
        if (id != null) {
            contact.setGlobalId(id);
        }
        this.contactStatusChanged(contact);
        String sessionid = (String)map.get("sessionid");
        SessionInfo sessionInfo = this.sessions.get(sessionid);
        if (sessionInfo != null) {
            sessionInfo.setStatus(0);
        }
    }

    private void contactRejected(Map map) {
        String userid = (String)map.get("userid");
        ContactInfo contact = this.findContactByUserId(userid);
        if (contact == null) {
            return;
        }
        contact.setStatus(-1);
        contact.setState(0);
        this.contactStatusChanged(contact);
    }

    private void contactCreated(Map map) {
        this.addContactInfo(new ContactInfo(map), true);
    }

    private void contactUpdated(Map map) {
        this.addContactInfo(new ContactInfo(map), true);
    }

    protected void contactChanged(Map map, boolean b) {
        ContactInfo contactInfo = new ContactInfo(map);
        if (contactInfo.getStatus() == 3) {
            this.removeContactInfo(contactInfo);
        } else {
            this.addContactInfo(contactInfo, b);
        }
    }

    protected void contactDeleted(Map map) {
        String id = (String)map.get("id");
        if (id != null) {
            this.removeContact(id);
        } else {
            ContactInfo contactInfo;
            String userid = (String)map.get("userid");
            if (userid != null && (contactInfo = this.numbers.get(userid)) != null) {
                this.removeContactInfo(contactInfo);
            }
        }
    }

    protected void removeContact(String id) {
        ContactInfo contactInfo = this.contacts.get(id);
        if (contactInfo != null) {
            this.removeContactInfo(contactInfo);
        }
    }

    private void removeFromSessions(ContactInfo contact) {
        String userid = contact.getUserID();
        if (userid == null) {
            return;
        }
        Iterator itr = this.sessionsIterator();
        while (itr.hasNext()) {
            SessionInfo session = (SessionInfo)itr.next();
            if (session.getStatus() > 0 || session.getParty(userid) == null) continue;
            this.sessionDeleted(session.getSessionId());
            break;
        }
    }

    private void terminate(Map map) {
        String termid = (String)map.get("termid");
        this.toLog("terminate " + map + " tid=" + this.client.getTerminalId());
        if (termid == null || termid.equals(this.client.getTerminalId())) {
            this.unregister();
            this.deleteCache();
            this.filedir.delete();
            System.exit(0);
        }
    }

    protected void setLocation(double latitude, double longitude) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        if (latitude != -1.0) {
            prms.put("latitude", latitude);
        }
        if (longitude != -1.0) {
            prms.put("longitude", longitude);
        }
        prms.put("termid", this.client.getTerminalId());
        this.sendIndication("setLocation", prms);
    }

    protected List<ContactInfo> findNearbyUsers(double latitude, double longitude, int skip, int limit, int gender) throws Exception {
        Vector<ContactInfo> retval = new Vector<ContactInfo>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("termid", this.client.getTerminalId());
        if (skip != -1) {
            params.put("skip", skip);
        }
        if (limit > 0) {
            params.put("limit", limit);
        }
        if (gender != -1) {
            params.put("gender", gender);
        }
        if (latitude != -1.0) {
            params.put("latitude", latitude);
        }
        if (longitude != -1.0) {
            params.put("longitude", longitude);
        }
        List list = (List)this.sendCommand("findUsers", params);
        for (int i = 0; i < list.size(); ++i) {
            ContactInfo contactInfo = new ContactInfo((Map)list.get(i));
            ContactInfo contact = this.findContactByUserId(contactInfo.getUserID());
            if (contact != null) {
                contact.updateProperties(contactInfo.getProperties());
                retval.add(contact);
                this.loadAvatar(contact);
                continue;
            }
            contactInfo.setState(4);
            contactInfo.setStatus(0);
            retval.add(contactInfo);
            this.loadAvatar(contactInfo);
        }
        return retval;
    }

    protected void makeCall(SessionInfo sessionInfo, boolean video) {
        if (sessionInfo.isGroup() && sessionInfo.getDialogType() != 3) {
            this.makeConferenceCall(sessionInfo.getSessionId(), video);
        } else {
            Object number = sessionInfo.getPartyNumbers().get(0);
            MessageInfo messageInfo = sessionInfo.getLastCall();
            if (messageInfo != null) {
                String partyNumber = messageInfo.getCallPartyNumber();
                if (partyNumber != null) {
                    number = partyNumber;
                }
                String trunkNumber = messageInfo.getCallTrunkNumber();
                List trunks = (List)this.myInfo.getProperty("trunks");
                if (trunks != null && trunkNumber != null) {
                    for (int i = 0; i < trunks.size(); ++i) {
                        Map trunk = (Map)trunks.get(i);
                        if (!new Integer(1).equals(trunk.get("state")) || !trunkNumber.equals(trunk.get("number")) && !trunkNumber.equals(trunk.get("user"))) continue;
                        String cc = (String)trunk.get("country");
                        if (cc == null) {
                            cc = this.client.getCountryCode();
                        }
                        number = "TRUNK" + trunk.get("oid") + "*" + this.normalizePhoneNumber((String)number, cc);
                        this.makeCall((String)number, video);
                        return;
                    }
                }
            }
            if (sessionInfo.getStatus() == 0) {
                this.makeCall(sessionInfo.getParties().get(0), video);
            } else {
                if (sessionInfo.isExternal()) {
                    number = this.normalizePhoneNumber((String)number, this.client.getCountryCode());
                }
                this.makeCall((String)number, video);
            }
        }
    }

    protected boolean isTrunkEnabled(String trunkNumber) {
        if (trunkNumber == null || this.myInfo == null) {
            return false;
        }
        List trunks = (List)this.myInfo.getProperty("trunks");
        if (trunks != null) {
            for (int i = 0; i < trunks.size(); ++i) {
                Map trunk = (Map)trunks.get(i);
                if (!new Integer(1).equals(trunk.get("state")) || !trunkNumber.equals(trunk.get("number")) && !trunkNumber.equals(trunk.get("user"))) continue;
                return true;
            }
        }
        return false;
    }

    protected String createMeeting(SessionInfo sessionInfo, String serviceName) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sessionid", sessionInfo.getSessionId());
        if (serviceName != null) {
            params.put("serviceid", this.getServiceId(serviceName));
        }
        Map result = (Map)this.sendCommand("createMeeting", params);
        return (String)result.get("url");
    }

    protected List<ContactInfo> getChannels(int skip, int limit) throws Exception {
        Vector<ContactInfo> retval = new Vector<ContactInfo>();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        if (skip != -1) {
            params.put("skip", skip);
        }
        if (limit > 0) {
            params.put("limit", limit);
        }
        List list = (List)this.sendCommand("getChannels", params);
        for (int i = 0; i < list.size(); ++i) {
            ContactInfo contactInfo = new ContactInfo((Map)list.get(i));
            contactInfo.setNumber(contactInfo.getUserID());
            contactInfo.setStatus(10);
            retval.add(contactInfo);
            this.loadAvatar(contactInfo);
        }
        return retval;
    }

    protected List getComments(String postid) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("postid", postid);
        return (List)this.sendCommand("getComments", params);
    }

    private void setTerminalType(int type) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("type", type);
        prms.put("termid", this.client.getTerminalId());
        this.sendIndication("setTerminalType", prms);
        this.server.setAutoanswerMode(type >= 2 ? 2 : 0);
    }

    protected void setDeviceToken(String svcid, String token, int type) throws Exception {
        HashMap<String, Object> prms = new HashMap<String, Object>();
        prms.put("service", svcid);
        prms.put("termid", this.client.getTerminalId());
        prms.put("token", token);
        prms.put("type", type);
        this.sendIndication(METHOD_SET_DEVICE_TOKEN, prms);
    }

    public String hash(String pass) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec key = new SecretKeySpec(this.client.getTerminalId().getBytes("UTF-8"), "HmacSHA256");
        mac.init(key);
        mac.update(pass.getBytes());
        byte[] hash = new byte[32];
        mac.doFinal(hash, 0);
        return Utils.encodeBase64String(hash);
    }

    public PhoneDevice getDevice() {
        return this.server.getDevice();
    }

    public List getProviders() {
        return this.providers;
    }

    public Map getOffer(String provider) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("provider", provider);
        Locale locale = Locale.getDefault();
        parameters.put("language", locale.getLanguage());
        parameters.put("country", locale.getCountry());
        return (Map)this.sendCommand("getOffer", parameters);
    }

    public Collection getPackagesList(String provider) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("provider", provider);
        return (Collection)this.sendCommand("getPackagesList", parameters);
    }

    public Collection getPhoneNumbers(String provider, String country, String city) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("provider", provider);
        parameters.put("country", country);
        parameters.put("city", city);
        return (Collection)this.sendCommand("getPhoneNumbers", parameters);
    }

    public Map getPhoneNumber(String provider, String phone_number, String package_id) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("provider", provider);
        parameters.put("package_id", package_id);
        parameters.put("phone_number", phone_number);
        return (Map)this.sendCommand("getPhoneNumber", parameters);
    }

    public Map connectPhoneNumber(String provider, String phone_number, String package_id, String code) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("provider", provider);
        parameters.put("package_id", package_id);
        parameters.put("phone_number", phone_number);
        parameters.put("code", code);
        return (Map)this.sendCommand("connectPhoneNumber", parameters);
    }

    public Map getPhoneNumberBalance(String provider, String phone_number) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("provider", provider);
        parameters.put("phone_number", phone_number);
        return (Map)this.sendCommand("getPhoneNumberBalance", parameters);
    }

    public void toLog(Throwable e) {
        Object message = e.getLocalizedMessage();
        StackTraceElement[] ste = e.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            message = (String)message + "\n" + ste[i].toString();
        }
        this.toLog((String)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toLog(String text) {
        File file = ResourceStore.LOG_FILE;
        synchronized (file) {
            ResourceStore.toLog(text);
        }
    }

    public void sendLogFile() {
        if (this.writelog && ResourceStore.LOG_FILE.length() > 2500L && this.logTask == null) {
            this.toLog("sendLogFile");
            this.logTask = new TimerTask(){

                @Override
                public void run() {
                    new Thread(){

                        @Override
                        public void run() {
                            ServiceManager.this.sendLog();
                            ServiceManager.this.logTask = null;
                        }
                    }.start();
                }
            };
            try {
                Utils.getTimer().schedule(this.logTask, 3000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sendLog() {
        if (!this.online || !this.startedOnline || this.hasActiveCalls()) {
            return;
        }
        File file = ResourceStore.getLog();
        if (file == null) {
            this.toLog("sending log " + file);
            return;
        }
        String resource = "bugreport/" + this.getUserId() + "-" + this.client.getTerminalId() + ".txt";
        try {
            this.toLog("sending log " + resource + " (" + file.length() + " bytes)");
            this.fileLoader.putFile(resource, file, null);
            this.toLog("sendLog " + file.length() + " bytes OK");
        }
        catch (Exception e) {
            this.toLog("sendLog: " + e);
        }
        file.delete();
    }

    public boolean sendLog(String url) throws Exception {
        File file = ResourceStore.getLog();
        HttpRequest httpRequest = new HttpRequest("https://" + url);
        int responseCode = httpRequest.put(file);
        return responseCode == 200;
    }

    protected List<ContactGroup> getGroups() {
        return new ArrayList<ContactGroup>();
    }

    protected ContactGroup getGroup(String id) {
        return null;
    }

    public List<String> checkUpdates(File binDir) throws Exception {
        return this.checkUpdates(binDir, null);
    }

    public List<String> checkUpdates(File binDir, String version) throws Exception {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") != -1) {
            os = "windows";
        }
        String arch = System.getProperty("os.arch").toLowerCase();
        Vector<String> retval = new Vector<String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("os", os);
        params.put("arch", arch);
        if (version != null) {
            params.put("version", version);
        }
        List list = (List)this.sendCommand(METHOD_CHECK_UPDATES, params);
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String filename = (String)map.get("file");
            long lastModified = (Long)map.get("date");
            File file = new File(binDir, new File(filename).getName());
            if (file.exists() && file.lastModified() >= lastModified) continue;
            retval.add(filename);
            this.toLog("checkUpdates: file=" + filename + " date=" + lastModified + " localModified=" + file.lastModified());
        }
        return retval;
    }

    public boolean loadUpdates(List<String> updates, File binDir, String execname) {
        return this.loadUpdates(updates, binDir, execname, null);
    }

    public boolean loadUpdates(List<String> updates, File binDir, String execname, String version) {
        this.toLog("loadUpdates: " + updates);
        boolean restart = false;
        try {
            Object path = "updates/";
            if (version != null) {
                path = (String)path + version + "/";
            }
            for (int i = 0; i < updates.size(); ++i) {
                File bak;
                File tmp;
                File file;
                block10: {
                    String filename = updates.get(i);
                    file = new File(filename);
                    tmp = File.createTempFile("xxx", ".tmp");
                    int status = this.fileLoader.getFile((String)path + filename, tmp, null, new HashMap());
                    if (status != 200) {
                        throw new Exception("Error status=" + status);
                    }
                    file = new File(binDir, file.getName());
                    bak = File.createTempFile("xxx", ".bak");
                    if (file.exists() && !file.renameTo(bak)) {
                        ResourceStore.error("Could not rename " + file + " to " + bak);
                    }
                    FileOutputStream fos = null;
                    try {
                        FileInputStream fis = new FileInputStream(tmp);
                        byte[] data = new byte[fis.available()];
                        fis.read(data);
                        fis.close();
                        fos = new FileOutputStream(file);
                        fos.write(data);
                        fos.close();
                        restart = true;
                    }
                    catch (Exception e) {
                        ResourceStore.error(e.toString());
                        if (fos == null) break block10;
                        fos.close();
                    }
                }
                if (!file.exists() && bak.exists()) {
                    bak.renameTo(file);
                } else {
                    file.setLastModified(tmp.lastModified());
                }
                tmp.delete();
                this.toLog("Save " + file + " lastModified=" + file.lastModified());
            }
        }
        catch (Exception e) {
            ResourceStore.error("loadUpdates", e);
        }
        return restart;
    }

    public static String getCauseDescription(int cause) {
        switch (cause & 0x7F) {
            case 0: {
                return "";
            }
            case 1: {
                return "UserAbsent";
            }
            case 2: {
                return "NoRouteToNetwork";
            }
            case 3: {
                return "NoRouteToDestination";
            }
            case 16: {
                return "NoAnswer";
            }
            case 17: {
                return "UserBusy";
            }
            case 19: {
                return "NoAnswer";
            }
            case 20: {
                return "SubscriberAbsent";
            }
            case 21: {
                return "CallRejected";
            }
            case 22: 
            case 23: {
                return "NumberChanged";
            }
            case 26: {
                return "AnsweredElsewhere";
            }
            case 27: {
                return "DestinationOutOfOrder";
            }
            case 28: {
                return "InvalidNumberFormat";
            }
            case 31: {
                return "UserAbsent";
            }
            case 34: {
                return "NoChannelAvailable";
            }
            case 55: {
                return "UserBusy";
            }
            case 63: {
                return "ServiceNotAvailable";
            }
        }
        return "CommunicationError";
    }

    public String normalizePhoneNumber(String number, String countryCode) {
        if (number.contains("@")) {
            return number;
        }
        return Utils.normalizePhoneNumber(number, countryCode);
    }

    public List<String> getPhoneNumbers(ContactInfo contactInfo) {
        ArrayList<String> list = new ArrayList<String>();
        List<ContactInfo.Detail> details = contactInfo.getPhoneDetails();
        for (int i = 0; i < details.size(); ++i) {
            list.add((String)details.get(i).getValue());
        }
        return list;
    }

    class UploadContactsTask
    extends TimerTask {
        private Collection<ContactInfo> contactList;
        boolean shared;

        UploadContactsTask() {
        }

        public void setContactList(Collection<ContactInfo> contacts, boolean shared) {
            this.contactList = contacts;
            this.shared = shared;
        }

        @Override
        public void run() {
            Collection<ContactInfo> contacts = null;
            if (!(ServiceManager.this.hasActiveCalls() || !ServiceManager.this.online && Boolean.TRUE.equals(ServiceManager.this.getProperty("exportContacts")))) {
                contacts = this.contactList;
                try {
                    ServiceManager.this.setContacts(contacts, this.shared);
                }
                catch (Exception e) {
                    ResourceStore.error("setContacts", e);
                    contacts = null;
                }
            }
            ServiceManager.this.ucTask = null;
            if (ServiceManager.this.online && !this.contactList.equals(contacts)) {
                ServiceManager.this.uploadContacts(this.contactList, this.shared);
            }
        }
    }

    class MyTimerTask
    extends TimerTask {
        private String key;

        MyTimerTask(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            if (this.key.equals("Autoanswer On")) {
                Boolean on = (Boolean)ServiceManager.this.localProperties.get("Autoanswer");
                if (on == null) {
                    on = true;
                }
                if (on.booleanValue()) {
                    ServiceManager.this.server.setAutoanswerMode(1);
                }
            } else if (this.key.equals("Autoanswer Off")) {
                ServiceManager.this.server.setAutoanswerMode(0);
            }
        }
    }
}

