/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import smile.cti.client.Activity;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.SIPMessageConnector;
import smile.cti.client.ServiceManager;
import smile.cti.phone.Line;
import smile.util.Utils;

public class UnifiedServiceManager
extends ServiceManager {
    private List trunks = new ArrayList();

    public UnifiedServiceManager(ClientConnector client) throws Exception {
        super(client);
        this.setServerConnector(new SIPMessageConnector(this, "$SERVICE$"));
    }

    @Override
    public void processCommand(String method, Map parameters) throws Exception {
        if (method.equals("stateChanged")) {
            super.processCommand("state", parameters);
        } else if (method.equals("extensionCreated")) {
            String kind = (String)parameters.get("kind");
            if ("channel".equals(kind) || "hunting".equals(kind) || "unit".equals(kind) || "selector".equals(kind)) {
                this.addContactInfo(parameters);
            }
        } else if (method.equals("objectCreated")) {
            String kind = (String)parameters.get("kind");
            if ("user".equals(kind) || "phone".equals(kind)) {
                this.addContactInfo(parameters);
            }
        } else if (method.equals("objectUpdated")) {
            String kind = (String)parameters.get("kind");
            if ("user".equals(kind) || "phone".equals(kind)) {
                String userid = (String)parameters.get("userid");
                ContactInfo contact = this.findContact(userid);
                if (contact == null) {
                    this.addContactInfo(parameters);
                } else {
                    contact.updateProperties(parameters);
                    this.client.contactStatusChanged(contact);
                }
            } else if ("channel".equals(kind)) {
                String oid = (String)parameters.get("oid");
                ContactInfo contact = this.findContact(oid);
                if (contact == null) {
                    this.addContactInfo(parameters);
                } else {
                    List list = (List)parameters.get("members");
                    if (list != null && !list.contains(this.getUserId())) {
                        this.removeContact(oid);
                    }
                }
            }
        } else if (method.equals("objectDeleted")) {
            String kind = (String)parameters.get("kind");
            if ("user".equals(kind) || "phone".equals(kind)) {
                this.contactDeleted(parameters);
            } else if ("channel".equals(kind)) {
                this.removeContact((String)parameters.get("oid"));
            }
        } else if (method.equals("extensionDeleted")) {
            this.removeContact((String)parameters.get("oid"));
        } else {
            super.processCommand(method, parameters);
        }
    }

    private void addContactInfo(Map map) {
        ContactInfo contact = new ContactInfo(map);
        contact.setStatus(4);
        super.addContactInfo(contact, true);
    }

    @Override
    protected ContactInfo addContactInfo(ContactInfo contactInfo, boolean b) {
        ContactInfo contact = super.addContactInfo(contactInfo, b);
        int status = contact.getStatus();
        if (status == -1 && (contact.isUser() || contact.isPhone())) {
            contact.setStatus(4);
        }
        return contact;
    }

    @Override
    public String createContact(ContactInfo contact, boolean shared) throws Exception {
        if (contact.getStatus() == -1) {
            contact.setStatus(4);
        }
        return super.createContact(contact, shared);
    }

    @Override
    public void updateContact(ContactInfo contact) throws Exception {
        if (contact.getStatus() == 3) {
            contact.setStatus(4);
        }
        super.updateContact(contact);
    }

    @Override
    public ContactInfo getContactInfo(ContactInfo contact) throws Exception {
        if (contact.getProperty("ext") == null) {
            return super.getContactInfo(contact);
        }
        contact.setProperty("info", this.getUserInfo(contact.getUserID()));
        return contact;
    }

    @Override
    public void dropFromConference(ContactInfo contact) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("party", contact.getUserID());
        for (LineInfo line : this.getLines()) {
            String confid = line.getConferenceId();
            if (confid == null || !line.containsParty(contact)) continue;
            prms.put("confid", confid);
            break;
        }
        this.sendIndication("dropConnectedParty", prms);
    }

    @Override
    public void lineStateChanged(int state, String number, String description, Line line) {
        LineInfo lineInfo;
        Activity activity;
        if (state == 3) {
            LineInfo lineInfo2 = (LineInfo)line.getLinePane();
            Activity activity2 = lineInfo2.getActivity();
            if (activity2 != null) {
                activity2.setTimeAssign(this.getServerTime());
            }
        } else if (state == 8 && (activity = (lineInfo = (LineInfo)line.getLinePane()).getActivity()) != null) {
            activity.setTimestop(this.getServerTime());
        }
        super.lineStateChanged(state, number, description, line);
    }

    @Override
    public List getTrunks(String number) {
        if (this.getServiceProperty("mod") == null) {
            return super.getTrunks(number);
        }
        ArrayList list = new ArrayList();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("number", Utils.normalizePhoneNumber(number));
            this.trunks = (List)this.sendCommand("getTrunks", params);
        }
        catch (Exception e) {
            this.trunks = new ArrayList();
        }
        for (int i = 0; i < this.trunks.size(); ++i) {
            Map trunk = (Map)this.trunks.get(i);
            list.add(trunk.get("name"));
        }
        return list;
    }

    @Override
    public void makeCall(String number, String trunk, boolean video) {
        if (this.trunks.isEmpty()) {
            super.makeCall((String)number, trunk, video);
            return;
        }
        if (trunk == null) {
            if (video) {
                this.makeVideoCall((String)number);
            } else {
                this.makeCall((String)number);
            }
            return;
        }
        for (int i = 0; i < this.trunks.size(); ++i) {
            Map m = (Map)this.trunks.get(i);
            if (!trunk.equals(m.get("name"))) continue;
            String cc = (String)m.get("country");
            if (cc == null) {
                cc = this.client.getCountryCode();
            }
            number = Utils.normalizePhoneNumber((String)number, cc) + "_" + m.get("oid");
            break;
        }
        this.server.makeCall((String)number, video);
    }

    @Override
    protected void trunkState(Map params) {
        super.trunkState(params);
        Integer state = (Integer)params.get("state");
        if (state == null) {
            state = (Boolean)params.get("enabled") != false ? 1 : 0;
        }
        int currentState = super.getUserState();
        boolean off = state == 0 && (currentState == 1 || currentState == 4);
        this.client.stateChanged(off ? 5 : currentState);
        ContactInfo info = this.getUserInfo();
        if (info != null) {
            info.notifyStateChanged();
        }
    }

    @Override
    public int getUserState() {
        int state = super.getUserState();
        if ((state == 1 || state == 4) && this.isTrunksDisabled()) {
            state = 5;
        }
        return state;
    }

    @Override
    public void stateChanged(int state) {
        if ((state == 1 || state == 4) && this.isTrunksDisabled()) {
            this.client.stateChanged(5);
            ContactInfo info = this.getUserInfo();
            if (info != null) {
                info.setState(state);
            }
        } else {
            super.stateChanged(state);
        }
    }

    @Override
    protected void initObjects(Map map) throws Exception {
        super.initObjects(map);
        int state = super.getUserState();
        if (state == 1 || state == 4) {
            this.client.stateChanged(this.isTrunksDisabled() ? 5 : state);
        }
    }
}

