/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.util.Map;
import smile.cti.client.PbxServiceManager;
import smile.cti.client.ServerConnector;
import smile.web.client.ClientWebSocket;
import smile.web.client.WebSocketListener;

public class WebSocketConnector
extends ServerConnector
implements WebSocketListener,
Runnable {
    private ClientWebSocket webSocket;
    private String url;
    private String user;
    private String passw;
    private String proxy;

    public WebSocketConnector(PbxServiceManager client) throws Exception {
        super(client);
        new Thread(this).start();
    }

    @Override
    public synchronized void register(String serverAddress, String username, char[] password, String proxy, String devinfo, boolean reconnect) throws Exception {
        this.url = "WSS://" + serverAddress;
        this.user = username;
        this.passw = new String(password);
        super.register(serverAddress, username, password, proxy, devinfo, reconnect);
        this.wait(3000L);
    }

    private void openSocket() throws Exception {
        if (this.webSocket != null) {
            try {
                this.webSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.webSocket = new ClientWebSocket(this.url, this.user, this.passw, this.proxy, this);
    }

    @Override
    public Object sendCommand(String method, Map params, long timeout) throws Exception {
        if (this.webSocket == null) {
            this.openSocket();
        }
        try {
            return this.webSocket.sendCommand(method, params, timeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connectionLost();
            this.openSocket();
            return this.webSocket.sendCommand(method, params, timeout);
        }
    }

    @Override
    public void sendIndication(String method, Map params) throws Exception {
        if (this.webSocket == null) {
            this.openSocket();
        }
        try {
            this.webSocket.sendIndication(method, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connectionLost();
            this.openSocket();
            this.webSocket.sendIndication(method, params);
        }
    }

    @Override
    public void processCommand(String method, Map parameters) {
        super.processCommand(method, parameters);
    }

    @Override
    public void connectionLost() {
        super.connectionLost();
        try {
            this.webSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.webSocket = null;
    }

    @Override
    public synchronized void connectionSet() {
        super.connectionSet();
        try {
            this.openSocket();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.notify();
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.webSocket == null) continue;
            this.webSocket.sendPing("!");
        }
    }
}

