/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone;

import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;
import smile.cti.phone.LinePane;
import smile.cti.phone.Lines;
import smile.util.ResourceStore;
import smile.util.Utils;

public class Line {
    public static final int IDLE = 0;
    public static final int DIALING = 1;
    public static final int RINGING = 2;
    public static final int CONNECTED = 3;
    public static final int HOLD = 4;
    public static final int CONFERENCE = 5;
    public static final int ERROR = 6;
    public static final int MUTE = 7;
    public static final int DISCONNECTED = 8;
    public static final int RESUMED = 9;
    public static final int CONNECTED2 = 10;
    public static final int FAXSND = 11;
    public static final int FAXRCV = 12;
    public static final int FAXEND = 13;
    public static final int ANSMACH = 14;
    public static final int DIALING2 = 15;
    public static final int HOLD2 = 16;
    public static final int PARK = 17;
    public static final int TERMINATED = 18;
    public static final int CONFERENCE_START = 19;
    public static final int CONFERENCE_STOP = 20;
    public static final int CONFERENCE_ADDED = 21;
    public static final int CONFERENCE_REMOVED = 22;
    private String name;
    private int linestate;
    private boolean auto;
    private boolean hold;
    private boolean park;
    private boolean connected;
    private boolean xferon;
    private int voiceconn = 0;
    private String stateDescription;
    private String d1 = "";
    private String d2 = "";
    private long startTime;
    private boolean inbound;
    private String connectedNumber = "";
    private String conferenceLine;
    private String conferenceId;
    private String recfile;
    private String callId;
    private boolean video;
    private boolean reject;
    private TimerTask timerTask;
    private LinePane linePane;

    public Line(String name, LinePane linePane) {
        this.name = name;
        this.linePane = linePane;
    }

    public void setLinePane(LinePane linePane) {
        this.linePane = linePane;
    }

    public LinePane getLinePane() {
        return this.linePane;
    }

    public String toString() {
        return this.name;
    }

    public void setActive(boolean mode) {
        this.linePane.setActive(mode);
    }

    public void setAuto() {
        this.auto = true;
        this.linePane.setState(14);
    }

    public void setHold(boolean b) {
        this.hold = b;
        this.linestate = b ? 4 : 9;
        this.linePane.setState(this.linestate);
    }

    public void setPark() {
        this.park = true;
        this.linePane.setState(17);
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        return this.linestate;
    }

    protected void setState(int state) {
        this.linestate = state;
        if (state == 2 && this.callId == null) {
            this.startTimer();
        }
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public boolean isHold() {
        return this.hold;
    }

    public boolean isPark() {
        return this.park;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isTransferring() {
        return this.xferon;
    }

    public boolean canBeTransferred() {
        return this.xferon || this.voiceconn == 1 || this.voiceconn == 2;
    }

    public boolean inConference() {
        return this.conferenceId != null || this.voiceconn == 3;
    }

    public String getConferenceId() {
        return this.conferenceId;
    }

    public void setConferenceId(String confId) {
        this.conferenceId = confId;
        if (confId != null && confId.length() > 0) {
            this.linePane.setState(5);
        }
    }

    public void setConferenceId(String confId, String confName) {
        this.conferenceId = confId;
        this.linePane.setState(5);
        this.linePane.setStateDescription(confName);
    }

    public String getConferenceLine() {
        return this.conferenceLine;
    }

    public void setConferenceLine(String confLine) {
        this.conferenceLine = confLine;
    }

    public boolean isConference() {
        return this.linePane.isConference();
    }

    public void setRecordingFile(String filename) {
        this.recfile = filename;
    }

    public String getRecordingFile() {
        return this.recfile;
    }

    public void fireAction(String cmd) {
        this.linePane.fireAction(cmd);
    }

    public void setJoined(Line line) {
        this.voiceconn = 3;
        this.linePane.setState(5);
    }

    public void setConnected(String number) {
        this.voiceconn = 2;
        this.connectedNumber = number;
    }

    public void dropParty(String number) {
        if (number.equals(this.d1)) {
            this.d1 = "";
            this.stateDescription = this.d2;
        } else if (number.equals(this.d2)) {
            this.d2 = "";
            this.stateDescription = this.d1;
        }
        if (this.voiceconn != 3) {
            this.voiceconn = 0;
        }
        this.linePane.setStateDescription(this.stateDescription);
    }

    public void setCallProperties(Map map) {
        this.video = map.get("cti.VideoCodec") != null;
        this.callId = (String)map.get("cti.CallID");
        if (this.callId != null) {
            this.stopTimer();
        }
        this.linePane.setCallProperties(map);
        this.auto = map.containsKey("cti.AUTOANSWER");
    }

    public void setVideo(boolean mode) {
        this.video = mode;
        this.linePane.setVideo(mode);
    }

    public boolean isVideo() {
        return this.video;
    }

    public String getCallId() {
        return this.callId;
    }

    public long getConnectionTime() {
        return this.connected ? System.currentTimeMillis() - this.startTime : 0L;
    }

    public String getStateDescription() {
        return this.stateDescription;
    }

    public String getConnectedNumber() {
        return this.connectedNumber;
    }

    public void setConnectedNumber(String number) {
        int n = number.indexOf("_");
        this.connectedNumber = n == -1 ? number : number.substring(0, n);
        boolean autoanswer = this.connectedNumber.endsWith("***");
        if (autoanswer) {
            this.connectedNumber = this.connectedNumber.substring(0, this.connectedNumber.length() - "***".length());
            if (this.connectedNumber.equals("#")) {
                this.connectedNumber = "";
            }
            this.auto = true;
        }
        this.linePane.setStateDescription(this.connectedNumber);
    }

    public boolean isSamePartyCall(String callingNumber, Map callProperties) {
        return callingNumber.equals(this.connectedNumber);
    }

    public void setAutoconnect() {
        this.auto = true;
    }

    public boolean isAutoconnect() {
        return this.auto;
    }

    public void setActive() {
        if (this.hold) {
            this.hold = false;
            this.linePane.setState(3);
        }
    }

    public void setReject() {
        this.reject = true;
    }

    public boolean getReject() {
        return this.reject;
    }

    public void showActionMenu(Line activeLine, int x, int y, Vector fwdNumbers, String number) {
        if (this.linestate == 0) {
            return;
        }
        if (this.linestate == 2) {
            this.linePane.showAnswerActionMenu(x, y, fwdNumbers);
        } else {
            Vector<String> menuItems = new Vector<String>();
            for (int i = 0; i < Lines.MENU_ITEMS2.length; ++i) {
                if (i > 1 && (this.hold || this.auto) || i > 3 && i < 7 && this != activeLine) continue;
                boolean set = false;
                switch (i) {
                    case 0: {
                        set = this.hold || this.auto;
                        break;
                    }
                    case 1: {
                        set = this.linestate == 3 && this.voiceconn != 1 && this.voiceconn != 2;
                        break;
                    }
                    case 2: {
                        set = this.linestate == 3;
                        break;
                    }
                    case 3: {
                        set = this.linestate == 4;
                        break;
                    }
                    case 4: {
                        set = this.voiceconn == 1 || this.voiceconn == 2;
                        break;
                    }
                    case 5: {
                        set = this.canBeTransferred();
                        break;
                    }
                    case 6: {
                        set = this.voiceconn == 1 || this.voiceconn == 2;
                        break;
                    }
                    case 7: {
                        set = number.length() > 0 && (this.linestate == 3 || this.linestate == 4);
                        break;
                    }
                    case 8: {
                        set = this != activeLine && activeLine != null;
                        break;
                    }
                    case 9: {
                        boolean bl = set = this.linestate == 1;
                    }
                }
                if (!set) continue;
                menuItems.add(Lines.MENU_ITEMS2[i]);
            }
            this.linePane.showActionMenu(x, y, menuItems);
        }
    }

    public void lineStateChanged(int state, String description) {
        ResourceStore.toLog(this.name + ": state=" + this.linestate + " newstate=" + state + " - " + description + " vc=" + this.voiceconn + " d1=" + this.d1 + " d2=" + this.d2);
        if (state == 2) {
            this.linePane.setState(2);
            this.linePane.setStateDescription(description);
            this.d1 = this.stateDescription = description;
            this.inbound = true;
            this.linestate = state;
        } else if (state == 1) {
            if (this.linestate == 3) {
                this.linePane.setState(15, description);
                this.d2 = description;
                this.xferon = true;
            } else if (this.linestate == 4) {
                this.linePane.setState(15, description);
                this.d2 = description;
                this.xferon = true;
            } else {
                this.linePane.setState(1, description);
                this.d1 = description;
            }
            this.linestate = state;
            this.stateDescription = description;
        } else if (state == 4) {
            if (this.voiceconn == 1) {
                this.voiceconn = 2;
                this.stateDescription = this.d2;
                this.linestate = 3;
                this.linePane.setState(10, this.d2);
            } else if (this.voiceconn == 2) {
                this.voiceconn = 1;
                this.stateDescription = this.d1;
                this.linestate = 3;
                this.linePane.setState(16, this.d1);
            } else if (this.linestate != 4) {
                this.linePane.setState(4);
                this.linestate = state;
            }
        } else if (state == 9) {
            this.linestate = 3;
            switch (this.voiceconn) {
                case 1: {
                    this.voiceconn = 2;
                    this.linePane.setState(3, this.stateDescription);
                    break;
                }
                case 2: {
                    this.voiceconn = 1;
                    this.linePane.setState(3, this.stateDescription);
                    break;
                }
                case 3: {
                    this.linePane.setState(5, this.stateDescription);
                    break;
                }
                default: {
                    this.linePane.setState(9, this.stateDescription);
                }
            }
            this.xferon = false;
            this.hold = false;
            this.park = false;
        } else if (state == 5) {
            this.voiceconn = 3;
            this.linePane.setState(5, description);
            this.stateDescription = description;
            this.linestate = 5;
            this.connected = true;
            this.xferon = false;
        } else if (state == 10) {
            this.voiceconn = 2;
            this.linePane.setState(10);
            this.linestate = 3;
        } else if (state == 3) {
            if (this.conferenceId != null || this.linestate == 5 && description.indexOf(44) != -1) {
                this.linePane.setState(5);
            } else {
                if (!this.hold) {
                    this.linePane.setState(3);
                }
                if (!this.connected) {
                    this.startTime = System.currentTimeMillis();
                }
                this.linestate = state;
            }
            this.connected = true;
            this.xferon = false;
        } else if (state == 8) {
            this.voiceconn = 0;
            this.d1 = "";
            this.d2 = "";
            this.stateDescription = "";
            this.linePane.setState(8);
            if (this.linestate == 1) {
                this.linePane.setStateDescription(description);
            }
            this.connectedNumber = "";
            this.conferenceLine = null;
            this.conferenceId = null;
            this.connected = false;
            this.inbound = false;
            this.hold = false;
            this.auto = false;
            this.park = false;
            this.xferon = false;
            this.recfile = null;
            this.linestate = 8;
            this.callId = null;
        } else if (state == 11) {
            this.linePane.setState(11);
            this.linestate = state;
        } else if (state == 12) {
            this.linePane.setState(12);
            this.linestate = state;
        } else if (state == 13 && (this.linestate == 11 || this.linestate == 12)) {
            this.linePane.setState(3);
            this.linestate = 3;
        } else {
            this.linestate = state;
            this.stateDescription = description;
            this.linePane.setState(state);
            this.linePane.setStateDescription(description);
        }
    }

    public void clear() {
        this.stopTimer();
        this.voiceconn = 0;
        this.d1 = "";
        this.d2 = "";
        this.stateDescription = "";
        this.connectedNumber = "";
        this.conferenceLine = null;
        this.conferenceId = null;
        this.connected = false;
        this.inbound = false;
        this.hold = false;
        this.auto = false;
        this.park = false;
        this.xferon = false;
        this.reject = false;
        this.recfile = null;
        this.callId = null;
        this.linestate = 0;
        this.linePane.setState(0);
        ResourceStore.toLog(this.name + ": cleared");
    }

    private void startTimer() {
        if (this.timerTask == null) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    Line.this.timerTask = null;
                    Line.this.clear();
                }
            };
            Utils.getTimer().schedule(this.timerTask, 7000L);
            ResourceStore.toLog(this.name + ": state=" + this.linestate + " startTimer");
        }
    }

    private void stopTimer() {
        if (this.timerTask != null) {
            ResourceStore.toLog(this.name + ": state=" + this.linestate + " stopTimer");
            try {
                this.timerTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timerTask = null;
        }
    }
}

