/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import smile.cti.phone.Line;
import smile.cti.phone.LinePane;
import smile.cti.phone.PhoneDevice;
import smile.util.ResourceStore;

public class Lines {
    public static final String RUN_APPLICATION = "Run application";
    public static final String RUN_APPLICATION_FILE = "Run application file";
    public static final String RUN_APPLICATION_PRMS = "Run application parameters";
    public static final int ANSWER_INTERACTIVE = 0;
    public static final int ANSWER_AUTO = 1;
    public static final int ANSWER_HOLD = 2;
    public static final int ANSWER_BUSY = 3;
    public static final int ANSWER_FWD = 4;
    public static final int ANSWER_MACHINE = 5;
    public static String[] MENU_ITEMS0 = LinePane.MENU_ITEMS_0[0];
    public static String[] MENU_ITEMS1 = LinePane.MENU_ITEMS_1[0];
    public static String[] MENU_ITEMS2 = LinePane.MENU_ITEMS_2[0];
    public static String[] MENU_ITEMS3 = LinePane.MENU_ITEMS_3[0];
    private PhoneDevice device;
    private Vector lines = new Vector();
    private Line activeLine;
    private String application;
    private String apprms = "";
    private boolean execapp = false;
    private boolean ansmauto;
    private boolean ansmscreening;
    private boolean playgreeting;
    private boolean autooffhook;
    private boolean autohold;
    private int ansmdelay = 10000;
    private int ansmmaxtime = 60000;
    private int maxinlines = 2;
    private int offhookdelay = 3000;
    private int holddelay = 7000;
    private int extansMode = 3;
    private String fwdNumber;
    public static final String PLAY_RING = "Play Ringtone";
    public static final String RING_TONE = "Ring tone";
    public static final String PLAY_GREETING = "Play greeting";
    public static final String PLAY_GREETING_FILE = "Play greeting file";
    public static final String ANSM_PROMPT = "Answering machine prompt";
    public static final String ANSM_AUTORUN = "Answering machine autorun";
    public static final String ANSM_START_DELAY = "Answering machine start";
    public static final String ANSM_SCREENING = "Live call screening";
    public static final String ANSM_MAX_TIME = "Max recording time";
    public static final String SET_ON_HOLD = "Set on hold";
    public static final String HOLD_DELAY = "Hold delay";
    public static final String HOLD_GREETING = "Hold greeting";
    public static final String AUTO_ANSWER = "Auto answer";
    public static final String AUTO_ANSWER_DELAY = "Auto answer delay";
    public static final String INCOMING_LINES = "Incoming lines";
    public static final String EXT_LINES_ACTION = "Extended action";
    public static final String FORWARD_NUMBER = "Forward number";

    public static void setLang(String langid) {
        for (int i = 0; i < LinePane.LANGS.length; ++i) {
            if (!langid.equals(LinePane.LANGS[i])) continue;
            MENU_ITEMS0 = LinePane.MENU_ITEMS_0[i];
            MENU_ITEMS1 = LinePane.MENU_ITEMS_1[i];
            MENU_ITEMS2 = LinePane.MENU_ITEMS_2[i];
            MENU_ITEMS3 = LinePane.MENU_ITEMS_3[i];
        }
    }

    public Lines(PhoneDevice device) {
        this.device = device;
    }

    public void addLine(Line line) {
        this.lines.add(line);
    }

    public String getConferenceId() {
        return this.activeLine.getConferenceId();
    }

    public String getStateDescription() {
        return this.activeLine.getStateDescription();
    }

    public Vector getLines() {
        return this.lines;
    }

    public Line getActiveLine() {
        return this.activeLine;
    }

    public void setMaxinlines(int n) {
        this.maxinlines = n;
    }

    public int getMaxinlines() {
        return this.maxinlines;
    }

    public void setProperties(Map properties) throws Exception {
        int ringMode = 1;
        try {
            ringMode = (Boolean)properties.get(PLAY_RING) != false ? 1 : 0;
            this.device.setRingMode(ringMode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.extansMode = (Integer)properties.get(EXT_LINES_ACTION);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fwdNumber = (String)properties.get(FORWARD_NUMBER);
        String value = (String)properties.get(RING_TONE);
        if (value != null && value.length() > 0) {
            this.device.setRingtone(value);
        }
        try {
            this.maxinlines = (Integer)properties.get(INCOMING_LINES);
        }
        catch (Exception e) {
            this.maxinlines = 2;
        }
        try {
            this.autooffhook = (Boolean)properties.get(AUTO_ANSWER);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.offhookdelay = 1000 * (Integer)properties.get(AUTO_ANSWER_DELAY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.offhookdelay < 1000) {
            this.offhookdelay = 1000;
        }
        try {
            this.playgreeting = (Boolean)properties.get(PLAY_GREETING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.playgreeting) {
            this.device.setPlayGreeting(null);
        } else {
            this.device.setPlayGreeting((String)properties.get(PLAY_GREETING_FILE));
        }
        try {
            this.autohold = (Boolean)properties.get(SET_ON_HOLD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.holddelay = 1000 * (Integer)properties.get(HOLD_DELAY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.holddelay < 1000) {
            this.holddelay = 1000;
        }
        try {
            this.execapp = (Boolean)properties.get(RUN_APPLICATION);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.application = (String)properties.get(RUN_APPLICATION_FILE);
        this.apprms = (String)properties.get(RUN_APPLICATION_PRMS);
        if (this.apprms == null) {
            this.apprms = "";
        }
        if ((value = (String)properties.get(ANSM_PROMPT)) != null) {
            this.device.setAnsmPrompt(value);
        }
        try {
            this.ansmauto = (Boolean)properties.get(ANSM_AUTORUN);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ansmdelay = 1000 * (Integer)properties.get(ANSM_START_DELAY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ansmmaxtime = 1000 * (Integer)properties.get(ANSM_MAX_TIME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ansmscreening = (Boolean)properties.get(ANSM_SCREENING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        value = (String)properties.get(HOLD_GREETING);
        if (value != null) {
            this.device.setHoldGreeting(value);
        }
    }

    public Line makeCall(String number) {
        return this.makeCall(number, true);
    }

    public Line makeCall(String number, boolean withhold) {
        Line line;
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            Line ln = (Line)en.nextElement();
            if (ln.getState() == 0 || !number.equals(ln.getConnectedNumber())) continue;
            if (ln.getState() == 2) {
                this.answerCall(ln.getName());
            } else {
                if (ln.getState() != 4 && ln.getState() != 16) break;
                this.swapCall(ln);
            }
            return ln;
        }
        if ((line = this.getLine()) == null) {
            return null;
        }
        if (withhold) {
            this.setActiveLine(line);
        }
        this.makeCall(number, line);
        return line;
    }

    public void makeCall(String number, Line line) {
        this.device.makeCall(number, line.getName());
        line.setConnectedNumber(number);
        line.setState(1);
    }

    public void initCall(String number) {
        this.processEnter(number);
    }

    public void initCall2(String number) {
        ResourceStore.toLog("initCall2 " + number + " activeLine=" + this.activeLine);
        if (this.activeLine != null && number.length() > 0) {
            if (number.equals(this.activeLine.getConnectedNumber())) {
                return;
            }
            Line line = this.getLine();
            if (line == null) {
                return;
            }
            this.setActiveLine(line);
        }
        this.initCall(number);
    }

    public void transferCall2(String lineName) {
        if (this.activeLine != null) {
            if (this.activeLine.getName().equals(lineName)) {
                Enumeration en = this.lines.elements();
                while (en.hasMoreElements()) {
                    Line ln = (Line)en.nextElement();
                    if (ln.getState() != 4) continue;
                    this.transferCall(lineName, ln.getName());
                }
            } else {
                this.transferCall(lineName, this.activeLine.getName());
            }
        }
    }

    public void transferCall(String number, String lineName) {
        Line line = this.getLine(lineName);
        ResourceStore.toLog("transferCall " + number + " line=" + line + " activeLine=" + this.activeLine);
        Line line2 = this.getLine(number);
        if (line2 != null) {
            boolean result;
            if (this.activeLine != line && this.activeLine != line2) {
                this.setActiveLine(line);
            }
            String activeLinaName = this.activeLine.getName();
            boolean bl = result = this.activeLine == line ? this.join(line, line2) : this.join(line2, line);
            if (result) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dropCall(activeLinaName);
            }
        } else if (line == this.activeLine) {
            this.transferCall(number);
        } else if (this.activeLine == null) {
            this.setActiveLine(line);
            this.transferCall(number);
        } else {
            this.device.transferCall(lineName, number);
            line.lineStateChanged(1, number);
        }
    }

    public void transferCall(String number) {
        if (this.activeLine == null) {
            Enumeration en = this.lines.elements();
            while (en.hasMoreElements()) {
                Line line = (Line)en.nextElement();
                if (!line.isConnected()) continue;
                this.setActiveLine(line);
                break;
            }
        }
        if (this.activeLine != null && this.activeLine.isConnected()) {
            this.processEnter(number);
        }
    }

    public void transfer() {
        if (this.activeLine != null && this.activeLine.canBeTransferred()) {
            this.dropCall(this.activeLine.getName());
        }
    }

    public void answerMachine(String name) {
        Line line = this.getLine(name);
        this.device.answerMachine(line.getName(), false, this.ansmmaxtime);
        line.setAuto();
        if (this.activeLine == line) {
            this.activeLine = null;
        }
    }

    public void menuCommand(String name, String command) {
        ResourceStore.toLog("menuCommand name=" + name + " command=" + command);
        if (command.equals(MENU_ITEMS1[0])) {
            this.answerCall(name);
        } else if (command.equals(MENU_ITEMS1[1])) {
            this.dropCall(name);
        } else if (command.equals(MENU_ITEMS1[2])) {
            this.holdCall(name);
        } else if (command.startsWith(MENU_ITEMS1[3])) {
            this.forwardCall(name, command.substring(MENU_ITEMS1[3].length()));
        } else if (command.equals(MENU_ITEMS1[4])) {
            this.answerMachine(name);
        } else if (command.equals(MENU_ITEMS2[0])) {
            this.setActiveLine(name);
        } else if (command.equals(MENU_ITEMS2[1])) {
            this.dropCall(name);
        } else if (command.equals(MENU_ITEMS2[2])) {
            this.device.swapCall(name);
        } else if (command.equals(MENU_ITEMS2[3])) {
            this.device.swapCall(name);
        } else if (command.equals(MENU_ITEMS2[4])) {
            this.device.swapCall(name);
        } else if (command.equals(MENU_ITEMS2[5])) {
            this.transfer();
        } else if (command.equals(MENU_ITEMS2[6])) {
            this.device.makeConference();
        } else if (command.equals(MENU_ITEMS2[7])) {
            this.parkCall(name, "");
        } else if (command.equals(MENU_ITEMS2[8])) {
            this.join(name);
        } else if (command.equals(MENU_ITEMS2[9])) {
            this.swapCall(name);
        }
    }

    public void dropCall(String linename, String number) {
        Line line = this.getLine(linename);
        if (line != null) {
            this.device.dropCall(linename, number);
            if (number != null) {
                line.dropParty(number);
            }
        }
    }

    public void dropCall() {
        if (this.activeLine != null) {
            if (this.activeLine.isTransferring()) {
                this.swapCall(this.activeLine.getName());
            } else {
                this.dropCall(this.activeLine.getName());
            }
        }
    }

    public void dropCall(String name) {
        this.device.dropCall(name);
    }

    public void rejectCall(String name) {
        Line line = this.getLine(name);
        if (line != null) {
            line.setReject();
        }
        this.device.rejectCall(name);
    }

    public void setConnected(String linename, String number) {
        Line line = this.getLine(linename);
        if (line != null) {
            line.setConnected(number);
        }
    }

    public void holdCall() {
        ResourceStore.toLog("holdCall activeLine=" + this.activeLine + " state=" + (this.activeLine != null ? this.activeLine.getState() : -1));
        if (this.activeLine != null && this.activeLine.getState() != 4) {
            this.device.swapCall(this.activeLine.getName());
            this.activeLine.setHold(true);
        }
    }

    public void resumeCall() {
        ResourceStore.toLog("resumeCall activeLine=" + this.activeLine + " state=" + (this.activeLine != null ? this.activeLine.getState() : -1));
        if (this.activeLine != null && this.activeLine.getState() == 4) {
            this.device.swapCall(this.activeLine.getName());
            this.activeLine.setHold(false);
        }
    }

    public void holdCall(String lineName) {
        Line line = this.getLine(lineName);
        ResourceStore.toLog("holdCall line=" + line + " state=" + line.getState());
        if (line.getState() != 2) {
            this.device.swapCall(lineName);
            line.setHold(!line.isHold());
        }
    }

    public void resumeCall(String lineName) {
        Line line = this.getLine(lineName);
        ResourceStore.toLog("resumeCall line=" + line + " state=" + line.getState());
        if (line != this.activeLine) {
            this.setActiveLine(line);
        } else if (line.getState() == 4) {
            this.device.holdCall(lineName);
            line.setHold(false);
        }
    }

    public void parkCall(String name, String num) {
        Line line = this.getLine(name);
        line.setPark();
        String number = "PARK*" + num;
        if (line.getState() != 4) {
            number = "!" + number;
        }
        this.device.transferCall(name, number);
    }

    public void splitCall() {
        if (this.activeLine != null) {
            this.device.swapCall(this.activeLine.getName());
        }
    }

    public void swapCall() {
        if (this.activeLine != null) {
            this.swapCall(this.activeLine);
        }
    }

    public void swapCall(String name) {
        this.swapCall(this.getLine(name));
    }

    public void swapCall(Line line) {
        if (!line.isConnected()) {
            this.device.dropCall(line.getName());
        } else {
            int linestate = line.getState();
            if (linestate == 1 || linestate == 4) {
                this.device.swapCall(line.getName());
            }
        }
    }

    public void forwardCall(String name, String number) {
        if (number.length() == 0) {
            number = this.fwdNumber;
        }
        if (number.length() > 0) {
            this.device.forwardCall(name, number);
        }
    }

    public Line getLine(String name) {
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            Line line = (Line)en.nextElement();
            if (!line.getName().equals(name)) continue;
            return line;
        }
        return null;
    }

    public void setActiveLine(String name) {
        Line line = this.getLine(name);
        if (line != null) {
            this.setActiveLine(line);
        }
    }

    public void switchLine(String name) {
        Line line = this.getLine(name);
        if (line != this.activeLine || this.activeLine.getState() == 2) {
            this.setActiveLine(line);
        } else {
            if (this.activeLine != null) {
                this.activeLine.setActive(false);
            }
            this.device.setActiveLine(null);
            this.activeLine = null;
        }
    }

    public void clearLine(Line line, boolean autoresume) {
        ResourceStore.toLog("clearLine " + line + " autoresume=" + autoresume + " activeLine=" + this.activeLine);
        if (line == this.activeLine) {
            this.activeLine = null;
            if (autoresume) {
                Enumeration en = this.lines.elements();
                while (en.hasMoreElements()) {
                    Line ln = (Line)en.nextElement();
                    if (ln == line || ln.getState() == 8 || ln.getState() == 0) continue;
                    this.activeLine = ln;
                }
            }
            this.device.setActiveLine(this.activeLine != null ? this.activeLine.getName() : null);
        }
        this.device.clearLine(line.getName());
    }

    public void clearLine(Line line) {
        line.clear();
        this.device.clearLine(line.getName());
    }

    public void clearLines() {
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            this.clearLine((Line)en.nextElement());
        }
        this.activeLine = null;
        this.device.setActiveLine(null);
    }

    public boolean join(String lineName) {
        if (this.activeLine == null) {
            return false;
        }
        Line line = null;
        if (lineName == null) {
            Enumeration en = this.getLines().elements();
            while (en.hasMoreElements()) {
                Line ln = (Line)en.nextElement();
                if (!ln.isConnected() || ln == this.activeLine) continue;
                line = ln;
                break;
            }
        } else {
            line = this.getLine(lineName);
            if (this.activeLine == line) {
                return true;
            }
        }
        if (line == null) {
            return false;
        }
        return this.join(this.activeLine, line);
    }

    public boolean join(String lineName1, String lineName2) {
        if (this.activeLine == null) {
            return false;
        }
        Line line1 = this.getLine(lineName1);
        Line line2 = this.getLine(lineName2);
        if (line1 == null || line2 == null) {
            return false;
        }
        if (this.activeLine == line1) {
            return this.join(line1, line2);
        }
        if (this.activeLine == line2) {
            return this.join(line2, line1);
        }
        this.setActiveLine(line1);
        return this.join(line1, line2);
    }

    public boolean join(Line line1, Line line2) {
        ResourceStore.toLog("join line1=" + line1 + " state=" + line1.getState() + " line2=" + line2 + " state=" + line2.getState() + " conf=" + line2.inConference());
        if (line2.inConference()) {
            this.setActiveLine(line2);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.device.join(line2.getName(), line1.getName())) {
                return false;
            }
            line2.setJoined(line1);
            this.dropCall(line1.getName());
        } else if (line1.getState() == 1) {
            if (!this.device.join(line2.getName(), line1.getName())) {
                return false;
            }
            this.dropCall(line2.getName());
        } else {
            if (!this.device.join(line1.getName(), line2.getName())) {
                return false;
            }
            line1.setJoined(line2);
            this.dropCall(line2.getName());
        }
        return true;
    }

    public void setActiveLine(Line line) {
        ResourceStore.toLog("setActiveLine=" + line + " state=" + line.getState() + " old=" + this.activeLine);
        Line oldLine = this.activeLine;
        if (oldLine != line && oldLine != null) {
            if (oldLine.getState() == 3 && !oldLine.isConference()) {
                this.device.swapCall(oldLine.getName());
            }
            oldLine.setActive(false);
        }
        this.device.setActiveLine(line.getName());
        this.activeLine = line;
        this.activeLine.setActive(true);
        line.setActive();
        if (line.getState() == 4) {
            this.device.swapCall(line.getName());
        }
    }

    public int getActiveLinesCount() {
        int c = 0;
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            Line ln = (Line)en.nextElement();
            if (ln.getCallId() == null) continue;
            ++c;
        }
        return c;
    }

    public boolean isConnected() {
        return this.activeLine != null && this.activeLine.getState() == 3;
    }

    public boolean startRecording(String path) throws Exception {
        ResourceStore.toLog("startRecording path=" + path + " activeLine=" + this.activeLine);
        if (this.activeLine == null) {
            return false;
        }
        File dir = new File(path + "/records");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, System.currentTimeMillis() + ".wav");
        String filename = file.getCanonicalPath();
        this.device.startRecording(this.activeLine.getName(), filename);
        this.activeLine.setRecordingFile(filename);
        return true;
    }

    public void startFax() {
        if (this.activeLine != null && this.activeLine.isConnected()) {
            this.device.startFax(this.activeLine.getName());
        }
    }

    public void stopFax() {
        if (this.activeLine != null && this.activeLine.isConnected()) {
            this.device.stopFax(this.activeLine.getName());
        }
    }

    public void keyPressed(char key) {
        this.device.sendChar(key);
    }

    public Line getLine() {
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            Line line = (Line)en.nextElement();
            if (line == this.activeLine || line.getState() != 0) continue;
            return line;
        }
        return null;
    }

    public Line getRingingLine() {
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            Line line = (Line)en.nextElement();
            if (line.getState() != 2) continue;
            return line;
        }
        return null;
    }

    public Line findLine(String party) {
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            Line line = (Line)en.nextElement();
            if (!party.equals(line.getConnectedNumber())) continue;
            return line;
        }
        return null;
    }

    public void setOutgoingCall(String lineName, String connectedNumber, Map props) {
        Line line = this.getLine(lineName);
        line.setCallProperties(props);
        ResourceStore.toLog("setOutgoingCall activeLine=" + this.activeLine + " lineName=" + lineName + " connectedNumber=" + connectedNumber + " props=" + props);
    }

    public synchronized Line setIncomingCall(String calledNumber, String callingNumber, Map props) {
        ResourceStore.toLog("setIncomingCall activeLine=" + this.activeLine + " callingNumber=" + callingNumber + " props=" + props);
        if (this.activeLine != null) {
            if (this.activeLine.getState() == 2 && this.activeLine.getCallId() != null || this.activeLine.getState() == 1) {
                return null;
            }
            String confid = this.activeLine.getConferenceId();
            if (confid != null) {
                String[] nums = confid.split("#");
                for (int i = 0; i < nums.length; ++i) {
                    if (!nums[i].equals(callingNumber)) continue;
                    return this.activeLine;
                }
            }
        }
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            Line ln = (Line)en.nextElement();
            if (ln.getState() == 0 || !callingNumber.equals(ln.getConnectedNumber())) continue;
            ResourceStore.toLog("setIncomingCall line=" + ln + " state=" + ln.getState() + " r=" + ln.getReject());
            if (ln.getState() == 2) {
                if (ln.getCallId() != null && !props.isEmpty()) {
                    return null;
                }
                ln.setCallProperties(props);
                return ln;
            }
            if (ln.getState() != 1 || calledNumber == null || calledNumber.hashCode() <= callingNumber.hashCode()) continue;
            throw new IllegalStateException();
        }
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        line.setConnectedNumber(callingNumber);
        line.setCallProperties(props);
        line.setState(2);
        if (props.isEmpty()) {
            this.dropCall(line.getName());
            return line;
        }
        int ansMode = 0;
        int c = this.getActiveLinesCount();
        if (c == 1 && this.autooffhook) {
            ansMode = 1;
        } else if (c > this.maxinlines) {
            ansMode = this.extansMode;
        } else if (this.autohold) {
            ansMode = 2;
        }
        ResourceStore.toLog("setIncomingCall line=" + line + " activeLine=" + this.activeLine + " lines=" + c + " maxinlines=" + this.maxinlines + " ansMode=" + ansMode + " props=" + props);
        switch (ansMode) {
            case 0: {
                if (c == 0) {
                    this.setActiveLine(line);
                }
                if (this.ansmauto) {
                    this.setAnswerTimer(line, this.ansmdelay, 5);
                }
                line.fireAction("arise");
                break;
            }
            case 1: {
                this.setAnswerTimer(line, this.offhookdelay, 1);
                break;
            }
            case 2: {
                this.setAnswerTimer(line, this.holddelay, 2);
                break;
            }
            case 3: {
                line.clear();
                return null;
            }
            case 5: {
                this.setAnswerTimer(line, 1000, 5);
                break;
            }
            case 4: {
                this.device.forwardCall(line.getName(), this.fwdNumber);
            }
        }
        return line;
    }

    public void setCallInfo(String callinfo, String username, String password) {
        if (this.execapp && this.application != null && this.application.length() > 0) {
            try {
                int n;
                String[] tokens = callinfo.split(";");
                String callingNumber = tokens[0];
                if (callingNumber.endsWith("***")) {
                    return;
                }
                Hashtable<String, String> t = new Hashtable<String, String>();
                for (int i = 1; i < tokens.length; ++i) {
                    n = tokens[i].indexOf("=");
                    t.put(tokens[i].substring(0, n), tokens[i].substring(n + 1));
                }
                String app = this.application;
                Object appstr = this.apprms;
                if (this.apprms.length() == 0) {
                    appstr = this.application;
                    app = null;
                }
                if ((n = ((String)appstr).indexOf("$")) != -1) {
                    appstr = ((String)appstr).substring(0, n) + callingNumber + ((String)appstr).substring(n + 1);
                }
                if ((n = ((String)appstr).indexOf("*")) != -1) {
                    appstr = ((String)appstr).substring(0, n) + t.get("to") + ((String)appstr).substring(n + 1);
                }
                if ((n = ((String)appstr).indexOf("~")) != -1) {
                    appstr = ((String)appstr).substring(0, n) + t.get("id") + ((String)appstr).substring(n + 1);
                }
                if ((n = ((String)appstr).indexOf("|")) != -1) {
                    appstr = ((String)appstr).substring(0, n) + username + ((String)appstr).substring(n + 1);
                }
                if ((n = ((String)appstr).indexOf("^")) != -1) {
                    appstr = ((String)appstr).substring(0, n) + password + ((String)appstr).substring(n + 1);
                }
                if (app == null) {
                    if (((String)appstr).startsWith("http://")) {
                        URI uRI = new URI((String)appstr);
                    }
                } else {
                    String[] args = this.getParametersArray(app, (String)appstr);
                    if (this.application.endsWith(".class")) {
                        Class<?> clazz = Class.forName(this.application.substring(0, this.application.lastIndexOf(46)));
                        Class[] prmtypes = new Class[]{args.getClass()};
                        Method m = clazz.getMethod("main", prmtypes);
                        Object[] prms = new Object[]{args};
                        m.invoke(null, prms);
                    } else {
                        Runtime run = Runtime.getRuntime();
                        run.exec(args);
                    }
                }
                Thread.sleep(1000L);
                Line line = null;
                Enumeration en = this.lines.elements();
                while (en.hasMoreElements()) {
                    Line ln = (Line)en.nextElement();
                    if (ln == this.activeLine || ln.getState() != 0) continue;
                    line = ln;
                    break;
                }
                if (line != null) {
                    line.fireAction("arise");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String[] getParametersArray(String application, String prms) {
        StringTokenizer stz;
        Vector<String> v = new Vector<String>();
        if (application.length() > 0 && !application.endsWith(".class")) {
            v.add(application);
        }
        String str = prms;
        int n = str.indexOf(34);
        while (n != -1) {
            if (n > 0 && str.charAt(n - 1) != ' ') {
                n = str.indexOf(34, n + 1);
                continue;
            }
            stz = new StringTokenizer(str.substring(0, n), " ");
            while (stz.hasMoreTokens()) {
                v.addElement(stz.nextToken());
            }
            if ((n = (str = str.substring(n)).indexOf(34, 1)) == -1) break;
            v.addElement(str.substring(1, n));
            str = str.substring(n + 1);
            n = str.indexOf(34);
        }
        stz = new StringTokenizer(str, " ");
        while (stz.hasMoreTokens()) {
            v.addElement(stz.nextToken());
        }
        Object[] array = new String[v.size()];
        v.copyInto(array);
        return array;
    }

    public void answerCall(String lineName) {
        this.setActiveLine(lineName);
        int linestate = this.activeLine.getState();
        if (linestate == 2) {
            this.activeLine.setVideo(this.device.getVideoMode() != -1);
        }
    }

    public synchronized void processEnter(String number) {
        if (this.activeLine == null) {
            Line line = null;
            Enumeration en = this.lines.elements();
            while (en.hasMoreElements()) {
                Line l = (Line)en.nextElement();
                if (l.getState() != 2) continue;
                line = l;
                break;
            }
            if (line == null) {
                if (number.length() == 0) {
                    return;
                }
                line = (Line)this.lines.firstElement();
            }
            this.setActiveLine(line);
            line.setActive(true);
        }
        int linestate = this.activeLine.getState();
        ResourceStore.toLog("processEnter activeLine=" + this.activeLine + " number=" + number + " linestate=" + linestate);
        if (linestate == 11 || linestate == 12) {
            return;
        }
        if (linestate == 2) {
            this.device.answerCall();
            this.activeLine.setActive(true);
        } else if (number.equals("video_call")) {
            if (linestate == 3 || linestate == 5) {
                new Thread(){

                    @Override
                    public void run() {
                        Lines.this.device.reinvite(Lines.this.activeLine.getName());
                    }
                }.start();
            }
        } else if (!number.equals("")) {
            switch (linestate) {
                case 0: {
                    this.makeCall(number, this.activeLine);
                    break;
                }
                case 3: 
                case 5: 
                case 10: {
                    this.device.swapCall(this.activeLine.getName());
                }
                case 4: {
                    this.device.transferCall(number);
                    this.activeLine.lineStateChanged(1, number);
                }
            }
        }
    }

    public void lineActionMenu(Line line, int x, int y, String input) {
        Vector<String> fwdNumbers = null;
        if (input.length() == 0) {
            fwdNumbers = new Vector<String>();
            if (this.fwdNumber != null && this.fwdNumber.length() > 0) {
                fwdNumbers.add(this.fwdNumber);
            }
        }
        line.showActionMenu(this.activeLine, x, y, fwdNumbers, input);
    }

    public void lineActionMenu(Line line, int x, int y) {
        line.showActionMenu(this.activeLine, x, y, null, "");
    }

    public void setAnswerTimer(Line line, int delay, int mode) {
        Answer answer = new Answer(line, delay, mode);
        answer.start();
    }

    class Answer
    extends Thread {
        Line line;
        int timeout;
        int ansmode;

        public Answer(Line line, int delay, int mode) {
            this.line = line;
            this.timeout = delay;
            this.ansmode = mode;
        }

        @Override
        public synchronized void run() {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.line.getState() != 2) {
                return;
            }
            switch (this.ansmode) {
                case 1: {
                    Lines.this.setActiveLine(this.line);
                    this.line.setActive(true);
                    break;
                }
                case 2: {
                    Lines.this.device.answerOnHold(this.line.getName());
                    this.line.setHold(true);
                    break;
                }
                case 3: {
                    Lines.this.device.dropCall(this.line.getName());
                    break;
                }
                case 0: 
                case 5: {
                    Lines.this.device.answerMachine(this.line.getName(), Lines.this.ansmscreening, Lines.this.ansmmaxtime);
                    this.line.setAuto();
                    break;
                }
                case 4: {
                    Lines.this.device.forwardCall(this.line.getName(), Lines.this.fwdNumber);
                }
            }
        }
    }
}

