/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone;

import com.smile.sound.WavAudioFormat;
import com.smile.sound.WaveParser;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioConverter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import smile.cti.phone.PhoneDevice;
import smile.cti.phone.PhoneLine;

public class PhoneApplication
extends Thread {
    protected PhoneLine line;
    protected boolean running;
    protected InputStream input;
    protected OutputStream output;

    public PhoneApplication(PhoneLine line) {
        this.line = line;
    }

    public PhoneLine getLine() {
        return this.line;
    }

    public void setInputStream(InputStream in) {
        this.input = in;
    }

    public void setOutputStream(OutputStream out) {
        this.output = out;
        this.running = true;
        this.start();
    }

    public void terminate() {
        this.running = false;
    }

    public void playFile(String filename, OutputStream output) throws Exception {
        InputStream voicedata = new FileInputStream(filename);
        wavFormatHeader hdr = new wavFormatHeader();
        voicedata = new WaveParser().parseWavHeader(voicedata, hdr);
        WavAudioFormat codec = hdr.getAudioFormat();
        if (!codec.equals(WavAudioFormat.PCM_LINEAR16)) {
            voicedata = new AudioConverter().getInputStream(voicedata, codec, PhoneDevice.wav_formats);
        }
        byte[] data = new byte[800];
        long nextTick = System.currentTimeMillis() + 50L;
        while (this.running && voicedata.read(data) != -1) {
            output.write(data);
            long wt = nextTick - System.currentTimeMillis();
            if (wt > 10L) {
                Thread.sleep(wt);
            }
            nextTick += 50L;
        }
        voicedata.close();
    }
}

